/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.inline.function;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionPresenter;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionProcessor;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PhpInlineFunctionDialog
extends InlineOptionsDialog {
    private final Function myFunction;
    private final FunctionReference myReference;

    protected PhpInlineFunctionDialog(Project project, Editor editor, Function function, FunctionReference functionReference) {
        super(project, true, (PsiElement)function);
        this.myFunction = function;
        this.myReference = functionReference;
        this.myInvokedOnReference = functionReference != null;
        this.setTitle(PhpBundle.message("refactoring.inline.function.title", StringUtil.capitalize((String)PhpInlineFunctionDialog.getElementKindDescription(this.myFunction))));
        this.init();
    }

    protected String getNameLabelText() {
        return PhpInlineFunctionPresenter.getElementDescription(this.myFunction, true);
    }

    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.method.border.title");
    }

    protected String getInlineAllText() {
        return PhpBundle.message("refactoring.inline.function.all.invocations.and.remove.the.method", PhpInlineFunctionDialog.getElementKindDescription(this.myFunction));
    }

    protected String getKeepTheDeclarationText() {
        if (this.myFunction.isWritable()) {
            return PhpBundle.message("refactoring.inline.function.all.invocations.keep.the.method", PhpInlineFunctionDialog.getElementKindDescription(this.myFunction));
        }
        return super.getKeepTheDeclarationText();
    }

    protected String getInlineThisText() {
        return PhpBundle.message("refactoring.inline.function.this.invocation.only.and.keep.the.method", PhpInlineFunctionDialog.getElementKindDescription(this.myFunction));
    }

    protected boolean isInlineThis() {
        return false;
    }

    protected void doAction() {
        this.invokeRefactoring(new PhpInlineFunctionProcessor(this.getProject(), this.myFunction, this.myReference, this.isInlineThisOnly(), !this.isKeepTheDeclaration()));
    }

    protected String getHelpId() {
        return "refactoring.inlineMethod";
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JComponent centerPanel = super.createCenterPanel();
        if (!PhpInlineFunctionDialog.isKeepDeclarationOptionAvailable(this.myFunction)) {
            this.myRbInlineAll.setEnabled(false);
            if (this.myKeepTheDeclaration != null) {
                this.myKeepTheDeclaration.setSelected(true);
            } else {
                this.myRbInlineThisOnly.setSelected(true);
            }
        }
        JComponent jComponent = centerPanel;
        if (jComponent == null) {
            PhpInlineFunctionDialog.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    public static boolean isKeepDeclarationOptionAvailable(Function function) {
        Method method = (Method)ObjectUtils.tryCast((Object)function, Method.class);
        if (method == null) {
            return !PhpInlineFunctionDialog.hasFirstClassCallableUsage(function);
        }
        return !PhpInlineFunctionDialog.hasSuperMethod(method) && !PhpInlineFunctionDialog.isUsedToImplementInterface(method) && !PhpInlineFunctionDialog.hasFirstClassCallableUsage(function);
    }

    private static boolean isUsedToImplementInterface(@NotNull Method method) {
        PhpClass phpClass;
        if (method == null) {
            PhpInlineFunctionDialog.$$$reportNull$$$0(1);
        }
        if ((phpClass = method.getContainingClass()) == null) {
            return false;
        }
        String methodName = method.getName();
        Ref res = new Ref((Object)false);
        PhpIndex.getInstance((Project)method.getProject()).processAllSubclasses(phpClass.getFQN(), c -> {
            if (c.isAbstract()) {
                return true;
            }
            Collection subclassMethods = c.findMethodsByName((CharSequence)methodName);
            if (ContainerUtil.exists((Iterable)subclassMethods, m -> !m.isAbstract() && !m.equals(method))) {
                return true;
            }
            if (ContainerUtil.exists((Object[])c.getImplementedInterfaces(), i -> i.findMethodByName((CharSequence)methodName) != null)) {
                res.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)res.get();
    }

    private static boolean hasFirstClassCallableUsage(@NotNull Function function) {
        if (function == null) {
            PhpInlineFunctionDialog.$$$reportNull$$$0(2);
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)function.getProject());
        return ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters((PsiElement)function, (SearchScope)scope, false)).anyMatch(it -> it instanceof PhpCallableFunction);
    }

    private static boolean hasSuperMethod(Method method) {
        Ref result = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperMethods((Method)method, (m, subClass, baseClass) -> {
            result.set((Object)true);
            return false;
        });
        return (Boolean)result.get();
    }

    @NotNull
    private static String getElementKindDescription(Function function) {
        return function instanceof Method ? "method" : "function";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/inline/function/PhpInlineFunctionDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/inline/function/PhpInlineFunctionDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUsedToImplementInterface";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasFirstClassCallableUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

