/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractMethod;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.core.CoreBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodHelper;
import com.intellij.refactoring.extractMethod.SimpleDuplicatesFinder;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpBreakContinueInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInterruptScriptInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionImpl;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpMissingFieldTypeInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Declare;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.RWAccess;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.elements.impl.DeclareImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpRefactoringErrorException;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodBlockCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodDialog;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodDialogOptionsLogger;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodExpressionCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodParameterInfo;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodSelectorLogger;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodSettings;
import com.jetbrains.php.refactoring.extractMethod.PhpParametersFolder;
import com.jetbrains.php.refactoring.extractMethod.PhpSimpleDuplicatesFinder;
import com.jetbrains.php.refactoring.extractMethod.inplace.PhpExtractMethodPopupProvider;
import com.jetbrains.php.refactoring.extractMethod.inplace.PhpInplaceMethodExtractor;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.validation.PhpFunctionInScopeConflictDetector;
import com.jetbrains.php.refactoring.validation.PhpMethodConflictDetector;
import com.jetbrains.php.refactoring.validation.PhpNameConflictDetector;
import com.jetbrains.php.ui.PhpUiUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class PhpExtractMethodHandler
implements RefactoringActionHandler {
    private static final PhpFunctionCodeGenerator IMPLEMENTATION = new PhpFunctionCodeGenerator.PhpFunctionImplementationGenerator(){

        @Override
        protected void appendReturnTypePart(StringBuilder builder2, String returnTypeText) {
        }
    };
    private static final Logger LOG = Logger.getInstance(PhpExtractMethodHandler.class);
    public static final String HELP_ID = "refactoring.extractMethod";
    public static final int MAX_SELECTOR_ITEMS = 6;
    private static final int MAX_CLOSEST_TO_CARET_EXPRESSIONS = 2;
    private static final int MAX_DFS_RECURSION_DEPTH = 1000;
    private final PhpExtractMethodDialogOptionsLogger.Context myContext;

    public PhpExtractMethodHandler() {
        this(PhpExtractMethodDialogOptionsLogger.Context.REFACTORING);
    }

    public PhpExtractMethodHandler(PhpExtractMethodDialogOptionsLogger.Context context) {
        this.myContext = context;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(0);
        }
        this.invoke(project, editor, file, true);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(2);
        }
    }

    @VisibleForTesting
    public final void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, boolean allowInplace) {
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(5);
        }
        try {
            this._invoke(editor, file, allowInplace);
        }
        catch (PhpRefactoringErrorException e) {
            PhpExtractMethodHandler.showErrorMessage(project, editor, e);
        }
    }

    public static void showErrorMessage(@NotNull Project project, @NotNull Editor editor, PhpRefactoringErrorException e) {
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(7);
        }
        String errorMessage = e.getMessage();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new CommonRefactoringUtil.RefactoringErrorHintException(errorMessage);
        }
        String message = RefactoringBundle.getCannotRefactorMessage((String)errorMessage);
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)PhpExtractMethodHandler.getRefactoringName(), (String)HELP_ID);
    }

    private void _invoke(@NotNull Editor editor, @NotNull PsiFile file, boolean allowInplace) throws PhpRefactoringErrorException {
        PhpInplaceMethodExtractor activeInplaceExtractor;
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(8);
        }
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(9);
        }
        if ((activeInplaceExtractor = PhpInplaceMethodExtractor.getActiveExtractor(editor)) != null) {
            activeInplaceExtractor.restartInDialog();
            return;
        }
        Project project = file.getProject();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CoreBundle.message((String)"editing.read.only.file.hint", (Object[])new Object[0]), (String)PhpExtractMethodHandler.getRefactoringName(), (String)HELP_ID);
            return;
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            List<PhpExtractMethodCodeFragment> codeFragments = PhpExtractMethodHandler.collectSuggestedCodeFragments(file, selectionModel.getSelectionStart());
            if (codeFragments.size() == 1) {
                this.extractFromValidatedCodeFragment(project, editor, codeFragments.get(0), allowInplace);
                return;
            }
            if (codeFragments.size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
                PhpExtractMethodSelectorLogger.SELECTOR_SHOWN.log(project);
                IntroduceTargetChooser.showIntroduceTargetChooser((Editor)editor, codeFragments, codeFragment -> {
                    int selectedElementPosition = codeFragments.indexOf(codeFragment);
                    boolean isStatement = codeFragment instanceof PhpExtractMethodBlockCodeFragment;
                    PhpExtractMethodSelectorLogger.ELEMENT_SELECTED.log(project, (Object)selectedElementPosition, (Object)isStatement);
                    this.extractFromValidatedCodeFragment(project, editor, (PhpExtractMethodCodeFragment)codeFragment, allowInplace);
                }, (String)PhpBundle.message("extract.method.selector.title", new Object[0]), (int)-1);
                return;
            }
            editor.getSelectionModel().selectLineAtCaret();
        }
        int startOffset = selectionModel.getSelectionStart();
        int endOffset = selectionModel.getSelectionEnd();
        PsiElement startElement = file.findElementAt(startOffset);
        PsiElement endElement = file.findElementAt(endOffset - 1);
        if (startElement instanceof PsiWhiteSpace) {
            startOffset = startElement.getTextRange().getEndOffset();
            startElement = file.findElementAt(startOffset);
        }
        if (endElement instanceof PsiWhiteSpace) {
            endOffset = endElement.getTextRange().getStartOffset();
            endElement = file.findElementAt(endOffset - 1);
        }
        if (startElement == null || startElement.getTextRange().getStartOffset() != startOffset || endElement == null || endElement.getTextRange().getEndOffset() != endOffset) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.extract.method.error.selected.block.should.represent.a.set.of.statement.or.an.expression", new Object[0]));
        }
        PhpExtractMethodBlockCodeFragment codeFragment2 = PhpExtractMethodHandler.tryToDetectBlockRangeElements(file, startElement, endElement);
        if (codeFragment2 != null) {
            this.tryExtractFromBlock(editor, codeFragment2, allowInplace);
            return;
        }
        this.tryExtractFromExpression(editor, file, startOffset, endOffset, allowInplace);
    }

    private void extractFromValidatedCodeFragment(Project project, @NotNull Editor editor, PhpExtractMethodCodeFragment validatedFragment, boolean allowInplace) {
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(10);
        }
        if (validatedFragment instanceof PhpExtractMethodExpressionCodeFragment) {
            this.extractFromExpression(project, editor, (PhpExtractMethodExpressionCodeFragment)validatedFragment, false, allowInplace);
        } else {
            this.extractFromBlock(project, editor, (PhpExtractMethodBlockCodeFragment)validatedFragment, false, allowInplace);
        }
    }

    public static List<PhpExtractMethodCodeFragment> collectSuggestedCodeFragments(@NotNull PsiFile file, int startOffset) {
        List<PhpExtractMethodCodeFragment> fragments;
        List expressions;
        PhpExtractMethodExpressionCodeFragment target;
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(11);
        }
        if ((target = (PhpExtractMethodExpressionCodeFragment)ContainerUtil.getFirstItem((List)(expressions = ContainerUtil.filterIsInstance(fragments = PhpExtractMethodHandler.collectExtractableCodeFragments(file, startOffset), PhpExtractMethodExpressionCodeFragment.class)))) != null && target.getStartStatement() instanceof Variable && expressions.size() > 1) {
            expressions = expressions.subList(1, expressions.size());
        }
        ArrayList<PhpExtractMethodCodeFragment> suggestedFragments = new ArrayList<PhpExtractMethodCodeFragment>(ContainerUtil.getFirstItems((List)expressions, (int)2));
        if (expressions.size() > 2) {
            suggestedFragments.add((PhpExtractMethodCodeFragment)ContainerUtil.getLastItem(expressions));
        }
        List blocks = ContainerUtil.filterIsInstance(fragments, PhpExtractMethodBlockCodeFragment.class);
        int numBlocksToAdd = 6 - suggestedFragments.size();
        suggestedFragments.addAll(ContainerUtil.getFirstItems((List)blocks, (int)numBlocksToAdd));
        return suggestedFragments;
    }

    public static List<PhpExtractMethodCodeFragment> collectExtractableCodeFragments(@NotNull PsiFile file, int startOffset) {
        PhpExpression returnArgument;
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(12);
        }
        PsiElement elementAtCaret = file.findElementAt(startOffset);
        List expressionFragments = ContainerUtil.map(PhpExtractMethodHandler.collectExtractableExpressions(file, startOffset), e -> new PhpExtractMethodExpressionCodeFragment(file, PhpExtractMethodHandler.getScopeHolder((PsiElement)e), (PhpExpression)e));
        ArrayList<PhpExtractMethodCodeFragment> codeFragments = new ArrayList<PhpExtractMethodCodeFragment>(expressionFragments);
        PhpExpression expression = PhpExtractMethodHandler.getExtractableExpressionFromAssignmentRHS(startOffset, elementAtCaret);
        if (expression != null) {
            codeFragments.add(new PhpExtractMethodExpressionCodeFragment(file, PhpExtractMethodHandler.getScopeHolder((PsiElement)expression), expression));
        }
        if ((returnArgument = PhpExtractMethodHandler.getExtractableExpressionFromReturnArgument(startOffset, elementAtCaret)) != null) {
            codeFragments.add(new PhpExtractMethodExpressionCodeFragment(file, PhpExtractMethodHandler.getScopeHolder((PsiElement)returnArgument), returnArgument));
        }
        Statement statement = PhpExtractMethodHandler.getSuitableParentStatement(elementAtCaret);
        PhpExtractMethodHandler.addCodeBlockOfBodyStatements(elementAtCaret, statement, codeFragments);
        while (statement != null) {
            PhpExtractMethodBlockCodeFragment blockFragment = new PhpExtractMethodBlockCodeFragment(statement, statement, PhpExtractMethodHandler.getScopeHolder((PsiElement)statement));
            statement = PhpExtractMethodHandler.getSuitableParentStatement((PsiElement)statement);
            if (PhpExtractMethodHandler.checkControlFlow(blockFragment) != null) continue;
            codeFragments.add(blockFragment);
        }
        return codeFragments;
    }

    @Nullable
    private static PhpExpression getExtractableExpressionFromReturnArgument(int startOffset, PsiElement elementAtCaret) {
        PhpReturn phpReturn = PhpPsiUtil.getParentOfClass(elementAtCaret, false, PhpReturn.class);
        if (phpReturn == null) {
            return null;
        }
        PsiElement argument = phpReturn.getArgument();
        if (argument == null) {
            return null;
        }
        PhpExpression argumentExpression = (PhpExpression)ObjectUtils.tryCast((Object)argument, PhpExpression.class);
        if (phpReturn.getFirstChild().getTextRange().contains(startOffset) && argumentExpression != null && PhpExtractMethodHandler.isExtractable(argumentExpression)) {
            return argumentExpression;
        }
        return null;
    }

    private static void addCodeBlockOfBodyStatements(PsiElement elementAtCaret, @Nullable Statement statement, List<PhpExtractMethodCodeFragment> codeFragments) {
        if (statement == null) {
            return;
        }
        GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getParentByCondition(elementAtCaret, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF, (Condition<? super PsiElement>)((Condition)statement::equals));
        if (groupStatement == null) {
            return;
        }
        Object[] statements = groupStatement.statements().filter(s -> !PhpPsiUtil.isOfType(s.getFirstChild(), PhpTokenTypes.opSEMICOLON)).toList().toArray(PsiElement.EMPTY_ARRAY);
        if (statements.length == 0) {
            return;
        }
        if (statements.length == 1 && (statements[0].getFirstChild() instanceof PhpExpression || statements[0] instanceof PhpReturn)) {
            return;
        }
        if (!ContainerUtil.and((Object[])statements, Statement.class::isInstance)) {
            return;
        }
        PhpScopeHolder scope = PhpExtractMethodHandler.getScopeHolder((PsiElement)statements[0]);
        PhpExtractMethodBlockCodeFragment fragment = new PhpExtractMethodBlockCodeFragment((Statement)statements[0], (Statement)statements[statements.length - 1], scope);
        if (PhpExtractMethodHandler.checkControlFlow(fragment) == null) {
            codeFragments.add(fragment);
        }
    }

    @Nullable
    public static PhpExpression getExtractableExpressionFromAssignmentRHS(int startOffset, PsiElement elementAtCaret) {
        AssignmentExpression assignment = PhpPsiUtil.getParentOfClass(elementAtCaret, false, AssignmentExpression.class);
        if (assignment == null) {
            return null;
        }
        PhpPsiElement variable = assignment.getVariable();
        if (variable == null) {
            return null;
        }
        PhpExpression rhsExpression = (PhpExpression)ObjectUtils.tryCast((Object)assignment.getValue(), PhpExpression.class);
        if (variable.getTextRange().contains(startOffset) && rhsExpression != null && PhpExtractMethodHandler.isExtractable(rhsExpression)) {
            return rhsExpression;
        }
        return null;
    }

    @Nullable
    private static Statement getSuitableParentStatement(PsiElement elementAtCaret) {
        Condition supportedScopesCondition = e -> e instanceof ForeachStatement || e instanceof For || e instanceof While || e instanceof If || e instanceof DoWhile || e instanceof Try || e instanceof PhpSwitch;
        return (Statement)PhpPsiUtil.getParentByCondition(elementAtCaret, (Condition<? super PsiElement>)supportedScopesCondition, (Condition<? super PsiElement>)PhpScopeHolder.INSTANCE_OF);
    }

    @Nullable
    public static PhpExtractMethodBlockCodeFragment tryToDetectBlockRangeElements(@NotNull PsiFile file, PsiElement startElement, PsiElement endElement) {
        Statement endStatement;
        PsiComment blockEndElement;
        PsiElement directive;
        Statement startStatement;
        PsiComment blockStartElement;
        PsiComment startComment;
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(13);
        }
        if ((startComment = PhpPsiUtil.getParentOfClass(startElement, false, PsiComment.class)) != null) {
            blockStartElement = startComment;
            startStatement = PhpExtractMethodHandler.findEndStatement(null, PhpPsiUtil.getNextSibling((PsiElement)blockStartElement, PhpPsiUtil.PSI_COMMENT_INSTANCEOF, PhpPsiUtil.PSI_WHITE_SPACE_INSTANCEOF));
        } else {
            startStatement = PhpExtractMethodHandler.findStartStatement(startElement);
            blockStartElement = startStatement;
        }
        if (startStatement instanceof Declare && (directive = DeclareImpl.getStrictTypesDirective((Declare)((Declare)startStatement))) != null) {
            return null;
        }
        PsiComment endComment = PhpPsiUtil.getParentOfClass(endElement, false, PsiComment.class);
        if (endComment != null) {
            blockEndElement = endComment;
            endStatement = PhpExtractMethodHandler.findEndStatement((PsiElement)blockStartElement, PhpPsiUtil.getPrevSibling((PsiElement)blockEndElement, PhpPsiUtil.PSI_COMMENT_INSTANCEOF, PhpPsiUtil.PSI_WHITE_SPACE_INSTANCEOF));
        } else {
            endStatement = PhpExtractMethodHandler.findEndStatement((PsiElement)blockStartElement, endElement);
            blockEndElement = endStatement;
        }
        PhpScopeHolder scopeHolder = PhpPsiUtil.getParentOfClass((PsiElement)startStatement, false, PhpScopeHolder.class);
        if (scopeHolder != null && blockEndElement != null && endStatement != null) {
            return new PhpExtractMethodBlockCodeFragment(file, scopeHolder, (PsiElement)blockStartElement, (PsiElement)blockEndElement, startStatement, endStatement);
        }
        return null;
    }

    public static List<PhpExpression> collectExtractableExpressions(@NotNull PsiFile file, int offset) {
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(14);
        }
        PsiElement elementAtCaret = file.findElementAt(offset);
        ArrayList<PhpExpression> expressions = new ArrayList<PhpExpression>();
        PhpExpression expression = PhpPsiUtil.getParentOfClass(elementAtCaret, PhpExpression.class);
        while (expression != null) {
            if (!(expressions.contains(expression) || expression instanceof ParenthesizedExpression || expression instanceof ArrayIndex || PhpIntroduceBaseHandler.isThisReferenceInMemberContext((PsiElement)expression, expression.getParent()) || !PhpExtractMethodHandler.isExtractable(expression))) {
                expressions.add(expression);
            }
            expression = PhpPsiUtil.getParentOfClass((PsiElement)expression, PhpExpression.class);
        }
        return expressions;
    }

    public static boolean isExtractable(@NotNull PhpExpression expression) {
        if (expression == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(15);
        }
        PhpScopeHolder scopeHolder = (PhpScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)expression, PhpScopeHolder.class, (boolean)false, (Class[])new Class[]{PhpClass.class});
        return PhpExtractMethodHandler.validateExpression(expression.getContainingFile(), scopeHolder, expression, expression.getTextRange().getEndOffset()) == null;
    }

    private void tryExtractFromExpression(@NotNull Editor editor, @NotNull PsiFile file, int startOffset, int endOffset, boolean allowInplace) throws PhpRefactoringErrorException {
        String error;
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(16);
        }
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(17);
        }
        PhpExpression expression = (PhpExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)endOffset, PhpExpression.class);
        PhpScopeHolder scopeHolder = (PhpScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)expression, PhpScopeHolder.class, (boolean)false, (Class[])new Class[]{PhpClass.class});
        if (expression != null && PhpPsiUtil.isOfType(file.findElementAt(endOffset - 1), PhpTokenTypes.opSEMICOLON)) {
            --endOffset;
        }
        if ((error = PhpExtractMethodHandler.validateExpression(file, scopeHolder, expression, endOffset)) != null) {
            throw new PhpRefactoringErrorException(error);
        }
        assert (scopeHolder != null);
        PhpExtractMethodExpressionCodeFragment fragment = new PhpExtractMethodExpressionCodeFragment(file, scopeHolder, expression);
        this.extractFromExpression(fragment.getScopeHolder().getProject(), editor, fragment, true, allowInplace);
    }

    @Nullable
    private static String validateExpression(@NotNull PsiFile file, @Nullable PhpScopeHolder scopeHolder, @Nullable PhpExpression expression, int endOffset) {
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(18);
        }
        if (expression == null || expression.getTextRange().getEndOffset() != endOffset) {
            return PhpBundle.message("refactoring.extract.method.error.selected.block.should.represent.a.set.of.statement.or.an.expression", new Object[0]);
        }
        if (scopeHolder == null || scopeHolder instanceof Function && FunctionImpl.isShortArrowFunction((Function)scopeHolder)) {
            return PhpBundle.message("refactoring.common.not.supported.context", PhpExtractMethodHandler.getRefactoringName());
        }
        if (!PhpRefactoringUtil.isExtractableExpression(expression)) {
            return PhpBundle.message("refactoring.common.not.extractable.expression", new Object[0]);
        }
        if (expression instanceof RWAccess && ((RWAccess)expression).isWriteAccess()) {
            return PhpBundle.message("refactoring.common.not.extractable.expression", new Object[0]);
        }
        if (PhpPsiUtil.getParentOfClass((PsiElement)expression, PhpAttribute.class) != null) {
            return PhpBundle.message("refactoring.common.not.supported.context", PhpExtractMethodHandler.getRefactoringName());
        }
        if (PhpPsiUtil.getParentOfClass((PsiElement)expression, PhpDocComment.class) != null) {
            return PhpBundle.message("refactoring.extract.method.error.selected.block.should.represent.a.set.of.statement.or.an.expression", new Object[0]);
        }
        if (PhpPsiUtil.getParentOfClass((PsiElement)expression, PhpUse.class) != null) {
            return PhpBundle.message("refactoring.common.not.supported.context", PhpExtractMethodHandler.getRefactoringName());
        }
        if (expression instanceof ClassReference) {
            return PhpBundle.message("refactoring.common.not.extractable.expression", new Object[0]);
        }
        if (expression instanceof Variable && StringUtil.isEmpty((String)expression.getName()) || expression instanceof AssignmentExpression) {
            return PhpBundle.message("refactoring.common.not.extractable.expression", new Object[0]);
        }
        if (PhpPsiUtil.getParentByCondition((PsiElement)expression, (Condition<? super PsiElement>)((Condition)e -> e instanceof Parameter || e instanceof Constant || e instanceof Field)) != null) {
            return PhpBundle.message("refactoring.common.not.supported.context", PhpExtractMethodHandler.getRefactoringName());
        }
        PhpExtractMethodExpressionCodeFragment fragment = new PhpExtractMethodExpressionCodeFragment(file, scopeHolder, expression);
        String error = fragment.validate();
        if (StringUtil.isNotEmpty((String)error)) {
            LOG.error(error);
            return PhpBundle.message("refactoring.common.fail.to.extract.expression", new Object[0]);
        }
        return null;
    }

    @Nullable
    private static Statement findStartStatement(@Nullable PsiElement startElement) {
        if (startElement == null || startElement.getTextRange() == null) {
            return null;
        }
        int startOffset = startElement.getTextRange().getStartOffset();
        Statement prevStatement = null;
        Statement curStatement = PhpPsiUtil.getParentOfClass(startElement, false, Statement.class);
        while (curStatement != null && curStatement.getTextRange().getStartOffset() == startOffset) {
            if (!(curStatement instanceof GroupStatement)) {
                prevStatement = curStatement;
            }
            curStatement = PhpPsiUtil.getParentOfClass((PsiElement)curStatement, Statement.class);
        }
        return prevStatement;
    }

    @Nullable
    private static Statement findEndStatement(@Nullable PsiElement startElement, @Nullable PsiElement endElement) {
        TextRange startElementRange;
        if (endElement == null || endElement.getTextRange() == null) {
            return null;
        }
        int endOffset = endElement.getTextRange().getEndOffset();
        PsiElement possiblySemicolon = endElement.getParent().getNextSibling();
        if (startElement != endElement && PhpPsiUtil.isOfType(possiblySemicolon, PhpTokenTypes.opSEMICOLON)) {
            endOffset = possiblySemicolon.getTextRange().getEndOffset();
        }
        Statement prevElement = null;
        Statement curStatement = PhpPsiUtil.getParentOfClass(endElement, false, Statement.class);
        TextRange textRange = startElementRange = startElement == null ? null : startElement.getTextRange();
        while (curStatement != null && curStatement.getTextRange().getEndOffset() == endOffset && !PhpExtractMethodHandler.strictContains((PsiElement)curStatement, startElementRange)) {
            if (!(curStatement instanceof GroupStatement)) {
                prevElement = curStatement;
            }
            curStatement = PhpPsiUtil.getParentOfClass((PsiElement)curStatement, Statement.class);
        }
        return prevElement;
    }

    private static boolean strictContains(@NotNull PsiElement element, @Nullable TextRange textRange) {
        if (element == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(19);
        }
        TextRange elementTextRange = element.getTextRange();
        return textRange != null && !elementTextRange.equalsToRange(textRange.getStartOffset(), textRange.getEndOffset()) && elementTextRange.contains(textRange);
    }

    public static PhpExtractMethodSettings getSettingsForInplace(PhpExtractMethodCodeFragment fragment, boolean handleDuplicates) {
        PhpScopeHolder scopeHolder = fragment.getScopeHolder();
        Method method = (Method)ObjectUtils.tryCast((Object)scopeHolder, Method.class);
        boolean isStatic = method != null && method.isStatic();
        PhpNameConflictDetector nameConflictDetector = method != null ? new PhpMethodConflictDetector(method.getContainingClass()) : new PhpFunctionInScopeConflictDetector(scopeHolder);
        Set<PhpPsiElement> outputVariables = PhpExtractMethodHandler.getOutputVariables(fragment);
        Project project = scopeHolder.getProject();
        Set<String> names = PhpExtractMethodDialog.uniqueNameSuggestions(project, fragment, outputVariables, nameConflictDetector);
        return PhpExtractMethodHandler.getSettingsForBatchMode(project, names, isStatic, fragment, PhpExtractMethodHandler.getInputVariables(fragment), outputVariables, handleDuplicates);
    }

    public void extractFromExpression(@NotNull Project project, @NotNull Editor editor, @NotNull PhpExtractMethodExpressionCodeFragment fragment, boolean restoreSelection, boolean allowInplace) {
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(20);
        }
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(21);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(22);
        }
        if (allowInplace && editor.getSettings().isVariableInplaceRenameEnabled()) {
            PhpExtractMethodHandler.extractInplace(project, editor, fragment);
            return;
        }
        this.extractFromExpressionWithDialog(project, editor, fragment, restoreSelection);
    }

    public void extractFromExpressionWithDialog(@NotNull Project project, @NotNull Editor editor, @NotNull PhpExtractMethodExpressionCodeFragment fragment, boolean restoreSelection) {
        PhpExtractMethodSettings settings;
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(23);
        }
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(24);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(25);
        }
        Statement anchorStatement = PhpPsiUtil.getParentOfClass(fragment.getStartStatement(), Statement.class);
        assert (anchorStatement != null);
        if (!editor.getSelectionModel().hasSelection()) {
            editor.getSelectionModel().setSelection(fragment.getStartOffset(), fragment.getEndOffset());
        }
        if ((settings = this._getSettings(fragment)) == null) {
            return;
        }
        fragment.setPassOutputByRefParam(settings.isPassOutputByReference());
        WriteCommandAction.runWriteCommandAction((Project)project, (String)PhpExtractMethodHandler.getRefactoringName(), (String)HELP_ID, () -> {
            Ref callElementOffset = Ref.create();
            PhpExtractMethodHandler.addRestoreSelectionAndCaretUndoableAction(project, editor, (Ref<Integer>)callElementOffset, restoreSelection);
            PhpExpression callExpression = PhpExtractMethodHandler.createCallExpression(fragment, settings);
            PsiElement functionDefinition = PhpExtractMethodHandler.addFunctionDefinition(fragment, settings, (PsiElement)anchorStatement);
            PsiElement callElement = PhpExtractMethodHandler.addCallElement(callExpression, fragment.getStartStatement());
            callElementOffset.set((Object)callElement.getTextOffset());
            PhpExtractMethodHandler.removeSelectionAndMoveCaretToElement(editor, callElement);
            if (settings.processDuplicates()) {
                this.processDuplicates(functionDefinition, callElement, fragment, settings, editor);
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    public static PsiElement addCallElement(PhpExpression callExpression, PsiElement expression) {
        PsiElement elementToReplace;
        Object object = elementToReplace = expression instanceof ArrayIndex ? ((ArrayIndex)expression).getValue() : expression;
        assert (elementToReplace != null);
        return elementToReplace.replace((PsiElement)callExpression);
    }

    @NotNull
    public static PhpSimpleDuplicatesFinder createDuplicatesFinder(@NotNull PhpExtractMethodCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(26);
        }
        return PhpExtractMethodHandler.createDuplicatesFinder(fragment, PhpExtractMethodHandler.getInputVariables(fragment), PhpExtractMethodHandler.getOutputVariables(fragment));
    }

    @NotNull
    static PhpSimpleDuplicatesFinder createDuplicatesFinder(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, @NotNull Set<PhpPsiElement> outputVariables) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(27);
        }
        if (inputVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(28);
        }
        if (outputVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(29);
        }
        return new PhpSimpleDuplicatesFinder(fragment, PhpExtractMethodHandler.transform(inputVariables), ContainerUtil.map(outputVariables, PsiElement::getText));
    }

    private void tryExtractFromBlock(@NotNull Editor editor, @NotNull PhpExtractMethodBlockCodeFragment fragment, boolean allowInplace) throws PhpRefactoringErrorException {
        String validationWarning;
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(30);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(31);
        }
        if ((validationWarning = PhpExtractMethodHandler.validateBlockFragment(fragment)) != null) {
            throw new PhpRefactoringErrorException(validationWarning);
        }
        this.extractFromBlock(fragment.getScopeHolder().getProject(), editor, fragment, true, allowInplace);
    }

    @Nullable
    public static String validateBlockFragment(@NotNull PhpExtractMethodBlockCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(32);
        }
        if (fragment.getStartElement().getParent() != fragment.getEndElement().getParent() || fragment.getStartStatement().getParent() != fragment.getEndStatement().getParent()) {
            return PhpBundle.message("refactoring.extract.method.error.a.set.of.statements.should.be.from.the.same.code.block", new Object[0]);
        }
        String fragmentValidationError = fragment.validate();
        if (fragmentValidationError == null) {
            return PhpExtractMethodHandler.checkControlFlow(fragment);
        }
        return fragmentValidationError;
    }

    public void extractFromBlock(@NotNull Project project, @NotNull Editor editor, @NotNull PhpExtractMethodBlockCodeFragment fragment, boolean restoreSelection, boolean allowInplace) {
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(33);
        }
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(34);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(35);
        }
        if (allowInplace && editor.getSettings().isVariableInplaceRenameEnabled()) {
            PhpExtractMethodHandler.extractInplace(project, editor, fragment);
            return;
        }
        this.extractFromBlockWithDialog(project, editor, fragment, restoreSelection);
    }

    public void extractFromBlockWithDialog(@NotNull Project project, @NotNull Editor editor, @NotNull PhpExtractMethodBlockCodeFragment fragment, boolean restoreSelection) {
        PhpExtractMethodSettings settings;
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(36);
        }
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(37);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(38);
        }
        if (!editor.getSelectionModel().hasSelection()) {
            editor.getSelectionModel().setSelection(fragment.getStartOffset(), fragment.getEndOffset());
        }
        if ((settings = this._getSettings(fragment)) == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)PhpExtractMethodHandler.getRefactoringName(), (String)HELP_ID, () -> {
            Ref callElementOffset = Ref.create();
            PhpExtractMethodHandler.addRestoreSelectionAndCaretUndoableAction(project, editor, (Ref<Integer>)callElementOffset, restoreSelection);
            Statement callStatement = PhpExtractMethodHandler.createCallStatement(fragment, settings);
            PsiElement functionDefinition = PhpExtractMethodHandler.addFunctionDefinition(fragment, settings, fragment.getStartElement());
            PsiElement callElement = PhpExtractMethodHandler.replaceWithCall(callStatement, fragment.getStartElement(), fragment);
            callElementOffset.set((Object)callElement.getTextOffset());
            PhpExtractMethodHandler.removeSelectionAndMoveCaretToElement(editor, callElement);
            if (settings.processDuplicates()) {
                this.processDuplicates(functionDefinition, callElement, fragment, settings, editor);
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private static void extractInplace(@NotNull Project project, @NotNull Editor editor, @NotNull PhpExtractMethodCodeFragment fragment) {
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(39);
        }
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(40);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(41);
        }
        PhpExtractMethodHandler.extractInplace(project, editor, fragment, false);
    }

    public static void extractInplace(@NotNull Project project, @NotNull Editor editor, @NotNull PhpExtractMethodCodeFragment fragment, boolean handleDuplicates) {
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(42);
        }
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(43);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(44);
        }
        PsiFile file = fragment.getFile();
        CommandProcessor.getInstance().executeCommand(project, () -> {
            PhpExtractMethodSettings settings = PhpExtractMethodHandler.getSettingsForInplace(fragment, handleDuplicates);
            PhpInplaceMethodExtractor inplaceMethodExtractor = new PhpInplaceMethodExtractor(project, file, editor, fragment, settings, new PhpExtractMethodPopupProvider());
            inplaceMethodExtractor.performInplaceRefactoring(settings.nameSuggestions());
        }, PhpBundle.message("refactoring.inplace.extract.method.name", new Object[0]), null);
    }

    @Nullable
    private static String checkControlFlow(@NotNull PhpExtractMethodBlockCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(45);
        }
        PhpControlFlow controlFlow = fragment.getScopeHolder().getControlFlow();
        PhpStatementInstruction startInstruction = PhpControlFlowUtil.getStatementInstruction(controlFlow, fragment.getStartStatement());
        PhpStatementInstruction endInstruction = PhpControlFlowUtil.getStatementInstruction(controlFlow, fragment.getEndStatement());
        if (startInstruction == null || endInstruction == null) {
            return PhpBundle.message("refactoring.extract.method.error.a.set.of.statements.should.be.from.the.same.code.block", new Object[0]);
        }
        if (PhpExtractMethodHandler.breakContinueAreInconsistent(fragment, startInstruction)) {
            return PhpBundle.message("refactoring.extract.method.error.there.are.break.continue.operators.which.can.interrupt.execution", new Object[0]);
        }
        if (PhpExtractMethodHandler.returnPointsAreInconsistent(fragment, startInstruction)) {
            return PhpBundle.message("refactoring.extract.method.error.inconsistent.return.points.in.selected.code.fragment", new Object[0]);
        }
        return null;
    }

    private static boolean breakContinueAreInconsistent(final @NotNull PhpExtractMethodBlockCodeFragment fragment, PhpStatementInstruction startInstruction) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(46);
        }
        final Ref isBreakContinueOutExistsRef = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)startInstruction, true, new PhpInstructionProcessor(){

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                return fragment.contains(instruction.getStatement().getTextRange());
            }

            public boolean processBreakContinueInstruction(PhpBreakContinueInstruction gotoInstruction) {
                Statement targetStatement = gotoInstruction.getTargetStatement();
                if (targetStatement != null && !fragment.contains(targetStatement.getTextRange())) {
                    isBreakContinueOutExistsRef.set((Object)true);
                }
                return true;
            }
        });
        return (Boolean)isBreakContinueOutExistsRef.get();
    }

    private static boolean returnPointsAreInconsistent(final @NotNull PhpExtractMethodBlockCodeFragment fragment, PhpStatementInstruction startInstruction) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(47);
        }
        final Ref isOutStatementReachableRef = new Ref((Object)false);
        final Ref isReturnReachableRef = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)startInstruction, true, new PhpInstructionProcessor(){

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                if (!fragment.contains(instruction.getStatement().getTextRange())) {
                    isOutStatementReachableRef.set((Object)true);
                    return false;
                }
                return true;
            }

            public boolean stopTraverseOnThrowInterruptingInstruction() {
                return true;
            }

            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                isReturnReachableRef.set((Object)true);
                return false;
            }
        });
        return (Boolean)isOutStatementReachableRef.get() != false && (Boolean)isReturnReachableRef.get() != false;
    }

    private static void addRestoreSelectionAndCaretUndoableAction(Project project, final @NotNull Editor editor, final @NotNull Ref<Integer> redoOffset, final boolean restoreSelection) {
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(48);
        }
        if (redoOffset == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(49);
        }
        final int start = editor.getSelectionModel().getSelectionStart();
        final int end = editor.getSelectionModel().getSelectionEnd();
        final boolean ltrSelection = editor.getSelectionModel().getLeadSelectionOffset() != end;
        final int caretOffset = editor.getCaretModel().getOffset();
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() {
                if (restoreSelection) {
                    if (ltrSelection) {
                        editor.getSelectionModel().setSelection(start, end);
                    } else {
                        editor.getSelectionModel().setSelection(end, start);
                    }
                }
                editor.getCaretModel().moveToOffset(caretOffset);
            }

            public void redo() {
                if (!redoOffset.isNull()) {
                    editor.getCaretModel().moveToOffset(((Integer)redoOffset.get()).intValue());
                }
                editor.getSelectionModel().removeSelection();
            }
        });
    }

    protected void processDuplicates(@NotNull PsiElement functionDefinition, @NotNull PsiElement callElement, @NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpExtractMethodSettings settings, @NotNull Editor editor) {
        if (functionDefinition == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(50);
        }
        if (callElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(51);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(52);
        }
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(53);
        }
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(54);
        }
        PhpExtractMethodHandler.processDuplicatesImpl(functionDefinition, callElement, fragment, settings, editor);
    }

    public static void processDuplicatesImpl(@NotNull PsiElement functionDefinition, @Nullable PsiElement callElement, @NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpExtractMethodSettings settings, @NotNull Editor editor) {
        if (functionDefinition == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(55);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(56);
        }
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(57);
        }
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(58);
        }
        PhpExtractMethodHandler.processDuplicatesImpl(functionDefinition, callElement, fragment, settings, editor, false);
    }

    public static void processDuplicatesImpl(@NotNull PsiElement functionDefinition, @Nullable PsiElement callElement, @NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpExtractMethodSettings settings, @NotNull Editor editor, boolean awaitProcessing) {
        if (functionDefinition == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(59);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(60);
        }
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(61);
        }
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(62);
        }
        PhpSimpleDuplicatesFinder finder = PhpExtractMethodHandler.createDuplicatesFinder(fragment, settings.getInputVariables(), settings.getOutputVariables());
        finder.setReplacement(callElement);
        callElement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)callElement);
        PhpScopeHolder holder = PhpPsiUtil.getScopeHolder(callElement);
        List<PsiElement> elements = PhpExtractMethodHandler.collectDuplicateScopes(holder, functionDefinition);
        if (awaitProcessing) {
            finder.setReplacement(callElement);
            ExtractMethodHelper.replaceDuplicates((PsiElement)callElement, (Editor)editor, pair -> PhpExtractMethodHandler.replaceElements((SimpleMatch)pair.first, ((PsiElement)pair.second).copy()), (List)finder.findDuplicates(elements, functionDefinition));
        } else {
            ExtractMethodHelper.processDuplicates((PsiElement)callElement, (PsiElement)functionDefinition, elements, (SimpleDuplicatesFinder)finder, (Editor)editor, pair -> PhpExtractMethodHandler.replaceElements((SimpleMatch)pair.first, ((PsiElement)pair.second).copy()));
        }
    }

    @NotNull
    static List<PsiElement> collectDuplicateScopes(@Nullable PhpScopeHolder holder, @NotNull PsiElement functionDefinition) {
        if (functionDefinition == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(63);
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        elements.add((PsiElement)holder);
        PhpClass phpClass = PhpPsiUtil.getParentOfClass(functionDefinition, PhpClass.class);
        if (phpClass != null) {
            for (Method it : phpClass.getMethods()) {
                if (it.equals(functionDefinition) || it.equals(holder)) continue;
                elements.add((PsiElement)it);
            }
        }
        ArrayList<PsiElement> arrayList = elements;
        if (arrayList == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(64);
        }
        return arrayList;
    }

    public static void replaceElements(@NotNull SimpleMatch match, @NotNull PsiElement callElement) {
        PhpPsiElement variable;
        if (match == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(65);
        }
        if (callElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(66);
        }
        List elementsRange = PsiTreeUtil.getElementsOfRange((PsiElement)match.getStartElement(), (PsiElement)match.getEndElement());
        callElement = ((PsiElement)elementsRange.get(0)).replace(PhpExtractMethodHandler.patchArguments(match, callElement));
        String changedOutput = match.getChangedOutput();
        AssignmentExpression assignment = (AssignmentExpression)ObjectUtils.tryCast((Object)callElement.getFirstChild(), AssignmentExpression.class);
        if (changedOutput != null && assignment != null && (variable = assignment.getVariable()) instanceof Variable) {
            variable.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(callElement.getProject(), Variable.class, changedOutput));
        }
        if (elementsRange.size() > 1) {
            callElement.getParent().deleteChildRange((PsiElement)elementsRange.get(1), (PsiElement)elementsRange.get(elementsRange.size() - 1));
        }
    }

    @NotNull
    private static PsiElement patchArguments(@NotNull SimpleMatch match, @NotNull PsiElement callElement) {
        Map changedParameters;
        if (match == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(67);
        }
        if (callElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(68);
        }
        if ((changedParameters = match.getChangedParameters()).isEmpty()) {
            PsiElement psiElement = callElement;
            if (psiElement == null) {
                PhpExtractMethodHandler.$$$reportNull$$$0(69);
            }
            return psiElement;
        }
        FunctionReference functionCall = (FunctionReference)PsiTreeUtil.findChildOfType((PsiElement)callElement, FunctionReference.class, (boolean)false);
        assert (functionCall != null) : "invalid call element generated";
        final Project project = callElement.getProject();
        final HashMap<Variable, PsiElement> variableToReplacement = new HashMap<Variable, PsiElement>();
        functionCall.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpVariable(Variable variable) {
                super.visitPhpVariable(variable);
                String text = variable.getText();
                if (changedParameters.containsKey(text)) {
                    variableToReplacement.put(variable, PhpPsiElementFactory.createStatement(project, (String)changedParameters.get(text)).getFirstChild());
                }
            }
        });
        variableToReplacement.forEach((variable, replacemenet) -> variable.replace(replacemenet));
        PsiElement psiElement = callElement;
        if (psiElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(70);
        }
        return psiElement;
    }

    private static AbstractVariableData[] transform(Set<PhpPsiElement> inputVars) {
        AbstractVariableData[] answer = new AbstractVariableData[inputVars.size()];
        int i = 0;
        for (PhpPsiElement it : inputVars) {
            answer[i] = new AbstractVariableData();
            answer[i].name = it.getName();
            answer[i].originalName = it instanceof Variable ? it.getText() : it.getName();
            answer[i].passAsParameter = true;
            ++i;
        }
        return answer;
    }

    public static PsiElement replaceWithCall(Statement callStatement, PsiElement startElement, @NotNull PhpExtractMethodBlockCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(71);
        }
        PsiElement callElement = startElement.getParent().addBefore((PsiElement)callStatement, startElement);
        startElement.getParent().deleteChildRange(startElement, fragment.getEndElement());
        return callElement;
    }

    private static void removeSelectionAndMoveCaretToElement(@NotNull Editor editor, @NotNull PsiElement callElement) {
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(72);
        }
        if (callElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(73);
        }
        editor.getSelectionModel().removeSelection();
        editor.getCaretModel().moveToOffset(callElement.getTextOffset());
    }

    public static PsiElement addFunctionDefinition(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpExtractMethodSettings settings, @NotNull PsiElement anchorElement) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(74);
        }
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(75);
        }
        if (anchorElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(76);
        }
        PsiElement function = PhpExtractMethodHandler.insertDefinition(fragment, settings, anchorElement);
        PhpExtractMethodHandler.renameParametersInFunction(function, settings.getParameters());
        settings.getParameterFolder().foldParameterUsagesInBodyIfNeeded(function, settings.getInputVariables());
        if (settings.generatePhpDoc()) {
            PhpDocComment comment = PhpDocCommentGenerator.constructDocComment(anchorElement.getProject(), function, false);
            PsiElement parent = function.getParent();
            if (parent != null && !PhpExtractMethodHandler.isEmptyComment(comment)) {
                parent.addBefore((PsiElement)comment, function);
            }
        }
        if (function instanceof Function) {
            String retType;
            PhpType localType = ((Function)function).getLocalType(true).global(function.getProject());
            if (PhpType.isArray((PhpType)localType)) {
                localType = PhpType.ARRAY;
            }
            if ((retType = PhpExtractMethodHandler.getReturnTypePresentation(function.getProject(), localType, (Function)function)) != null) {
                PhpExtractMethodHandler.insertReturnType(function, retType);
            }
        }
        return function;
    }

    @Nullable
    public static String getReturnTypePresentation(Project project, @NotNull PhpType localType, Function function) {
        if (localType == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(77);
        }
        if (!PhpLanguageFeature.RETURN_TYPES.isSupported(project)) {
            return null;
        }
        PhpType composedType = PhpMissingFieldTypeInspection.composeType(project, localType, PhpType::isAnonymousClass);
        String retType = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, composedType, (PsiElement)function);
        if (StringUtil.isEmpty((String)retType)) {
            return null;
        }
        if (retType.equals("$this") && function instanceof Method) {
            PhpClass containingClass = ((Method)function).getContainingClass();
            return containingClass != null ? containingClass.getName() : retType;
        }
        boolean isUnionType = retType.contains("|");
        if (composedType.getTypes().contains("\\mixed") && !PhpLanguageFeature.MIXED_TYPE_HINT.isSupported(project) || composedType.getTypes().contains("\\void") && (!PhpLanguageFeature.RETURN_VOID.isSupported(project) || isUnionType)) {
            return null;
        }
        return retType;
    }

    private static void insertReturnType(PsiElement function, String retType) {
        PsiElement lastChild = function.getLastChild();
        if (lastChild instanceof GroupStatement) {
            function.addBefore(PhpPsiElementFactory.createFromText(function.getProject(), PhpTokenTypes.opCOLON, ":"), lastChild);
            function.addBefore((PsiElement)PhpPsiElementFactory.createReturnType(function.getProject(), retType), lastChild);
        }
    }

    private static boolean isEmptyComment(@Nullable PhpDocComment comment) {
        return comment == null || comment.getParamTags().isEmpty() && comment.getReturnTag() == null;
    }

    private static PsiElement insertDefinition(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpExtractMethodSettings settings, @NotNull PsiElement anchorElement) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(78);
        }
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(79);
        }
        if (anchorElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(80);
        }
        PhpScopeHolder scopeHolder = PhpExtractMethodHandler.getNearestNonClosureScopeHolder(fragment.getScopeHolder());
        Function definition = PhpExtractMethodHandler.createDefinition(scopeHolder.getProject(), settings, scopeHolder instanceof Method);
        PhpExtractMethodHandler.patchDefinition(settings, (PhpScopeHolder)definition);
        return PhpExtractMethodHandler.insertDefinition(scopeHolder, anchorElement, definition);
    }

    public static PsiElement insertDefinition(@NotNull PhpScopeHolder scopeHolder, @NotNull PsiElement anchorElement, Function definition) {
        PsiElement curChild;
        if (scopeHolder == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(81);
        }
        if (anchorElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(82);
        }
        if ((scopeHolder = PhpExtractMethodHandler.getNearestNonClosureScopeHolder(scopeHolder)) instanceof Method) {
            PhpClass clazz = ((Method)scopeHolder).getContainingClass();
            assert (clazz != null);
            return PhpCodeEditUtil.insertClassMember(clazz, (PsiElement)definition);
        }
        if (scopeHolder instanceof Function && !((Function)scopeHolder).isClosure()) {
            return scopeHolder.getParent().addAfter((PsiElement)definition, (PsiElement)scopeHolder);
        }
        GroupStatement groupStatement = (GroupStatement)PsiTreeUtil.findChildOfType((PsiElement)scopeHolder, GroupStatement.class);
        assert (groupStatement != null);
        for (curChild = groupStatement.getFirstChild(); curChild != null && !PsiTreeUtil.isAncestor((PsiElement)curChild, (PsiElement)anchorElement, (boolean)false); curChild = curChild.getNextSibling()) {
        }
        assert (curChild != null);
        return groupStatement.addBefore((PsiElement)definition, curChild);
    }

    @NotNull
    public static Function createDefinition(@NotNull Project project, @NotNull PhpExtractMethodSettings settings, boolean method) {
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(83);
        }
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(84);
        }
        if (method) {
            Method method2 = PhpPsiElementFactory.createMethod(project, PhpExtractMethodHandler.generateFunctionText(settings));
            if (method2 == null) {
                PhpExtractMethodHandler.$$$reportNull$$$0(85);
            }
            return method2;
        }
        Function function = PhpPsiElementFactory.createFunction(project, PhpExtractMethodHandler.generateFunctionText(settings));
        if (function == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(86);
        }
        return function;
    }

    private static void patchDefinition(@NotNull PhpExtractMethodSettings settings, @NotNull PhpScopeHolder function) {
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(87);
        }
        if (function == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(88);
        }
        String returnArgument = PhpExtractMethodHandler.generateReturnArgument(settings);
        if (!settings.isReplaceBreakContinueWithReturn()) {
            PhpExtractMethodHandler.addReturnStatementToEndOfFunctionIfNeeded(returnArgument, function);
        } else {
            final HashSet breakStatements = new HashSet();
            PhpExitPointInstruction exitPoint = function.getControlFlow().getExitPoint();
            PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)exitPoint, false, new PhpInstructionProcessor(){

                public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                    Statement statement = instruction.getStatement();
                    if (statement instanceof PhpBreak) {
                        breakStatements.add(statement);
                    }
                    return false;
                }
            });
            PhpReturn returnStatement = PhpPsiElementFactory.createReturnStatement(function.getProject(), returnArgument);
            for (Statement breakStatement : breakStatements) {
                breakStatement.replace((PsiElement)returnStatement);
            }
            if (breakStatements.size() < exitPoint.getPredecessors().size()) {
                PhpExtractMethodHandler.addReturnStatementToEndOfFunctionIfNeeded(returnArgument, function);
            }
        }
    }

    @Nullable
    private static String generateReturnArgument(@NotNull PhpExtractMethodSettings settings) {
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(89);
        }
        if (settings.isPassOutputByReference()) {
            return null;
        }
        StringBuilder returnArgumentBuilder = new StringBuilder();
        Set<PhpPsiElement> outputVariables = settings.getOutputVariables();
        if (outputVariables.isEmpty()) {
            return null;
        }
        if (outputVariables.size() == 1) {
            returnArgumentBuilder.append("$");
            returnArgumentBuilder.append(((PhpPsiElement)ContainerUtil.getFirstItem(outputVariables)).getName());
        } else {
            returnArgumentBuilder.append("array(");
            Iterator<PhpPsiElement> iterator = outputVariables.iterator();
            while (iterator.hasNext()) {
                returnArgumentBuilder.append("$").append(iterator.next().getName());
                if (!iterator.hasNext()) continue;
                returnArgumentBuilder.append(",");
            }
            returnArgumentBuilder.append(")");
        }
        return returnArgumentBuilder.toString();
    }

    private static void addReturnStatementToEndOfFunctionIfNeeded(String returnArgument, @NotNull PhpScopeHolder function) {
        if (function == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(90);
        }
        if (returnArgument != null) {
            GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getChildOfType((PsiElement)function, PhpElementTypes.ANY_GROUP_STATEMENT);
            assert (groupStatement != null);
            Object child = PhpPsiUtil.getPrevSiblingByCondition(groupStatement.getLastChild(), (Condition<? super PsiElement>)((Condition)e -> !(e instanceof PhpDocPsiElement) && e instanceof PhpPsiElement));
            if (child != null && !(child instanceof PhpReturn)) {
                PhpReturn returnStatement = PhpPsiElementFactory.createReturnStatement(function.getProject(), returnArgument);
                groupStatement.addAfter((PsiElement)returnStatement, child);
            }
        }
    }

    public static Statement createCallStatement(@NotNull PhpExtractMethodBlockCodeFragment fragment, @NotNull PhpExtractMethodSettings settings) {
        Statement callStatement;
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(91);
        }
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(92);
        }
        PhpScopeHolder scopeHolder = PhpExtractMethodHandler.getNearestNonClosureScopeHolder(fragment.getScopeHolder());
        Project project = scopeHolder.getProject();
        if (scopeHolder instanceof Method) {
            String methodCallStatementText = PhpExtractMethodHandler.generateMethodCallStatementText(settings, fragment);
            callStatement = PhpPsiElementFactory.createStatement(project, methodCallStatementText);
        } else {
            String functionCallStatementText = PhpExtractMethodHandler.generateFunctionCallStatementText(settings, fragment);
            callStatement = PhpPsiElementFactory.createStatement(project, functionCallStatementText);
        }
        return callStatement;
    }

    public static PhpExpression createCallExpression(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpExtractMethodSettings settings) {
        PhpScopeHolder scopeHolder;
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(93);
        }
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(94);
        }
        Object callExpression = (scopeHolder = PhpExtractMethodHandler.getNearestNonClosureScopeHolder(fragment.getScopeHolder())) instanceof Method ? PhpPsiElementFactory.createMethodReference(scopeHolder.getProject(), PhpExtractMethodHandler.generateMethodCallText(settings)) : PhpPsiElementFactory.createFunctionReference(scopeHolder.getProject(), PhpExtractMethodHandler.generateCall(settings));
        return callExpression;
    }

    @Nullable
    private PhpExtractMethodSettings _getSettings(@NotNull PhpExtractMethodCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(95);
        }
        Set<PhpPsiElement> inputVariables = PhpExtractMethodHandler.getInputVariables(fragment);
        Set<PhpPsiElement> outputVariables = PhpExtractMethodHandler.getOutputVariables(fragment);
        return this.getSettings(fragment, inputVariables, outputVariables);
    }

    private static void renameParametersInFunction(@Nullable PsiElement element, @Nullable List<? extends PhpExtractMethodParameterInfo> newParameters) {
        if (element == null || newParameters == null) {
            return;
        }
        Parameter[] parameters = ((Function)element).getParameters();
        assert (parameters.length == newParameters.size());
        for (int i = 0; i < parameters.length; ++i) {
            PhpExtractMethodParameterInfo newParameter = newParameters.get(i);
            if (!newParameter.nameWasChanged()) continue;
            Parameter parameter = parameters[i];
            CharSequence newName = newParameter.getNewName();
            if (StringUtil.isEmpty((CharSequence)newName)) continue;
            ArrayList<UsageInfo> list = new ArrayList<UsageInfo>();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).findAll()) {
                if (reference.getElement() == parameter) continue;
                list.add(new UsageInfo(reference));
            }
            PhpExtractMethodHandler.renameParameter(parameter, newName.toString(), list.toArray(UsageInfo.EMPTY_ARRAY));
        }
    }

    private static void renameParameter(Parameter parameter, String newName, UsageInfo[] infos) {
        RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement((PsiElement)parameter);
        processor2.renameElement((PsiElement)parameter, newName, infos, null);
    }

    @NotNull
    public PhpExtractMethodDialog createSettings(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, @NotNull Set<PhpPsiElement> outputVariables) {
        PhpExtractMethodDialog dialog;
        boolean isReplacedBreakContinueWithReturnEnabled;
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(96);
        }
        if (inputVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(97);
        }
        if (outputVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(98);
        }
        PhpScopeHolder scopeHolder = PhpExtractMethodHandler.getNearestNonClosureScopeHolder(fragment.getScopeHolder());
        Project project = scopeHolder.getProject();
        String dummyFunctionText = PhpExtractMethodHandler.generateDummyFunction(fragment);
        Function dummyFunction = PhpPsiElementFactory.createFunction(project, dummyFunctionText);
        final Ref breakContinueTarget = new Ref();
        PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)dummyFunction.getControlFlow().getExitPoint(), false, new PhpInstructionProcessor(){

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                return false;
            }

            public boolean processInterruptScriptInstruction(PhpInterruptScriptInstruction instruction) {
                return false;
            }

            public boolean processBreakContinueInstruction(PhpBreakContinueInstruction instruction) {
                breakContinueTarget.set((Object)instruction.getTargetStatement());
                return false;
            }
        });
        boolean bl = isReplacedBreakContinueWithReturnEnabled = breakContinueTarget.get() != null;
        if (scopeHolder instanceof Method) {
            boolean isDeclareStatic;
            boolean isDeclareStaticEnabled;
            Method method = (Method)scopeHolder;
            if (method.isStatic()) {
                isDeclareStaticEnabled = false;
                isDeclareStatic = true;
            } else {
                final Ref isDynamicContext = new Ref((Object)false);
                PhpControlFlowUtil.processFlow(dummyFunction.getControlFlow(), new PhpInstructionProcessor(){

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                        if (PhpLangUtil.isThisReference(instruction.getVariableName())) {
                            isDynamicContext.set((Object)true);
                            return false;
                        }
                        return true;
                    }
                });
                isDeclareStaticEnabled = (Boolean)isDynamicContext.get() == false;
                isDeclareStatic = false;
            }
            PhpClass containingClass = method.getContainingClass();
            assert (containingClass != null);
            dialog = PhpExtractMethodDialog.createExtractMethodDialog(project, fragment, inputVariables, outputVariables, new PhpMethodConflictDetector(containingClass), isReplacedBreakContinueWithReturnEnabled, isDeclareStaticEnabled, isDeclareStatic, method.getAccess(), this.myContext);
        } else {
            PhpScopeHolder externalScope = PhpExtractMethodHandler.getExternalScopeHolder(scopeHolder);
            dialog = PhpExtractMethodDialog.createExtractFunctionDialog(project, fragment, inputVariables, outputVariables, new PhpFunctionInScopeConflictDetector(externalScope), isReplacedBreakContinueWithReturnEnabled, this.myContext);
        }
        PhpExtractMethodDialog phpExtractMethodDialog = dialog;
        if (phpExtractMethodDialog == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(99);
        }
        return phpExtractMethodDialog;
    }

    @Nullable
    protected PhpExtractMethodSettings getSettings(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, @NotNull Set<PhpPsiElement> outputVariables) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(100);
        }
        if (inputVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(101);
        }
        if (outputVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(102);
        }
        PhpExtractMethodDialog dialog = this.createSettings(fragment, inputVariables, outputVariables);
        PhpUiUtil.show((DialogWrapper)dialog);
        if (!dialog.isOK()) {
            return null;
        }
        return dialog;
    }

    @NotNull
    private static PhpScopeHolder getScopeHolder(PsiElement element) {
        PhpScopeHolder phpScopeHolder = Objects.requireNonNull(PhpPsiUtil.getParentOfClass(element, false, PhpScopeHolder.class));
        if (phpScopeHolder == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(103);
        }
        return phpScopeHolder;
    }

    private static PhpScopeHolder getNearestNonClosureScopeHolder(PhpScopeHolder holder) {
        if (holder instanceof Function && ((Function)holder).isClosure()) {
            return (PhpScopeHolder)PhpPsiUtil.getParentByCondition((PsiElement)holder, true, (Condition<? super PsiElement>)((Condition)e -> e instanceof PhpScopeHolder && (!(e instanceof Function) || !((Function)e).isClosure())));
        }
        return holder;
    }

    @Nullable
    private static PhpScopeHolder getExternalScopeHolder(@NotNull PhpScopeHolder scopeHolder) {
        PhpNamespace namespace;
        if (scopeHolder == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(104);
        }
        if ((namespace = PhpPsiUtil.getParentOfClass((PsiElement)scopeHolder, false, PhpNamespace.class)) != null) {
            return namespace;
        }
        PsiFile file = scopeHolder.getContainingFile();
        return file instanceof PhpFile ? (PhpFile)file : null;
    }

    @NotNull
    public static Set<PhpPsiElement> getInputVariables(final @NotNull PhpExtractMethodCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(105);
        }
        PhpScopeHolder scopeHolder = fragment.getScopeHolder();
        PhpScopeHolder externalScopeHolder = PhpExtractMethodHandler.getNearestNonClosureScopeHolder(scopeHolder);
        final Set predefinedVariables = externalScopeHolder.getPredefinedVariables();
        final Set<CharSequence> scopeParameters = PhpExtractMethodHandler.getFunctionParametersNames(scopeHolder);
        final LinkedHashSet<PhpPsiElement> inputVariables = new LinkedHashSet<PhpPsiElement>();
        final HashSet names = new HashSet();
        PhpControlFlow controlFlow = scopeHolder.getControlFlow();
        PhpControlFlowUtil.processFlow(controlFlow, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpPsiElement anchor = instruction.getAnchor();
                if (fragment.contains(anchor.getTextRange())) {
                    PhpInstruction nearestInstruction;
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    final CharSequence variableName = instruction.getVariableName();
                    if (PhpExtractMethodHandler.isIgnoredVariables(variableName, predefinedVariables)) {
                        return true;
                    }
                    final Ref hasWriteAccessInsideFragment = new Ref((Object)false);
                    final Ref hasWriteAccessOutsideFragment = new Ref((Object)false);
                    PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                        public boolean processAccessVariableInstruction(PhpAccessVariableInstruction curInstruction) {
                            PhpAccessInstruction.Access curAccess = curInstruction.getAccess();
                            if (PhpLangUtil.equalsVariableNames(variableName, curInstruction.getVariableName()) && (curAccess.isWrite() || curAccess.isWriteRef() || curAccess.isReadWrite() || PhpWorkaroundUtil.getArrayAccess(curInstruction).isWrite())) {
                                if (fragment.contains(curInstruction.getAnchor().getTextRange())) {
                                    hasWriteAccessInsideFragment.set((Object)true);
                                } else {
                                    hasWriteAccessOutsideFragment.set((Object)true);
                                }
                            }
                            return true;
                        }
                    });
                    if (access.isRead() || access.isLightRead() || access.isReadWrite() || access.isReadRef()) {
                        if (PhpWorkaroundUtil.getArrayAccess(instruction).isWrite()) {
                            if ((((Boolean)hasWriteAccessOutsideFragment.get()).booleanValue() || scopeParameters.contains(variableName)) && names.add(variableName.toString())) {
                                inputVariables.add(anchor);
                            }
                        } else if ((!((Boolean)hasWriteAccessInsideFragment.get()).booleanValue() || scopeParameters.contains(variableName)) && names.add(variableName.toString())) {
                            inputVariables.add(anchor);
                        }
                    } else if ((access.isWrite() || access.isWriteRef()) && (nearestInstruction = PhpUndefinedClassInspection.findNearestInstruction(fragment.getStartStatement())) != null && !names.contains(variableName.toString()) && (scopeParameters.contains(variableName) || ((Boolean)hasWriteAccessOutsideFragment.get()).booleanValue()) && PhpExtractMethodHandler.isVariableNeededAt(variableName, nearestInstruction, new HashMap<Integer, Boolean>(), 0)) {
                        names.add(variableName.toString());
                        inputVariables.add(anchor);
                    }
                }
                return true;
            }
        });
        LinkedHashSet<PhpPsiElement> linkedHashSet = inputVariables;
        if (linkedHashSet == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(106);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<CharSequence> getFunctionParametersNames(@NotNull PhpScopeHolder scopeHolder) {
        if (scopeHolder == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(107);
        }
        if (scopeHolder instanceof Function) {
            Set set = (Set)((StreamEx)StreamEx.of((Object[])((Function)scopeHolder).getParameters()).map(Parameter::getName).filter(Predicate.not(StringUtil::isEmptyOrSpaces))).collect(Collectors.toSet());
            if (set == null) {
                PhpExtractMethodHandler.$$$reportNull$$$0(108);
            }
            return set;
        }
        Set<CharSequence> set = Collections.emptySet();
        if (set == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(109);
        }
        return set;
    }

    private static boolean isVariableNeededAt(CharSequence variableName, PhpInstruction instruction, Map<Integer, Boolean> result, int depth) {
        if (depth > 1000) {
            LOG.warn("Control flow is too deep to analyze");
            return false;
        }
        int num = instruction.num();
        if (result.containsKey(num)) {
            return result.get(num);
        }
        result.put(num, false);
        if (instruction instanceof PhpAccessVariableInstruction && PhpLangUtil.equalsVariableNames(variableName, ((PhpAccessVariableInstruction)instruction).getVariableName())) {
            PhpAccessInstruction.Access access = ((PhpAccessVariableInstruction)instruction).getAccess();
            boolean isNeeded = access.isRead() || access.isReadRef() || access.isReadWrite() || access.isLightRead();
            result.put(num, isNeeded);
            return isNeeded;
        }
        boolean isNeeded = ContainerUtil.or(((PhpInstructionImpl)instruction).getSuccessors(), i -> PhpExtractMethodHandler.isVariableNeededAt(variableName, i, result, depth + 1));
        result.put(num, isNeeded);
        return isNeeded;
    }

    @NotNull
    public static Set<PhpPsiElement> getOutputVariables(final @NotNull PhpExtractMethodCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(110);
        }
        final PhpScopeHolder scopeHolder = fragment.getScopeHolder();
        final Set predefinedVariables = scopeHolder.getPredefinedVariables();
        final LinkedHashSet<PhpPsiElement> set = new LinkedHashSet<PhpPsiElement>();
        final HashSet names = new HashSet();
        PhpControlFlowUtil.processFlow(scopeHolder.getControlFlow(), new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpPsiElement anchor = instruction.getAnchor();
                if (fragment.contains(anchor.getTextRange())) {
                    CharSequence variableName;
                    boolean refAccess;
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    boolean bl = refAccess = access.isWriteRef() || access.isReadRef();
                    if ((access.isWrite() || refAccess || access.isReadWrite() || access.isUnset() || !PhpWorkaroundUtil.getArrayAccess(instruction).isRead()) && !PhpExtractMethodHandler.isIgnoredVariables(variableName = instruction.getVariableName(), predefinedVariables) && !names.contains(variableName) && (PhpControlFlowUtil.isReferenced(scopeHolder, instruction) || refAccess || PhpExtractMethodHandler.hasReadAccess(instruction, access, fragment))) {
                        names.add(variableName.toString());
                        set.add(anchor);
                    }
                }
                return true;
            }
        });
        LinkedHashSet<PhpPsiElement> linkedHashSet = set;
        if (linkedHashSet == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(111);
        }
        return linkedHashSet;
    }

    public static boolean hasReadAccess(final @NotNull PhpAccessVariableInstruction instruction, final @NotNull PhpAccessInstruction.Access access, final @NotNull PhpExtractMethodCodeFragment fragment) {
        if (instruction == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(112);
        }
        if (access == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(113);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(114);
        }
        final Ref hasReadAccess = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction curInstruction) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), curInstruction.getVariableName()) && !fragment.contains(curInstruction.getAnchor().getTextRange())) {
                    if (access.isReadRef()) {
                        hasReadAccess.set((Object)true);
                        return false;
                    }
                    PhpAccessInstruction.Access curAccess = curInstruction.getAccess();
                    if (curAccess.isRead() || curAccess.isReadRef() || curAccess.isLightRead() || curAccess.isReadWrite()) {
                        hasReadAccess.set((Object)true);
                        return false;
                    }
                }
                return true;
            }
        });
        return (Boolean)hasReadAccess.get();
    }

    public static boolean isIgnoredVariables(@NotNull CharSequence variableName, @NotNull Set<CharSequence> predefinedVariables) {
        if (variableName == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(115);
        }
        if (predefinedVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(116);
        }
        return PhpLangUtil.isSuperGlobal(variableName) || predefinedVariables.contains(variableName);
    }

    private static String generateDummyFunction(@NotNull PhpExtractMethodCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(117);
        }
        return "public function dummyFunction() {" + fragment.generateCodeText() + "}";
    }

    @NotNull
    private static String generateFunctionText(@NotNull PhpExtractMethodSettings extractMethodSettings) {
        if (extractMethodSettings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(118);
        }
        String string = IMPLEMENTATION.generate(extractMethodSettings);
        if (string == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(119);
        }
        return string;
    }

    private static void appendCallStatementPrefix(@NotNull PhpExtractMethodSettings settings, @NotNull PhpExtractMethodBlockCodeFragment fragment, @NotNull StringBuilder builder2) {
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(120);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(121);
        }
        if (builder2 == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(122);
        }
        if (PhpExtractMethodHandler.isReturnValueInside(fragment)) {
            builder2.append("return ");
        } else {
            Set<PhpPsiElement> outputVariables = settings.getOutputVariables();
            if (!outputVariables.isEmpty() && !settings.isPassOutputByReference()) {
                if (outputVariables.size() == 1) {
                    builder2.append("$").append(((PhpPsiElement)ContainerUtil.getFirstItem(outputVariables)).getName());
                } else {
                    builder2.append("list(");
                    Iterator<PhpPsiElement> iterator = outputVariables.iterator();
                    while (iterator.hasNext()) {
                        builder2.append("$").append(iterator.next().getName());
                        if (!iterator.hasNext()) continue;
                        builder2.append(",");
                    }
                    builder2.append(")");
                }
                builder2.append("=");
            }
        }
    }

    @NotNull
    private static String generateMethodCallStatementText(@NotNull PhpExtractMethodSettings settings, @NotNull PhpExtractMethodBlockCodeFragment fragment) {
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(123);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(124);
        }
        StringBuilder methodCallStatementBuilder = new StringBuilder();
        PhpExtractMethodHandler.appendCallStatementPrefix(settings, fragment, methodCallStatementBuilder);
        methodCallStatementBuilder.append(PhpExtractMethodHandler.generateMethodCallText(settings)).append(";");
        String string = methodCallStatementBuilder.toString();
        if (string == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(125);
        }
        return string;
    }

    @NotNull
    private static String generateMethodCallText(@NotNull PhpExtractMethodSettings extractMethodSettings) {
        if (extractMethodSettings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(126);
        }
        StringBuilder methodCallBuilder = new StringBuilder();
        if (extractMethodSettings.isDeclareStatic()) {
            methodCallBuilder.append("self::");
        } else {
            methodCallBuilder.append("$this->");
        }
        methodCallBuilder.append(PhpExtractMethodHandler.generateCall(extractMethodSettings));
        String string = methodCallBuilder.toString();
        if (string == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(127);
        }
        return string;
    }

    private static String generateCall(@NotNull PhpExtractMethodSettings extractMethodSettings) {
        if (extractMethodSettings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(128);
        }
        PhpParametersFolder folder = extractMethodSettings.getParameterFolder();
        return extractMethodSettings.getName() + "(" + String.join((CharSequence)", ", folder.generateCallArguments(extractMethodSettings.getParameters())) + ");";
    }

    @NotNull
    private static String generateFunctionCallStatementText(@NotNull PhpExtractMethodSettings settings, @NotNull PhpExtractMethodBlockCodeFragment fragment) {
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(129);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(130);
        }
        StringBuilder functionCallStatementBuilder = new StringBuilder();
        PhpExtractMethodHandler.appendCallStatementPrefix(settings, fragment, functionCallStatementBuilder);
        functionCallStatementBuilder.append(PhpExtractMethodHandler.generateCall(settings)).append(";");
        String string = functionCallStatementBuilder.toString();
        if (string == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(131);
        }
        return string;
    }

    private static boolean isReturnValueInside(@NotNull PhpExtractMethodCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(132);
        }
        final Ref isReturn = new Ref((Object)false);
        fragment.getScopeHolder().acceptChildren((PsiElementVisitor)new PhpExtractMethodCodeFragmentRecursiveElementVisitor(fragment, new PhpElementVisitor(){

            public void visitPhpReturn(PhpReturn returnStatement) {
                if (returnStatement.getArgument() != null) {
                    isReturn.set((Object)true);
                }
            }
        }));
        return (Boolean)isReturn.get();
    }

    @NlsContexts.Command
    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return PhpBundle.message("refactoring.extract.method.name", new Object[0]);
    }

    public static PhpExtractMethodSettings getSettingsForBatchMode(Project project, Set<String> names, boolean isStatic, @NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, @NotNull Set<PhpPsiElement> outputVariables) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(133);
        }
        if (inputVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(134);
        }
        if (outputVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(135);
        }
        return PhpExtractMethodHandler.getSettingsForBatchMode(project, names, isStatic, fragment, inputVariables, outputVariables, false);
    }

    public static PhpExtractMethodSettings getSettingsForBatchMode(final Project project, final Set<String> names, final boolean isStatic, final @NotNull PhpExtractMethodCodeFragment fragment, final @NotNull Set<PhpPsiElement> inputVariables, final @NotNull Set<PhpPsiElement> outputVariables, final boolean handleDuplicatesForInline) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(136);
        }
        if (inputVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(137);
        }
        if (outputVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(138);
        }
        final PhpParametersFolder folder = new PhpParametersFolder();
        final List<PhpExtractMethodParameterInfo> parameters = PhpExtractMethodDialog.getParameterItems(fragment, inputVariables, outputVariables, folder);
        final PhpModifier.Access access = fragment.getScopeHolder() instanceof Method ? PhpRefactoringSettings.getInstance().EXTRACT_METHOD_DEFAULT_VISIBILITY : null;
        return new PhpExtractMethodSettings(){

            @Override
            @NotNull
            public Set<PhpPsiElement> getOutputVariables() {
                Set set = outputVariables;
                if (set == null) {
                    13.$$$reportNull$$$0(0);
                }
                return set;
            }

            @Override
            @NotNull
            public Set<PhpPsiElement> getInputVariables() {
                Set set = inputVariables;
                if (set == null) {
                    13.$$$reportNull$$$0(1);
                }
                return set;
            }

            @Override
            public boolean isPassOutputByReference() {
                return false;
            }

            @Override
            public boolean processDuplicatesForInline() {
                return handleDuplicatesForInline;
            }

            @Override
            public boolean isReplaceBreakContinueWithReturn() {
                return false;
            }

            @Override
            public boolean generatePhpDoc() {
                return PhpRefactoringSettings.getInstance().EXTRACT_METHOD_GENERATE_PHPDOC;
            }

            @Override
            @NotNull
            public PhpParametersFolder getParameterFolder() {
                PhpParametersFolder phpParametersFolder = folder;
                if (phpParametersFolder == null) {
                    13.$$$reportNull$$$0(2);
                }
                return phpParametersFolder;
            }

            @Override
            @NotNull
            public String getName() {
                String string = (String)ContainerUtil.getFirstItem(this.nameSuggestions());
                if (string == null) {
                    13.$$$reportNull$$$0(3);
                }
                return string;
            }

            @Override
            public LinkedHashSet<String> nameSuggestions() {
                return new LinkedHashSet<String>(names);
            }

            @Override
            @NotNull
            public List<PhpExtractMethodParameterInfo> getParameters() {
                List<PhpExtractMethodParameterInfo> parameterForCurrentMode = PhpExtractMethodDialog.filterParametersByReturnType(parameters, this.isPassOutputByReference());
                for (PhpExtractMethodParameterInfo parameter : parameterForCurrentMode) {
                    parameter.setIsReturnByRefMode(project, this.isPassOutputByReference());
                }
                List<PhpExtractMethodParameterInfo> list = parameterForCurrentMode;
                if (list == null) {
                    13.$$$reportNull$$$0(4);
                }
                return list;
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable PhpModifier.Access getVisibility() {
                return access;
            }

            @Override
            public boolean isDeclareStatic() {
                return isStatic;
            }

            @Override
            public boolean useTrailingCommaInParametersList() {
                return false;
            }

            @Override
            @NotNull
            public String getFunctionBody() {
                String string = fragment.generateCodeText();
                if (string == null) {
                    13.$$$reportNull$$$0(5);
                }
                return string;
            }

            @Override
            @NotNull
            public String getReturnType() {
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodHandler$13";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOutputVariables";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInputVariables";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParameterFolder";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParameters";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFunctionBody";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 64, 69, 70, 85, 86, 99, 103, 106, 108, 109, 111, 119, 125, 127, 131 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 16: 
            case 21: 
            case 24: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 48: 
            case 54: 
            case 58: 
            case 62: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 52: 
            case 56: 
            case 60: 
            case 71: 
            case 74: 
            case 78: 
            case 91: 
            case 93: 
            case 95: 
            case 96: 
            case 100: 
            case 105: 
            case 110: 
            case 114: 
            case 117: 
            case 121: 
            case 124: 
            case 130: 
            case 132: 
            case 133: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 28: 
            case 97: 
            case 101: 
            case 134: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVariables";
                break;
            }
            case 29: 
            case 98: 
            case 102: 
            case 135: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputVariables";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "redoOffset";
                break;
            }
            case 50: 
            case 55: 
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDefinition";
                break;
            }
            case 51: 
            case 66: 
            case 68: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 53: 
            case 57: 
            case 61: 
            case 75: 
            case 79: 
            case 84: 
            case 87: 
            case 89: 
            case 92: 
            case 94: 
            case 120: 
            case 123: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 64: 
            case 69: 
            case 70: 
            case 85: 
            case 86: 
            case 99: 
            case 103: 
            case 106: 
            case 108: 
            case 109: 
            case 111: 
            case 119: 
            case 125: 
            case 127: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodHandler";
                break;
            }
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 76: 
            case 80: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorElement";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localType";
                break;
            }
            case 81: 
            case 104: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 88: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedVariables";
                break;
            }
            case 118: 
            case 126: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractMethodSettings";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodHandler";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDuplicateScopes";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "patchArguments";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefinition";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeHolder";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputVariables";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionParametersNames";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariables";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFunctionText";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMethodCallStatementText";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMethodCallText";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFunctionCallStatementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "_invoke";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractFromValidatedCodeFragment";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectSuggestedCodeFragments";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectExtractableCodeFragments";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tryToDetectBlockRangeElements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectExtractableExpressions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isExtractable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryExtractFromExpression";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "validateExpression";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "strictContains";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractFromExpression";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "extractFromExpressionWithDialog";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createDuplicatesFinder";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "tryExtractFromBlock";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "validateBlockFragment";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "extractFromBlock";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "extractFromBlockWithDialog";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "extractInplace";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "checkControlFlow";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "breakContinueAreInconsistent";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "returnPointsAreInconsistent";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addRestoreSelectionAndCaretUndoableAction";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processDuplicates";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "processDuplicatesImpl";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "collectDuplicateScopes";
                break;
            }
            case 64: 
            case 69: 
            case 70: 
            case 85: 
            case 86: 
            case 99: 
            case 103: 
            case 106: 
            case 108: 
            case 109: 
            case 111: 
            case 119: 
            case 125: 
            case 127: 
            case 131: {
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "replaceElements";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "patchArguments";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithCall";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectionAndMoveCaretToElement";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "addFunctionDefinition";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypePresentation";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "insertDefinition";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "createDefinition";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "patchDefinition";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "generateReturnArgument";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "addReturnStatementToEndOfFunctionIfNeeded";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "createCallStatement";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "createCallExpression";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "_getSettings";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "createSettings";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getExternalScopeHolder";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getInputVariables";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParametersNames";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getOutputVariables";
                break;
            }
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "hasReadAccess";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredVariables";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "generateDummyFunction";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "generateFunctionText";
                break;
            }
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "appendCallStatementPrefix";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodCallStatementText";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodCallText";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "generateCall";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "generateFunctionCallStatementText";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "isReturnValueInside";
                break;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsForBatchMode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 64, 69, 70, 85, 86, 99, 103, 106, 108, 109, 111, 119, 125, 127, 131 -> new IllegalStateException(string);
        };
    }

    private static final class PhpExtractMethodCodeFragmentRecursiveElementVisitor
    extends PhpRecursiveElementVisitor {
        private final PhpExtractMethodCodeFragment myFragment;
        private final PhpElementVisitor myVisitor;

        private PhpExtractMethodCodeFragmentRecursiveElementVisitor(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpElementVisitor visitor) {
            if (fragment == null) {
                PhpExtractMethodCodeFragmentRecursiveElementVisitor.$$$reportNull$$$0(0);
            }
            if (visitor == null) {
                PhpExtractMethodCodeFragmentRecursiveElementVisitor.$$$reportNull$$$0(1);
            }
            this.myFragment = fragment;
            this.myVisitor = visitor;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                PhpExtractMethodCodeFragmentRecursiveElementVisitor.$$$reportNull$$$0(2);
            }
            if (this.myFragment.contains(element.getTextRange())) {
                element.accept((PsiElementVisitor)this.myVisitor);
            }
            super.visitElement(element);
        }

        public void visitPhpFunction(Function function) {
            this.checkIsInTheSameScope((PhpScopeHolder)function);
        }

        public void visitPhpMethod(Method method) {
            this.checkIsInTheSameScope((PhpScopeHolder)method);
        }

        private void checkIsInTheSameScope(PhpScopeHolder holder) {
            if (holder == this.myFragment.getScopeHolder()) {
                super.visitElement((PsiElement)holder);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodHandler$PhpExtractMethodCodeFragmentRecursiveElementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

