/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.refactoring.classMembers.ClassMembersRefactoringSupport;
import com.intellij.refactoring.classMembers.DependentMembersCollectorBase;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.HashSet;

public final class PhpClassMembersRefactoringSupport
implements ClassMembersRefactoringSupport<PhpClass> {
    public DependentMembersCollectorBase<?, ? extends PhpClass> createDependentMembersCollector(PhpClass clazz, PhpClass superClass) {
        return new PhpDependentMembersCollector(clazz, superClass);
    }

    public boolean isProperMember(MemberInfoBase member) {
        PsiElement memberElement = member.getMember();
        return memberElement instanceof Field || memberElement instanceof Method;
    }

    private static void addElement(MemberReference reference, HashSet<PsiElement> myCollection) {
        PsiElement element = reference.resolve();
        if (element != null) {
            myCollection.add(element);
        }
    }

    private static class PhpDependentMembersCollector
    extends DependentMembersCollectorBase<PsiElement, PhpClass> {
        private PhpDependentMembersCollector(PhpClass clazz, PhpClass superClass) {
            super((Object)clazz, (Object)superClass);
        }

        public void collect(PsiElement member) {
            member.accept(this.getVisitor());
        }

        private PsiElementVisitor getVisitor() {
            return new PhpRecursiveElementVisitor(){

                public void visitPhpMethodReference(MethodReference reference) {
                    PhpClassMembersRefactoringSupport.addElement((MemberReference)reference, myCollection);
                }

                public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
                    PhpClassMembersRefactoringSupport.addElement((MemberReference)constantReference, myCollection);
                }

                public void visitPhpFieldReference(FieldReference fieldReference) {
                    PhpClassMembersRefactoringSupport.addElement((MemberReference)fieldReference, myCollection);
                }
            };
        }
    }
}

