/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.psalm.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.impl.PhpExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.psalm.types.PsalmAdvancedCallableTypeProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PsalmAdvanceCallableParamsInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PsalmAdvanceCallableParamsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                if (StringUtil.isEmpty((String)reference.getName())) {
                    PsiElement[] parameters = reference.getParameters();
                    if (parameters.length == 0) {
                        return;
                    }
                    List<Pair<String, PhpType>> parameterTypes = PsalmAdvanceCallableParamsInspection.getAdvancedCallableParametersTypes(reference);
                    if (parameterTypes != null) {
                        for (int i = 0; i < Math.min(parameters.length, parameterTypes.size()); ++i) {
                            PhpType parameterType;
                            PhpType callType = new PhpType().add(parameters[i]).global(holder.getProject());
                            if (PhpParamsInspection.isCallTypeConvertibleFromDeclaredType(callType, parameterType = ((PhpType)parameterTypes.get(i).getSecond()).global(holder.getProject()), PhpIndex.getInstance((Project)holder.getProject()))) continue;
                            String message = PhpBundle.message("parameter.type.is.not.compatible.with.declaration", callType.toStringResolved(), parameterType.toStringResolved());
                            holder.registerProblem(parameters[i], message, new LocalQuickFix[0]);
                        }
                    }
                }
            }
        };
    }

    public static List<Pair<String, PhpType>> getAdvancedCallableParametersTypes(FunctionReference reference) {
        List types = (List)ContainerUtil.getFirstItem(PsalmAdvanceCallableParamsInspection.getAdvancedCallableTypes(reference.getProject(), new PhpType().add((PsiElement)reference.getFirstPsiChild())));
        return types == null ? Collections.emptyList() : types.subList(0, types.size() - 1);
    }

    @NotNull
    public static List<List<Pair<String, PhpType>>> getAdvancedCallableTypes(Project project, PhpType type) {
        List<List<Pair<String, PhpType>>> list = type.global(project).getTypesWithParametrisedParts().stream().filter(PsalmAdvanceCallableParamsInspection::isParametrizedAdvancedCallable).map(PhpType::getParametrizedParts).map(t -> ContainerUtil.map((Collection)t, PhpExpressionImpl::getTypeFromSerializedClosureParameter)).filter(t -> !t.isEmpty()).collect(Collectors.toList());
        if (list == null) {
            PsalmAdvanceCallableParamsInspection.$$$reportNull$$$0(1);
        }
        return list;
    }

    public static boolean isParametrizedAdvancedCallable(String t) {
        return PhpType.hasParameterizedPart((String)t) && PsalmAdvancedCallableTypeProvider.ADVANCED_CALLABLES.contains(PhpType.removeParametrisedType((String)t));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/psalm/lang/inspections/PsalmAdvanceCallableParamsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/psalm/lang/inspections/PsalmAdvanceCallableParamsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdvancedCallableTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

