/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.psalm.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.completion.PhpTraitDocTagCompletionProvider;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTemplateParameter;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTemplateTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsBaseExtendedWithGenericTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsExtendedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsTemplatesCustomDocTagValueStubProvider;
import com.jetbrains.php.psalm.types.PsalmExtendedStringDocTypeProvider;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PsalmCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final String[] ADDITIONAL_TRAIT_DOC_TAG_COMPLETIONS = new String[]{"psalm-require-extends", "psalm-require-implements"};

    public PsalmCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpDocType.class), new PsalmCustomDocTypeCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpDocType.class), new PsalmCustomTypesCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)PhpDocTokenTypes.DOC_TAG_NAME), new PhpTraitDocTagCompletionProvider(ADDITIONAL_TRAIT_DOC_TAG_COMPLETIONS));
    }

    @NotNull
    private static LookupElementBuilder createCustomTypeLookupElement(String tag) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)tag).withBoldness(true);
        if (lookupElementBuilder == null) {
            PsalmCompletionContributor.$$$reportNull$$$0(0);
        }
        return lookupElementBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/psalm/completion/PsalmCompletionContributor", "createCustomTypeLookupElement"));
    }

    private static class PsalmCustomDocTypeCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final @Unmodifiable Collection<String> TYPES = ContainerUtil.union((Set)ContainerUtil.union(PsalmExtendedStringDocTypeProvider.EXTENDED_SCALAR_TYPES, PhpWorkaroundUtil.getGenericArraysNames()), Set.of("key-of", "value-of"));

        private PsalmCustomDocTypeCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PsalmCustomDocTypeCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PsalmCustomDocTypeCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PsalmCustomDocTypeCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String tag : TYPES) {
                result.addElement((LookupElement)PsalmCompletionContributor.createCustomTypeLookupElement(tag));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/psalm/completion/PsalmCompletionContributor$PsalmCustomDocTypeCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PsalmCustomTypesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PsalmCustomTypesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PhpDocComment docComment;
            if (parameters == null) {
                PsalmCustomTypesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PsalmCustomTypesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PsalmCustomTypesCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((docComment = PhpPsiUtil.getParentOfClass(parameters.getPosition(), PhpDocComment.class)) != null) {
                PsalmCustomTypesCompletionProvider.addTemplates(docComment, result);
                Collection<String> customTypes = PhpGenericsExtendedTypeProvider.getCustomTypes(docComment);
                for (String customType : customTypes) {
                    result.addElement((LookupElement)PsalmCompletionContributor.createCustomTypeLookupElement(customType));
                }
            }
        }

        private static void addTemplates(PhpDocComment docComment, CompletionResultSet result) {
            PsiElement owner = docComment.getOwner();
            Stream<PsiElement> templates = PhpGenericsTemplatesCustomDocTagValueStubProvider.getTypeNamesPsi(docComment, PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplateNames());
            PhpClass clazz = PhpPsiUtil.getParentOfClass(owner, PhpClass.class);
            if (clazz != null) {
                templates = Stream.concat(templates, PhpGenericsTemplatesCustomDocTagValueStubProvider.getTypeNamesPsi(clazz.getDocComment(), PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplateNames()));
            }
            List<LookupElementBuilder> elements = templates.map(t -> PhpPsiUtil.getParentOfClass(t, PhpDocTemplateTag.class)).filter(Objects::nonNull).map(tag -> PsalmCustomTypesCompletionProvider.createTemplateLookupElement(tag)).filter(Objects::nonNull).toList();
            result.addAllElements(elements);
        }

        @Nullable
        private static LookupElementBuilder createTemplateLookupElement(PhpDocTemplateTag tag) {
            PhpDocComment tagDocComment = PhpPsiUtil.getParentOfClass((PsiElement)tag, PhpDocComment.class);
            PsiElement tagOwner = tagDocComment != null ? tagDocComment.getOwner() : null;
            Object definedAt = "";
            if (tagOwner instanceof PhpClass) {
                PhpClass clazz = (PhpClass)tagOwner;
                definedAt = " of " + clazz.getFQN();
            } else if (tagOwner instanceof Method) {
                Method method = (Method)tagOwner;
                definedAt = " of " + method.getName() + "()";
            }
            PhpDocTemplateParameter templateParameter = tag.getTemplateParameter();
            if (templateParameter == null) {
                return null;
            }
            String name = templateParameter.getName();
            String variantString = tag.isCovariant() ? " covariant" : (tag.isContravariant() ? " contravariant" : "");
            String tailText = variantString + " template parameter" + (String)definedAt;
            PhpDocType superType = tag.getSuperType();
            if (superType != null) {
                tailText = tailText + " extends " + superType.getText();
            }
            return LookupElementBuilder.create((String)name).withBoldness(true).withTailText(tailText).withIcon(PhpIcons.TEMPLATE_PARAMETER);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/psalm/completion/PsalmCompletionContributor$PsalmCustomTypesCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

