/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.phpunit.PhpUnitConsoleProperties;
import com.jetbrains.php.phpunit.PhpUnitExecutionUtil;
import com.jetbrains.php.phpunit.PhpUnitLocalRunConfiguration;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationSettings;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitTestPattern;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerSettings;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.run.PhpRunConfiguration;
import com.jetbrains.php.run.PhpRunConfigurationHolder;
import com.jetbrains.php.run.PhpRunUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitRerunFailedTestsAction
extends AbstractRerunFailedTestsAction {
    private static final Logger LOG = Logger.getInstance(PhpUnitRerunFailedTestsAction.class);
    private static final String FAKE_TEST_NAME = "Warning";
    public static final String WITH_DATA_SET = " with data set ";

    public PhpUnitRerunFailedTestsAction(@NotNull ComponentContainer componentContainer, PhpUnitConsoleProperties consoleProperties) {
        if (componentContainer == null) {
            PhpUnitRerunFailedTestsAction.$$$reportNull$$$0(0);
        }
        super(componentContainer);
        this.init((TestConsoleProperties)consoleProperties);
    }

    @Nullable
    protected AbstractRerunFailedTestsAction.MyRunProfile getRunProfile(@NotNull ExecutionEnvironment environment) {
        RunProfile configuration;
        if (environment == null) {
            PhpUnitRerunFailedTestsAction.$$$reportNull$$$0(1);
        }
        if (!((configuration = this.myConsoleProperties.getConfiguration()) instanceof PhpUnitLocalRunConfiguration)) {
            LOG.warn("Expected PHPUnit run-configuration type, got: " + String.valueOf(configuration.getClass()));
            return null;
        }
        PhpUnitLocalRunConfiguration phpRunConfiguration = (PhpUnitLocalRunConfiguration)configuration;
        return new PhpUnitRerunProfile((RunConfigurationBase)phpRunConfiguration, this.getFailedTestPatterns(phpRunConfiguration.getProject()));
    }

    @NotNull
    private List<PhpUnitTestPattern> getFailedTestPatterns(@NotNull Project project) {
        if (project == null) {
            PhpUnitRerunFailedTestsAction.$$$reportNull$$$0(2);
        }
        List failedTests = this.getFailedTests(project);
        HashMap<Object, List> result = new HashMap<Object, List>();
        for (AbstractTestProxy testProxy : failedTests) {
            String fullTestName;
            Object className;
            String testFilePath;
            Location parentLocation;
            PsiElement element;
            AbstractTestProxy parent;
            if (!testProxy.isLeaf() || (parent = testProxy.getParent()) == null) continue;
            String testName = testProxy.getName();
            boolean isFakeWarningTest = StringUtil.equals((CharSequence)testName, (CharSequence)FAKE_TEST_NAME);
            if (isFakeWarningTest && !result.containsKey(FAKE_TEST_NAME)) {
                result.put(FAKE_TEST_NAME, ContainerUtil.emptyList());
            }
            PsiElement psiElement = element = (parentLocation = parent.getLocation(project, this.myConsoleProperties.getScope())) != null ? parentLocation.getPsiElement() : null;
            if (element == null) {
                LOG.warn("Element is null for test location");
            }
            String string = testFilePath = element != null ? element.getContainingFile().getVirtualFile().getPath() : "";
            if (element instanceof Method) {
                AbstractTestProxy grandParent = parent.getParent();
                className = grandParent.getName();
                fullTestName = isFakeWarningTest ? parent.getName() + "(.*)?" : testName;
            } else if (parent.getChildren().size() == 1 && isFakeWarningTest) {
                className = parent.getName() + "(.*)?";
                fullTestName = "";
            } else {
                className = parent.getName();
                fullTestName = testName;
            }
            String dataSet = null;
            if (fullTestName.contains(WITH_DATA_SET)) {
                List methodNameAndDataSet = StringUtil.split((String)fullTestName, (String)WITH_DATA_SET);
                if (methodNameAndDataSet.size() >= 2) {
                    fullTestName = (String)methodNameAndDataSet.get(0);
                    dataSet = (String)methodNameAndDataSet.get(1);
                } else {
                    LOG.warn("Invalid PHPUnit test name: " + fullTestName);
                }
            }
            fullTestName = StringUtil.escapeBackSlashes((String)fullTestName);
            PhpUnitTestPattern pattern = new PhpUnitTestPattern((String)className, fullTestName, testFilePath, dataSet);
            if (StringUtil.isEmpty((String)fullTestName)) {
                if (result.containsKey(className)) continue;
                result.put(className, ContainerUtil.emptyList());
                continue;
            }
            if (!result.containsKey(className)) {
                result.put(className, List.of(pattern));
                continue;
            }
            result.put(className, ContainerUtil.concat((List)((List)result.get(className)), Collections.singletonList(pattern)));
        }
        List list = ContainerUtil.flatten(result.values());
        if (list == null) {
            PhpUnitRerunFailedTestsAction.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentContainer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/actions/PhpUnitRerunFailedTestsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/actions/PhpUnitRerunFailedTestsAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailedTestPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRunProfile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFailedTestPatterns";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static class PhpUnitRerunProfile
    extends AbstractRerunFailedTestsAction.MyRunProfile
    implements PhpRunConfigurationHolder<PhpUnitRunConfigurationSettings> {
        private final List<PhpUnitTestPattern> myFailedTests;

        public List<PhpUnitTestPattern> getFailedTests() {
            return this.myFailedTests;
        }

        public PhpUnitRerunProfile(RunConfigurationBase configuration, @NotNull List<PhpUnitTestPattern> failedTests) {
            if (failedTests == null) {
                PhpUnitRerunProfile.$$$reportNull$$$0(0);
            }
            super(configuration);
            this.myFailedTests = failedTests;
        }

        @Nullable
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            PhpUnitLocalRunConfiguration runConfiguration;
            PhpInterpreter interpreter;
            if (executor == null) {
                PhpUnitRerunProfile.$$$reportNull$$$0(1);
            }
            if (environment == null) {
                PhpUnitRerunProfile.$$$reportNull$$$0(2);
            }
            if ((interpreter = (runConfiguration = (PhpUnitLocalRunConfiguration)this.getPeer()).getInterpreter()) == null) {
                throw new ExecutionException(PhpCommandSettingsBuilder.getInterpreterNotFoundError());
            }
            Map<String, String> envParameters = Collections.emptyMap();
            SmartList arguments = new SmartList();
            PhpUnitRunConfigurationSettings settings = this.getSettings();
            PhpCommandSettings command = runConfiguration.createCommand(interpreter, settings, envParameters, (List<String>)arguments, false);
            String error = this.validate(runConfiguration, interpreter.getName(), command.isRemote(), command.getWorkingDirectory());
            if (StringUtil.isNotEmpty((String)error)) {
                String title = PhpBundle.message("phpunit.can.not.rerun.failed.tests.title", new Object[0]);
                PhpUnitUtil.NOTIFICATION_GROUP.createNotification(title, error, NotificationType.ERROR).notify(this.getProject());
                return null;
            }
            if (PhpUnitExecutionUtil.hasUnsupportedParaTestOptions(this.getProject(), settings.getTestRunnerSettings())) {
                runConfiguration.showParaTestUnsupportedOptionNotification(false);
            }
            return runConfiguration.getState(environment, command);
        }

        @NlsContexts.NotificationContent
        private String validate(@NotNull PhpUnitLocalRunConfiguration runConfiguration, String interpreterName, boolean isRemote, String workingDirectory) {
            if (runConfiguration == null) {
                PhpUnitRerunProfile.$$$reportNull$$$0(3);
            }
            PhpUnitRunConfigurationSettings oldSettings = (PhpUnitRunConfigurationSettings)runConfiguration.getSettings();
            PhpUnitTestRunnerSettings testRunnerSettings = oldSettings.getTestRunnerSettings();
            PhpUnitTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
            Project project = this.getProject();
            if (scope == PhpUnitTestRunnerSettings.Scope.Directory) {
                if (PhpRunUtil.findDirectory(testRunnerSettings.getDirectoryPath()) == null) {
                    return PhpBundle.message("validation.value.is.not.specified.or.invalid", "Directory");
                }
            } else if (scope == PhpUnitTestRunnerSettings.Scope.XML) {
                VirtualFile locationContext;
                PhpUnitSettings phpUnitSettings;
                VirtualFile file;
                if (testRunnerSettings.isUseAlternativeConfigurationFile() ? (file = PhpRunUtil.findFile(testRunnerSettings.getConfigurationFilePath())) == null : (phpUnitSettings = PhpUnitLocalRunConfiguration.getOrCreateOnTheFlySettings(project, interpreterName, isRemote, locationContext = PhpRunUtil.findDirectory(workingDirectory))) == null || !phpUnitSettings.isUseConfigurationFile()) {
                    return PhpBundle.message("validation.value.is.not.specified.or.invalid", "Configuration file");
                }
            } else if (scope == PhpUnitTestRunnerSettings.Scope.Pattern) {
                if (PhpRunUtil.findDirectory(testRunnerSettings.getDirectoryPath()) == null && PhpRunUtil.findFile(testRunnerSettings.getFilePath()) == null) {
                    return PhpBundle.message("validation.value.is.not.specified.or.invalid", "File/Directory");
                }
            } else {
                VirtualFile file = PhpRunUtil.findFile(testRunnerSettings.getFilePath());
                if (file == null) {
                    return PhpBundle.message("validation.value.is.not.specified.or.invalid", "File");
                }
            }
            return null;
        }

        @Override
        @NotNull
        public PhpRunConfiguration<PhpUnitRunConfigurationSettings> getRunConfiguration() {
            RunConfigurationBase peer = this.getPeer();
            PhpRunConfiguration phpRunConfiguration = (PhpRunConfiguration)peer;
            if (phpRunConfiguration == null) {
                PhpUnitRerunProfile.$$$reportNull$$$0(4);
            }
            return phpRunConfiguration;
        }

        @Override
        @NotNull
        public PhpUnitRunConfigurationSettings getSettings() {
            PhpUnitLocalRunConfiguration runConfiguration = (PhpUnitLocalRunConfiguration)this.getPeer();
            PhpUnitRunConfigurationSettings settings = ((PhpUnitRunConfigurationSettings)runConfiguration.getSettings()).clone();
            PhpUnitTestRunnerSettings runnerSettings = settings.getTestRunnerSettings();
            PhpUnitTestRunnerSettings.Scope scope = runnerSettings.getScope();
            if (scope == PhpUnitTestRunnerSettings.Scope.XML) {
                runnerSettings.setFilePath(null);
                runnerSettings.setDirectoryPath(null);
            } else if (scope == PhpUnitTestRunnerSettings.Scope.Directory) {
                runnerSettings.setFilePath(null);
            } else if (scope != PhpUnitTestRunnerSettings.Scope.Pattern) {
                runnerSettings.setDirectoryPath(null);
            }
            runnerSettings.setScope(PhpUnitTestRunnerSettings.Scope.Pattern);
            runnerSettings.setTestPatterns(this.myFailedTests);
            PhpUnitRunConfigurationSettings phpUnitRunConfigurationSettings = settings;
            if (phpUnitRunConfigurationSettings == null) {
                PhpUnitRerunProfile.$$$reportNull$$$0(5);
            }
            return phpUnitRunConfigurationSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "failedTests";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfiguration";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phpunit/actions/PhpUnitRerunFailedTestsAction$PhpUnitRerunProfile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phpunit/actions/PhpUnitRerunFailedTestsAction$PhpUnitRerunProfile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunConfiguration";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "validate";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

