/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.testframework.sm.runner.ui.TestStackTraceParser;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.DocumentUtil;
import com.jetbrains.php.phpunit.PhpUnitQualifiedNameLocationProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitTestStackTraceParser
extends TestStackTraceParser {
    PhpUnitTestStackTraceParser(int failedLine, String failedMethodName, String errorMessage, String topLocationLine) {
        super(failedLine, failedMethodName, errorMessage, topLocationLine);
    }

    private PhpUnitTestStackTraceParser(String errorMessage) {
        this(-1, null, errorMessage, null);
    }

    public static PhpUnitTestStackTraceParser parse(@NotNull String url, @Nullable String stacktrace, @Nullable String errorMessage, @NotNull PhpUnitQualifiedNameLocationProvider locator, @NotNull Project project) {
        if (url == null) {
            PhpUnitTestStackTraceParser.$$$reportNull$$$0(0);
        }
        if (locator == null) {
            PhpUnitTestStackTraceParser.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PhpUnitTestStackTraceParser.$$$reportNull$$$0(2);
        }
        if (stacktrace == null) {
            return new PhpUnitTestStackTraceParser(errorMessage);
        }
        String[] lines = StringUtil.splitByLines((String)stacktrace);
        if (lines.length == 0) {
            return new PhpUnitTestStackTraceParser(errorMessage);
        }
        if (StringUtil.isEmpty((String)errorMessage)) {
            errorMessage = lines[0];
        }
        String path = StringUtil.substringBefore((String)StringUtil.trimStart((String)url, (String)"php_qn://"), (String)"::");
        String lastLine = lines[lines.length - 1].trim();
        if (path == null || !lastLine.startsWith(path)) {
            return new PhpUnitTestStackTraceParser(errorMessage);
        }
        int failedLine = StringUtil.parseInt((String)lastLine.substring(path.length() + 1), (int)-1);
        String failedLineText = failedLine > 0 ? PhpUnitTestStackTraceParser.getLineText(path, failedLine, project, locator) : null;
        return new PhpUnitTestStackTraceParser(failedLine, failedLineText, errorMessage, null);
    }

    @Nullable
    private static String getLineText(@NotNull String path, int line, @NotNull Project project, @NotNull PhpUnitQualifiedNameLocationProvider locator) {
        VirtualFile vFile;
        if (path == null) {
            PhpUnitTestStackTraceParser.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PhpUnitTestStackTraceParser.$$$reportNull$$$0(4);
        }
        if (locator == null) {
            PhpUnitTestStackTraceParser.$$$reportNull$$$0(5);
        }
        if ((vFile = locator.getPathMapper().getLocalFile(path)) == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
        if (psiFile == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (document == null) {
            return null;
        }
        if (line > document.getLineCount()) {
            return null;
        }
        TextRange range = DocumentUtil.getLineTextRange((Document)document, (int)(line - 1));
        return document.getText(range);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locator";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitTestStackTraceParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

