/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.actions.ComposerInstallAction;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.composer.lib.ComposerLibraryServiceFactory;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkHelpersManager;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpParaTestExecutor;
import com.jetbrains.php.phpunit.PhpUnitComposerConfig;
import com.jetbrains.php.phpunit.PhpUnitConsoleProperties;
import com.jetbrains.php.phpunit.PhpUnitExecutionUtil;
import com.jetbrains.php.phpunit.PhpUnitFrameworkType;
import com.jetbrains.php.phpunit.PhpUnitQualifiedNameLocationProvider;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationCounterCollector;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationEditor;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationSettings;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitSettingsManager;
import com.jetbrains.php.phpunit.PhpUnitTestPattern;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerConfigurationEditor;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerSettings;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.phpunit.PhpUnitVersion;
import com.jetbrains.php.phpunit.PhpUnitVersionDetector;
import com.jetbrains.php.phpunit.actions.PhpUnitRerunFailedTestsAction;
import com.jetbrains.php.run.PhpAsyncRunConfiguration;
import com.jetbrains.php.run.PhpRefactoringListenerRunConfiguration;
import com.jetbrains.php.run.PhpRunConfigurationExtensionsManager;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.run.RunConfigurationInterpreterProvider;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkVersionCache;
import com.jetbrains.php.testFramework.PhpTestFrameworksConfigurable;
import com.jetbrains.php.testFramework.run.PhpTestRunConfiguration;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.PhpConfigurationUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitLocalRunConfiguration
extends PhpRefactoringListenerRunConfiguration<PhpUnitRunConfigurationSettings>
implements LocatableConfiguration,
SMRunnerConsolePropertiesProvider,
RunConfigurationInterpreterProvider,
PhpAsyncRunConfiguration {
    public static final String PHPUNIT = "PHPUnit";
    private static final Logger LOG = Logger.getInstance(PhpUnitLocalRunConfiguration.class);
    private static final String PHPUNIT_CACHE_RESULT_FILENAME = ".phpunit.result.cache";

    PhpUnitLocalRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @Override
    @NotNull
    protected PhpUnitRunConfigurationSettings createSettings() {
        return new PhpUnitRunConfigurationSettings();
    }

    @Override
    protected void fixSettingsAfterDeserialization(@NotNull PhpUnitRunConfigurationSettings settings) {
        if (settings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(0);
        }
        PhpUnitTestRunnerSettings testRunnerSettings = settings.getTestRunnerSettings();
        testRunnerSettings.setDirectoryPath(PhpConfigurationUtil.deserializePath(testRunnerSettings.getDirectoryPath()));
        testRunnerSettings.setFilePath(PhpConfigurationUtil.deserializePath(testRunnerSettings.getFilePath()));
        testRunnerSettings.setConfigurationFilePath(PhpConfigurationUtil.deserializePath(testRunnerSettings.getConfigurationFilePath()));
        testRunnerSettings.setBootstrapFilePath(PhpConfigurationUtil.deserializePath(testRunnerSettings.getBootstrapFilePath()));
        testRunnerSettings.setParaTestPath(PhpConfigurationUtil.deserializePath(testRunnerSettings.getParaTestPath()));
    }

    @Override
    protected void fixSettingsBeforeSerialization(@NotNull PhpUnitRunConfigurationSettings settings) {
        if (settings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(1);
        }
        PhpUnitTestRunnerSettings testRunnerSettings = settings.getTestRunnerSettings();
        testRunnerSettings.setDirectoryPath(PhpConfigurationUtil.serializePath(testRunnerSettings.getDirectoryPath()));
        testRunnerSettings.setFilePath(PhpConfigurationUtil.serializePath(testRunnerSettings.getFilePath()));
        testRunnerSettings.setConfigurationFilePath(PhpConfigurationUtil.serializePath(testRunnerSettings.getConfigurationFilePath()));
        testRunnerSettings.setBootstrapFilePath(PhpConfigurationUtil.serializePath(testRunnerSettings.getBootstrapFilePath()));
        testRunnerSettings.setParaTestPath(PhpConfigurationUtil.serializePath(testRunnerSettings.getParaTestPath()));
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        PhpInterpreter interpreter;
        if (executor == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(2);
        }
        if (env == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(3);
        }
        if ((interpreter = this.getInterpreter()) == null) {
            return null;
        }
        return this.getState(env, this.createCommand(interpreter, Collections.emptyMap(), false));
    }

    public RunProfileState checkAndGetState(@NotNull ExecutionEnvironment env, @NotNull PhpCommandSettings command) throws ExecutionException {
        if (env == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(4);
        }
        if (command == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(5);
        }
        try {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                this.checkConfiguration();
            }
        }
        catch (RuntimeConfigurationWarning runtimeConfigurationWarning) {
        }
        catch (RuntimeConfigurationException e) {
            throw new ExecutionException(PhpBundle.message("0.for.1.run.configuration", e.getMessage(), this.getName()));
        }
        if (PhpUnitExecutionUtil.hasUnsupportedParaTestOptions(this.getProject(), ((PhpUnitRunConfigurationSettings)this.getSettings()).getTestRunnerSettings())) {
            this.showParaTestUnsupportedOptionNotification(true);
        }
        return this.getState(env, command);
    }

    @NotNull
    public RunProfileState getState(@NotNull ExecutionEnvironment env, final @NotNull PhpCommandSettings command) {
        if (env == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(6);
        }
        if (command == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(7);
        }
        return new CommandLineState(env){

            @NotNull
            protected ProcessHandler startProcess() throws ExecutionException {
                PhpUnitRunConfigurationCounterCollector.logRunEvent((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings());
                GeneralCommandLine commandLine = command.createGeneralCommandLine(true);
                PhpRunConfigurationExtensionsManager.getInstance().patchCommandLine((RunConfigurationBase)PhpUnitLocalRunConfiguration.this.getRunConfiguration(), this.getRunnerSettings(), commandLine, this.getEnvironment().getRunner().getRunnerId(), this.getEnvironment().getExecutor());
                ProcessHandler processHandler = PhpUnitLocalRunConfiguration.this.createProcessHandler(PhpUnitLocalRunConfiguration.this.getProject(), command, PtyCommandLine.isEnabled(), commandLine);
                processHandler.addProcessListener((ProcessListener)new MyMigrationProcessAdapter(commandLine, command));
                PhpRunUtil.attachProcessOutputDebugDumper(processHandler);
                ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)PhpUnitLocalRunConfiguration.this.getProject());
                ProcessHandler processHandler2 = processHandler;
                if (processHandler2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return processHandler2;
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
                if (executor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (runner == null) {
                    1.$$$reportNull$$$0(2);
                }
                ProcessHandler processHandler = this.startProcess();
                if (executor instanceof PhpParaTestExecutor || PhpUnitExecutionUtil.isUseParaTest(PhpUnitLocalRunConfiguration.this.getProject(), ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings())) {
                    PhpUnitLocalRunConfiguration.forceManualDurationStrategy(processHandler);
                }
                PhpUnitConsoleProperties properties = PhpUnitLocalRunConfiguration.this.createTestConsoleProperties(executor, command.getPathProcessor());
                Ref ref = Ref.create();
                ApplicationManager.getApplication().invokeAndWait(() -> ref.set((Object)PhpUnitExecutionUtil.createConsole(PhpUnitLocalRunConfiguration.this.getProject(), processHandler, properties)));
                ConsoleView consoleView = (ConsoleView)ref.get();
                if (!command.hasInvalidPathArguments()) {
                    PhpUnitLocalRunConfiguration.this.notifyIfTestSuitIsEmpty(PhpUnitLocalRunConfiguration.this.getProject(), consoleView, processHandler);
                }
                DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler);
                PhpUnitRerunFailedTestsAction rerunFailedTestsAction = new PhpUnitRerunFailedTestsAction((ComponentContainer)consoleView, properties);
                rerunFailedTestsAction.setModelProvider(() -> {
                    if (consoleView instanceof SMTRunnerConsoleView) {
                        return ((SMTRunnerConsoleView)consoleView).getResultsViewer();
                    }
                    return null;
                });
                result.setRestartActions(new AnAction[]{rerunFailedTestsAction, new ToggleAutoTestAction()});
                DefaultExecutionResult defaultExecutionResult = result;
                if (defaultExecutionResult == null) {
                    1.$$$reportNull$$$0(3);
                }
                return defaultExecutionResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runner";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startProcess";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "execute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    public void showParaTestUnsupportedOptionNotification(boolean disableParaTestAction) {
        Notification notification = PhpUnitUtil.NOTIFICATION_GROUP.createNotification(PhpBundle.message("notification.title.paratest.doesn.t.support.filter.option", new Object[0]), PhpBundle.message("notification.content.tests.have.been.run.without.paratest", new Object[0]), NotificationType.WARNING);
        if (disableParaTestAction) {
            notification.addAction((AnAction)new NotificationAction(PhpBundle.message("notification.content.disable.paratest", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().setUseParaTest(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        notification.setSuggestionType(true);
        notification.configureDoNotAskOption("UnsupportedParaTestOption", PhpBundle.message("notification.title.paratest.doesn.t.support.filter.option", new Object[0]));
        if (notification.canShowFor(this.getProject())) {
            notification.notify(this.getProject());
        }
    }

    private static void forceManualDurationStrategy(final ProcessHandler processHandler) {
        processHandler.addProcessListener(new ProcessListener(){
            private boolean isExecuted = false;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (this.isExecuted) {
                    return;
                }
                if (event.getText().startsWith("##teamcity[")) {
                    this.isExecuted = true;
                    processHandler.notifyTextAvailable("##teamcity[enteredTheMatrix durationStrategy='MANUAL']", ProcessOutputTypes.STDOUT);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$3";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void notifyIfTestSuitIsEmpty(final @NotNull Project project, final @NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        PhpInterpreter interpreter;
        if (project == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(8);
        }
        if (consoleView == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(9);
        }
        if (processHandler == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(10);
        }
        if (consoleView instanceof SMTRunnerConsoleView && (interpreter = this.getInterpreter()) != null) {
            final String name = interpreter.getName();
            final VirtualFile workingDir = this.findWorkingDirectory(null, interpreter);
            PhpUnitSettings phpUnitSettings = PhpUnitLocalRunConfiguration.getOrCreateOnTheFlySettings(project, name, interpreter.isRemote(), workingDir);
            if (phpUnitSettings == null) {
                processHandler.addProcessListener(new ProcessListener(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        SMTestRunnerResultsForm resultViewer;
                        AbstractTestProxy proxy;
                        if (event == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        if ((proxy = (resultViewer = ((SMTRunnerConsoleView)consoleView).getResultsViewer()).getRoot()) instanceof SMTestProxy.SMRootTestProxy && ((SMTestProxy.SMRootTestProxy)proxy).isEmptySuite() && !((SMTestProxy.SMRootTestProxy)proxy).isTestsReporterAttached()) {
                            String title = PhpBundle.message("phpunit.not.tests.was.executed.title", new Object[0]);
                            VirtualFile composerConfig = ComposerConfigManager.getInstance(project).getConfig(workingDir);
                            if (composerConfig != null && ComposerConfigUtils.findRequiresDirectiveValue(composerConfig, PhpUnitFrameworkType.getInstance().getComposerPackageNames(), true) != null && !ComposerLibraryServiceFactory.getInstance(project, composerConfig).vendorDirExists()) {
                                Notification notification2 = PhpUnitUtil.NOTIFICATION_GROUP.createNotification(title, PhpBundle.message("validation.vendor.doesnt.exit", new Object[0]), NotificationType.WARNING);
                                notification2.addAction((AnAction)new ComposerInstallAction()).addAction((AnAction)NotificationAction.createSimpleExpiring((String)PhpBundle.message("action.run.composer.install.text", new Object[0]), () -> new ComposerInstallAction().act(project, composerConfig, "PhpTestRunConfiguration"))).setSuggestionType(true).notify(project);
                            } else {
                                PhpUnitSettings settings = PhpUnitSettingsManager.getInstance(project).getLocalSettings(workingDir);
                                String envName = settings == null ? PhpUnitSettings.MAIN : settings.getPresentableName(project);
                                String env = interpreter.isRemote() ? "'" + name + "' interpreter" : "'" + envName + "' configuration";
                                String message = PhpBundle.message("phpunit.not.tests.was.executed.message", env);
                                PhpUnitUtil.NOTIFICATION_GROUP.createNotification(title, message, NotificationType.WARNING).setListener((notification, e) -> {
                                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                        if (PhpUnitSettingsManager.getInstance(project).getLocalSettings(workingDir) == null) {
                                            PhpUiUtil.editConfigurable(project, (Configurable)new PhpTestFrameworksConfigurable(project, new PhpUnitComposerConfig().updateSettings(project, null, false, composerConfig)));
                                            return;
                                        }
                                        PhpUiUtil.editConfigurable(project, (Configurable)new PhpTestFrameworksConfigurable(project, PhpUnitSettingsManager.getInstance(project).getLocalSettings(workingDir)));
                                    }
                                }).setSuggestionType(true).notify(project);
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$4", "processTerminated"));
                    }
                });
            }
        }
    }

    @NotNull
    public PhpUnitConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        PhpRemoteInterpreterManager manager;
        if (executor == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(11);
        }
        PhpCommandLinePathProcessor pathProcessor = null;
        PhpInterpreter interpreter = this.getInterpreter();
        if (interpreter != null && interpreter.isRemote() && (manager = PhpRemoteInterpreterManager.getInstance()) != null) {
            try {
                pathProcessor = manager.createPathMapper(this.getProject(), interpreter.getPhpSdkAdditionalData());
            }
            catch (ExecutionException e) {
                LOG.info("Can not detect path mappings for selected interpreter: '" + interpreter.getName() + "'");
            }
        }
        PhpUnitConsoleProperties phpUnitConsoleProperties = this.createTestConsoleProperties(executor, pathProcessor == null ? PhpCommandLinePathProcessor.LOCAL : pathProcessor);
        if (phpUnitConsoleProperties == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(12);
        }
        return phpUnitConsoleProperties;
    }

    @NotNull
    public PhpUnitConsoleProperties createTestConsoleProperties(Executor executor, @NotNull PhpCommandLinePathProcessor processor2) {
        if (processor2 == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(13);
        }
        PhpPathMapper pathMapper = processor2.createPathMapper(this.getProject());
        PhpUnitQualifiedNameLocationProvider locationProvider = PhpUnitQualifiedNameLocationProvider.create(pathMapper);
        return new PhpUnitConsoleProperties<PhpUnitLocalRunConfiguration>(this, executor, locationProvider, true);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        PhpUnitSettings phpUnitConfiguration;
        Project project = this.getProject();
        PhpUnitRunConfigurationSettings settings = (PhpUnitRunConfigurationSettings)this.getSettings();
        PhpInterpreter interpreter = this.getInterpreter();
        PhpRunUtil.checkCommandLineSettings(project, settings.getCommandLineSettings(), settings.getCommandLineSettings().getInterpreterSettings().getInterpreterName());
        PhpUnitTestRunnerSettings testRunnerSettings = settings.getTestRunnerSettings();
        if (interpreter != null) {
            VirtualFile workingDir = this.findWorkingDirectory(null, interpreter);
            phpUnitConfiguration = PhpUnitLocalRunConfiguration.getOrCreateOnTheFlySettings(project, interpreter.getName(), interpreter.isRemote(), workingDir);
        } else {
            phpUnitConfiguration = null;
        }
        switch (testRunnerSettings.getScope()) {
            case Directory: {
                if (PhpRunUtil.findDirectory(testRunnerSettings.getDirectoryPath()) != null) break;
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "Directory"));
            }
            case Class: {
                PsiFile file = PhpRunUtil.findPsiFile(project, testRunnerSettings.getFilePath());
                if (file == null) {
                    throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "File"));
                }
                if (DumbService.getInstance((Project)project).isDumb()) break;
                PhpUnitLocalRunConfiguration.getAndCheckClass(testRunnerSettings.getClassName(), file, project);
                break;
            }
            case Method: {
                PsiFile file = PhpRunUtil.findPsiFile(project, testRunnerSettings.getFilePath());
                if (file == null) {
                    throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "File"));
                }
                if (DumbService.getInstance((Project)project).isDumb()) break;
                PhpClass clazz = PhpUnitLocalRunConfiguration.getAndCheckClass(testRunnerSettings.getClassName(), file, project);
                PhpUnitLocalRunConfiguration.getAndCheckMethod(testRunnerSettings.getMethodName(), clazz);
                break;
            }
            case XML: {
                if (testRunnerSettings.isUseAlternativeConfigurationFile() || phpUnitConfiguration != null && phpUnitConfiguration.isUseConfigurationFile()) break;
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.press.fix.project.configuration", "Default Configuration file", PHPUNIT), PhpTestFrameworksConfigurable.createFix(project, PhpUnitFrameworkType.getInstance(), interpreter));
            }
            case Pattern: {
                if (testRunnerSettings.getTestPatterns().isEmpty()) {
                    throw new RuntimeConfigurationError(PhpBundle.message("validation.test.no.test.patterns", new Object[0]));
                }
                if (PhpRunUtil.findDirectory(testRunnerSettings.getDirectoryPath()) != null || PhpRunUtil.findFile(testRunnerSettings.getFilePath()) != null) break;
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "File/Directory"));
            }
        }
        if (testRunnerSettings.isUseAlternativeConfigurationFile()) {
            String configFile = testRunnerSettings.getConfigurationFilePath();
            if (StringUtil.isEmpty((String)configFile)) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.path.to.value.should.be.specified", "configuration file", "\"Use alternative configuration file\" field"));
            }
            if (!PhpRunUtil.isValidFilePath(configFile)) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.path.to.value.is.invalid", "configuration file", "\"Use alternative configuration file\" field"));
            }
        }
        if (testRunnerSettings.isUseAlternativeBootstrapFile()) {
            String bootstrapFile = testRunnerSettings.getBootstrapFilePath();
            if (StringUtil.isEmpty((String)bootstrapFile)) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.path.to.value.should.be.specified", "bootstrap file", "\"Use alternative bootstrap file\" field"));
            }
            if (!PhpRunUtil.isValidFilePath(bootstrapFile)) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.path.to.value.is.invalid", "bootstrap file", "\"Use alternative bootstrap file\" field"));
            }
        }
        if (testRunnerSettings.isUseParaTest()) {
            String paraTestBinary = testRunnerSettings.getParaTestPath();
            if (StringUtil.isEmpty((String)paraTestBinary)) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.path.to.value.should.be.specified", "ParaTest binary", "\"Use ParaTest\" field"));
            }
            if (!PhpRunUtil.isValidFilePath(paraTestBinary)) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.path.to.value.is.invalid", "ParaTest binary", "\"Use ParaTest\" field"));
            }
        }
        if (interpreter != null && !interpreter.isRemote() && phpUnitConfiguration != null) {
            if (phpUnitConfiguration.isUseConfigurationFile() && !PhpRunUtil.isValidFilePath(phpUnitConfiguration.getConfigurationFilePath())) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.path.to.value.is.invalid.press.fix.project.configuration", "configuration file", "\"Default Configuration file\" field", PHPUNIT), PhpTestFrameworksConfigurable.createFix(project, PhpUnitFrameworkType.getInstance(), interpreter));
            }
            if (!testRunnerSettings.isUseAlternativeBootstrapFile() && phpUnitConfiguration.isUseBootstrapFile() && !PhpRunUtil.isValidFilePath(phpUnitConfiguration.getBootstrapFilePath())) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid.press.fix.project.configuration", "Bootstrap file"), PhpTestFrameworksConfigurable.createFix(project, PhpUnitFrameworkType.getInstance(), interpreter));
            }
            if (phpUnitConfiguration.getLoadMethod() == PhpUnitSettings.LoadMethod.CUSTOM_LOADER && !PhpRunUtil.isValidFilePath(phpUnitConfiguration.getCustomLoaderPath())) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid.press.fix.project.configuration", "Custom loader"), PhpTestFrameworksConfigurable.createFix(project, PhpUnitFrameworkType.getInstance(), interpreter));
            }
            if (phpUnitConfiguration.getLoadMethod() == PhpUnitSettings.LoadMethod.PHPUNIT_PHAR && !PhpRunUtil.isValidFilePath(phpUnitConfiguration.getPhpUnitPharPath())) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid.press.fix.project.configuration", "phpunit.phar"), PhpTestFrameworksConfigurable.createFix(project, PhpUnitFrameworkType.getInstance(), interpreter));
            }
        }
    }

    @Nullable
    public static PhpUnitSettings getPhpUnitSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter, boolean isRemote, @Nullable VirtualFile locationContext) {
        if (project == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(14);
        }
        PhpUnitSettingsManager manager = PhpUnitSettingsManager.getInstance(project);
        return isRemote ? manager.getSettingsByInterpreter(interpreter, locationContext) : manager.getLocalSettings(locationContext);
    }

    @Nullable
    public static PhpUnitSettings getOrCreateOnTheFlySettings(@NotNull Project project, @Nullable String interpreterName, boolean isRemote, @Nullable VirtualFile locationContext) {
        if (project == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(15);
        }
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreter(interpreterName);
        PhpUnitSettingsManager manager = PhpUnitSettingsManager.getInstance(project);
        PhpUnitSettings settings = PhpUnitLocalRunConfiguration.getPhpUnitSettings(project, interpreter, isRemote, locationContext);
        if (settings == null && manager.getDefaultSettings(locationContext) != null) {
            settings = manager.getOrCreateByInterpreter(interpreter, true, locationContext);
        }
        return settings;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        PhpUnitRunConfigurationEditor editor = new PhpUnitRunConfigurationEditor(this.getProject());
        SettingsEditor<? extends RunConfiguration> settingsEditor = PhpRunConfigurationExtensionsManager.getInstance().addExtensionEditor(editor, this, editor::getInterpreter);
        if (settingsEditor == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(16);
        }
        return settingsEditor;
    }

    public boolean isGeneratedName() {
        return PhpRunUtil.isGeneratedName(this);
    }

    public String suggestedName() {
        PhpUnitTestRunnerSettings testRunnerSettings = ((PhpUnitRunConfigurationSettings)this.getSettings()).getTestRunnerSettings();
        PhpUnitTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        return switch (scope) {
            default -> throw new IncompatibleClassChangeError();
            case PhpUnitTestRunnerSettings.Scope.Class -> PhpLangUtil.toShortName(StringUtil.notNullize((String)testRunnerSettings.getClassName()));
            case PhpUnitTestRunnerSettings.Scope.Directory -> PathUtil.getFileName((String)StringUtil.notNullize((String)testRunnerSettings.getDirectoryPath()));
            case PhpUnitTestRunnerSettings.Scope.Method -> {
                String shortName = PhpLangUtil.toShortName(StringUtil.notNullize((String)testRunnerSettings.getClassName()));
                yield shortName + "." + StringUtil.notNullize((String)testRunnerSettings.getMethodName());
            }
            case PhpUnitTestRunnerSettings.Scope.XML -> PathUtil.getFileName((String)StringUtil.notNullize((String)testRunnerSettings.getConfigurationFilePath()));
            case PhpUnitTestRunnerSettings.Scope.Pattern -> {
                List<PhpUnitTestPattern> patterns = testRunnerSettings.getTestPatterns();
                PhpUnitTestPattern firstItem = (PhpUnitTestPattern)ContainerUtil.getFirstItem(patterns);
                if (firstItem == null) {
                    yield PhpBundle.message("phpunit.config.empty.pattern", new Object[0]);
                }
                String firstName = firstItem.getMethodName();
                if (StringUtil.isEmpty((String)firstName)) {
                    firstName = PhpLangUtil.toShortName(firstItem.getClassFqn());
                }
                if (patterns.size() > 1) {
                    yield TestRunnerBundle.message((String)"test.config.first.pattern.and.few.more", (Object[])new Object[]{firstName, patterns.size() - 1});
                }
                yield firstName;
            }
        };
    }

    @Nullable
    public String getActionName() {
        PhpUnitTestRunnerSettings testRunnerSettings = ((PhpUnitRunConfigurationSettings)this.getSettings()).getTestRunnerSettings();
        PhpUnitTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        if (scope == PhpUnitTestRunnerSettings.Scope.Method && StringUtil.isNotEmpty((String)testRunnerSettings.getMethodName())) {
            String methodName = testRunnerSettings.getMethodName();
            return methodName.length() < 20 ? methodName : methodName.substring(0, 20) + "...";
        }
        return super.getActionName();
    }

    @Nullable
    public String getWorkingDirectory(@NotNull PhpUnitRunConfigurationSettings settings, @Nullable PhpUnitSettings phpUnitSettings) {
        PhpUnitTestRunnerSettings testRunnerSettings;
        String configurationFilePath;
        if (settings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(17);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(configurationFilePath = (testRunnerSettings = settings.getTestRunnerSettings()).getConfigurationFilePath()))) {
            return PathUtil.getParentPath((String)configurationFilePath);
        }
        PhpUnitTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        String directoryPath = testRunnerSettings.getDirectoryPath();
        String filePath = testRunnerSettings.getFilePath();
        switch (scope) {
            case Directory: {
                if (StringUtil.isEmptyOrSpaces((String)directoryPath)) break;
                return PathUtil.getParentPath((String)directoryPath);
            }
            case Class: 
            case Method: {
                if (StringUtil.isEmptyOrSpaces((String)filePath)) break;
                return PathUtil.getParentPath((String)filePath);
            }
            case Pattern: {
                if (!StringUtil.isEmptyOrSpaces((String)directoryPath)) {
                    return PathUtil.getParentPath((String)directoryPath);
                }
                if (StringUtil.isEmptyOrSpaces((String)filePath)) break;
                return PathUtil.getParentPath((String)filePath);
            }
            case XML: {
                String workingDirectory = null;
                if (testRunnerSettings.isUseAlternativeConfigurationFile()) {
                    workingDirectory = this.findComposerConfigDirectory(testRunnerSettings.getConfigurationFilePath());
                } else if (phpUnitSettings != null && phpUnitSettings.isUseConfigurationFile()) {
                    workingDirectory = this.findComposerConfigDirectory(testRunnerSettings.getConfigurationFilePath());
                }
                return workingDirectory;
            }
        }
        return null;
    }

    @Nullable
    public VirtualFile findWorkingDirectory(@Nullable PhpUnitSettings phpUnitSettings, @Nullable PhpInterpreter interpreter) {
        String workingDirectoryPath = this.getWorkingDirectory((PhpUnitRunConfigurationSettings)this.getSettings(), phpUnitSettings);
        return PhpTestRunConfiguration.findDirectory(this.getProject(), interpreter, workingDirectoryPath);
    }

    @Nullable
    private String findComposerConfigDirectory(@Nullable String path) {
        VirtualFile configParent;
        VirtualFile file = PhpTestRunConfiguration.findFileOrDirectory(this.getProject(), this.getInterpreter(), path);
        if (file == null) {
            return null;
        }
        VirtualFile composerConfig = ComposerConfigManager.getInstance(this.myProject).getConfig(file);
        VirtualFile virtualFile = configParent = composerConfig != null ? composerConfig.getParent() : null;
        if (configParent != null) {
            return configParent.getPath();
        }
        return null;
    }

    public PhpCommandSettings createCommand(@NotNull PhpInterpreter interpreter, @NotNull Map<String, String> envParameters, boolean enableDebug) throws ExecutionException {
        if (interpreter == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(18);
        }
        if (envParameters == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(19);
        }
        return this.createCommand(interpreter, (PhpUnitRunConfigurationSettings)this.getSettings(), envParameters, (List<String>)new SmartList(), enableDebug);
    }

    public PhpCommandSettings createCommand(@NotNull PhpInterpreter interpreter, @NotNull PhpUnitRunConfigurationSettings settings, @NotNull Map<String, String> envParameters, @NotNull List<String> arguments, boolean enableDebug) throws ExecutionException {
        Collection<String> options;
        if (interpreter == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(20);
        }
        if (settings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(21);
        }
        if (envParameters == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(22);
        }
        if (arguments == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(23);
        }
        Project project = this.getProject();
        PhpCommandSettings command = new PhpCommandSettingsBuilder(project, interpreter).loadAndStartDebug(enableDebug).build();
        if (PhpUnitExecutionUtil.isUseParaTest(project, settings.getTestRunnerSettings()) && enableDebug && !(options = PhpCommandSettingsBuilder.getDebugOptions(true, this.getProject(), this.getInterpreter())).isEmpty()) {
            command.addArgument("--passthru-php=" + StringUtil.join(options, (String)" "));
        }
        return this.fillTestArguments(interpreter, command, settings, envParameters, arguments);
    }

    @NotNull
    public PhpCommandSettings fillTestArguments(@NotNull PhpInterpreter interpreter, @NotNull PhpCommandSettings command, @NotNull PhpUnitRunConfigurationSettings settings, @NotNull Map<String, String> envParameters, @NotNull List<String> arguments) throws ExecutionException {
        boolean isPhpCacheFileOptionSupported;
        boolean isNewPhpUnit;
        if (interpreter == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(24);
        }
        if (command == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(25);
        }
        if (settings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(26);
        }
        if (envParameters == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(27);
        }
        if (arguments == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(28);
        }
        Project project = this.getProject();
        VirtualFile workingDir = this.findWorkingDirectory(null, interpreter);
        PhpUnitSettings phpUnitSettings = PhpUnitLocalRunConfiguration.getOrCreateOnTheFlySettings(project, interpreter.getName(), command.isRemote(), workingDir);
        String executable = PhpUnitLocalRunConfiguration.findPathToExecutable(phpUnitSettings, interpreter.isRemote());
        PhpUnitVersion version = null;
        if (executable != null) {
            String cachedVersion = PhpTestFrameworkVersionCache.getCache(project, phpUnitSettings);
            if (cachedVersion == null && SwingUtilities.isEventDispatchThread()) {
                try {
                    version = (PhpUnitVersion)PhpUnitVersionDetector.getInstance().getVersion(project, interpreter, executable);
                    PhpTestFrameworkVersionCache.setCache(project, phpUnitSettings, version.getVersion());
                }
                catch (ExecutionException e) {
                    LOG.warn("Cannot detect PHPUnit version by " + executable, (Throwable)e);
                }
            } else {
                version = PhpUnitVersion.create(cachedVersion);
            }
        }
        PhpUnitTestRunnerSettings testRunnerSettings = settings.getTestRunnerSettings();
        PhpUnitLocalRunConfiguration.runInReadAction(() -> PhpUnitExecutionUtil.fillPhpUnitTestRunnerArguments(project, testRunnerSettings, arguments, command, phpUnitSettings));
        command.importCommandLineSettings(settings.getCommandLineSettings(), this.getWorkingDirectory(settings, phpUnitSettings));
        boolean useParaTest = PhpUnitExecutionUtil.isUseParaTest(project, testRunnerSettings);
        if (useParaTest) {
            command.addPathOption(Objects.requireNonNull(testRunnerSettings.getParaTestPath()));
        }
        boolean bl = isNewPhpUnit = version != null && version.isAfterPrinterChange();
        if (isNewPhpUnit) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PHPUnit " + version.getVersion() + " was detected. Execute tests with " + executable);
            }
            command.setScript(executable, false);
        } else if (!PlatformUtils.isFleetBackend()) {
            String script = PhpUnitLocalRunConfiguration.getPathToScript(project, command);
            if (StringUtil.isEmpty((String)script)) {
                String message = PhpBundle.message("php.interpreter.base.configuration.interpreter.is.invalid", "PHPUnit tests", PHPUNIT);
                throw new ExecutionException(message);
            }
            command.setScript(script, false);
        }
        if (phpUnitSettings != null) {
            PhpUnitLocalRunConfiguration.fillPhpUnitConfigurationSettings(phpUnitSettings, command, version == null ? null : version.getVersion());
        }
        command.addEnvs(envParameters);
        if (isNewPhpUnit) {
            command.addArgument("--teamcity");
        }
        boolean bl2 = isPhpCacheFileOptionSupported = version != null && version.isAfterCacheFileOptionAdded() && !useParaTest;
        if (isPhpCacheFileOptionSupported && !PhpUnitLocalRunConfiguration.isConfigFileUsed(testRunnerSettings)) {
            PhpUnitLocalRunConfiguration.addOptionForPhpUnitCacheFile(command, project);
        }
        PhpCommandSettings phpCommandSettings = command;
        if (phpCommandSettings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(29);
        }
        return phpCommandSettings;
    }

    private static void runInReadAction(Runnable r) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            r.run();
        } else {
            ApplicationManager.getApplication().runReadAction(r);
        }
    }

    private static void addOptionForPhpUnitCacheFile(@NotNull PhpCommandSettings command, @NotNull Project project) {
        if (command == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(30);
        }
        if (project == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(31);
        }
        String pathToCaches = project.getBasePath();
        String pathToCachesFile = pathToCaches + "/.phpunit.result.cache";
        String targetPathToCachesFile = command.getPathProcessor().process(pathToCachesFile);
        if (!PhpUnitLocalRunConfiguration.wasOptionConfiguredInCommand(command, "--cache-result-file=")) {
            command.addArgument("--cache-result-file=" + targetPathToCachesFile);
        }
    }

    private static boolean wasOptionConfiguredInCommand(@NotNull PhpCommandSettings command, @NotNull String option) {
        if (command == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(32);
        }
        if (option == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(33);
        }
        List<String> args = command.getArguments();
        String trimmedOption = StringUtil.trimEnd((String)option, (String)"=");
        for (String arg : args) {
            String[] split = arg.split("=");
            if (!split[0].equals(trimmedOption)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConfigFileUsed(@NotNull PhpUnitTestRunnerSettings testRunnerSettings) {
        if (testRunnerSettings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(34);
        }
        return testRunnerSettings.isUseAlternativeConfigurationFile() || StringUtil.isNotEmpty((String)testRunnerSettings.getConfigurationFilePath());
    }

    @Nullable
    private static String findPathToExecutable(@Nullable PhpUnitSettings settings, boolean isRemote) {
        if (settings != null) {
            String loader;
            if (settings.getLoadMethod() == PhpUnitSettings.LoadMethod.PHPUNIT_PHAR) {
                return settings.getPhpUnitPharPath();
            }
            if (settings.getLoadMethod() == PhpUnitSettings.LoadMethod.CUSTOM_LOADER && StringUtil.isNotEmpty((String)(loader = settings.getCustomLoaderPath()))) {
                String directory = PathUtil.getParentPath((String)loader);
                String fullExePath = FileUtil.join((String[])new String[]{directory, "phpunit", "phpunit", "phpunit"});
                if (isRemote) {
                    return FileUtil.toSystemIndependentName((String)fullExePath);
                }
                VirtualFile binary = PhpRunUtil.findFile(fullExePath);
                if (binary == null) {
                    binary = PhpRunUtil.findFile(FileUtil.join((String[])new String[]{directory, "bin", "phpunit"}));
                }
                return binary == null ? null : binary.getPath();
            }
        }
        return null;
    }

    private static void fillPhpUnitConfigurationSettings(@NotNull PhpUnitSettings phpUnitConfiguration, @NotNull PhpCommandSettings command, @Nullable String version) {
        if (phpUnitConfiguration == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(35);
        }
        if (command == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(36);
        }
        switch (phpUnitConfiguration.getLoadMethod()) {
            case CUSTOM_LOADER: {
                command.addEnv("IDE_PHPUNIT_CUSTOM_LOADER", StringUtil.notNullize((String)phpUnitConfiguration.getCustomLoaderPath()));
                break;
            }
            case PHPUNIT_PHAR: {
                String pathToPhar = StringUtil.notNullize((String)phpUnitConfiguration.getPhpUnitPharPath());
                command.addEnv("IDE_PHPUNIT_PHPUNIT_PHAR", pathToPhar);
                if (!StringUtil.isNotEmpty((String)version)) break;
                command.addEnv("IDE_PHPUNIT_VERSION", version);
            }
        }
    }

    @Nullable
    private static String getPathToScript(@NotNull Project project, @NotNull PhpCommandSettings command) throws ExecutionException {
        if (project == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(37);
        }
        if (command == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(38);
        }
        if (command.isRemote()) {
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            if (manager == null) {
                throw new ExecutionException(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
            }
            try {
                PhpSdkAdditionalData data = command.getAdditionalData();
                assert (data != null);
                return PhpSdkHelpersManager.getHelpersManager(data).getHelperScript(project, "phpunit.php", null);
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        return PhpUnitExecutionUtil.getPhpUnitHelperScriptFile().getPath();
    }

    @Override
    @NotNull
    protected List<PhpRefactoringListenerRunConfiguration.PhpRefValue<String>> getPathsToUpdate() {
        List<PhpRefactoringListenerRunConfiguration.PhpRefValue<String>> toUpdate = super.getPathsToUpdate();
        toUpdate.add(new PhpRefactoringListenerRunConfiguration.PhpRefValue<String>(){

            @Override
            @Nullable
            public String getValue() {
                return ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().getDirectoryPath();
            }

            @Override
            public void setValue(@Nullable String newValue) {
                ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().setDirectoryPath(newValue);
            }
        });
        toUpdate.add(new PhpRefactoringListenerRunConfiguration.PhpRefValue<String>(){

            @Override
            @Nullable
            public String getValue() {
                return ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().getFilePath();
            }

            @Override
            public void setValue(@Nullable String newValue) {
                ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().setFilePath(newValue);
            }
        });
        toUpdate.add(new PhpRefactoringListenerRunConfiguration.PhpRefValue<String>(){

            @Override
            @Nullable
            public String getValue() {
                return ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().getConfigurationFilePath();
            }

            @Override
            public void setValue(@Nullable String newValue) {
                ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().setConfigurationFilePath(newValue);
            }
        });
        toUpdate.add(new PhpRefactoringListenerRunConfiguration.PhpRefValue<String>(){

            @Override
            @Nullable
            public String getValue() {
                return ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().getBootstrapFilePath();
            }

            @Override
            public void setValue(@Nullable String newValue) {
                ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().setBootstrapFilePath(newValue);
            }
        });
        toUpdate.add(new PhpRefactoringListenerRunConfiguration.PhpRefValue<String>(){

            @Override
            @Nullable
            public String getValue() {
                return ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().getParaTestPath();
            }

            @Override
            public void setValue(@Nullable String newValue) {
                ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().setParaTestPath(newValue);
            }
        });
        List<PhpRefactoringListenerRunConfiguration.PhpRefValue<String>> list = toUpdate;
        if (list == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(39);
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    protected RefactoringElementListener getRefactoringPsiElementListener(@NotNull PsiElement oldElement) {
        if (oldElement == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(40);
        }
        ClassAndMethodData oldCam = PhpUnitLocalRunConfiguration.getClassAndMethodData(oldElement);
        PhpUnitTestRunnerSettings settings = ((PhpUnitRunConfigurationSettings)this.getSettings()).getTestRunnerSettings();
        if (oldCam == null) return null;
        if (!PhpUnitLocalRunConfiguration.getClassAndMethodData(((PhpUnitRunConfigurationSettings)this.getSettings()).getTestRunnerSettings()).stream().anyMatch(oldCam::equals)) return null;
        PhpUnitTestElementRenamedListener phpUnitTestElementRenamedListener = new PhpUnitTestElementRenamedListener(oldCam, settings);
        return phpUnitTestElementRenamedListener;
    }

    @NotNull
    private static Collection<ClassAndMethodData> getClassAndMethodData(@NotNull PhpUnitTestRunnerSettings settings) {
        PhpUnitTestRunnerSettings.Scope scope;
        if (settings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(41);
        }
        if ((scope = settings.getScope()) == PhpUnitTestRunnerSettings.Scope.Class) {
            List<ClassAndMethodData> list = Collections.singletonList(new ClassAndMethodData(StringUtil.notNullize((String)settings.getClassName()), null, StringUtil.notNullize((String)settings.getFilePath())));
            if (list == null) {
                PhpUnitLocalRunConfiguration.$$$reportNull$$$0(42);
            }
            return list;
        }
        if (scope == PhpUnitTestRunnerSettings.Scope.Method) {
            List<ClassAndMethodData> list = Collections.singletonList(new ClassAndMethodData(StringUtil.notNullize((String)settings.getClassName()), settings.getMethodName(), StringUtil.notNullize((String)settings.getFilePath())));
            if (list == null) {
                PhpUnitLocalRunConfiguration.$$$reportNull$$$0(43);
            }
            return list;
        }
        if (scope == PhpUnitTestRunnerSettings.Scope.Pattern) {
            List list = ContainerUtil.map(settings.getTestPatterns(), p -> new ClassAndMethodData(p.getClassFqn(), p.getMethodName(), StringUtil.notNullize((String)p.getContainingFileAbsolutePath())));
            if (list == null) {
                PhpUnitLocalRunConfiguration.$$$reportNull$$$0(44);
            }
            return list;
        }
        List<ClassAndMethodData> list = Collections.emptyList();
        if (list == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(45);
        }
        return list;
    }

    @Nullable
    private static ClassAndMethodData getClassAndMethodData(@NotNull PsiElement element) {
        if (element == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(46);
        }
        if (!(element instanceof PhpClass) && !(element instanceof Method)) {
            return null;
        }
        PhpClass aClass = element instanceof PhpClass ? (PhpClass)element : ((Method)element).getContainingClass();
        String classFQN = aClass != null ? aClass.getPresentableFQN() : null;
        Method method = element instanceof Method ? (Method)element : null;
        String methodName = method != null ? method.getName() : null;
        return classFQN != null ? new ClassAndMethodData(classFQN, methodName, element.getContainingFile().getVirtualFile().getPresentableUrl()) : null;
    }

    private static void getAndCheckMethod(@Nullable String methodName, @NotNull PhpClass testClass) throws RuntimeConfigurationError {
        if (testClass == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(47);
        }
        if (StringUtil.isEmptyOrSpaces((String)methodName)) {
            throw new RuntimeConfigurationError(PhpBundle.message("php.method.name.empty", new Object[0]));
        }
        Method method = testClass.findMethodByName((CharSequence)methodName);
        if (method == null) {
            throw new RuntimeConfigurationError(PhpBundle.message("php.method.not.found", methodName, testClass.getName()));
        }
        if (!PhpUnitUtil.isTestMethod(testClass, method)) {
            throw new RuntimeConfigurationError(PhpBundle.message("php.not.test.method", methodName, testClass.getName()));
        }
    }

    @NotNull
    private static PhpClass getAndCheckClass(@Nullable String classFQN, @NotNull PsiFile file, @NotNull Project project) throws RuntimeConfigurationError {
        PhpClass phpClass;
        if (file == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(48);
        }
        if (project == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(49);
        }
        if (classFQN != null && (phpClass = PhpUnitUtil.findClassByFQNInFile(classFQN, file, project)) != null && PhpUnitUtil.isTestClass(phpClass)) {
            PhpClass phpClass2 = phpClass;
            if (phpClass2 == null) {
                PhpUnitLocalRunConfiguration.$$$reportNull$$$0(50);
            }
            return phpClass2;
        }
        throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "Test class"));
    }

    @Override
    @Nullable
    public PhpInterpreter getInterpreter() {
        String interpreterName = ((PhpUnitRunConfigurationSettings)this.getSettings()).getCommandLineSettings().getInterpreterSettings().getInterpreterName();
        if (interpreterName != null) {
            return PhpInterpretersManagerImpl.getInstance(this.getProject()).findInterpreter(interpreterName);
        }
        return PhpProjectConfigurationFacade.getInstance(this.getProject()).getInterpreter();
    }

    @Override
    protected boolean showVerboseOutput() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 16, 29, 39, 42, 43, 44, 45, 50 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: 
            case 7: 
            case 25: 
            case 30: 
            case 32: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 8: 
            case 14: 
            case 15: 
            case 31: 
            case 37: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 12: 
            case 16: 
            case 29: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 19: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envParameters";
                break;
            }
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnerSettings";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpUnitConfiguration";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestConsoleProperties";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "fillTestArguments";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToUpdate";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassAndMethodData";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndCheckClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fixSettingsAfterDeserialization";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fixSettingsBeforeSerialization";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkAndGetState";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "notifyIfTestSuitIsEmpty";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 12: 
            case 16: 
            case 29: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 50: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPhpUnitSettings";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateOnTheFlySettings";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createCommand";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fillTestArguments";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addOptionForPhpUnitCacheFile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "wasOptionConfiguredInCommand";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isConfigFileUsed";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fillPhpUnitConfigurationSettings";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPathToScript";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getRefactoringPsiElementListener";
                break;
            }
            case 41: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getClassAndMethodData";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getAndCheckMethod";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getAndCheckClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 16, 29, 39, 42, 43, 44, 45, 50 -> new IllegalStateException(string);
        };
    }

    private static class ClassAndMethodData {
        @NotNull
        private final String myClassFQN;
        @Nullable
        private final String myMethodName;
        @NotNull
        private final String myFilePath;

        ClassAndMethodData(@NotNull String classFQN, @Nullable String methodName, @NotNull String filePath) {
            if (classFQN == null) {
                ClassAndMethodData.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                ClassAndMethodData.$$$reportNull$$$0(1);
            }
            this.myClassFQN = classFQN;
            this.myMethodName = methodName;
            this.myFilePath = filePath;
        }

        @NotNull
        public String getClassName() {
            String string = this.myClassFQN;
            if (string == null) {
                ClassAndMethodData.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public String getMethodName() {
            return this.myMethodName;
        }

        @NotNull
        public String getFilePath() {
            String string = this.myFilePath;
            if (string == null) {
                ClassAndMethodData.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassAndMethodData data = (ClassAndMethodData)o;
            if (!this.myClassFQN.equals(data.myClassFQN)) {
                return false;
            }
            if (this.myMethodName != null && !this.myMethodName.equals(data.myMethodName)) {
                return false;
            }
            return this.myFilePath.equals(data.myFilePath);
        }

        public int hashCode() {
            int result = this.myClassFQN.hashCode();
            result = 31 * result + (this.myMethodName != null ? this.myMethodName.hashCode() : 0);
            result = 31 * result + this.myFilePath.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFQN";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$ClassAndMethodData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$ClassAndMethodData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpUnitTestElementRenamedListener
    extends UndoRefactoringElementAdapter {
        private final ClassAndMethodData myCamBeforeRefactoring;
        private final PhpUnitTestRunnerSettings mySettings;
        @Nullable
        private ClassAndMethodData myCamAfterRefactoring;

        PhpUnitTestElementRenamedListener(ClassAndMethodData camBeforeRefactoring, PhpUnitTestRunnerSettings settings) {
            this.myCamBeforeRefactoring = camBeforeRefactoring;
            this.mySettings = settings;
        }

        protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
            ClassAndMethodData cam;
            boolean isUndoAction;
            if (element == null) {
                PhpUnitTestElementRenamedListener.$$$reportNull$$$0(0);
            }
            boolean bl = isUndoAction = oldQualifiedName != null;
            if (!isUndoAction) {
                this.myCamAfterRefactoring = PhpUnitLocalRunConfiguration.getClassAndMethodData(element);
            }
            ClassAndMethodData oldCam = isUndoAction ? this.myCamAfterRefactoring : this.myCamBeforeRefactoring;
            ClassAndMethodData classAndMethodData = cam = isUndoAction ? this.myCamBeforeRefactoring : this.myCamAfterRefactoring;
            if (cam == null) {
                return;
            }
            this.mySettings.setClassName(cam.getClassName());
            if (cam.getMethodName() != null) {
                this.mySettings.setMethodName(cam.getMethodName());
            }
            if (this.mySettings.getScope() == PhpUnitTestRunnerSettings.Scope.Pattern) {
                boolean customBasePathNotUsed = this.isCustomBasePathNotUsed();
                this.updateTestPatterns(oldCam, cam);
                if (customBasePathNotUsed) {
                    PhpUnitTestRunnerConfigurationEditor.setCommonPath(this.mySettings, PhpUnitTestRunnerConfigurationEditor.getCommonFileOrDirectory(this.mySettings.getTestPatterns()));
                }
            } else {
                this.mySettings.setFilePath(cam.getFilePath());
            }
        }

        private boolean isCustomBasePathNotUsed() {
            VirtualFile common = PhpUnitTestRunnerConfigurationEditor.getCommonFileOrDirectory(this.mySettings.getTestPatterns());
            if (common == null) {
                return false;
            }
            return common.isDirectory() ? FileUtil.pathsEqual((String)common.getPath(), (String)this.mySettings.getDirectoryPath()) : FileUtil.pathsEqual((String)common.getPath(), (String)this.mySettings.getFilePath());
        }

        private void updateTestPatterns(ClassAndMethodData oldCam, ClassAndMethodData newCam) {
            List testPatterns = ContainerUtil.map(this.mySettings.getTestPatterns(), p -> PhpUnitTestElementRenamedListener.updatePattern(p, oldCam, newCam));
            this.mySettings.setTestPatterns(testPatterns);
        }

        @NotNull
        private static PhpUnitTestPattern updatePattern(@NotNull PhpUnitTestPattern pattern, @NotNull ClassAndMethodData oldCam, @NotNull ClassAndMethodData newCam) {
            if (pattern == null) {
                PhpUnitTestElementRenamedListener.$$$reportNull$$$0(1);
            }
            if (oldCam == null) {
                PhpUnitTestElementRenamedListener.$$$reportNull$$$0(2);
            }
            if (newCam == null) {
                PhpUnitTestElementRenamedListener.$$$reportNull$$$0(3);
            }
            String fqn = StringUtil.equals((CharSequence)pattern.getClassFqn(), (CharSequence)oldCam.getClassName()) ? newCam.getClassName() : pattern.getClassFqn();
            String methodName = StringUtil.equals((CharSequence)pattern.getMethodName(), (CharSequence)oldCam.getMethodName()) ? newCam.getMethodName() : pattern.getMethodName();
            String path = StringUtil.equals((CharSequence)pattern.getContainingFileAbsolutePath(), (CharSequence)oldCam.getFilePath()) ? newCam.getFilePath() : pattern.getContainingFileAbsolutePath();
            return new PhpUnitTestPattern(fqn, methodName, path, pattern.getDataSet());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldCam";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newCam";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$PhpUnitTestElementRenamedListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refactored";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePattern";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyMigrationProcessAdapter
    extends CapturingProcessAdapter {
        private final GeneralCommandLine myCommandLine;
        @NotNull
        private final PhpCommandSettings myCommand;

        private MyMigrationProcessAdapter(@NotNull GeneralCommandLine commandLine, PhpCommandSettings command) {
            if (command == null) {
                MyMigrationProcessAdapter.$$$reportNull$$$0(0);
            }
            this.myCommandLine = commandLine;
            this.myCommand = command;
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                MyMigrationProcessAdapter.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                MyMigrationProcessAdapter.$$$reportNull$$$0(2);
            }
            if (event.getText().contains("--migrate-configuration")) {
                Notification notification = new Notification(PhpUnitLocalRunConfiguration.PHPUNIT, PhpBundle.message("notification.title.phpunit", new Object[0]), PhpBundle.message("notification.content.should.be.migrated", new Object[0]), NotificationType.INFORMATION);
                notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)PhpBundle.message("action.migrate.text", new Object[0]), () -> {
                    PhpCommandSettings settings = new PhpCommandSettings(this.myCommandLine.getExePath(), this.myCommand.getPathProcessor(), this.myCommand.getAdditionalData());
                    settings.addPathArgument(this.myCommandLine.getParametersList().get(0));
                    settings.addArgument("--migrate-configuration");
                    settings.setWorkingDir(this.myCommand.getWorkingDirectory());
                    GeneralCommandLine cli = settings.createGeneralCommandLine(true);
                    try {
                        ProcessHandler processHandler = PhpUnitLocalRunConfiguration.this.createProcessHandler(PhpUnitLocalRunConfiguration.this.getProject(), settings, PtyCommandLine.isEnabled(), cli);
                        processHandler.startNotify();
                        processHandler.addProcessListener((ProcessListener)new CapturingProcessAdapter(){

                            public void processTerminated(@NotNull ProcessEvent event) {
                                if (event == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (event.getExitCode() == 0) {
                                    new Notification(PhpUnitLocalRunConfiguration.PHPUNIT, PhpBundle.message("notification.title.phpunit", new Object[0]), PhpBundle.message("notification.content.phpunit.xml.configuration.file.was.migrated", new Object[0]), NotificationType.INFORMATION).notify(PhpUnitLocalRunConfiguration.this.getProject());
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$MyMigrationProcessAdapter$1", "processTerminated"));
                            }
                        });
                    }
                    catch (ExecutionException ex) {
                        throw new RuntimeException(ex);
                    }
                }));
                notification.notify(PhpUnitLocalRunConfiguration.this.getProject());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$MyMigrationProcessAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

