/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.UriUtil;
import com.jetbrains.php.phar.PharHandlers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PharFileSystem
extends ArchiveFileSystem {
    public static final String PHAR_PREFIX = "phar://";
    public static final String PHAR_PROTOCOL = "phar";
    public static final String PHAR_EXTENSION = ".phar";

    public static PharFileSystem getInstance() {
        return (PharFileSystem)VirtualFileManager.getInstance().getFileSystem(PHAR_PROTOCOL);
    }

    @NotNull
    public String getProtocol() {
        return PHAR_PROTOCOL;
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        int endIndex;
        if (path == null) {
            PharFileSystem.$$$reportNull$$$0(0);
        }
        return (endIndex = PharHandlers.fileNameEndIndex(path)) > 0 ? FileUtil.normalize((String)path.substring(0, endIndex)) + path.substring(endIndex) : null;
    }

    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        int endIndex;
        if (normalizedPath == null) {
            PharFileSystem.$$$reportNull$$$0(1);
        }
        return (endIndex = PharHandlers.fileNameEndIndex(normalizedPath)) > 0 ? normalizedPath.substring(0, endIndex) : "";
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        if (rootPath == null) {
            PharFileSystem.$$$reportNull$$$0(2);
        }
        String string = UriUtil.trimTrailingSlashes((String)rootPath);
        if (string == null) {
            PharFileSystem.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        if (localPath == null) {
            PharFileSystem.$$$reportNull$$$0(4);
        }
        String string = localPath;
        if (string == null) {
            PharFileSystem.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        if (entryFile == null) {
            PharFileSystem.$$$reportNull$$$0(6);
        }
        ArchiveHandler archiveHandler = VfsImplUtil.getHandler((ArchiveFileSystem)this, (VirtualFile)entryFile, localPath -> PharHandlers.create(localPath));
        if (archiveHandler == null) {
            PharFileSystem.$$$reportNull$$$0(7);
        }
        return archiveHandler;
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            PharFileSystem.$$$reportNull$$$0(8);
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            PharFileSystem.$$$reportNull$$$0(9);
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            PharFileSystem.$$$reportNull$$$0(10);
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, (boolean)asynchronous);
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        if (local == null) {
            PharFileSystem.$$$reportNull$$$0(11);
        }
        return local.getName().contains(PHAR_EXTENSION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phar/PharFileSystem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phar/PharFileSystem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLocalPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "composeRootPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractLocalPath";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "composeRootPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectFileType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7 -> new IllegalStateException(string);
        };
    }
}

