/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.navigation;

import com.intellij.lang.Language;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.classAlias.PhpClassAliasIndex;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassAliasFqnIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassAliasNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassFqnIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInterfaceFqnIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInterfaceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTraitFqnIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTraitIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpGotoClassContributor
implements GotoClassContributor,
ChooseByNameContributorEx,
PossiblyDumbAware {
    public void processNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor2 == null) {
            PhpGotoClassContributor.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            PhpGotoClassContributor.$$$reportNull$$$0(1);
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE.ignoreDumbMode(() -> {
            if (!index.processAllKeys(PhpClassAliasNameIndex.KEY, processor2, scope, filter)) {
                return;
            }
            if (!index.processAllKeys(PhpClassAliasFqnIndex.KEY, processor2, scope, filter)) {
                return;
            }
            if (!index.processAllKeys(PhpClassFqnIndex.KEY, s -> PhpGotoClassContributor.processFQN(processor2, s), scope, filter)) {
                return;
            }
            if (!index.processAllKeys(PhpInterfaceFqnIndex.KEY, s -> PhpGotoClassContributor.processFQN(processor2, s), scope, filter)) {
                return;
            }
            Project project = scope.getProject();
            if (project == null || DumbService.getInstance((Project)project).isDumb()) {
                return;
            }
            StubIndex.getInstance().processAllKeys(PhpTraitFqnIndex.KEY, project, s -> PhpGotoClassContributor.processFQN(processor2, s));
        });
    }

    private static boolean processFQN(@NotNull Processor<? super String> processor2, String s) {
        if (processor2 == null) {
            PhpGotoClassContributor.$$$reportNull$$$0(2);
        }
        return processor2.process((Object)s) && processor2.process((Object)PhpLangUtil.toShortName(s));
    }

    public void processElementsWithName(@NotNull String name, @NotNull Processor<? super NavigationItem> processor2, @NotNull FindSymbolParameters parameters) {
        if (name == null) {
            PhpGotoClassContributor.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            PhpGotoClassContributor.$$$reportNull$$$0(4);
        }
        if (parameters == null) {
            PhpGotoClassContributor.$$$reportNull$$$0(5);
        }
        Project project = parameters.getProject();
        GlobalSearchScope scope = parameters.getSearchScope();
        IdFilter filter = parameters.getIdFilter();
        StubIndex index = StubIndex.getInstance();
        String lcName = StringUtil.toLowerCase((String)PhpLangUtil.toShortName(name));
        if (PhpLangUtil.isFqn(name)) {
            processor2 = PhpGotoClassContributor.createFqnMatchingProcessor(processor2, name);
        }
        Processor<? super NavigationItem> finalProcessor = processor2;
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
            if (!index.processElements(PhpInterfaceIndex.KEY, (Object)lcName, project, scope, filter, PhpClass.class, finalProcessor)) {
                return;
            }
            if (!index.processElements(PhpClassIndex.KEY, (Object)lcName, project, scope, filter, PhpClass.class, finalProcessor)) {
                return;
            }
            if (!index.processElements(PhpTraitIndex.KEY, (Object)lcName, project, scope, filter, PhpClass.class, finalProcessor)) {
                return;
            }
            ContainerUtil.process((Iterable)PhpClassAliasIndex.getInstance((Project)project).getAliasesByName(lcName, null, scope), (Processor)finalProcessor);
        });
    }

    private static Processor<? super NavigationItem> createFqnMatchingProcessor(Processor<? super NavigationItem> processor2, String fqn) {
        return item -> {
            if (item instanceof PhpClass && PhpLangUtil.equalsClassNames(((PhpClass)item).getFQN(), fqn)) {
                return processor2.process(item);
            }
            return true;
        };
    }

    public String getQualifiedName(@NotNull NavigationItem item) {
        if (item == null) {
            PhpGotoClassContributor.$$$reportNull$$$0(6);
        }
        if (item instanceof PhpClass) {
            PhpClass phpClass = (PhpClass)item;
            return phpClass.getFQN();
        }
        return null;
    }

    public String getQualifiedNameSeparator() {
        return "\\";
    }

    @Nullable
    public Language getElementLanguage() {
        return PhpLanguage.INSTANCE;
    }

    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/navigation/PhpGotoClassContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processFQN";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementsWithName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifiedName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

