/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocCommentImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocCoversTag;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpPathInfo;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpPathInfoDescriptor;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpPathInfoSetExternalizer;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpUnitDataProvidersIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionClassConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitCoversIndex
extends FileBasedIndexExtension<PhpPathInfo, Set<PhpPathInfo>> {
    @NonNls
    public static final ID<PhpPathInfo, Set<PhpPathInfo>> KEY = ID.create((String)"php.unit.covers");
    private static final String PHPUNIT_COVERS_CLASS_ATTRIBUTE = "\\PHPUnit\\Framework\\Attributes\\CoversClass";
    private static final String PHPUNIT_COVERS_METHOD_ATTRIBUTE = "\\PHPUnit\\Framework\\Attributes\\CoversMethod";

    @NotNull
    public ID<PhpPathInfo, Set<PhpPathInfo>> getName() {
        ID<PhpPathInfo, Set<PhpPathInfo>> iD = KEY;
        if (iD == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<PhpPathInfo, Set<PhpPathInfo>, FileContent> getIndexer() {
        return new DataIndexer<PhpPathInfo, Set<PhpPathInfo>, FileContent>(){

            @NotNull
            public Map<PhpPathInfo, Set<PhpPathInfo>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashMap<PhpPathInfo, Set<PhpPathInfo>> map = new HashMap<PhpPathInfo, Set<PhpPathInfo>>();
                PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)inputData.getPsiFile(), PhpFile.class);
                if (file != null) {
                    for (PhpClass testClass : PhpPsiUtil.findAllClasses(file)) {
                        if (!TestFinderHelper.isTest((PsiElement)testClass)) continue;
                        String testClassFQN = testClass.getFQN();
                        for (PhpPathInfo coveredPath : PhpUnitCoversIndex.getCoveredPaths((PhpNamedElement)testClass, null)) {
                            map.computeIfAbsent(coveredPath, elements -> new HashSet()).add(PhpPathInfo.byClass(testClassFQN));
                        }
                        String defaultCoveredClassName = PhpUnitUtil.getDefaultCoveredClassName(testClass);
                        PhpClassHierarchyUtils.processMethods((PhpClass)testClass, (PhpClass)testClass, (method, subClass, baseClass) -> {
                            if (!(method instanceof PhpDocMethod)) {
                                for (PhpPathInfo coveredMethodPath : PhpUnitCoversIndex.getCoveredPaths((PhpNamedElement)method, defaultCoveredClassName)) {
                                    map.computeIfAbsent(coveredMethodPath, elements -> new HashSet()).add(PhpPathInfo.byMethod(testClassFQN, method.getName()));
                                    map.computeIfAbsent(PhpPathInfo.byClass(coveredMethodPath.getClassFQN()), elements -> new HashSet()).add(PhpPathInfo.byClass(testClassFQN));
                                }
                            }
                            return true;
                        }, (boolean)true, (boolean)false);
                    }
                }
                HashMap<PhpPathInfo, Set<PhpPathInfo>> hashMap = map;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitCoversIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitCoversIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public static Set<PhpPathInfo> getCoveredPaths(@NotNull PhpNamedElement element, @Nullable String defaultCoveredClassFQN) {
        if (element == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(1);
        }
        HashSet<PhpPathInfo> result = new HashSet<PhpPathInfo>();
        result.addAll(PhpUnitCoversIndex.getCoveredPathsFromDocComment(element, defaultCoveredClassFQN));
        result.addAll(PhpUnitCoversIndex.getCoveredPathsFromAttributes(element));
        HashSet<PhpPathInfo> hashSet = result;
        if (hashSet == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    private static Set<PhpPathInfo> getCoveredPathsFromDocComment(@NotNull PhpNamedElement element, @Nullable String defaultCoveredClassFQN) {
        if (element == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(3);
        }
        HashSet<PhpPathInfo> result = new HashSet<PhpPathInfo>();
        PhpDocCommentImpl comment = (PhpDocCommentImpl)element.getDocComment();
        if (comment != null) {
            String namespaceName = element.getNamespaceName();
            for (PhpDocCoversTag tag : comment.getDocTagByClass(PhpDocCoversTag.class)) {
                ContainerUtil.addIfNotNull(result, (Object)PhpUnitCoversIndex.parseCoveredPath(tag, defaultCoveredClassFQN, namespaceName));
            }
        }
        HashSet<PhpPathInfo> hashSet = result;
        if (hashSet == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @NotNull
    private static Set<PhpPathInfo> getCoveredPathsFromAttributes(@NotNull PhpNamedElement element) {
        PhpPathInfo phpPathInfo;
        if (element == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(5);
        }
        HashSet<PhpPathInfo> result = new HashSet<PhpPathInfo>();
        if (!(element instanceof PhpAttributesOwner)) {
            HashSet<PhpPathInfo> hashSet = result;
            if (hashSet == null) {
                PhpUnitCoversIndex.$$$reportNull$$$0(6);
            }
            return hashSet;
        }
        for (PhpAttribute coversAttribute : ((PhpAttributesOwner)element).getAttributes(PHPUNIT_COVERS_CLASS_ATTRIBUTE)) {
            phpPathInfo = PhpUnitCoversIndex.getClassFqnFromClassAttribute(coversAttribute);
            if (phpPathInfo == null) continue;
            result.add(phpPathInfo);
        }
        for (PhpAttribute coversAttribute : ((PhpAttributesOwner)element).getAttributes(PHPUNIT_COVERS_METHOD_ATTRIBUTE)) {
            phpPathInfo = PhpUnitCoversIndex.getClassFqnFromMethodAttribute(coversAttribute);
            if (phpPathInfo == null) continue;
            result.add(phpPathInfo);
        }
        HashSet<PhpPathInfo> hashSet = result;
        if (hashSet == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @Nullable
    private static PhpPathInfo getClassFqnFromClassAttribute(PhpAttribute coversAttribute) {
        PhpExpectedFunctionArgument argument = PhpUnitDataProvidersIndex.getAttributeArgument(coversAttribute, "className", 0);
        if (argument == null) {
            return null;
        }
        PhpExpectedFunctionClassConstantArgument classConstantArg = (PhpExpectedFunctionClassConstantArgument)((Object)ObjectUtils.tryCast((Object)argument, PhpExpectedFunctionClassConstantArgument.class));
        if (classConstantArg != null) {
            return PhpPathInfo.byClass(classConstantArg.getClassFqn());
        }
        PhpExpectedFunctionScalarArgument classNameArg = (PhpExpectedFunctionScalarArgument)((Object)ObjectUtils.tryCast((Object)argument, PhpExpectedFunctionScalarArgument.class));
        if (classNameArg != null && classNameArg.isStringLiteral()) {
            return PhpPathInfo.byClass(PhpLangUtil.toFQN(StringUtil.unquoteString((String)classNameArg.getValue())));
        }
        return null;
    }

    @Nullable
    private static PhpPathInfo getClassFqnFromMethodAttribute(PhpAttribute coversAttribute) {
        PhpExpectedFunctionArgument classArgument = PhpUnitDataProvidersIndex.getAttributeArgument(coversAttribute, "className", 0);
        PhpExpectedFunctionArgument methodArgument = PhpUnitDataProvidersIndex.getAttributeArgument(coversAttribute, "className", 1);
        if (classArgument == null || methodArgument == null) {
            return null;
        }
        String classFqn = PhpUnitCoversIndex.getClassFqnFromClassNameArgument(classArgument);
        if (classFqn == null) {
            return null;
        }
        PhpExpectedFunctionScalarArgument methodNameArg = (PhpExpectedFunctionScalarArgument)((Object)ObjectUtils.tryCast((Object)methodArgument, PhpExpectedFunctionScalarArgument.class));
        if (methodNameArg != null && methodNameArg.isStringLiteral()) {
            return PhpPathInfo.byMethod(classFqn, StringUtil.unquoteString((String)methodNameArg.getValue()));
        }
        return null;
    }

    @Nullable
    private static String getClassFqnFromClassNameArgument(PhpExpectedFunctionArgument classArgument) {
        PhpExpectedFunctionClassConstantArgument classConstantArg = (PhpExpectedFunctionClassConstantArgument)((Object)ObjectUtils.tryCast((Object)classArgument, PhpExpectedFunctionClassConstantArgument.class));
        if (classConstantArg != null) {
            return classConstantArg.getClassFqn();
        }
        PhpExpectedFunctionScalarArgument classNameArg = (PhpExpectedFunctionScalarArgument)((Object)ObjectUtils.tryCast((Object)classArgument, PhpExpectedFunctionScalarArgument.class));
        if (classNameArg != null && classNameArg.isStringLiteral()) {
            return PhpLangUtil.toFQN(StringUtil.unquoteString((String)classNameArg.getValue()));
        }
        return null;
    }

    @Nullable
    private static PhpPathInfo parseCoveredPath(@NotNull PhpDocCoversTag tag, @Nullable String defaultCoveredClassFQN, @NotNull String namespaceName) {
        PsiElement methodIdentifier;
        PsiElement firstChild;
        PhpPsiElement tagValue;
        if (tag == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(8);
        }
        if (namespaceName == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(9);
        }
        if ((tagValue = tag.getFirstPsiChild()) instanceof PhpDocRef) {
            PsiElement firstChild2 = tagValue.getFirstChild();
            PsiElement classIdentifier = PhpPsiUtil.isOfType(firstChild2, PhpElementTypes.NS_REFERENCE) ? PhpUnitCoversIndex.getNextSibling(firstChild2, PhpDocTokenTypes.DOC_IDENTIFIER) : firstChild2;
            String coveredClassFQN = PhpUnitCoversIndex.getCoveredClassFqn(classIdentifier, namespaceName);
            if (coveredClassFQN != null) {
                PsiElement docStatic = PhpUnitCoversIndex.getNextSibling(classIdentifier, PhpDocTokenTypes.DOC_STATIC);
                if (docStatic != null) {
                    String accessValue;
                    PsiElement methodIdentifier2 = PhpUnitCoversIndex.getNextSibling(docStatic, PhpDocTokenTypes.DOC_IDENTIFIER);
                    if (methodIdentifier2 != null) {
                        return PhpPathInfo.byMethod(coveredClassFQN, methodIdentifier2.getText());
                    }
                    PsiElement docLab = PhpUnitCoversIndex.getNextSibling(docStatic, PhpDocTokenTypes.DOC_LAB);
                    if (docLab != null && StringUtil.startsWith((CharSequence)(accessValue = PhpUnitCoversIndex.getTextBeforeFirstWhitespace(docLab)), (CharSequence)"<")) {
                        return PhpUnitCoversIndex.parseCoveredAccess(accessValue, coveredClassFQN);
                    }
                }
                return PhpPathInfo.byClass(coveredClassFQN);
            }
        } else if (defaultCoveredClassFQN != null && PhpPsiUtil.isOfType((PsiElement)tagValue, (IElementType)PhpDocElementTypes.phpDocTagValue) && PhpPsiUtil.isOfType(firstChild = tagValue.getFirstChild(), PhpDocTokenTypes.DOC_STATIC) && (methodIdentifier = PhpUnitCoversIndex.getNextSibling(firstChild, PhpDocTokenTypes.DOC_IDENTIFIER)) != null) {
            return PhpPathInfo.byMethod(defaultCoveredClassFQN, methodIdentifier.getText());
        }
        return null;
    }

    @Nullable
    private static PsiElement getNextSibling(@Nullable PsiElement element, @NotNull IElementType type) {
        if (type == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(10);
        }
        if (element == null) {
            return null;
        }
        PsiElement sibling = element.getNextSibling();
        return PhpPsiUtil.isOfType(sibling, type) ? sibling : null;
    }

    @Nullable
    private static String getCoveredClassFqn(@Nullable PsiElement classIdentifier, @NotNull String baseNamespaceName) {
        if (baseNamespaceName == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(11);
        }
        if (PhpPsiUtil.isOfType(classIdentifier, PhpDocTokenTypes.DOC_IDENTIFIER)) {
            PsiElement namespace = classIdentifier.getPrevSibling();
            if (PhpPsiUtil.isOfType(namespace, PhpElementTypes.NS_REFERENCE)) {
                return PhpLangUtil.concat(PhpLangUtil.toFQN(namespace.getText()), classIdentifier.getText());
            }
            return PhpLangUtil.concat(baseNamespaceName, classIdentifier.getText());
        }
        return null;
    }

    @NotNull
    private static String getTextBeforeFirstWhitespace(@NotNull PsiElement docLab) {
        if (docLab == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(12);
        }
        StringBuilder result = new StringBuilder();
        for (PsiElement child = docLab; child != null && !PhpPsiUtil.isOfType(child, PhpDocTokenTypes.WHITE_SPACE); child = child.getNextSibling()) {
            result.append(child.getText());
        }
        String string = result.toString();
        if (string == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    private static PhpPathInfo parseCoveredAccess(@NotNull String coveredAccess, @NotNull String coveredClassFQN) {
        if (coveredAccess == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(14);
        }
        if (coveredClassFQN == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(15);
        }
        if (coveredAccess.length() < 3) {
            return null;
        }
        boolean inverseAccess = coveredAccess.charAt(1) == '!';
        String access = coveredAccess.substring(inverseAccess ? 2 : 1, coveredAccess.length() - 1);
        boolean isAccessValid = StringUtil.equals((CharSequence)"public", (CharSequence)access) || StringUtil.equals((CharSequence)"protected", (CharSequence)access) || StringUtil.equals((CharSequence)"private", (CharSequence)access);
        return isAccessValid ? PhpPathInfo.byAccess(coveredClassFQN, access, inverseAccess) : null;
    }

    @NotNull
    public KeyDescriptor<PhpPathInfo> getKeyDescriptor() {
        KeyDescriptor<PhpPathInfo> keyDescriptor = PhpPathInfoDescriptor.INSTANCE;
        if (keyDescriptor == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(16);
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<Set<PhpPathInfo>> getValueExternalizer() {
        PhpPathInfoSetExternalizer phpPathInfoSetExternalizer = PhpPathInfoSetExternalizer.INSTANCE;
        if (phpPathInfoSetExternalizer == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(17);
        }
        return phpPathInfoSetExternalizer;
    }

    public int getVersion() {
        return 4;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpUnitCoversIndex.$$$reportNull$$$0(18);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 5, 8, 9, 10, 11, 12, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitCoversIndex";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseNamespaceName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docLab";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coveredAccess";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coveredClassFQN";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitCoversIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveredPaths";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveredPathsFromDocComment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveredPathsFromAttributes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextBeforeFirstWhitespace";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCoveredPaths";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCoveredPathsFromDocComment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCoveredPathsFromAttributes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseCoveredPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNextSibling";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCoveredClassFqn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTextBeforeFirstWhitespace";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseCoveredAccess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 5, 8, 9, 10, 11, 12, 14, 15 -> new IllegalArgumentException(string);
        };
    }
}

