/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.injection.PhpElementPattern;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpFuncGetArgUsageProvider;
import com.jetbrains.php.lang.patterns.PhpPatterns;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionsWithNotCatchedDynamicPassedCallsIndex;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PhpFunctionParametersUsedAsRegExpIndex
extends FileBasedIndexExtension<String, Pair<String, IntSet>> {
    @NonNls
    public static final ID<String, Pair<String, IntSet>> KEY = ID.create((String)"php.function.parameters.used.as.regexp");
    private static final IntSet EMPTY_SET = new IntOpenHashSet();
    public static final PhpElementPattern.Capture<PhpExpression> PCRE_FUNCTION_DIRECT_FIRST_ARGUMENT = PhpPatterns.phpDirectFirstArgument(PhpPatterns.pcreFunction());

    @NotNull
    public ID<String, Pair<String, IntSet>> getName() {
        ID<String, Pair<String, IntSet>> iD = KEY;
        if (iD == null) {
            PhpFunctionParametersUsedAsRegExpIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Pair<String, IntSet>, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            PhpFile phpFile = (PhpFile)ObjectUtils.tryCast((Object)inputData.getPsiFile(), PhpFile.class);
            if (phpFile != null) {
                return PhpFuncGetArgUsageProvider.findTopLevelFunctions((PsiFile)phpFile).mapToEntry(function -> StringUtil.toLowerCase((String)function.getName()), f -> Pair.create((Object)f.getFQN(), (Object)this.getParameterIndicesUsedAsRegExp((Function)f))).filterValues(v -> !((IntSet)v.getSecond()).isEmpty()).toMap();
            }
            return Collections.emptyMap();
        };
        if (dataIndexer == null) {
            PhpFunctionParametersUsedAsRegExpIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    private IntSet getParameterIndicesUsedAsRegExp(Function f) {
        if (f instanceof PhpDocMethod) {
            return EMPTY_SET;
        }
        PhpControlFlow flow = f.getControlFlow();
        Parameter @NotNull [] parameters = f.getParameters();
        IntOpenHashSet set = new IntOpenHashSet();
        for (int i = 0; i < parameters.length; ++i) {
            final Parameter parameter = parameters[i];
            final Ref usedAsRegExp = new Ref((Object)false);
            PhpControlFlowUtil.processSuccessors((PhpInstruction)flow.getEntryPoint(), false, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    if (!PhpLangUtil.equalsVariableNames(instruction.getVariableName(), parameter.getName())) {
                        return true;
                    }
                    PhpPsiElement anchor = instruction.getAnchor();
                    if (PCRE_FUNCTION_DIRECT_FIRST_ARGUMENT.accepts(anchor) || PhpPatterns.phpArrayValueSkippingConcatenation(PCRE_FUNCTION_DIRECT_FIRST_ARGUMENT).accepts((Object)anchor)) {
                        usedAsRegExp.set((Object)true);
                        return false;
                    }
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    if (!(access instanceof PhpAccessInstruction.ReadOrReadRefAccess) && !access.isRead()) {
                        return false;
                    }
                    return super.processAccessVariableInstruction(instruction);
                }
            });
            if (!((Boolean)usedAsRegExp.get()).booleanValue()) continue;
            set.add(i);
        }
        return set;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpFunctionParametersUsedAsRegExpIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Pair<String, IntSet>> getValueExternalizer() {
        FqnWithIntSetDataExternalizer fqnWithIntSetDataExternalizer = FqnWithIntSetDataExternalizer.INSTANCE;
        if (fqnWithIntSetDataExternalizer == null) {
            PhpFunctionParametersUsedAsRegExpIndex.$$$reportNull$$$0(3);
        }
        return fqnWithIntSetDataExternalizer;
    }

    public int getVersion() {
        return 1;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpFunctionParametersUsedAsRegExpIndex.$$$reportNull$$$0(4);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpFunctionParametersUsedAsRegExpIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class FqnWithIntSetDataExternalizer
    implements DataExternalizer<Pair<String, IntSet>> {
        public static final FqnWithIntSetDataExternalizer INSTANCE = new FqnWithIntSetDataExternalizer();

        private FqnWithIntSetDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, Pair<String, IntSet> value) throws IOException {
            if (out == null) {
                FqnWithIntSetDataExternalizer.$$$reportNull$$$0(0);
            }
            EnumeratorStringDescriptor.INSTANCE.save(out, (String)value.getFirst());
            PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.EXTERNALIZER.save(out, (Object)((IntSet)value.getSecond()));
        }

        public Pair<String, IntSet> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                FqnWithIntSetDataExternalizer.$$$reportNull$$$0(1);
            }
            String fqn = EnumeratorStringDescriptor.INSTANCE.read(in);
            IntSet indexes = (IntSet)PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.EXTERNALIZER.read(in);
            return Pair.create((Object)fqn, (Object)indexes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpFunctionParametersUsedAsRegExpIndex$FqnWithIntSetDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

