/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PhpAliasedTraitMethodNamesIndex
extends FileBasedIndexExtension<String, Collection<String>> {
    @NonNls
    public static final ID<String, Collection<String>> KEY = ID.create((String)"php.aliased.trait.method.name");
    public static final DataExternalizer<Collection<String>> EXTERNALIZER = new DataExternalizer<Collection<String>>(){

        public void save(@NotNull DataOutput out, Collection<String> value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (String s : value) {
                out.writeUTF(s);
            }
        }

        public Collection<String> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            HashSet<String> res = new HashSet<String>(size);
            for (int i = 0; i < size; ++i) {
                res.add(in.readUTF());
            }
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpAliasedTraitMethodNamesIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public DataIndexer<String, Collection<String>, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)inputData.getPsiFile(), PhpFile.class);
            HashMap<String, Collection> res = new HashMap<String, Collection>();
            if (file == null) {
                return res;
            }
            for (PhpClass aClass : PhpPsiUtil.findClasses(file, (Condition<? super PhpClass>)((Condition)a -> true))) {
                if (!(aClass instanceof PhpClassImpl)) continue;
                for (Map.Entry<String, Set<String>> entry : ((PhpClassImpl)aClass).getAliasedTraitMethods().entrySet()) {
                    res.computeIfAbsent(entry.getKey(), k -> new HashSet()).addAll((Collection)entry.getValue());
                }
            }
            return res;
        };
        if (dataIndexer == null) {
            PhpAliasedTraitMethodNamesIndex.$$$reportNull$$$0(0);
        }
        return dataIndexer;
    }

    @NotNull
    public DataExternalizer<Collection<String>> getValueExternalizer() {
        DataExternalizer<Collection<String>> dataExternalizer = EXTERNALIZER;
        if (dataExternalizer == null) {
            PhpAliasedTraitMethodNamesIndex.$$$reportNull$$$0(1);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpAliasedTraitMethodNamesIndex.$$$reportNull$$$0(2);
        }
        return inputFilter;
    }

    @NotNull
    public ID<String, Collection<String>> getName() {
        ID<String, Collection<String>> iD = KEY;
        if (iD == null) {
            PhpAliasedTraitMethodNamesIndex.$$$reportNull$$$0(3);
        }
        return iD;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpAliasedTraitMethodNamesIndex.$$$reportNull$$$0(4);
        }
        return enumeratorStringDescriptor;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 3;
    }

    public static Collection<String> getAliasedMethodNames(Project project, @NotNull String traitUseRuleAliasName) {
        if (traitUseRuleAliasName == null) {
            PhpAliasedTraitMethodNamesIndex.$$$reportNull$$$0(5);
        }
        HashSet<String> res = new HashSet<String>();
        FileBasedIndex.getInstance().processValues(KEY, (Object)StringUtil.toLowerCase((String)traitUseRuleAliasName), null, (v, s) -> {
            res.addAll((Collection<String>)s);
            return true;
        }, GlobalSearchScope.allScope((Project)project));
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpAliasedTraitMethodNamesIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traitUseRuleAliasName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpAliasedTraitMethodNamesIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAliasedMethodNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }
}

