/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types.prophecy;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpUnitMockBuilderTP;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class ProphecyProphesizeTypeProvider
implements PhpTypeProvider4 {
    public static final PhpCharBasedTypeKey KEY = new PhpCharBasedTypeKey(){

        @Override
        public char getKey() {
            return '\u2541';
        }
    };
    private static final String PROPHET_FQN = "\\Prophecy\\Prophet";
    public static final String OBJECT_PROPHECY_FQN = "\\Prophecy\\Prophecy\\ObjectProphecy";

    public char getKey() {
        return KEY.getKey();
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof MethodReference && PhpLangUtil.equalsMethodNames(((MethodReference)element).getName(), "prophesize")) {
            String fqn = PhpUnitMockBuilderTP.getParameterSignature(((MethodReference)element).getParameter(0));
            if (fqn == null) {
                return null;
            }
            return PhpType.or((PhpType)ProphecyProphesizeTypeProvider.encodeClassReferencePayloadWithFQN((MethodReference)element, fqn, KEY), (PhpType)PhpType.from((String[])new String[]{fqn}));
        }
        return null;
    }

    @Nullable
    public static PhpType encodeClassReferencePayloadWithFQN(MethodReference element, String fqn, PhpCharBasedTypeKey key) {
        PhpReference reference = (PhpReference)ObjectUtils.tryCast((Object)element.getClassReference(), PhpReference.class);
        if (reference == null) {
            return null;
        }
        List payload = ContainerUtil.append(reference.getSignatureParts().stream().toList(), (Object[])new String[]{fqn});
        return PhpType.from((String[])new String[]{key.sign(PhpParameterBasedTypeProvider.wrapTypes(payload))});
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        return ProphecyProphesizeTypeProvider.resolveParametrisedProphecyObject(project, PhpType.from((String[])new String[]{PROPHET_FQN}), expression);
    }

    @Nullable
    public static PhpType resolveParametrisedProphecyObject(Project project, PhpType base, String expression) {
        List<String> signatures = PhpParameterBasedTypeProvider.extractSignatures(expression, 2);
        List<String> classReferenceSignatures = signatures.subList(0, signatures.size() - 1);
        if (ContainerUtil.exists(classReferenceSignatures, s -> PhpType.intersects((PhpType)PhpType.global((Project)project, (String[])new String[]{s}), (PhpType)base))) {
            return PhpType.createParametrized((String)OBJECT_PROPHECY_FQN, (String[])new String[]{(String)ContainerUtil.getLastItem(signatures)});
        }
        return null;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }
}

