/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types.generics;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsBaseExtendedWithGenericTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsTemplatesCustomDocTagValueStubProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public final class PhpYieldGenericTypeProvider
extends PhpGenericsBaseExtendedWithGenericTypeProvider<PhpClass> {
    public static final PhpCharBasedTypeKey KEY = new PhpCharTypeKey('\u0423');

    public char getKey() {
        return KEY.getKey();
    }

    @Override
    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof PhpYield) {
            PsiElement argument = ((PhpYield)element).getArgument();
            return PhpType.from((PsiElement[])new PsiElement[]{argument}).map(KEY::sign);
        }
        return null;
    }

    @Override
    protected Class<PhpClass> getElementClass() {
        return PhpClass.class;
    }

    @Override
    protected PhpClass getContainingClass(PhpClass element) {
        return element;
    }

    @Override
    protected Collection<String> getDeclaredTypes(PhpClass phpClass) {
        PhpDocComment comment = phpClass.getDocComment();
        if (comment == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(PhpGenericsTemplatesCustomDocTagValueStubProvider.getTagNamesWithSuffixes("yield")).flatMap(name -> Arrays.stream(comment.getTagElementsByName(name))).flatMap(t -> t.getDocType().getTypesWithParametrisedParts().stream()).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    protected String getClassRef(@Nullable String expression) {
        return expression != null ? expression.substring(2) : null;
    }

    @Override
    protected StreamEx<? extends PhpClass> resolveTargetMembers(Project project, String expression, PhpIndex index, Map<String, Set<List<String>>> extendedClassesToSubstitutedTemplates, int depth) {
        return (StreamEx)StreamEx.of((Collection)PhpType.from((String[])new String[]{expression.substring(2)}).global(project).getTypes()).flatMap(fqn -> index.getAnyByFQN(fqn).stream()).distinct();
    }
}

