/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpCallableMethod;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PipeExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J8\u0010\u000f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/php/lang/psi/resolve/types/PhpPipeOperatorTypeProvider;", "Lcom/jetbrains/php/lang/psi/resolve/types/PhpTypeProvider4;", "<init>", "()V", "getKey", "", "getType", "Lcom/jetbrains/php/lang/psi/resolve/types/PhpType;", "element", "Lcom/intellij/psi/PsiElement;", "complete", "expression", "", "project", "Lcom/intellij/openapi/project/Project;", "getBySignature", "", "Lcom/jetbrains/php/lang/psi/elements/PhpNamedElement;", "visited", "", "depth", "", "buildTypeFromReference", "right", "buildCallableMethodType", "method", "Lcom/jetbrains/php/lang/psi/elements/PhpCallableMethod;", "extractFunctionElement", "Lcom/jetbrains/php/lang/psi/elements/Function;", "intellij.php.impl"})
public final class PhpPipeOperatorTypeProvider
implements PhpTypeProvider4 {
    public char getKey() {
        return '\u1d3e';
    }

    @Nullable
    public PhpType getType(@Nullable PsiElement element) {
        if (!(element instanceof PipeExpression)) {
            return null;
        }
        PsiElement psiElement = ((PipeExpression)element).getRightOperand();
        if (psiElement == null) {
            return null;
        }
        PsiElement right = psiElement;
        Function function = this.extractFunctionElement(right);
        if (function == null || (function = function.getType()) == null) {
            function = this.buildTypeFromReference(right);
        }
        return function;
    }

    @Nullable
    public PhpType complete(@NotNull String expression, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    @Nullable
    public Collection<? extends PhpNamedElement> getBySignature(@NotNull String expression, @NotNull Set<String> visited, int depth, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter(visited, (String)"visited");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    private final PhpType buildTypeFromReference(PsiElement right) {
        if (!(right instanceof PhpReference)) {
            PhpType phpType = PhpType.MIXED;
            Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"MIXED");
            return phpType;
        }
        if (right instanceof PhpCallableMethod) {
            return this.buildCallableMethodType((PhpCallableMethod)right);
        }
        PhpType phpType = new PhpType().add(PhpTypeSignatureKey.FUNCTION.sign((CharSequence)((PhpReference)right).getFQN()));
        Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"add(...)");
        return phpType;
    }

    private final PhpType buildCallableMethodType(PhpCallableMethod method) {
        PhpExpression classReference = method.getClassReference();
        if (classReference instanceof PhpReference) {
            String string = PhpTypeSignatureKey.METHOD.sign((CharSequence)PhpTypeSignatureKey.CLASS.sign((CharSequence)(((PhpReference)classReference).getFQN() + "." + method.getName())));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sign(...)");
            String signature = string;
            PhpType phpType = new PhpType().add(signature);
            Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"add(...)");
            return phpType;
        }
        PhpType phpType = PhpType.MIXED;
        Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"MIXED");
        return phpType;
    }

    private final Function extractFunctionElement(PsiElement element) {
        PsiElement targetElement = element instanceof ParenthesizedExpression ? (PsiElement)((ParenthesizedExpression)element).extract() : element;
        return (Function)PhpPsiUtil.getChildByCondition(targetElement, (Condition<? super PsiElement>)Function.INSTANCEOF);
    }
}

