/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpDeprecationProvider;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPsiElementImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypedElementImpl;
import com.jetbrains.php.lang.psi.stubs.PhpNamedStub;
import com.jetbrains.php.lang.psi.stubs.PhpNamedTypedStub;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpNamedElementImpl<T extends NamedStub>
extends PhpTypedElementImpl<T>
implements PhpNamedElement {
    private static final Key<PhpPsiElementImpl.StubBuildCachedValue<PsiElement[]>> AVAILABLE_IN_RANGE_STUB_BUILDING_KEY = Key.create((String)"php.stub.available.in.range");

    public PhpNamedElementImpl(ASTNode node) {
        super(node);
    }

    protected PhpNamedElementImpl(T stub, @NotNull IElementType nodeType) {
        if (nodeType == null) {
            PhpNamedElementImpl.$$$reportNull$$$0(0);
        }
        super(stub, nodeType);
    }

    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getPresentation(this);
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.getNameNode();
        return node != null ? node.getPsi() : null;
    }

    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(PhpTokenTypes.IDENTIFIER);
    }

    @NotNull
    @NlsSafe
    public String getName() {
        NamedStub stub = (NamedStub)this.getGreenStub();
        if (stub != null) {
            String stubName = stub.getName();
            return stubName != null ? stubName : "";
        }
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            String name = nameNode.getText();
            String string = name = StringUtil.trimStart((String)name, (String)"PS_UNRESERVE_PREFIX_");
            if (string == null) {
                PhpNamedElementImpl.$$$reportNull$$$0(1);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public CharSequence getNameCS() {
        NamedStub stub = (NamedStub)this.getGreenStub();
        if (stub != null) {
            String stubName = stub.getName();
            return stubName != null ? stubName : "";
        }
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            CharSequence name = nameNode.getChars();
            if (StringUtil.startsWith((CharSequence)name, (CharSequence)"PS_UNRESERVE_PREFIX_")) {
                name = name.subSequence("PS_UNRESERVE_PREFIX_".length(), name.length());
            }
            CharSequence charSequence = name;
            if (charSequence == null) {
                PhpNamedElementImpl.$$$reportNull$$$0(2);
            }
            return charSequence;
        }
        return "";
    }

    public int getTextOffset() {
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            return nameNode.getStartOffset();
        }
        return super.getTextOffset();
    }

    @Nullable
    public PhpDocComment getDocComment() {
        return PhpPsiUtil.getDocCommentFor(this);
    }

    public void processDocs(Processor<PhpDocComment> processor2) {
        processor2.process((Object)this.getDocComment());
    }

    @NotNull
    @NlsSafe
    public String getFQN() {
        String string = this.getNamespaceName() + this.getName();
        if (string == null) {
            PhpNamedElementImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getNamespaceName() {
        return PhpNamedElementImpl.getNamespace((PsiElement)this);
    }

    @NotNull
    public static String getNamespace(@NotNull PsiElement psiElement) {
        Object name;
        if (psiElement == null) {
            PhpNamedElementImpl.$$$reportNull$$$0(4);
        }
        if ((name = ((PhpFile)psiElement.getContainingFile()).getMainNamespaceName()) == null) {
            PhpNamespace namespace = PhpPsiUtil.getParentOfClass(psiElement, false, PhpNamespace.class);
            Object object = name = namespace != null ? namespace.getFQN() : "";
        }
        if (!((String)name).endsWith("\\")) {
            name = (String)name + "\\";
        }
        Object object = StringUtil.startsWithChar((CharSequence)name, (char)'\\') ? name : "\\" + (String)name;
        if (object == null) {
            PhpNamedElementImpl.$$$reportNull$$$0(5);
        }
        return object;
    }

    public boolean isDeprecated() {
        String version = PhpNamedElementImpl.getDeprecatedSinceVersion(this);
        if (version == null) {
            version = this.getDeprecatedSinceVersionFromSuperCommentsSkippingInheritDoc();
        }
        if (version == null) {
            return false;
        }
        return PhpNamedElementImpl.isDeprecated(this, version);
    }

    @Nullable
    protected String getDeprecatedSinceVersionFromSuperCommentsSkippingInheritDoc() {
        Ref minVersion = new Ref(null);
        this.processDocs((Processor<PhpDocComment>)((Processor)c -> {
            if (c == null) {
                return false;
            }
            String sinceVersion = PhpNamedElementImpl.getDeprecatedSinceVersion(c);
            if (sinceVersion == null) {
                return c.hasInheritDocTag();
            }
            if (minVersion.isNull() || PhpNamedElementImpl.parseVersion((String)minVersion.get()).compareTo((Enum)PhpNamedElementImpl.parseVersion(sinceVersion)) > 0) {
                minVersion.set((Object)sinceVersion);
            }
            return false;
        }));
        return (String)minVersion.get();
    }

    @NotNull
    private static PhpLanguageLevel parseVersion(String version) {
        PhpLanguageLevel phpLanguageLevel = (PhpLanguageLevel)ObjectUtils.notNull((Object)PhpLanguageLevel.parse((String)version), (Object)PhpLanguageLevel.DEFAULT);
        if (phpLanguageLevel == null) {
            PhpNamedElementImpl.$$$reportNull$$$0(6);
        }
        return phpLanguageLevel;
    }

    private static boolean isDeprecated(@NotNull PhpNamedElement element, @NotNull String version) {
        List providers;
        if (element == null) {
            PhpNamedElementImpl.$$$reportNull$$$0(7);
        }
        if (version == null) {
            PhpNamedElementImpl.$$$reportNull$$$0(8);
        }
        return (providers = PhpDeprecationProvider.getProvidersForElement((PhpNamedElement)element)).isEmpty() || providers.stream().allMatch(provider -> provider.isDeprecated(element, version));
    }

    @Nullable
    protected String getDeprecationVersionFromDocComment() {
        String deprecatedTag;
        PhpDocComment docComment = this.getDocComment();
        if (docComment != null && (deprecatedTag = PhpNamedElementImpl.getDeprecatedSinceVersion(docComment)) != null) {
            return deprecatedTag;
        }
        return null;
    }

    @Nullable
    private static String getDeprecatedSinceVersion(PhpDocComment docComment) {
        PhpDocTag deprecatedTag = (PhpDocTag)ArrayUtil.getFirstElement((Object[])docComment.getTagElementsByName("@deprecated"));
        if (deprecatedTag != null) {
            return PhpNamedElementImpl.getVersionString(deprecatedTag);
        }
        return null;
    }

    public static String getDeprecatedSinceVersion(@NotNull PhpNamedElement element) {
        PhpDeprecationAttributeOwner.PhpDeprecationInfo info;
        if (element == null) {
            PhpNamedElementImpl.$$$reportNull$$$0(9);
        }
        if (element instanceof PhpDocPsiElement || !(element instanceof PhpNamedElementImpl)) {
            return null;
        }
        if (element instanceof PhpDeprecationAttributeOwner && (info = ((PhpDeprecationAttributeOwner)element).getDeprecationInfo()) != null) {
            return PhpNamedElementImpl.getOrDefaultVersion(info.getVersion());
        }
        PhpNamedTypedStub stub = (PhpNamedTypedStub)ObjectUtils.tryCast((Object)((PhpNamedElementImpl)element).getGreenStub(), PhpNamedTypedStub.class);
        if (stub != null) {
            return stub.getDeprecatedSinceVersion();
        }
        return ((PhpNamedElementImpl)element).getDeprecationVersionFromDocComment();
    }

    @NotNull
    public static String getVersionString(PhpDocTag tag) {
        return PhpNamedElementImpl.getOrDefaultVersion(PhpNamedElementImpl.getVersionString(tag.getTagValue()));
    }

    @NotNull
    private static String getOrDefaultVersion(String deprecatedVersionFromTag) {
        String string = (String)ObjectUtils.notNull((Object)StringUtil.nullize((String)deprecatedVersionFromTag), (Object)PhpLanguageLevel.DEFAULT.getVersionString());
        if (string == null) {
            PhpNamedElementImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static String getVersionString(String value) {
        int index;
        value = value.trim();
        for (index = 0; index < value.length() && (Character.isDigit(value.charAt(index)) || value.charAt(index) == '.'); ++index) {
        }
        return value.substring(0, index);
    }

    public boolean isInternal() {
        StubElement stubElement = this.getGreenStub();
        if (stubElement instanceof PhpNamedTypedStub) {
            PhpNamedTypedStub namedStub = (PhpNamedTypedStub)stubElement;
            return namedStub.isInternal();
        }
        stubElement = this.getGreenStub();
        if (stubElement instanceof PhpNamedStub) {
            PhpNamedStub namedStub = (PhpNamedStub)stubElement;
            return namedStub.isInternal();
        }
        PhpDocComment docComment = this.getDocComment();
        if (docComment != null) {
            PhpDocTag[] elements;
            for (PhpDocTag element : elements = docComment.getTagElementsByName("@internal")) {
                if (!(element instanceof PhpDocTag) || !StringUtil.isEmpty((String)element.getTagValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return PhpNamedElementImpl.toStringWithValue((PsiElement)this, this.getName());
    }

    protected static Collection<PhpAttribute> getAttributesStubAware(StubBasedPsiElementBase<?> element) {
        StubElement stub = element.getGreenStub();
        if (stub != null) {
            PhpAttribute[] attributes = (PhpAttribute[])stub.getChildrenByType((IElementType)PhpStubElementTypes.ATTRIBUTE, count -> count == 0 ? PhpAttribute.EMPTY_ARRAY : new PhpAttribute[count]);
            return attributes.length > 0 ? Arrays.asList(attributes) : Collections.emptyList();
        }
        PsiElement nameIdentifier = element instanceof PhpNamedElement ? ((PhpNamedElement)element).getNameIdentifier() : null;
        return PhpPsiUtil.getChildren(element, (Condition<? super PsiElement>)((Condition)PhpAttributesList.class::isInstance), (Condition<? super PsiElement>)((Condition)c -> nameIdentifier != null && nameIdentifier == c)).stream().flatMap(list -> list.getAttributes().stream()).collect(Collectors.toList());
    }

    @Nullable
    protected String getAvailableInLanguageLevelFromAstBased() {
        return PhpNamedElementImpl.findParameterByNameOrIndex(PhpNamedElementImpl.getAvailableInLanguageLevelRangeParameter(this), "from", 0);
    }

    @Nullable
    protected String getAvailableInLanguageLevelToAstBased() {
        return PhpNamedElementImpl.findParameterByNameOrIndex(PhpNamedElementImpl.getAvailableInLanguageLevelRangeParameter(this), "to", 1);
    }

    private static PsiElement[] getAvailableInLanguageLevelRangeParameter(PhpNamedElement element) {
        return PhpNamedElementImpl.getCachedValueStubBuildOptimized((PsiElement)element, AVAILABLE_IN_RANGE_STUB_BUILDING_KEY, () -> {
            PhpAttribute item;
            PsiElement[] res = PsiElement.EMPTY_ARRAY;
            if (element instanceof PhpAttributesOwner && (item = (PhpAttribute)ContainerUtil.getFirstItem((Collection)((PhpAttributesOwner)element).getAttributes("\\JetBrains\\PhpStorm\\Internal\\PhpStormStubsElementAvailable"))) != null) {
                res = item.getParameters();
            }
            return CachedValueProvider.Result.createSingleDependency((Object)res, (Object)element);
        });
    }

    protected static String findParameterByNameOrIndex(PsiElement[] parameters, String name, int index) {
        PsiElement s = PhpNamedElementImpl.getElement(parameters, name, index);
        return s instanceof StringLiteralExpression ? ((StringLiteralExpression)s).getContents() : null;
    }

    @Nullable
    static PsiElement getElement(PsiElement[] parameters, String name, int index) {
        PsiElement byName = (PsiElement)ContainerUtil.find((Object[])parameters, p -> {
            PsiElement identifier = ParameterListImpl.getNameIdentifier(p);
            return identifier != null && identifier.getText().equals(name);
        });
        return byName != null ? byName : (index < parameters.length && ParameterListImpl.getNameIdentifier(parameters[index]) == null ? parameters[index] : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpNamedElementImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpNamedElementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCS";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrDefaultVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecated";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedSinceVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6, 10 -> new IllegalStateException(string);
        };
    }
}

