/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.FieldReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpBaseMemberReference;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.PhpMemberResolveResult;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReferenceImpl
extends MemberReferenceImpl
implements MethodReference,
PsiExternalReferenceHost {
    static final TokenSet NN = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsKEYWORDS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.IDENTIFIER})});
    private static final String EMPTY_CLASS_FQN = "";
    static final Function<PhpExpression, PhpType> METHOD_REFERENCE_TYPE_PROVIDER = it -> {
        PhpType globalType = it.getGlobalType();
        FieldReference fieldReference = MethodReferenceImpl.getFieldReferencedFromPropertyHookCall(it);
        if (fieldReference == null) {
            return globalType;
        }
        PhpExpression parent = fieldReference.getClassReference();
        if (parent == null) {
            return globalType;
        }
        PhpType parentGlobalType = parent.getGlobalType();
        return PhpType.from((PhpType[])new PhpType[]{globalType, parentGlobalType});
    };

    public MethodReferenceImpl(ASTNode node) {
        super(node);
    }

    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            MethodReferenceImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpMethodReference((MethodReference)this);
    }

    public ParameterList getParameterList() {
        return (ParameterList)PhpPsiUtil.getChildByCondition((PsiElement)this, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(NN);
    }

    public PsiElement @NotNull [] getParameters() {
        ParameterList list = this.getParameterList();
        PsiElement[] psiElementArray = list != null ? list.getParameters() : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            MethodReferenceImpl.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    @Override
    @Nullable
    public PhpExpression getClassReference() {
        PhpUse[] declarations;
        PhpExpression reference = super.getClassReference();
        if (reference != null) {
            return reference;
        }
        PhpTraitUseRule rule = (PhpTraitUseRule)PhpPsiUtil.getParentByCondition((PsiElement)this, (Condition<? super PsiElement>)PhpTraitUseRule.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (rule != null && (declarations = ((PhpUseList)rule.getParent()).getDeclarations()).length == 1) {
            return declarations[0].getTargetReference();
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        Collection<? extends PhpNamedElement> result = super.resolveLocal();
        if (!result.isEmpty()) {
            Collection<? extends PhpNamedElement> collection = result;
            if (collection == null) {
                MethodReferenceImpl.$$$reportNull$$$0(2);
            }
            return collection;
        }
        return this.resolveTraitUseRule(true);
    }

    @Override
    @NotNull
    public PhpType resolveLocalType() {
        Collection<? extends PhpNamedElement> targets = this.resolveLocal();
        Collection<PhpNamedElement> targetsWithNonRecursiveCalls = FunctionReferenceImpl.getNonRecursiveTargets(this, targets);
        PhpType res = FunctionReferenceImpl.getTypeFromRecursiveTargets(targets, targetsWithNonRecursiveCalls);
        PhpType phpType = res.add(this.getType(targetsWithNonRecursiveCalls));
        if (phpType == null) {
            MethodReferenceImpl.$$$reportNull$$$0(3);
        }
        return phpType;
    }

    @Override
    protected ResolveResult[] multiResolve(PhpReference expression, boolean incompleteCode) {
        if (expression instanceof PhpBaseMemberReference) {
            return (ResolveResult[])((PhpBaseMemberReference)expression).resolveGlobalDescriptors(METHOD_REFERENCE_TYPE_PROVIDER).toArray(EMPTY_RESOLVE_RESULTS);
        }
        return super.multiResolve(expression, incompleteCode);
    }

    @Override
    @NotNull
    protected Collection<PhpMemberResolveResult> resolveGlobalDescriptors(Function<PhpExpression, PhpType> classReferenceTypeProvider) {
        if (this.getParent() instanceof PhpTraitUseRule && !(this.getFirstPsiChild() instanceof ClassReference)) {
            List list = ContainerUtil.map(this.resolveTraitUseRule(false), e -> new PhpMemberResolveResult((PhpNamedElement)e, false));
            if (list == null) {
                MethodReferenceImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection<PhpMemberResolveResult> collection = super.resolveGlobalDescriptors(classReferenceTypeProvider);
        if (collection == null) {
            MethodReferenceImpl.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Nullable
    public static FieldReference getFieldReferencedFromPropertyHookCall(@Nullable PhpExpression reference) {
        FieldReference fieldReference = (FieldReference)ObjectUtils.tryCast((Object)reference, FieldReference.class);
        if (fieldReference == null || !PhpLanguageFeature.PROPERTY_HOOKS.isSupported(reference.getProject())) {
            return null;
        }
        MethodReference methodReference = (MethodReference)ObjectUtils.tryCast((Object)reference.getParent(), MethodReference.class);
        if (methodReference == null) {
            return null;
        }
        ClassReference parentReference = (ClassReference)ObjectUtils.tryCast((Object)fieldReference.getClassReference(), ClassReference.class);
        if (parentReference == null || !"parent".equals(parentReference.getName())) {
            return null;
        }
        PhpPropertyHook hook = (PhpPropertyHook)PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)PhpPropertyHook.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        if (hook == null) {
            return null;
        }
        return fieldReference;
    }

    @NotNull
    private static Set<PhpNamedElement> tryToResolveParentPropertyHookCall(@NotNull PhpClass klass, @NotNull MethodReference reference, boolean localOnly) {
        PhpPropertyHook.PhpPropertyHookType hookType;
        PhpClassImpl phpClass;
        if (klass == null) {
            MethodReferenceImpl.$$$reportNull$$$0(6);
        }
        if (reference == null) {
            MethodReferenceImpl.$$$reportNull$$$0(7);
        }
        if ((phpClass = (PhpClassImpl)((Object)ObjectUtils.tryCast((Object)klass, PhpClassImpl.class))) == null) {
            Set<PhpNamedElement> set = Collections.emptySet();
            if (set == null) {
                MethodReferenceImpl.$$$reportNull$$$0(8);
            }
            return set;
        }
        FieldReference fieldReference = MethodReferenceImpl.getFieldReferencedFromPropertyHookCall(reference.getClassReference());
        if (fieldReference == null) {
            Set<PhpNamedElement> set = Collections.emptySet();
            if (set == null) {
                MethodReferenceImpl.$$$reportNull$$$0(9);
            }
            return set;
        }
        String fieldName = fieldReference.getName();
        if (fieldName == null) {
            Set<PhpNamedElement> set = Collections.emptySet();
            if (set == null) {
                MethodReferenceImpl.$$$reportNull$$$0(10);
            }
            return set;
        }
        String hookName = reference.getName();
        if (hookName == null) {
            Set<PhpNamedElement> set = Collections.emptySet();
            if (set == null) {
                MethodReferenceImpl.$$$reportNull$$$0(11);
            }
            return set;
        }
        Object object = hookName.equalsIgnoreCase(PhpTokenTypes.kwGET.getDebugName()) ? PhpPropertyHook.PhpPropertyHookType.GET : (hookType = hookName.equalsIgnoreCase(PhpTokenTypes.kwSET.getDebugName()) ? PhpPropertyHook.PhpPropertyHookType.SET : null);
        if (hookType == null) {
            Set<PhpNamedElement> set = Collections.emptySet();
            if (set == null) {
                MethodReferenceImpl.$$$reportNull$$$0(12);
            }
            return set;
        }
        PhpPropertyHook hook = (PhpPropertyHook)PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)PhpPropertyHook.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        if (hook == null) {
            Set<PhpNamedElement> set = Collections.emptySet();
            if (set == null) {
                MethodReferenceImpl.$$$reportNull$$$0(13);
            }
            return set;
        }
        Collection<Field> superFields = localOnly ? FieldReferenceImpl.resolveFields((MemberReference)reference, phpClass, false, fieldName) : PhpClassImpl.findFieldsByName(phpClass, fieldName, false, false, null);
        Set<PhpNamedElement> propertyHooks = superFields.stream().filter(it -> it != null).flatMap(superField -> superField.getPropertyHooksList().stream()).filter(hookProperty -> hookProperty.getHookType() == hookType).collect(Collectors.toSet());
        if (propertyHooks.isEmpty()) {
            Set set = ContainerUtil.map2Set(superFields, it -> it);
            if (set == null) {
                MethodReferenceImpl.$$$reportNull$$$0(14);
            }
            return set;
        }
        Set<PhpNamedElement> set = propertyHooks;
        if (set == null) {
            MethodReferenceImpl.$$$reportNull$$$0(15);
        }
        return set;
    }

    @Override
    protected boolean resolveInSubclasses(Set<PhpNamedElement> result) {
        return MethodReferenceImpl.resolveInSubclasses(result, this.getClassReference());
    }

    static boolean resolveInSubclasses(Set<PhpNamedElement> result, PhpExpression classReference) {
        return result.isEmpty() || !MethodReferenceImpl.isSelfOrParentReference(classReference) && ContainerUtil.all(result, MethodReferenceImpl::isAbstractMemberReference) || PhpLangUtil.canBeResolvedInSubclasses((PsiElement)classReference) && ContainerUtil.all(result, MethodReferenceImpl::isInsideTrait);
    }

    private static boolean isInsideTrait(PhpNamedElement element) {
        if (element instanceof Method) {
            PhpClass containingClass = ((Method)element).getContainingClass();
            return containingClass != null && containingClass.isTrait();
        }
        return false;
    }

    public static boolean isSelfOrParentReference(@Nullable PhpExpression classReference) {
        return classReference instanceof ClassReference && (PhpLangUtil.isSelfReference((ClassReference)classReference) || PhpLangUtil.isParentReference((PsiElement)classReference));
    }

    private static boolean isAbstractMemberReference(PhpNamedElement element) {
        if (element instanceof Method) {
            PhpClass containingClass = ((PhpClassMember)element).getContainingClass();
            return containingClass != null && containingClass.isAbstract();
        }
        return false;
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        return MethodReferenceImpl.resolve(this);
    }

    @Nullable
    static PsiElement resolve(@NotNull PhpReference reference) {
        Object[] elements;
        if (reference == null) {
            MethodReferenceImpl.$$$reportNull$$$0(16);
        }
        if (ContainerUtil.exists((Object[])(elements = reference.multiResolve(false)), e -> e instanceof PhpMemberResolveResult && ((PhpMemberResolveResult)((Object)e)).isFromSubclass())) {
            return MethodReferenceImpl.findBaseMethodInHierarchy((ResolveResult[])elements, reference);
        }
        return elements.length == 1 ? elements[0].getElement() : null;
    }

    private static PsiElement findBaseMethodInHierarchy(ResolveResult[] elements, PhpReference methodReference) {
        if (elements.length == 0) {
            return null;
        }
        if (elements.length == 1) {
            return elements[0].getElement();
        }
        Map membersByClass = StreamEx.of((Object[])elements).map(ResolveResult::getElement).groupingBy(MethodReferenceImpl::getContainingClassFQN, () -> CollectionFactory.createCaseInsensitiveStringMap(), Collectors.toList());
        if (membersByClass.containsKey(EMPTY_CLASS_FQN)) {
            return null;
        }
        PhpClass containingClass = PhpPsiUtil.getParentOfClass((PsiElement)methodReference, PhpClass.class);
        if (containingClass != null && membersByClass.containsKey(containingClass.getFQN())) {
            return (PsiElement)ContainerUtil.getOnlyItem((Collection)((Collection)membersByClass.get(containingClass.getFQN())));
        }
        ArrayList classes = new ArrayList(membersByClass.keySet());
        if (classes.isEmpty()) {
            return null;
        }
        Comparator<String> comparator = MethodReferenceImpl.createComparator(methodReference.getProject());
        String baseClassFQN = classes.stream().min(comparator).orElse(null);
        if (!ContainerUtil.and(classes, fqn -> fqn.equals(baseClassFQN) || comparator.compare(baseClassFQN, (String)fqn) < 0)) {
            return null;
        }
        return (PsiElement)ContainerUtil.getOnlyItem((Collection)((Collection)membersByClass.get(baseClassFQN)));
    }

    @NotNull
    private static Comparator<String> createComparator(@NotNull Project project) {
        if (project == null) {
            MethodReferenceImpl.$$$reportNull$$$0(17);
        }
        PhpIndex index = PhpIndex.getInstance((Project)project);
        Comparator comparator = (o1, o2) -> {
            boolean isSuper = PhpType.findSuper((String)o1, (String)o2, (PhpIndex)index);
            boolean isReverseSuper = PhpType.findSuper((String)o2, (String)o1, (PhpIndex)index);
            if (isSuper && !isReverseSuper) {
                return -1;
            }
            if (isReverseSuper && !isSuper) {
                return 1;
            }
            return 0;
        };
        if (comparator == null) {
            MethodReferenceImpl.$$$reportNull$$$0(18);
        }
        return comparator;
    }

    @NotNull
    private static String getContainingClassFQN(PsiElement c) {
        if (c instanceof PhpClassMember) {
            PhpClass containingClass = ((PhpClassMember)c).getContainingClass();
            return containingClass != null ? containingClass.getFQN() : EMPTY_CLASS_FQN;
        }
        return EMPTY_CLASS_FQN;
    }

    @NotNull
    private Collection<? extends PhpNamedElement> resolveTraitUseRule(boolean localOnly) {
        if (!(this.getParent() instanceof PhpTraitUseRule)) {
            List list = Collections.emptyList();
            if (list == null) {
                MethodReferenceImpl.$$$reportNull$$$0(19);
            }
            return list;
        }
        LinkedHashSet<PhpNamedElement> res = new LinkedHashSet<PhpNamedElement>();
        PhpClass containingClass = PhpPsiUtil.getParentOfClass((PsiElement)this, true, PhpClass.class);
        if (containingClass != null) {
            for (PhpClass trait : containingClass.getTraits()) {
                res.addAll(this.resolveMember(trait, localOnly));
            }
        }
        LinkedHashSet<PhpNamedElement> linkedHashSet = res;
        if (linkedHashSet == null) {
            MethodReferenceImpl.$$$reportNull$$$0(20);
        }
        return linkedHashSet;
    }

    @NotNull
    public Set<PhpNamedElement> resolveMember(@NotNull PhpClass klass, boolean localOnly) {
        if (klass == null) {
            MethodReferenceImpl.$$$reportNull$$$0(21);
        }
        Set<PhpNamedElement> set = this.resolveMemberWithGenerics(klass, localOnly, null);
        if (set == null) {
            MethodReferenceImpl.$$$reportNull$$$0(22);
        }
        return set;
    }

    @NotNull
    public Set<PhpNamedElement> resolveMemberWithGenerics(@NotNull PhpClass klass, boolean localOnly, @Nullable String genericInstantiationType) {
        PhpClass containingClass;
        if (klass == null) {
            MethodReferenceImpl.$$$reportNull$$$0(23);
        }
        if (localOnly) {
            PhpClass.PhpOverloadedMethods methods = klass.findOwnMethodsByName((CharSequence)this.getName());
            return new HashSet<PhpNamedElement>(methods.getMethods());
        }
        PhpClass.PhpOverloadedMethods methods = PhpClassImpl.findMethodsByName(klass, this.getName(), new HashSet<PhpClass>(), genericInstantiationType);
        if (!methods.isEmpty() && (containingClass = methods.getAny().getContainingClass()) != null && !PhpLangUtil.isObject(containingClass)) {
            Set<PhpNamedElement> set = MethodReferenceImpl.chooseOverloadedMethods((ParameterListOwner)this, methods);
            if (set == null) {
                MethodReferenceImpl.$$$reportNull$$$0(24);
            }
            return set;
        }
        return MethodReferenceImpl.tryToResolveParentPropertyHookCall(klass, this, localOnly);
    }

    public static Set<PhpNamedElement> chooseOverloadedMethods(ParameterListOwner reference, PhpClass.PhpOverloadedMethods overloadedMethods) {
        return StreamEx.of((Collection)overloadedMethods.getMethods()).groupingBy(PhpClassMember::getContainingClass).values().stream().flatMap(m -> MethodReferenceImpl.chooseOverloadedMethods(reference, m).stream()).collect(Collectors.toSet());
    }

    @NotNull
    private static Set<PhpNamedElement> chooseOverloadedMethods(ParameterListOwner reference, Collection<Method> methods) {
        if (methods.size() == 1) {
            return new HashSet<Method>(methods);
        }
        Method methodWithMatchingSignatures = (Method)ContainerUtil.find(methods, m -> MethodReferenceImpl.signatureMatches(reference, m));
        return methodWithMatchingSignatures != null ? Collections.singleton(methodWithMatchingSignatures) : new HashSet<Method>(methods);
    }

    private static boolean signatureMatches(ParameterListOwner call, Method method) {
        Object[] parameters;
        if (method instanceof PhpDocMethod && call instanceof MethodReference && ((MethodReference)call).isStatic() != method.isStatic()) {
            return false;
        }
        HashMap<PsiElement, ProblemDescriptor> problems = new HashMap<PsiElement, ProblemDescriptor>();
        Object[] arguments = call.getParameters();
        if (!(arguments.length <= (parameters = method.getParameters()).length || parameters.length > 0 && ((Parameter)ArrayUtil.getLastElement((Object[])parameters)).isVariadic())) {
            return false;
        }
        PhpParamsInspection.checkMissingParameter((PhpPsiElement)call, Arrays.asList(arguments), Arrays.asList(parameters), problems, true, true);
        if (!problems.isEmpty()) {
            return false;
        }
        PhpParamsInspection.checkParametersTypes(PhpParamsInspection.createCachedTypeFunc((PsiElement[])arguments), (PhpPsiElement)call, Arrays.asList(arguments), Arrays.asList(parameters), problems, true);
        if (!problems.isEmpty()) {
            return false;
        }
        return !ContainerUtil.exists((Object[])arguments, MethodReferenceImpl::isTypeAmbiguous);
    }

    private static boolean isTypeAmbiguous(PsiElement argument) {
        PhpType t = new PhpType().add(argument).global(argument.getProject());
        return t.isEmpty() || t.hasUnknown();
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            MethodReferenceImpl.$$$reportNull$$$0(25);
        }
        if (element instanceof PhpTraitUseRule) {
            return MethodReferenceImpl.isReferenceToTraitUseRule(this, (PhpTraitUseRule)element);
        }
        return super.isReferenceTo(element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isReferenceToTraitUseRule(PhpReference reference, PhpTraitUseRule element) {
        Method method = element.getMethod();
        if (method == null) return false;
        if (!Arrays.stream(reference.multiResolve(false)).map(ResolveResult::getElement).anyMatch(method::equals)) return false;
        return true;
    }

    @Override
    protected PhpTypeSignatureKey getTypeSignatureKey() {
        return PhpTypeSignatureKey.METHOD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 18, 19, 20, 22, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/MethodReferenceImpl";
                break;
            }
            case 6: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/MethodReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobalDescriptors";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToResolveParentPropertyHookCall";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createComparator";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTraitUseRule";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMember";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMemberWithGenerics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryToResolveParentPropertyHookCall";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createComparator";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberWithGenerics";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 18, 19, 20, 22, 24 -> new IllegalStateException(string);
        };
    }
}

