/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.MemberOrderService;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.completion.autoImport.PhpAutoImportConfiguration;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassUsageInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCodeEditUtil {
    private PhpCodeEditUtil() {
    }

    @NotNull
    public static Statement putStatementBefore(@NotNull PsiElement point, @NotNull Statement statement) {
        Statement anchor;
        if (point == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(1);
        }
        if ((anchor = PhpPsiUtil.getParentOfClass(point, false, Statement.class)) instanceof PhpCase) {
            anchor = PhpPsiUtil.getParentOfClass((PsiElement)anchor, true, Statement.class);
        }
        if (anchor instanceof GroupStatement) {
            anchor = PhpCodeEditUtil.findChildAncestor((PsiElement)anchor, point);
        }
        assert (anchor != null);
        PsiElement parent = anchor.getParent();
        if (parent instanceof Statement && !(parent instanceof GroupStatement)) {
            PsiElement anchorStatementCopy = anchor.copy();
            Project project = point.getProject();
            GroupStatement groupStatement = (GroupStatement)anchor.replace((PsiElement)PhpPsiElementFactory.createFromText(project, GroupStatement.class, "if(true){}"));
            anchor = groupStatement.addAfter(anchorStatementCopy, groupStatement.getFirstChild());
        }
        Statement statement2 = (Statement)anchor.getParent().addBefore((PsiElement)statement, (PsiElement)anchor);
        if (statement2 == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(2);
        }
        return statement2;
    }

    @NotNull
    public static Global addGlobalStatementBefore(@NotNull PsiElement point, @NotNull String variableName) {
        if (point == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(3);
        }
        if (variableName == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(4);
        }
        Project project = point.getProject();
        String globalStatementString = "global $" + variableName + ";";
        PsiElement groupStatement = point.getParent();
        Global globalStatement = PhpPsiElementFactory.createFromText(project, Global.class, globalStatementString);
        assert (globalStatement != null);
        PsiElement globalKeyword = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.kwGLOBAL, globalStatementString);
        globalKeyword = groupStatement.addBefore(globalKeyword, point);
        PsiElement whitespace = groupStatement.addAfter((PsiElement)PhpPsiElementFactory.createWhiteSpace(project), globalKeyword);
        PsiElement globalVar = groupStatement.addAfter((PsiElement)globalStatement, whitespace);
        Global global = (Global)globalVar;
        if (global == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(5);
        }
        return global;
    }

    @NotNull
    private static PsiElement findChildAncestor(@NotNull PsiElement outerElement, @NotNull PsiElement innerElement) {
        if (outerElement == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(6);
        }
        if (innerElement == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(7);
        }
        assert (PsiTreeUtil.isAncestor((PsiElement)outerElement, (PsiElement)innerElement, (boolean)true));
        for (PsiElement curElement = outerElement.getFirstChild(); curElement != null; curElement = curElement.getNextSibling()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)curElement, (PsiElement)innerElement, (boolean)false)) continue;
            PsiElement psiElement = curElement;
            if (psiElement == null) {
                PhpCodeEditUtil.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        assert (false);
        if (null == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(9);
        }
        return null;
    }

    @NotNull
    public static ParenthesizedExpression parenthesize(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(10);
        }
        Project project = expression.getProject();
        String newText = "(" + expression.getText() + ")";
        ParenthesizedExpression parenthesizedExpression = PhpPsiElementFactory.createPhpPsiFromText(project, ParenthesizedExpression.class, newText);
        if (parenthesizedExpression == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(11);
        }
        return parenthesizedExpression;
    }

    @NotNull
    public static UnaryExpression negate(@NotNull PhpExpression expression) {
        if (expression == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(12);
        }
        String expressionText = expression.getText();
        boolean dontNeedParensForNegation = expression instanceof PhpReference || expression instanceof ParenthesizedExpression;
        Object parenthesizedIfNeededExpression = dontNeedParensForNegation ? expressionText : "(" + expressionText + ")";
        UnaryExpression unaryExpression = PhpPsiElementFactory.createPhpPsiFromText(expression.getProject(), UnaryExpression.class, "!" + (String)parenthesizedIfNeededExpression);
        if (unaryExpression == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(13);
        }
        return unaryExpression;
    }

    public static boolean needToParenthesizeWhenReplace(@NotNull PsiElement elementToBeReplaced, @NotNull PsiElement elementToReplace) {
        PsiElement parent;
        if (elementToBeReplaced == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(14);
        }
        if (elementToReplace == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(15);
        }
        if (!((parent = elementToBeReplaced.getParent()) instanceof PhpExpression) || elementToReplace instanceof ParenthesizedExpression) {
            return false;
        }
        if (elementToReplace instanceof UnaryExpression || elementToReplace instanceof TernaryExpression) {
            return true;
        }
        if (elementToReplace instanceof NewExpression && parent instanceof MemberReference) {
            return true;
        }
        IElementType parentOperationType = PhpCodeEditUtil.getOperationType(parent);
        IElementType elementToReplaceOperationType = PhpCodeEditUtil.getOperationType(elementToReplace);
        if (parentOperationType != null && elementToReplaceOperationType != null) {
            return parentOperationType != elementToReplaceOperationType || !PhpCodeInsightUtil.tsASSOCIATIVE_OPS.contains(parentOperationType);
        }
        return parent instanceof UnaryExpression && !PhpAnnotatorVisitor.isAssignable(elementToReplace);
    }

    @Nullable
    private static IElementType getOperationType(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(16);
        }
        if (expression instanceof BinaryExpression) {
            return ((BinaryExpression)expression).getOperationType();
        }
        if (expression instanceof SelfAssignmentExpression) {
            return PhpCodeEditUtil.convertAssigmentOperations(((SelfAssignmentExpression)expression).getOperationType());
        }
        return null;
    }

    @Nullable
    public static IElementType convertAssigmentOperations(@Nullable IElementType operationType) {
        if (PhpTokenTypes.opPLUS_ASGN == operationType) {
            return PhpTokenTypes.opPLUS;
        }
        if (PhpTokenTypes.opMINUS_ASGN == operationType) {
            return PhpTokenTypes.opMINUS;
        }
        if (PhpTokenTypes.opMUL_ASGN == operationType) {
            return PhpTokenTypes.opMUL;
        }
        if (PhpTokenTypes.opDIV_ASGN == operationType) {
            return PhpTokenTypes.opDIV;
        }
        if (PhpTokenTypes.opREM_ASGN == operationType) {
            return PhpTokenTypes.opREM;
        }
        if (PhpTokenTypes.opSHIFT_RIGHT_ASGN == operationType) {
            return PhpTokenTypes.opSHIFT_RIGHT;
        }
        if (PhpTokenTypes.opSHIFT_LEFT_ASGN == operationType) {
            return PhpTokenTypes.opSHIFT_LEFT;
        }
        if (PhpTokenTypes.opBIT_AND_ASGN == operationType) {
            return PhpTokenTypes.opBIT_AND;
        }
        if (PhpTokenTypes.opBIT_OR_ASGN == operationType) {
            return PhpTokenTypes.opBIT_OR;
        }
        if (PhpTokenTypes.opBIT_XOR_ASGN == operationType) {
            return PhpTokenTypes.opBIT_XOR;
        }
        if (PhpTokenTypes.opCONCAT_ASGN == operationType) {
            return PhpTokenTypes.opCONCAT;
        }
        if (PhpTokenTypes.opEXP_ASGN == operationType) {
            return PhpTokenTypes.opEXP;
        }
        if (PhpTokenTypes.opCOALESCE_ASGN == operationType) {
            return PhpTokenTypes.opCOALESCE;
        }
        return operationType;
    }

    public static PsiElement replace(@NotNull PsiElement elementToBeReplaced, @NotNull PsiElement elementToReplace) {
        if (elementToBeReplaced == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(17);
        }
        if (elementToReplace == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(18);
        }
        if (PhpCodeEditUtil.needToParenthesizeWhenReplace(elementToBeReplaced, elementToReplace)) {
            return elementToBeReplaced.replace((PsiElement)PhpCodeEditUtil.parenthesize(elementToReplace));
        }
        return elementToBeReplaced.replace(elementToReplace);
    }

    public static boolean isEquivalent(@NotNull PsiElement sample, @NotNull PsiElement element) {
        if (sample == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(19);
        }
        if (element == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(20);
        }
        if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)sample, (PsiElement)element)) {
            return true;
        }
        if (sample instanceof StringLiteralExpression && element instanceof StringLiteralExpression) {
            String sampleString = PhpCodeInsightUtil.toString((StringLiteralExpression)sample);
            return sampleString != null && sampleString.equals(PhpCodeInsightUtil.toString((StringLiteralExpression)element));
        }
        return false;
    }

    public static void replaceNamespaceReference(@NotNull PhpPsiElement classReference, @Nullable String newNamespaceQualifiedName, @Nullable PhpNamespaceReference namespaceReference) {
        PhpUseList useList;
        if (classReference == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(21);
        }
        if ((useList = PhpUseImpl.getUseList((PsiElement)classReference)) == null) {
            if (StringUtil.isEmpty((String)newNamespaceQualifiedName)) {
                if (namespaceReference != null) {
                    namespaceReference.delete();
                }
            } else if (PhpLangUtil.equals(newNamespaceQualifiedName, "\\")) {
                Project project = classReference.getProject();
                String newReferenceText = newNamespaceQualifiedName + classReference.getName();
                Object newClassReference = classReference instanceof PhpDocPsiElement ? PhpPsiElementFactory.createPhpPsiFromText(project, PhpDocType.class, "/*** @var " + newReferenceText + " */\n") : PhpPsiElementFactory.createClassReference(project, newReferenceText);
                classReference.replace((PsiElement)newClassReference);
            } else {
                Project project = classReference.getProject();
                PhpNamespaceReference newNamespaceReference = classReference instanceof PhpDocPsiElement ? PhpPsiElementFactory.createNamespaceReference(project, newNamespaceQualifiedName, true) : PhpPsiElementFactory.createNamespaceReference(project, newNamespaceQualifiedName, false);
                if (namespaceReference != null) {
                    namespaceReference.replace((PsiElement)newNamespaceReference);
                } else {
                    classReference.addBefore(PsiTreeUtil.firstChild((PsiElement)classReference), (PsiElement)newNamespaceReference);
                }
            }
        } else {
            PhpCodeEditUtil.replaceNamespaceReferenceForUse(StringUtil.notNullize((String)newNamespaceQualifiedName), (PsiElement)classReference, true);
        }
    }

    public static void replaceNamespaceReferenceForUse(@NotNull String newNamespaceQualifiedName, @NotNull PsiElement nsReferenceHolder, boolean updateGlobalName) {
        block4: {
            PhpPsiElement scope;
            PhpUseList useList;
            String newNamespaceName;
            block8: {
                String newFullName;
                PhpUse use;
                block9: {
                    PhpNamespaceReference namespaceReference;
                    block7: {
                        block6: {
                            block5: {
                                if (newNamespaceQualifiedName == null) {
                                    PhpCodeEditUtil.$$$reportNull$$$0(22);
                                }
                                if (nsReferenceHolder == null) {
                                    PhpCodeEditUtil.$$$reportNull$$$0(23);
                                }
                                newNamespaceName = PhpLangUtil.concat(newNamespaceQualifiedName, "\\");
                                useList = PhpUseImpl.getUseList(nsReferenceHolder);
                                if (useList == null) break block4;
                                namespaceReference = useList.getNamespaceReference();
                                if (namespaceReference != null) break block5;
                                PhpCodeEditUtil.updateSingleReference(nsReferenceHolder, newNamespaceName);
                                break block4;
                            }
                            use = (PhpUse)PhpPsiUtil.getParentByCondition(nsReferenceHolder, (Condition<? super PsiElement>)PhpUse.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                            String globalName = namespaceReference.getFullName();
                            if (use == null || !newNamespaceName.startsWith(globalName)) break block6;
                            PhpCodeEditUtil.updateSingleReference(nsReferenceHolder, newNamespaceName.substring(globalName.length()));
                            break block4;
                        }
                        if (!updateGlobalName || use != null || "\\".equals(newNamespaceName)) break block7;
                        PhpCodeEditUtil.updateSingleReference(nsReferenceHolder, newNamespaceName);
                        break block4;
                    }
                    if (use == null) break block8;
                    String localName = PhpUseImpl.getReferenceText(use);
                    String className = PhpLangUtil.toShortName(use.getFQN());
                    newFullName = PhpLangUtil.concat(newNamespaceName, className);
                    int offset = newFullName.length() - localName.length();
                    if (!updateGlobalName || !newFullName.endsWith(localName) || offset == 0 || "\\".equals(newNamespaceName)) break block9;
                    PhpCodeEditUtil.replaceReference(newFullName.substring(0, offset), (PsiElement)namespaceReference);
                    break block4;
                }
                PhpPsiElement scope2 = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)useList);
                if (scope2 == null) break block4;
                PhpCodeEditUtil.createNewUseAndDeleteOld(use, useList, newFullName, scope2);
                break block4;
            }
            if ("\\".equals(newNamespaceName) && (scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)useList)) != null) {
                for (PhpUse phpUse : useList.getDeclarations()) {
                    PhpCodeEditUtil.createNewUseAndDeleteOld(phpUse, useList, PhpUseImpl.getReferenceText(phpUse), scope);
                }
            }
        }
    }

    private static void createNewUseAndDeleteOld(@NotNull PhpUse use, @NotNull PhpUseList useList, @NotNull String newFullName, @NotNull PhpPsiElement scope) {
        if (use == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(24);
        }
        if (useList == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(25);
        }
        if (newFullName == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(26);
        }
        if (scope == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(27);
        }
        String keyword = PhpGroupUseElement.getKeyword(use, useList);
        PhpAliasImporter.insertUseStatementWithKeyword(keyword, PhpLangUtil.toFQN(newFullName), use.getAliasName(), scope);
        PhpCodeEditUtil.deleteUseOrUseList(use, useList);
    }

    private static void updateSingleReference(@NotNull PsiElement nsReferenceHolder, @NotNull String newNamespaceName) {
        PsiElement reference;
        if (nsReferenceHolder == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(28);
        }
        if (newNamespaceName == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(29);
        }
        if ((reference = PhpPsiUtil.getChildOfType(nsReferenceHolder, PhpElementTypes.NS_REFERENCE)) != null) {
            PhpCodeEditUtil.replaceReference(newNamespaceName, reference);
        } else {
            PsiElement identifier = PhpPsiUtil.getChildOfType(nsReferenceHolder, PhpTokenTypes.IDENTIFIER);
            if (identifier != null) {
                Project project = nsReferenceHolder.getProject();
                String name = PhpLangUtil.toName(newNamespaceName);
                nsReferenceHolder.addBefore((PsiElement)PhpPsiElementFactory.createNamespaceReference(project, name, false), identifier);
            }
        }
    }

    private static void replaceReference(@NotNull String newNamespaceName, @NotNull PsiElement reference) {
        String name;
        if (newNamespaceName == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(30);
        }
        if (reference == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(31);
        }
        if (StringUtil.isEmpty((String)(name = PhpLangUtil.toName(newNamespaceName)))) {
            reference.delete();
        } else {
            reference.replace((PsiElement)PhpPsiElementFactory.createNamespaceReference(reference.getProject(), name, false));
        }
    }

    public static void deleteUseOrUseList(@Nullable PhpUse use, @NotNull PhpUseList useList) {
        if (useList == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(32);
        }
        if (use == null) {
            useList.delete();
        } else {
            Object prev = PhpPsiUtil.getPrevSiblingByCondition((PsiElement)use, (Condition<? super PsiElement>)PhpUse.INSTANCEOF);
            if (prev != null) {
                use.getParent().deleteChildRange(prev.getNextSibling(), (PsiElement)use);
            } else {
                Object next = PhpPsiUtil.getNextSiblingByCondition((PsiElement)use, (Condition<? super PsiElement>)PhpUse.INSTANCEOF);
                if (next != null) {
                    use.getParent().deleteChildRange((PsiElement)use, next.getPrevSibling());
                } else {
                    useList.delete();
                }
            }
        }
    }

    public static void deleteUse(@NotNull PhpUse use) {
        PhpUseList useList;
        if (use == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(33);
        }
        if ((useList = PhpUseImpl.getUseList((PsiElement)use)) != null) {
            PhpCodeEditUtil.deleteUseOrUseList(use, useList);
        }
    }

    public static void removeStatementWithDelivery(@NotNull PsiElement element, @Nullable IElementType delivery) {
        if (element == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(34);
        }
        PhpCodeEditUtil.removeStatementWithDelivery(element, delivery != null ? TokenSet.create((IElementType[])new IElementType[]{delivery}) : null, true);
    }

    public static void removeStatementWithDelivery(@NotNull PsiElement element, @Nullable TokenSet delivery) {
        if (element == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(35);
        }
        PhpCodeEditUtil.removeStatementWithDelivery(element, delivery, true);
    }

    public static void removeStatementWithDelivery(@NotNull PsiElement element, @Nullable TokenSet delivery, boolean deleteParent) {
        PsiElement parentElement;
        if (element == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(36);
        }
        if ((parentElement = element.getParent()) == null) {
            return;
        }
        if (delivery == null) {
            parentElement.deleteChildRange(element, element);
            return;
        }
        if (parentElement.getChildren().length == 1 && parentElement.getChildren()[0] == element) {
            if (deleteParent) {
                parentElement.delete();
            } else {
                element.delete();
            }
            return;
        }
        PsiElement prevElement = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(element, true);
        if (PhpPsiUtil.isOfType(prevElement, delivery)) {
            PsiElement prevPrevElement = PhpPsiUtil.getPrevSibling(prevElement, new Condition[0]);
            parentElement.deleteChildRange(prevPrevElement instanceof PsiWhiteSpace ? prevPrevElement : prevElement, element);
        } else {
            PsiElement nextElement = PhpPsiUtil.getNextSiblingIgnoreWhitespace(element, true);
            if (PhpPsiUtil.isOfType(nextElement, delivery)) {
                PsiElement nextNextElement = PhpPsiUtil.getNextSibling(nextElement, new Condition[0]);
                parentElement.deleteChildRange(element, nextNextElement instanceof PsiWhiteSpace ? nextNextElement : nextElement);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PsiElement insertDocMethodBeforeClass(@NotNull PhpClass clazz, PsiElement docMethod) {
        PhpDocComment docComment;
        if (clazz == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(37);
        }
        if ((docComment = clazz.getDocComment()) != null) {
            PhpDocMethod[] methods = docComment.getMethods();
            int docOffset = docComment.getTextRange().getStartOffset();
            if (methods.length > 0) {
                PhpDocMethod method = methods[0];
                if (method == null) return null;
                PsiElement parent = method.getParent();
                int methodOffset = parent.getTextRange().getStartOffset();
                int offset = methodOffset - docOffset;
                return PhpCodeEditUtil.insertDocMethod(docMethod, docComment, offset, true);
            }
            int lastChildOffset = docComment.getLastChild().getTextRange().getStartOffset();
            int offset = lastChildOffset - docOffset;
            return PhpCodeEditUtil.insertDocMethod(docMethod, docComment, offset, false);
        }
        PhpDocComment element = PhpPsiElementFactory.createFromText(clazz.getProject(), PhpDocComment.class, " /**\n" + docMethod.getText() + "\n*/");
        if (element == null) return element;
        PsiElement parent = clazz.getParent();
        parent.addBefore((PsiElement)element, (PsiElement)clazz);
        PsiElement singleLineSeparator = element.getPrevSibling();
        if (!PhpPsiUtil.isOfType(singleLineSeparator, TokenType.WHITE_SPACE)) return element;
        parent.addBefore(singleLineSeparator, (PsiElement)clazz);
        return element;
    }

    private static PsiElement insertDocMethod(PsiElement docMethod, PhpDocComment docComment, int offset, boolean withAsteriks) {
        String text = docComment.getText();
        String firstPart = text.substring(0, offset);
        String secondPart = text.substring(offset);
        PhpDocComment newDoc = PhpPsiElementFactory.createFromText(docComment.getProject(), PhpDocComment.class, firstPart + docMethod.getText() + "\n" + (withAsteriks ? "* " : "") + secondPart);
        if (newDoc != null) {
            docComment.replace((PsiElement)newDoc);
        }
        return newDoc;
    }

    @NotNull
    public static PsiElement insertClassMemberWithPhpDoc(@NotNull PhpClass clazz, @NotNull PsiElement member, @Nullable PhpDocComment comment) {
        if (clazz == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(38);
        }
        if (member == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(39);
        }
        PsiElement inserted = PhpCodeEditUtil.insertClassMember(clazz, member);
        if (comment != null) {
            inserted.getParent().addBefore((PsiElement)comment, inserted);
        }
        PsiElement psiElement = inserted;
        if (psiElement == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(40);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement insertClassMember(@NotNull PhpClass clazz, @NotNull PsiElement member) {
        if (clazz == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(41);
        }
        if (member == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(42);
        }
        CommonCodeStyleSettings settings = CodeStyle.getLanguageSettings((PsiFile)clazz.getContainingFile(), (Language)PhpLanguage.INSTANCE);
        MemberOrderService service = (MemberOrderService)ApplicationManager.getApplication().getService(MemberOrderService.class);
        PsiElement anchor = service.getAnchor(member, settings, (PsiElement)clazz);
        if (anchor == null || anchor == clazz) {
            PsiElement psiElement = clazz.addBefore(member, PhpCodeEditUtil.getBeforeAnchorForClassMember(clazz));
            if (psiElement == null) {
                PhpCodeEditUtil.$$$reportNull$$$0(43);
            }
            return psiElement;
        }
        PsiElement lastSiblingComment = PhpCodeEditUtil.findLastRelatedComment(anchor);
        PsiElement psiElement = clazz.addAfter(member, lastSiblingComment != null ? lastSiblingComment : anchor);
        if (psiElement == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(44);
        }
        return psiElement;
    }

    @Nullable
    private static PsiElement findLastRelatedComment(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(45);
        }
        PsiElement lastComment = null;
        for (PsiElement e = anchor.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (e instanceof PsiWhiteSpace) continue;
            if (!(e instanceof PsiComment) || e instanceof PhpDocComment) break;
            lastComment = e;
        }
        return lastComment;
    }

    @Nullable
    private static PsiElement getBeforeAnchorForClassMember(@NotNull PhpClass clazz) {
        Field field;
        PsiElement firstChild;
        PsiElement firstMember;
        if (clazz == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(46);
        }
        PsiElement psiElement = firstMember = (firstChild = clazz.getFirstChild()) == null ? null : PhpPsiUtil.findNextSiblingOfAnyType(firstChild, new IElementType[]{PhpElementTypes.CLASS_FIELDS, PhpElementTypes.CLASS_CONSTANTS, PhpStubElementTypes.CLASS_METHOD});
        if (firstMember == null) {
            return clazz.getLastChild();
        }
        PhpDocComment comment = null;
        if (firstMember instanceof PhpNamedElement) {
            comment = ((PhpNamedElement)firstMember).getDocComment();
        } else if ((PhpPsiUtil.isOfType(firstMember, PhpElementTypes.CLASS_FIELDS) || PhpPsiUtil.isOfType(firstMember, PhpElementTypes.CLASS_CONSTANTS)) && (field = (Field)PhpPsiUtil.getChildByCondition(firstMember, (Condition<? super PsiElement>)Field.INSTANCEOF)) != null) {
            comment = field.getDocComment();
        }
        return comment == null ? firstMember : comment;
    }

    @Nullable
    public static PhpClass findClassAtCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(47);
        }
        if (file == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(48);
        }
        return (PhpClass)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset(), PhpClass.class, (boolean)false);
    }

    public static TextRange insertDocCommentBeforeAndGetTextRange(@NotNull PsiElement element, @NotNull PhpDocComment docComment) {
        if (element == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(49);
        }
        if (docComment == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(50);
        }
        PsiElement parent = element.getParent();
        PsiElement added = parent.addBefore((PsiElement)docComment, element);
        PhpDocUtil.replaceFqnsWithImports(added);
        return PhpCodeEditUtil.reformatDocComment(element.getProject(), parent, added);
    }

    public static boolean importIfNeeded(@NotNull PhpReference ref, @NotNull String fqn, @Nullable PhpPsiElement scope) {
        if (ref == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(51);
        }
        if (fqn == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(52);
        }
        if (scope == null) {
            return false;
        }
        if (PhpType.isPrimitiveType((String)fqn) && (ref.getParent() instanceof PhpTypeDeclaration || ref instanceof PhpDocType)) {
            return false;
        }
        if (PhpLangUtil.isGlobalNamespaceFQN(ref.getNamespaceName()) && PhpCodeEditUtil.isFqnPreferedForGlobalNameSpace()) {
            return PhpCodeInsightUtil.isSameNamespace(scope, fqn);
        }
        if (PhpMoveClassUsageInfo.InternalNamespaceUsage.alreadyImported(scope, fqn)) {
            return true;
        }
        if (!PhpCodeInsightUtil.isAutoImportEnabled(scope)) {
            return false;
        }
        if (PhpCodeEditUtil.hasNameConflicts((PsiElement)ref, fqn, scope)) {
            return false;
        }
        if (PhpCodeInsightUtil.canImport(scope, fqn, PhpGroupUseElement.PhpUseKeyword.CLASS)) {
            PhpAliasImporter.insertUseStatement(fqn, scope);
            return true;
        }
        return false;
    }

    private static boolean isFqnPreferedForGlobalNameSpace() {
        PhpAutoImportConfiguration.State state = PhpAutoImportConfiguration.getInstance().getState();
        return PhpAutoImportConfiguration.GlobalSymbolBehavior.PREFER_FQN == state.getGlobalClassBehavior();
    }

    private static boolean hasNameConflicts(@NotNull PsiElement element, @NotNull String fqn, @Nullable PhpPsiElement scope) {
        if (element == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(53);
        }
        if (fqn == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(54);
        }
        if (!PhpLangUtil.isFqn(fqn)) {
            return false;
        }
        if (scope == null) {
            return false;
        }
        PhpCodeInsightUtil.ImportElementType elementType = PhpCodeInsightUtil.ImportElementType.fromElement(element);
        if (elementType == null) {
            return false;
        }
        return PhpCodeInsightUtil.hasNameConflicts(scope, fqn, elementType);
    }

    private static TextRange reformatDocComment(Project project, PsiElement parent, PsiElement docComment) {
        PsiElement docStart;
        if (docComment == null) {
            return null;
        }
        PsiFile psiFile = parent.getContainingFile();
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project);
        Document doc = psiFile.getFileDocument();
        RangeMarker rangeMarker = doc.createRangeMarker(docComment.getTextRange());
        if (docManager.isDocumentBlockedByPsi(doc)) {
            docManager.doPostponedOperationsAndUnblockDocument(doc);
            docManager.commitDocument(doc);
        }
        if (PhpPsiUtil.isOfType(docStart = psiFile.findElementAt(rangeMarker.getStartOffset()), PhpDocTokenTypes.DOC_COMMENT_START)) {
            ASTNode newDocNode = docStart.getParent().getNode();
            CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(newDocNode.getTreeParent(), newDocNode);
        }
        TextRange result = rangeMarker.getTextRange();
        rangeMarker.dispose();
        return result;
    }

    public static void setupMethodBody(@NotNull Project project) {
        Editor editor;
        if (project == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(55);
        }
        if ((editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return;
            }
            CaretModel caretModel = editor.getCaretModel();
            Function method = (Function)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(caretModel.getOffset() - 1), Function.class, (boolean)false);
            GroupStatement methodBody = (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)method, GroupStatement.class);
            if (methodBody == null) {
                return;
            }
            List<PsiElement> statements = PhpCodeEditUtil.collectStatements(methodBody);
            if (statements.isEmpty()) {
                PsiElement openBrace = PhpPsiUtil.getChildOfType((PsiElement)methodBody, PhpTokenTypes.chLBRACE);
                if (openBrace == null) {
                    return;
                }
                int offset = openBrace.getTextRange().getEndOffset();
                caretModel.moveToOffset(offset + 1);
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)StringUtil.notNullize((String)CodeStyleManager.getInstance((Project)project).getLineIndent(file, offset)));
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\n", (boolean)false, (boolean)false);
            } else {
                int startOffset = statements.get(0).getTextRange().getStartOffset();
                int endOffset = statements.get(statements.size() - 1).getTextRange().getEndOffset();
                caretModel.moveToOffset(startOffset);
                editor.getSelectionModel().setSelection(startOffset, endOffset);
            }
        });
    }

    @NotNull
    private static List<PsiElement> collectStatements(@NotNull GroupStatement bodyStatement) {
        if (bodyStatement == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(56);
        }
        SmartList result = new SmartList();
        PsiElement s = bodyStatement.getFirstChild();
        while (s != null) {
            if (!PhpPsiUtil.isOfType(s, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE)) {
                result.add(s);
            }
            s = PhpPsiUtil.getNextSiblingIgnoreWhitespace(s, true);
        }
        SmartList smartList = result;
        if (smartList == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(57);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 8, 9, 11, 13, 40, 43, 44, 57 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 40: 
            case 43: 
            case 44: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/PhpCodeEditUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerElement";
                break;
            }
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToBeReplaced";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReplace";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 20: 
            case 34: 
            case 35: 
            case 36: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNamespaceQualifiedName";
                break;
            }
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsReferenceHolder";
                break;
            }
            case 24: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "use";
                break;
            }
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useList";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFullName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNamespaceName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 37: 
            case 38: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/PhpCodeEditUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "putStatementBefore";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addGlobalStatementBefore";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildAncestor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parenthesize";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "negate";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "insertClassMemberWithPhpDoc";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "insertClassMember";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "collectStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "putStatementBefore";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 40: 
            case 43: 
            case 44: 
            case 57: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addGlobalStatementBefore";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findChildAncestor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parenthesize";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "negate";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "needToParenthesizeWhenReplace";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOperationType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "replaceNamespaceReference";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "replaceNamespaceReferenceForUse";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createNewUseAndDeleteOld";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updateSingleReference";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "replaceReference";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "deleteUseOrUseList";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "deleteUse";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeStatementWithDelivery";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "insertDocMethodBeforeClass";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "insertClassMemberWithPhpDoc";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "insertClassMember";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findLastRelatedComment";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getBeforeAnchorForClassMember";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findClassAtCaret";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "insertDocCommentBeforeAndGetTextRange";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "importIfNeeded";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "hasNameConflicts";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "setupMethodBody";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "collectStatements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 8, 9, 11, 13, 40, 43, 44, 57 -> new IllegalStateException(string);
        };
    }
}

