/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.strings;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.highlighting.PhpConversionSpecificationParser;
import com.jetbrains.php.codeInsight.highlighting.PhpHighlightFormatStringParametersHandlerFactory;
import com.jetbrains.php.codeInsight.highlighting.PhpHighlightFormatStringParametersUsagesHandler;
import com.jetbrains.php.lang.inspections.PhpFormatFunctionParametersMismatchInspection;
import com.jetbrains.php.lang.intentions.stringDoc.PhpHeredocToStringIntention;
import com.jetbrains.php.lang.intentions.strings.PhpExtractSelectedStringPartAsConcatenationOperandIntention;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringLiteralLazyStringPartDescriptor;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention
extends PsiUpdateModCommandAction<PsiElement> {
    public PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention() {
        super(PsiElement.class);
    }

    protected boolean isElementApplicable(@NotNull PsiElement element, @NotNull ActionContext context) {
        TextRange selectionRange;
        if (element == null) {
            PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.$$$reportNull$$$0(1);
        }
        if ((selectionRange = context.selection()).isEmpty()) {
            return false;
        }
        StringLiteralExpression string = PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.getString(element);
        if (string == null || string.isHeredoc() || PhpHeredocToStringIntention.isNowdoc((PsiElement)string)) {
            return false;
        }
        if (!PhpExtractSelectedStringPartAsConcatenationOperandIntention.getAbsoluteValueRange(string).contains(selectionRange) || PhpExtractSelectedStringPartAsConcatenationOperandIntention.selectionRangeIntersectsStringVariables(string, selectionRange)) {
            return false;
        }
        MultiMap<Integer, PhpHighlightFormatStringParametersUsagesHandler.RelativeRange> relativeSpecificationRanges = PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.getRelativeSpecificationRangesInNaturalOrder(context.project(), string);
        if (relativeSpecificationRanges == null) {
            return false;
        }
        return !PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.selectionRangeIntersectsSpecificationsRanges(selectionRange, string, relativeSpecificationRanges.values());
    }

    @Nullable
    private static StringLiteralExpression getString(@NotNull PsiElement element) {
        if (element == null) {
            PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.$$$reportNull$$$0(2);
        }
        return (StringLiteralExpression)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
    }

    private static MultiMap<Integer, PhpHighlightFormatStringParametersUsagesHandler.RelativeRange> getRelativeSpecificationRangesInNaturalOrder(Project project, StringLiteralExpression string) {
        PsiElement selectedFormatStringParameter = PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.getSelectedFormatStringParameter(project, string);
        if (selectedFormatStringParameter == null) {
            return null;
        }
        List<StringLiteralExpression> expressions = PhpFormatFunctionParametersMismatchInspection.getLiteralExpressions(selectedFormatStringParameter);
        MultiMap<Integer, PhpConversionSpecificationParser.ConversionSpecification> specifications = PhpFormatFunctionParametersMismatchInspection.getConversionSpecifications(expressions);
        if (specifications == null || !ContainerUtil.and((Iterable)specifications.values(), r -> r.naturalOrder())) {
            return null;
        }
        return PhpHighlightFormatStringParametersUsagesHandler.getRelativeSpecificationRanges(specifications, expressions);
    }

    public static PsiElement getSelectedFormatStringParameter(Project project, @Nullable StringLiteralExpression string) {
        FunctionReference reference = PhpPsiUtil.getParentOfClass((PsiElement)string, FunctionReference.class);
        if (reference == null) {
            return null;
        }
        int formatStringIndex = PhpHighlightFormatStringParametersHandlerFactory.getFormatStringIndex(project, reference);
        PsiElement formatStringParameter = reference.getParameter(formatStringIndex);
        return PsiTreeUtil.isAncestor((PsiElement)formatStringParameter, (PsiElement)string, (boolean)false) ? formatStringParameter : null;
    }

    private static boolean selectionRangeIntersectsSpecificationsRanges(TextRange selectionRange, StringLiteralExpression string, Collection<PhpHighlightFormatStringParametersUsagesHandler.RelativeRange> relativeSpecificationRanges) {
        TextRange selectionRangeInsideExpression = selectionRange.shiftLeft(PhpExtractSelectedStringPartAsConcatenationOperandIntention.getAbsoluteValueRange(string).getStartOffset());
        return relativeSpecificationRanges.stream().filter(r -> r.getContainingExpression() == string).anyMatch(r -> r.getRangeInsideExpression().intersectsStrict(selectionRangeInsideExpression));
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.$$$reportNull$$$0(5);
        }
        TextRange selectionRange = context.selection();
        StringLiteralExpression string = PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.getString(element);
        if (string == null) {
            return;
        }
        Project project = context.project();
        MultiMap<Integer, PhpHighlightFormatStringParametersUsagesHandler.RelativeRange> relativeSpecificationRanges = PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.getRelativeSpecificationRangesInNaturalOrder(project, string);
        if (relativeSpecificationRanges == null) {
            return;
        }
        TextRange selectionRangeRelativeToElement = selectionRange.shiftLeft(PhpExtractSelectedStringPartAsConcatenationOperandIntention.getAbsoluteValueRange(string).getStartOffset());
        PsiElement selectedFormatStringParameter = PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.getSelectedFormatStringParameter(project, string);
        if (selectedFormatStringParameter == null) {
            return;
        }
        FunctionReference reference = PhpPsiUtil.getParentOfClass((PsiElement)string, FunctionReference.class);
        if (reference == null) {
            return;
        }
        PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.insertNewFormatParameter(relativeSpecificationRanges, string, selectionRangeRelativeToElement, reference, selectedFormatStringParameter);
        PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.replaceSelectionWithFormatParameter(selectionRangeRelativeToElement, string);
    }

    private static void replaceSelectionWithFormatParameter(TextRange range, StringLiteralExpression string) {
        String updatedContent = range.replace(string.getContents(), "%s");
        string.replace((PsiElement)PhpPsiElementFactory.createStringLiteralExpression(string.getProject(), updatedContent, string.isSingleQuote()));
    }

    private static void insertNewFormatParameter(MultiMap<Integer, PhpHighlightFormatStringParametersUsagesHandler.RelativeRange> ranges, StringLiteralExpression selectedString, TextRange selectedRange, FunctionReference functionReference, PsiElement selectedFormatStringParameter) {
        int conversionsCountSpecificationsBeforeSelectedRange = PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.countConversionsSpecificationsBeforeSelectedRange(selectedString, selectedRange, ranges);
        PsiElement argumentToAppendBefore = PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.findArgumentToAppendBefore(selectedFormatStringParameter, conversionsCountSpecificationsBeforeSelectedRange);
        Project project = selectedString.getProject();
        ParameterList list = functionReference.getParameterList();
        if (list == null) {
            return;
        }
        PsiElement nextSibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(argumentToAppendBefore, true);
        boolean hasTrailingComma = PhpPsiUtil.isOfType(nextSibling, PhpTokenTypes.opCOMMA);
        PsiElement comma = nextSibling != null && hasTrailingComma ? nextSibling : list.addAfter(PhpPsiElementFactory.createComma(project), argumentToAppendBefore);
        PsiElement extractedStringPart = list.addAfter(new PhpStringLiteralLazyStringPartDescriptor(project, selectedRange.substring(selectedString.getContents()), selectedString.isSingleQuote()).getElement(), comma);
        if (hasTrailingComma) {
            list.addAfter(PhpPsiElementFactory.createComma(project), extractedStringPart);
        }
    }

    private static int countConversionsSpecificationsBeforeSelectedRange(StringLiteralExpression string, TextRange range, MultiMap<Integer, PhpHighlightFormatStringParametersUsagesHandler.RelativeRange> specificationsRanges) {
        Comparator<PhpHighlightFormatStringParametersUsagesHandler.RelativeRange> comparator = Comparator.comparingInt(e -> PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.getStartOffset(e.getContainingExpression())).thenComparing(e -> e.getRangeInsideExpression().getStartOffset());
        int result = 0;
        for (PhpHighlightFormatStringParametersUsagesHandler.RelativeRange specificationRange : specificationsRanges.values().stream().sorted(comparator).toList()) {
            if (PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.getStartOffset(specificationRange.getContainingExpression()) > PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.getStartOffset(string) || string == specificationRange.getContainingExpression() && specificationRange.getRangeInsideExpression().getStartOffset() > range.getStartOffset()) break;
            ++result;
        }
        return result;
    }

    private static int getStartOffset(StringLiteralExpression string) {
        return string.getTextRange().getStartOffset();
    }

    @NotNull
    private static PsiElement findArgumentToAppendBefore(@NotNull PsiElement selectedFormatStringParameter, int conversionsSpecificationsBeforeSelectedRange) {
        Object nextSibling;
        if (selectedFormatStringParameter == null) {
            PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.$$$reportNull$$$0(6);
        }
        Object argumentToAppendBefore = selectedFormatStringParameter;
        while (conversionsSpecificationsBeforeSelectedRange > 0 && (nextSibling = PhpPsiUtil.getNextSiblingByCondition(argumentToAppendBefore, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF)) != null) {
            argumentToAppendBefore = nextSibling;
            --conversionsSpecificationsBeforeSelectedRange;
        }
        PsiElement psiElement = argumentToAppendBefore;
        if (psiElement == null) {
            PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("extract.selected.string.part.as.format.function.argument", new Object[0]);
        if (string == null) {
            PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFormatStringParameter";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/strings/PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/strings/PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findArgumentToAppendBefore";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isElementApplicable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findArgumentToAppendBefore";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

