/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.codeStyle.PhpSwitchCanBeReplacedWithMatchExpressionInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpUnnecessaryParenthesesInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpLoop;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpReplaceIfWithTernaryIntention
extends PsiUpdateModCommandAction<If> {
    private static final ReturnStatementProcessor RETURN_STATEMENT_PROCESSOR = new ReturnStatementProcessor();
    private static final IfStatementProcessor[] branchProcessors = new IfStatementProcessor[]{new AssignmentStatementProcessor(), RETURN_STATEMENT_PROCESSOR};

    public PhpReplaceIfWithTernaryIntention() {
        super(If.class);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull If ifClause, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(0);
        }
        if (ifClause == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(2);
        }
        PhpReplaceIfWithTernaryIntention.replaceWithTernary(ifClause);
    }

    public static PsiElement replaceWithTernary(If ifClause) {
        PhpPsiElement condition;
        Statement elseStatement;
        if (ifClause == null) {
            return null;
        }
        Else elseBranch = ifClause.getElseBranch();
        Statement ifStatement = PhpReplaceIfWithTernaryIntention.getTheFirstStatementFromBranch((PsiElement)ifClause);
        Statement statement = elseStatement = elseBranch != null ? PhpReplaceIfWithTernaryIntention.getTheFirstStatementFromBranch((PsiElement)elseBranch) : null;
        if (elseStatement == null) {
            elseStatement = (Statement)PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)ifClause, true);
        }
        if ((condition = ifClause.getCondition()) != null && ifStatement != null && elseStatement != null) {
            for (IfStatementProcessor it : branchProcessors) {
                Statement toReplace = it.tryToBuildTernary((PsiElement)condition, ifStatement, elseStatement);
                if (toReplace == null) continue;
                elseStatement.delete();
                return ifClause.replace((PsiElement)toReplace);
            }
        }
        return null;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull If ifClause) {
        if (context == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(3);
        }
        if (ifClause == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(4);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable((PsiElement)ifClause)) {
            return null;
        }
        if (ifClause.getElseIfBranches().length == 0) {
            Else elseBranch = ifClause.getElseBranch();
            Statement ifStatement = PhpReplaceIfWithTernaryIntention.getTheFirstStatementFromBranch((PsiElement)ifClause);
            if (ifStatement == null) {
                return null;
            }
            if (elseBranch != null) {
                Statement elseStatement = PhpReplaceIfWithTernaryIntention.getTheFirstStatementFromBranch((PsiElement)elseBranch);
                PhpPsiElement condition = ifClause.getCondition();
                if (condition != null && elseStatement != null) {
                    for (IfStatementProcessor it : branchProcessors) {
                        if (!it.isAvailable(ifStatement, elseStatement)) continue;
                        return Presentation.of((String)PhpReplaceIfWithTernaryIntention.getTitle());
                    }
                    return null;
                }
            }
            if (PhpReplaceIfWithTernaryIntention.isIfWithReturns(ifClause, ifStatement)) {
                return Presentation.of((String)PhpReplaceIfWithTernaryIntention.getTitle());
            }
        }
        return null;
    }

    private static boolean isIfWithReturns(If ifClause, Statement ifStatement) {
        PsiElement nextStatement = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)ifClause, true);
        Object parentBlock = PhpPsiUtil.getParentByCondition(nextStatement, (Condition<? super PsiElement>)((Condition)a -> a instanceof PhpLoop || a instanceof Function));
        return parentBlock != null && nextStatement instanceof Statement && RETURN_STATEMENT_PROCESSOR.isAvailable(ifStatement, (Statement)nextStatement);
    }

    @Nullable
    private static Statement getTheFirstStatementFromBranch(@NotNull PsiElement branch) {
        GroupStatement branchGroupStatement;
        if (branch == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(5);
        }
        if ((branchGroupStatement = (GroupStatement)PhpPsiUtil.getChildByCondition(branch, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF)) != null) {
            return (Statement)ObjectUtils.tryCast((Object)branchGroupStatement.statements().single(), Statement.class);
        }
        return (Statement)PhpPsiUtil.getChildByCondition(branch, (Condition<? super PsiElement>)Statement.INSTANCEOF);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("replace.if.clause.with.ternary.expression", new Object[0]);
        if (string == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static boolean assignmentsToTheSameVariable(@Nullable AssignmentExpression assignmentExpression1, @Nullable AssignmentExpression assignmentExpression2) {
        if (assignmentExpression1 != null && assignmentExpression2 != null) {
            PhpPsiElement thenVariable = assignmentExpression1.getVariable();
            PhpPsiElement elseVariable = assignmentExpression2.getVariable();
            if (thenVariable != null && elseVariable != null) {
                PsiReference thenReference = thenVariable.getReference();
                PsiReference elseReference = elseVariable.getReference();
                if (thenReference instanceof FieldReference) {
                    FieldReference thenFieldReference = (FieldReference)thenReference;
                    if (elseReference instanceof FieldReference) {
                        FieldReference elseFieldReference = (FieldReference)elseReference;
                        PhpExpression thenClassExpression = thenFieldReference.getClassReference();
                        PhpExpression elseClassExpression = elseFieldReference.getClassReference();
                        PsiElement resolvedThen = thenReference.resolve();
                        PsiElement resolvedElse = elseReference.resolve();
                        if (resolvedThen == null && resolvedElse == null && thenClassExpression != null && elseClassExpression != null) {
                            String thenClassExpressionName = thenClassExpression.getName();
                            CharSequence thenFieldReferenceNameCS = thenFieldReference.getNameCS();
                            return thenClassExpressionName != null && thenClassExpressionName.equals(elseClassExpression.getName()) && thenFieldReferenceNameCS != null && thenFieldReferenceNameCS.equals(elseFieldReference.getNameCS());
                        }
                        if (!PhpReplaceIfWithTernaryIntention.checkClassReference(thenClassExpression, elseClassExpression)) {
                            return false;
                        }
                    }
                }
                if (thenReference != null && elseReference != null) {
                    PsiElement resolvedThen = thenReference.resolve();
                    return resolvedThen != null && resolvedThen.equals(elseReference.resolve());
                }
            }
        }
        return false;
    }

    private static boolean checkClassReference(PhpExpression thenClassExpression, PhpExpression elseClassExpression) {
        if (thenClassExpression != null && elseClassExpression != null) {
            String thenName = thenClassExpression.getName();
            String elseClassExpressionName = elseClassExpression.getName();
            return thenName != null && thenName.equals(elseClassExpressionName);
        }
        return true;
    }

    public static boolean isPassedByReference(PsiElement element) {
        ASTNode prevSiblingNode = element.getNode().getTreePrev();
        return prevSiblingNode != null && (prevSiblingNode.getElementType() == PhpTokenTypes.opBIT_AND || prevSiblingNode.getElementType() == PhpTokenTypes.opASGN && prevSiblingNode.getText().endsWith("&"));
    }

    @NotNull
    private static TernaryExpression createTernaryExpression(@NotNull PsiElement condition, @NlsSafe String thenText, @NlsSafe String elseText) {
        if (condition == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(7);
        }
        String text = "(" + condition.getText() + ")?(" + thenText + "):(" + elseText + ")";
        TernaryExpression ternaryExpression = PhpPsiElementFactory.createPhpPsiFromText(condition.getProject(), TernaryExpression.class, text);
        PhpReplaceIfWithTernaryIntention.unwrapIfNecessary((PsiElement)ternaryExpression.getCondition());
        PhpReplaceIfWithTernaryIntention.unwrapIfNecessary((PsiElement)ternaryExpression.getTrueVariant());
        TernaryExpression ternaryExpression2 = (TernaryExpression)PhpReplaceIfWithTernaryIntention.unwrapIfNecessary((PsiElement)ternaryExpression.getFalseVariant()).getParent();
        if (ternaryExpression2 == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(8);
        }
        return ternaryExpression2;
    }

    @NotNull
    public static PsiElement unwrapIfNecessary(@Nullable PsiElement element) {
        ParenthesizedExpression parenthesized;
        if (element instanceof ParenthesizedExpression && PhpUnnecessaryParenthesesInspection.isParensUnnecessary(parenthesized = (ParenthesizedExpression)element)) {
            PsiElement psiElement = element.replace((PsiElement)parenthesized.extract());
            if (psiElement == null) {
                PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(9);
            }
            return psiElement;
        }
        assert (element != null);
        PsiElement psiElement = element;
        if (psiElement == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    private static String getPrefix(AssignmentExpression expression) {
        SelfAssignmentExpression selfAssignmentExpression;
        PsiElement operation;
        Object operationText = "";
        if (expression instanceof SelfAssignmentExpression && (operation = (selfAssignmentExpression = (SelfAssignmentExpression)expression).getOperation()) != null) {
            operationText = operation.getText();
            if (!PhpPsiUtil.isOfType(operation, PhpTokenTypes.opASGN)) {
                operationText = ((String)operationText).replace("=", "");
                PhpPsiElement variable = expression.getVariable();
                if (variable != null) {
                    operationText = variable.getText() + (String)operationText;
                }
            } else {
                operationText = "";
            }
        }
        return operationText;
    }

    @IntentionName
    public static String getTitle() {
        return PhpBundle.message("intention.replace.if.with.ternaryExpression", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifClause";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpReplaceIfWithTernaryIntention";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpReplaceIfWithTernaryIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTernaryExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTheFirstStatementFromBranch";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTernaryExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    static interface IfStatementProcessor {
        public boolean isAvailable(Statement var1, Statement var2);

        public Statement tryToBuildTernary(@NotNull PsiElement var1, @NotNull Statement var2, @NotNull Statement var3);
    }

    static class ReturnStatementProcessor
    implements IfStatementProcessor {
        ReturnStatementProcessor() {
        }

        @Override
        public boolean isAvailable(@NotNull Statement thenStatement, @NotNull Statement elseStatement) {
            if (thenStatement == null) {
                ReturnStatementProcessor.$$$reportNull$$$0(0);
            }
            if (elseStatement == null) {
                ReturnStatementProcessor.$$$reportNull$$$0(1);
            }
            return ReturnStatementProcessor.checkReturnStatement(thenStatement) && ReturnStatementProcessor.checkReturnStatement(elseStatement) || ReturnStatementProcessor.checkReturnWithThrow(thenStatement, elseStatement) || ReturnStatementProcessor.checkReturnWithThrow(elseStatement, thenStatement);
        }

        private static boolean checkReturnWithThrow(Statement returnStatement, Statement throwStatement) {
            if (!ReturnStatementProcessor.checkReturnStatement(returnStatement)) {
                return false;
            }
            return throwStatement.getFirstChild() instanceof PhpThrowExpression && PhpLanguageLevel.current((Project)throwStatement.getProject()).isAtLeast(PhpLanguageLevel.PHP800);
        }

        private static boolean checkReturnStatement(Statement statement) {
            if (statement instanceof PhpReturn) {
                PsiElement argument = ((PhpReturn)statement).getArgument();
                return argument != null && !PhpReplaceIfWithTernaryIntention.isPassedByReference(argument);
            }
            return false;
        }

        @Override
        public Statement tryToBuildTernary(@NotNull PsiElement condition, @NotNull Statement thenStatement, @NotNull Statement elseStatement) {
            if (condition == null) {
                ReturnStatementProcessor.$$$reportNull$$$0(2);
            }
            if (thenStatement == null) {
                ReturnStatementProcessor.$$$reportNull$$$0(3);
            }
            if (elseStatement == null) {
                ReturnStatementProcessor.$$$reportNull$$$0(4);
            }
            if (ReturnStatementProcessor.checkReturnStatement(thenStatement) && ReturnStatementProcessor.checkReturnStatement(elseStatement) || ReturnStatementProcessor.checkReturnWithThrow(thenStatement, elseStatement) || ReturnStatementProcessor.checkReturnWithThrow(elseStatement, thenStatement)) {
                PsiElement elseElement;
                PsiElement thenElement = thenStatement instanceof PhpReturn ? ((PhpReturn)thenStatement).getArgument() : thenStatement.getFirstChild();
                PsiElement psiElement = elseElement = elseStatement instanceof PhpReturn ? ((PhpReturn)elseStatement).getArgument() : elseStatement.getFirstChild();
                if (elseElement != null && thenElement != null) {
                    Project project = condition.getProject();
                    TernaryExpression ternaryExpression = PhpReplaceIfWithTernaryIntention.createTernaryExpression(condition, thenElement.getText(), elseElement.getText());
                    return (Statement)PhpPsiElementFactory.createFirstFromText(project, PhpReturn.class, "return " + ternaryExpression.getText() + ";");
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenStatement";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseStatement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpReplaceIfWithTernaryIntention$ReturnStatementProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryToBuildTernary";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class AssignmentStatementProcessor
    implements IfStatementProcessor {
        AssignmentStatementProcessor() {
        }

        @Override
        public boolean isAvailable(Statement thenStatement, Statement elseStatement) {
            PhpPsiElement ifFirstPsiChild = thenStatement.getFirstPsiChild();
            PhpPsiElement elseFirstPsiChild = elseStatement.getFirstPsiChild();
            if (ifFirstPsiChild instanceof AssignmentExpression && elseFirstPsiChild instanceof AssignmentExpression) {
                AssignmentExpression assignmentExpressionIf = (AssignmentExpression)ifFirstPsiChild;
                AssignmentExpression assignmentExpressionElse = (AssignmentExpression)elseFirstPsiChild;
                return PhpReplaceIfWithTernaryIntention.assignmentsToTheSameVariable(assignmentExpressionIf, assignmentExpressionElse) && assignmentExpressionIf.getValue() != null && assignmentExpressionElse.getValue() != null && !PhpReplaceIfWithTernaryIntention.isPassedByReference((PsiElement)assignmentExpressionIf.getValue()) && !PhpReplaceIfWithTernaryIntention.isPassedByReference((PsiElement)assignmentExpressionElse.getValue());
            }
            return false;
        }

        @Override
        public Statement tryToBuildTernary(@NotNull PsiElement condition, @NotNull Statement ifStatement, @NotNull Statement elseStatement) {
            if (condition == null) {
                AssignmentStatementProcessor.$$$reportNull$$$0(0);
            }
            if (ifStatement == null) {
                AssignmentStatementProcessor.$$$reportNull$$$0(1);
            }
            if (elseStatement == null) {
                AssignmentStatementProcessor.$$$reportNull$$$0(2);
            }
            PhpPsiElement ifFirstPsiChild = ifStatement.getFirstPsiChild();
            PhpPsiElement elseFirstPsiChild = elseStatement.getFirstPsiChild();
            if (ifFirstPsiChild instanceof AssignmentExpression && elseFirstPsiChild instanceof AssignmentExpression) {
                AssignmentExpression assignmentExpressionElse = (AssignmentExpression)elseFirstPsiChild;
                AssignmentExpression assignmentExpressionThen = (AssignmentExpression)ifFirstPsiChild;
                PhpPsiElement thenVariable = assignmentExpressionThen.getVariable();
                PhpPsiElement thenValue = assignmentExpressionThen.getValue();
                PhpPsiElement elseValue = assignmentExpressionElse.getValue();
                assert (thenValue != null);
                assert (elseValue != null);
                if (PhpSwitchCanBeReplacedWithMatchExpressionInspection.isHomogeneousAssignments((PsiElement)assignmentExpressionThen, (PsiElement)assignmentExpressionElse)) {
                    String leftHandSideText = PhpSwitchCanBeReplacedWithMatchExpressionInspection.PhpReplaceSwitchWithMatchExpressionFix.getLeftHandSideText((PsiElement)assignmentExpressionThen);
                    TernaryExpression expression = PhpReplaceIfWithTernaryIntention.createTernaryExpression(condition, thenValue.getText(), elseValue.getText());
                    return PhpPsiElementFactory.createStatement(condition.getProject(), leftHandSideText + expression.getText() + ";");
                }
                String prefixThen = PhpReplaceIfWithTernaryIntention.getPrefix(assignmentExpressionThen);
                String prefixElse = PhpReplaceIfWithTernaryIntention.getPrefix(assignmentExpressionElse);
                if (PhpReplaceIfWithTernaryIntention.assignmentsToTheSameVariable(assignmentExpressionThen, assignmentExpressionElse)) {
                    assert (thenVariable != null);
                    TernaryExpression expression = PhpReplaceIfWithTernaryIntention.createTernaryExpression(condition, prefixThen + thenValue.getText(), prefixElse + elseValue.getText());
                    return PhpPsiElementFactory.createFromText(condition.getProject(), Statement.class, thenVariable.getText() + "=" + expression.getText() + ";");
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "condition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ifStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "elseStatement";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/intentions/PhpReplaceIfWithTernaryIntention$AssignmentStatementProcessor";
            objectArray[2] = "tryToBuildTernary";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

