/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpAddNumberSeparatorsIntention
extends PsiUpdateModCommandAction<PsiElement> {
    public PhpAddNumberSeparatorsIntention() {
        super(PsiElement.class);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        if (context == null) {
            PhpAddNumberSeparatorsIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpAddNumberSeparatorsIntention.$$$reportNull$$$0(1);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return null;
        }
        PhpLanguageLevel languageLevel = PhpProjectConfigurationFacade.getInstance(element.getProject()).getLanguageLevel();
        if (!languageLevel.hasFeature(PhpLanguageFeature.NUMERIC_LITERALS_SEPARATORS)) {
            return null;
        }
        if (!PhpPsiUtil.isOfType(element.getParent(), PhpElementTypes.NUMBER)) {
            return null;
        }
        if (!PhpAddNumberSeparatorsIntention.canAddNumberSeparators(element.getText(), PsiUtilCore.getElementType((PsiElement)element))) {
            return null;
        }
        return Presentation.of((String)this.getFamilyName());
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpAddNumberSeparatorsIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpAddNumberSeparatorsIntention.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PhpAddNumberSeparatorsIntention.$$$reportNull$$$0(4);
        }
        String textWithSeparators = PhpAddNumberSeparatorsIntention.addNumberSeparators(element.getText(), PsiUtilCore.getElementType((PsiElement)element));
        PsiElement elementWithSeparators = PhpPsiElementFactory.createFromText(context.project(), PhpElementTypes.NUMBER, textWithSeparators);
        if (elementWithSeparators == null) {
            return;
        }
        element.getParent().replace(elementWithSeparators);
    }

    private static int getSeparatorDist(IElementType type) {
        boolean isDecimal = type == PhpTokenTypes.DECIMAL_INTEGER || type == PhpTokenTypes.FLOAT_LITERAL;
        return isDecimal ? 3 : 4;
    }

    private static int getNumberPrefixLength(IElementType type) {
        if (type == PhpTokenTypes.HEX_INTEGER || type == PhpTokenTypes.BINARY_INTEGER) {
            return 2;
        }
        if (type == PhpTokenTypes.OCTAL_INTEGER) {
            return 1;
        }
        return 0;
    }

    private static int getLengthBeforeExponent(String floatText) {
        int expIndex = StringUtil.indexOfAny((String)floatText, (String)"eE");
        return expIndex != -1 ? expIndex : floatText.length();
    }

    private static String addNumberSeparators(String text, IElementType type) {
        int separatorDist = PhpAddNumberSeparatorsIntention.getSeparatorDist(type);
        StringBuilder builder2 = new StringBuilder();
        if (type == PhpTokenTypes.FLOAT_LITERAL) {
            int dotIndex = text.indexOf(46);
            int lengthBeforeExponent = PhpAddNumberSeparatorsIntention.getLengthBeforeExponent(text);
            if (dotIndex != -1) {
                PhpAddNumberSeparatorsIntention.appendRightAlignedNumberSeparators(builder2, text.substring(0, dotIndex), separatorDist);
                builder2.append('.');
                PhpAddNumberSeparatorsIntention.appendLeftAlignedNumberSeparators(builder2, text.substring(dotIndex + 1, lengthBeforeExponent), separatorDist);
            } else {
                PhpAddNumberSeparatorsIntention.appendRightAlignedNumberSeparators(builder2, text.substring(0, lengthBeforeExponent), separatorDist);
            }
            builder2.append(text, lengthBeforeExponent, text.length());
        } else {
            int prefixLength = PhpAddNumberSeparatorsIntention.getNumberPrefixLength(type);
            builder2.append(text, 0, prefixLength);
            PhpAddNumberSeparatorsIntention.appendRightAlignedNumberSeparators(builder2, text.substring(prefixLength), separatorDist);
        }
        return builder2.toString();
    }

    private static void appendRightAlignedNumberSeparators(StringBuilder builder2, String number, int separatorDist) {
        PhpAddNumberSeparatorsIntention.appendNumberSeparators(builder2, number, separatorDist, number.length() % separatorDist);
    }

    private static void appendLeftAlignedNumberSeparators(StringBuilder builder2, String number, int separatorDist) {
        PhpAddNumberSeparatorsIntention.appendNumberSeparators(builder2, number, separatorDist, 0);
    }

    private static void appendNumberSeparators(StringBuilder builder2, String number, int separatorDist, int firstSeparatorPos) {
        if (firstSeparatorPos == 0) {
            firstSeparatorPos = separatorDist;
        }
        int prevPos = 0;
        for (int pos = firstSeparatorPos; pos < number.length(); pos += separatorDist) {
            builder2.append(number, prevPos, pos);
            builder2.append('_');
            prevPos = pos;
        }
        builder2.append(number, prevPos, number.length());
    }

    private static boolean canAddNumberSeparators(String text, IElementType type) {
        if (text.contains("_")) {
            return false;
        }
        int separatorDist = PhpAddNumberSeparatorsIntention.getSeparatorDist(type);
        int length = text.length();
        if (type == PhpTokenTypes.FLOAT_LITERAL) {
            int dotIndex = text.indexOf(46);
            int lengthBeforeExponent = PhpAddNumberSeparatorsIntention.getLengthBeforeExponent(text);
            if (dotIndex != -1) {
                return dotIndex > separatorDist || lengthBeforeExponent - dotIndex - 1 > separatorDist;
            }
            return lengthBeforeExponent > separatorDist;
        }
        return length > separatorDist + PhpAddNumberSeparatorsIntention.getNumberPrefixLength(type);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.add.number.separators", new Object[0]);
        if (string == null) {
            PhpAddNumberSeparatorsIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpAddNumberSeparatorsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpAddNumberSeparatorsIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

