/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCastIsEvaluableInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpCastIsEvaluableInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpUnaryExpression(UnaryExpression expr) {
                PhpPsiElement value = expr.getValue();
                PsiElement operation = expr.getOperation();
                if (value == null || operation == null) {
                    return;
                }
                PhpType castType = PhpTypeAnalyserVisitor.getCastOperationType(PsiUtilCore.getElementType((PsiElement)operation));
                String replacementText = 1.getReplacementText((PsiElement)value, castType);
                if (replacementText == null) {
                    return;
                }
                holder.registerProblem(operation.getParent(), PhpBundle.message("inspection.message.cast.evaluable", replacementText), new LocalQuickFix[]{new PhpEvaluateCastQuickFix(replacementText)});
            }

            @Nullable
            private static String getReplacementText(PsiElement value, PhpType castType) {
                PsiElement actualValue;
                UnaryExpression maybeCompositeNumber = (UnaryExpression)ObjectUtils.tryCast((Object)(value = PhpPsiUtil.unparenthesize(value)), UnaryExpression.class);
                Object object = actualValue = maybeCompositeNumber == null ? value : maybeCompositeNumber.getValue();
                if (!PhpLangUtil.isScalar(actualValue)) {
                    return null;
                }
                PhpType valueType = new PhpType().add(value).global(value.getProject());
                if (valueType.equals((Object)castType)) {
                    return null;
                }
                if (maybeCompositeNumber != null) {
                    boolean literalIsNumber = Set.of(PhpType.INT, PhpType.FLOAT).contains(valueType);
                    boolean operationIsSupported = PhpPsiUtil.isOfType(maybeCompositeNumber.getOperation(), PhpTokenTypes.opMINUS, PhpTokenTypes.opPLUS);
                    if (!literalIsNumber || !operationIsSupported) {
                        return null;
                    }
                }
                return (String)ObjectUtils.doIfCast((Object)value, PhpExpression.class, literal -> Util.getCastResultText(literal, valueType, castType));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/type/PhpCastIsEvaluableInspection", "buildVisitor"));
    }

    private static final class Util {
        private static final Map<PhpType, Function<PhpExpression, @Nullable String>> INT_TRANSITIONS = Map.of(PhpType.BOOLEAN, Util::getBooleanTextFromNumber, PhpType.STRING, Util::getStringTextFromInt, PhpType.FLOAT, Util::getFloatTextFromInt);
        private static final Map<PhpType, Function<PhpExpression, @Nullable String>> FLOAT_TRANSITIONS = Map.of(PhpType.INT, Util::getIntTextFromFloat, PhpType.BOOLEAN, Util::getBooleanTextFromNumber);
        private static final Map<PhpType, Function<ConstantReference, @Nullable String>> BOOLEAN_TRANSITIONS = Map.of(PhpType.INT, Util::getIntTextFromBoolean, PhpType.STRING, Util::getStringTextFromBoolean, PhpType.FLOAT, Util::getFloatTextFromBoolean);
        private static final Map<PhpType, Function<StringLiteralExpression, @Nullable String>> STRING_TRANSITIONS = Map.of(PhpType.INT, Util::getIntTextFromString, PhpType.BOOLEAN, Util::getBooleanTextFromString);

        private Util() {
        }

        @Nullable
        public static String getCastResultText(PhpExpression literal, PhpType valueType, PhpType castType) {
            if (valueType.equals((Object)PhpType.INT)) {
                if (!Util.intLiteralIsSupported(literal)) {
                    return null;
                }
                return (String)ObjectUtils.doIfNotNull(INT_TRANSITIONS.get(castType), t -> (String)t.apply(literal));
            }
            if (valueType.equals((Object)PhpType.FLOAT)) {
                return (String)ObjectUtils.doIfNotNull(FLOAT_TRANSITIONS.get(castType), t -> (String)t.apply(literal));
            }
            if (valueType.equals((Object)PhpType.STRING)) {
                return (String)ObjectUtils.doIfNotNull(STRING_TRANSITIONS.get(castType), t -> (String)t.apply((StringLiteralExpression)literal));
            }
            if (PhpLangUtil.isTrue((PsiElement)literal) || PhpLangUtil.isFalse((PsiElement)literal)) {
                return (String)ObjectUtils.doIfNotNull(BOOLEAN_TRANSITIONS.get(castType), t -> (String)t.apply((ConstantReference)literal));
            }
            return null;
        }

        private static boolean intLiteralIsSupported(PhpExpression literal) {
            PsiElement value = (PsiElement)ObjectUtils.doIfCast((Object)literal, UnaryExpression.class, UnaryExpression::getValue);
            literal = value == null ? literal : (PhpExpression)value;
            return PhpTokenTypes.DECIMAL_INTEGER.equals(PsiUtilCore.getElementType((PsiElement)literal.getFirstChild()));
        }

        @NotNull
        private static String getBooleanTextFromNumber(PhpExpression literal) {
            String text = PhpPsiUtil.getLiteralText((PsiElement)literal);
            for (char c : text.toCharArray()) {
                if (c == '+' || c == '-' || c == '0' || c == '.') continue;
                return "true";
            }
            return "false";
        }

        @NotNull
        private static String getIntTextFromBoolean(ConstantReference literal) {
            return PhpLangUtil.isTrue(literal) ? "1" : "0";
        }

        @NotNull
        private static String getStringTextFromBoolean(ConstantReference literal) {
            return PhpLangUtil.isTrue(literal) ? "\"1\"" : "\"\"";
        }

        @Nullable
        private static String getIntTextFromString(StringLiteralExpression literal) {
            String text = literal.getContents().trim();
            if (text.isEmpty()) {
                return "0";
            }
            try {
                return String.valueOf(Long.parseLong(text));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @NotNull
        private static String getBooleanTextFromString(StringLiteralExpression literal) {
            String text = literal.getContents();
            return text.isEmpty() || text.equals("0") ? "false" : "true";
        }

        @NotNull
        private static String getFloatTextFromInt(PhpExpression literal) {
            String string = literal.getText() + ".0";
            if (string == null) {
                Util.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        private static String getFloatTextFromBoolean(ConstantReference literal) {
            return PhpLangUtil.isTrue(literal) ? "1.0" : "0.0";
        }

        @NotNull
        private static String getIntTextFromFloat(PhpExpression literal) {
            String result = PhpPsiUtil.getLiteralText((PsiElement)literal);
            String string = (result = result.substring(0, result.indexOf(46))).equals("-0") ? "0" : result;
            if (string == null) {
                Util.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static String getStringTextFromInt(PhpExpression element) {
            return String.format("\"%s\"", PhpPsiUtil.getLiteralText((PsiElement)element));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/php/lang/inspections/type/PhpCastIsEvaluableInspection$Util";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFloatTextFromInt";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIntTextFromFloat";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class PhpEvaluateCastQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myReplacementText;

        PhpEvaluateCastQuickFix(String replacementText) {
            this.myReplacementText = replacementText;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.evaluate.cast", this.myReplacementText);
            if (string == null) {
                PhpEvaluateCastQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("intention.name.evaluate.cast", new Object[0]);
            if (string == null) {
                PhpEvaluateCastQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpEvaluateCastQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpEvaluateCastQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpEvaluateCastQuickFix.$$$reportNull$$$0(4);
            }
            UnaryExpression replaceable = (UnaryExpression)element;
            PhpExpression replacement = PhpPsiElementFactory.createFirstFromText(project, PhpExpression.class, this.myReplacementText);
            if (replacement != null) {
                replaceable.replace((PsiElement)replacement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpCastIsEvaluableInspection$PhpEvaluateCastQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpCastIsEvaluableInspection$PhpEvaluateCastQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

