/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.strictStandards;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpTraitUseRuleImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpSuperClassIncompatibleWithInterfaceInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpSuperClassIncompatibleWithInterfaceInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public void visitPhpClass(PhpClass clazz) {
                if (clazz.isInterface() || clazz.isTrait()) {
                    return;
                }
                if (clazz.getSuperFQN() == null && !clazz.hasTraitUses() || clazz.getInterfaceNames().length == 0) {
                    return;
                }
                Set ownMethodsNames = ((StreamEx)StreamEx.of((Object[])clazz.getOwnMethods()).filter(Predicate.not(PhpDocMethod.class::isInstance))).map(PhpNamedElement::getName).toSet();
                MultiMap<String, Method> interfacesImplicitMethods = 1.getInterfacesImplicitMethods(clazz, ownMethodsNames);
                if (interfacesImplicitMethods.isEmpty()) {
                    return;
                }
                Ref classMethod = new Ref(null);
                Ref interfaceMethod = new Ref(null);
                @Nls Ref reason = new Ref(null);
                Ref target = new Ref((Object)clazz.getExtendsList());
                Set processedMethodNamesFromTraits = CollectionFactory.createCaseInsensitiveStringSet();
                Set processedMethodNamesFromClass = CollectionFactory.createCaseInsensitiveStringSet();
                PhpClassHierarchyUtils.processMethods((PhpClass)clazz, (PhpClass)clazz, (method, subClass, baseClass) -> {
                    if ((method instanceof PhpTraitUseRuleImpl.TraitUseRuleRenameableFakePsiElement || subClass.isTrait()) && !method.isAbstract() ? !processedMethodNamesFromTraits.add(method.getName()) : method instanceof PhpDocMethod || processedMethodNamesFromTraits.contains(method.getName())) {
                        return true;
                    }
                    PhpClass superClass = method.getContainingClass();
                    if (superClass == null || superClass.isInterface()) {
                        return true;
                    }
                    String methodName = method.getName();
                    if (!subClass.isTrait() && !processedMethodNamesFromClass.add(methodName)) {
                        return true;
                    }
                    for (Method implementedMethod : interfacesImplicitMethods.get((Object)methodName)) {
                        if (implementedMethod == method || ownMethodsNames.contains(methodName) || implementedMethod instanceof PhpDocMethod) continue;
                        boolean interfaceMethodStatic = implementedMethod.isStatic();
                        if (method.isStatic() != interfaceMethodStatic) {
                            if (interfaceMethodStatic) {
                                reason.set((Object)PhpBundle.message("cannot.make.interface.method.non.static", new Object[0]));
                            } else {
                                reason.set((Object)PhpBundle.message("cannot.make.interface.method.static", new Object[0]));
                            }
                        } else if (implementedMethod.getAccess().isWeakerThan(method.getAccess())) {
                            reason.set((Object)PhpBundle.message("access.must.be.public", new Object[0]));
                        } else if (PhpHierarchyChecksInspection.areDeclarationsFullyCompatible(method, implementedMethod, clazz)) continue;
                        classMethod.set((Object)method);
                        interfaceMethod.set((Object)implementedMethod);
                        if (superClass.isTrait()) {
                            target.set((Object)1.findContainingInterface(clazz.getImplementsList(), implementedMethod));
                        }
                        return false;
                    }
                    return true;
                }, (boolean)false, (boolean)false);
                if (classMethod.get() != null && interfaceMethod.get() != null) {
                    PhpClass superClass = ((Method)classMethod.get()).getContainingClass();
                    PhpClass anInterface = ((Method)interfaceMethod.get()).getContainingClass();
                    if (superClass != null && anInterface != null) {
                        holder.registerProblem((PsiElement)target.get(), this.getMessage(superClass, (Method)classMethod.get(), anInterface, (Method)interfaceMethod.get(), (String)reason.get()), new LocalQuickFix[0]);
                    }
                }
            }

            @NotNull
            private static PsiElement findContainingInterface(@NotNull ImplementsList implementsList, @NotNull Method method) {
                PhpClass containingInterface;
                if (implementsList == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (method == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((containingInterface = method.getContainingClass()) != null) {
                    String containingInterfaceFqn = containingInterface.getFQN();
                    for (ClassReference implementedInterface : implementsList.getReferenceElements()) {
                        if (!PhpLangUtil.equalsClassNames(containingInterfaceFqn, implementedInterface.getFQN())) continue;
                        ClassReference classReference = implementedInterface;
                        if (classReference == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return classReference;
                    }
                }
                ImplementsList implementsList2 = implementsList;
                if (implementsList2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                return implementsList2;
            }

            @NotNull
            private static MultiMap<String, Method> getInterfacesImplicitMethods(@NotNull PhpClass clazz, @NotNull Set<String> ownMethodsNames) {
                if (clazz == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (ownMethodsNames == null) {
                    1.$$$reportNull$$$0(5);
                }
                MultiMap interfacesImplicitMethods = MultiMap.create();
                PhpClassHierarchyUtils.processSuperInterfaces((PhpClass)clazz, (boolean)false, (boolean)false, anInterface -> {
                    for (Method method : anInterface.getOwnMethods()) {
                        String name = method.getName();
                        if (ownMethodsNames.contains(name)) continue;
                        interfacesImplicitMethods.putValue((Object)name, (Object)method);
                    }
                    return true;
                });
                MultiMap multiMap = interfacesImplicitMethods;
                if (multiMap == null) {
                    1.$$$reportNull$$$0(6);
                }
                return multiMap;
            }

            @NotNull
            @InspectionMessage
            private String getMessage(@NotNull PhpClass superClass, @NotNull Method superClassMethod, @NotNull PhpClass anInterface, @NotNull Method interfaceMethod, @Nullable String reason) {
                if (superClass == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (superClassMethod == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (anInterface == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (interfaceMethod == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (!isOnTheFly) {
                    String string = PhpBundle.message("declaration.in.parent.class.is.incompatible.with.interface", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(11);
                    }
                    return string;
                }
                String baseMessage = PhpBundle.message("inspection.super.incompatible.with.interface.declaration.must.be.compatible", PhpHierarchyChecksInspection.buildSuperName(superClassMethod, superClass), PhpHierarchyChecksInspection.buildSuperName(interfaceMethod, anInterface));
                String string = reason != null ? PhpBundle.message("0.1", baseMessage, reason) : baseMessage;
                if (string == null) {
                    1.$$$reportNull$$$0(12);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 6, 11, 12 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "implementsList";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 11: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/strictStandards/PhpSuperClassIncompatibleWithInterfaceInspection$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clazz";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ownMethodsNames";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "superClass";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "superClassMethod";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "anInterface";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "interfaceMethod";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/strictStandards/PhpSuperClassIncompatibleWithInterfaceInspection$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findContainingInterface";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInterfacesImplicitMethods";
                        break;
                    }
                    case 11: 
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMessage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "findContainingInterface";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "getInterfacesImplicitMethods";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "getMessage";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 6, 11, 12 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/strictStandards/PhpSuperClassIncompatibleWithInterfaceInspection", "buildVisitor"));
    }
}

