/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.type;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeReturnTypeQuickFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final PhpType myNewType;
    @NotNull
    private final String myTypePresentation;
    @NotNull
    private final String myCurrentTypePresentation;

    public PhpChangeReturnTypeQuickFix(Project project, @NotNull PhpType currentType, @NotNull PhpType newType) {
        if (currentType == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(0);
        }
        if (newType == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(1);
        }
        this.myNewType = newType;
        this.myCurrentTypePresentation = StringUtil.notNullize((String)PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, currentType, null, true));
        this.myTypePresentation = StringUtil.notNullize((String)PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, newType, null, true));
    }

    @Nls
    @NotNull
    public String getName() {
        String string = PhpBundle.message("quickfix.strict.type.checking.change.return.type.name", this.myCurrentTypePresentation, this.myTypePresentation);
        if (string == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.strict.type.checking.change.return.type.family", new Object[0]);
        if (string == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Function function;
        if (project == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(6);
        }
        if ((function = PhpChangeReturnTypeQuickFix.getFunctionByReturnStatement(element)) == null) {
            return;
        }
        PhpChangeReturnTypeQuickFix.changeReturnType(function, this.myNewType);
    }

    public static void changeReturnType(@NotNull Function function, @NotNull PhpType newType) {
        PhpDocComment phpDoc;
        PhpReturnType returnType;
        if (function == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(7);
        }
        if (newType == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(8);
        }
        if ((returnType = (PhpReturnType)function.getTypeDeclaration()) != null) {
            returnType.update(newType);
        }
        if ((phpDoc = function.getDocComment()) != null) {
            PhpTypeDeclarationImpl.update((PhpDocTag)phpDoc.getReturnTag(), newType);
        }
    }

    @Nullable
    public static Function getFunctionByReturnStatement(@Nullable PsiElement element) {
        Condition stopAt = Conditions.or((Condition)PhpClass.INSTANCEOF, (Condition)PhpNamespace.INSTANCEOF);
        return (Function)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)stopAt);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpChangeReturnTypeQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpChangeReturnTypeQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "changeReturnType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

