/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseImportQuickFix;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpAttributesFQNsIndex;
import com.jetbrains.php.statistics.PhpImportClassUsagesCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PhpImportClassQuickFix
extends PhpBaseImportQuickFix<PhpClass> {
    public static final PhpImportClassQuickFix INSTANCE = new PhpImportClassQuickFix();
    public static final String[] IGNORABLE_NAMESPACES = new String[]{"\\___PHPSTORM_HELPERS\\"};

    @NotNull
    public String getFamilyName() {
        String string = PhpImportClassQuickFix.getNameText();
        if (string == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void applyDirectly(@NotNull Project project, PhpReference classReference, PhpNamedElement candidate) {
        if (project == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(1);
        }
        super.applyDirectly(project, classReference, candidate);
        if (!IntentionPreviewUtils.isPreviewElement((PsiElement)classReference)) {
            PhpImportClassUsagesCollector.IMPORT_CLASS_INVOKED.log((Object)0, (Object)PhpImportClassUsagesCollector.getPlace(classReference));
        }
    }

    @Override
    protected void showPopup(@NotNull Project project, PhpReference classReference, List<PhpNamedElement> allCandidates, Editor editor) {
        if (project == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(2);
        }
        super.showPopup(project, classReference, allCandidates, editor);
        if (!IntentionPreviewUtils.isPreviewElement((PsiElement)classReference)) {
            PhpImportClassUsagesCollector.IMPORT_CLASS_INVOKED.log((Object)allCandidates.size(), (Object)PhpImportClassUsagesCollector.getPlace(classReference));
        }
    }

    @Override
    protected void chooseElement(@NotNull Project project, @NotNull PhpNamedElement element, PhpReference classReference, List<PhpNamedElement> allCandidates) {
        if (project == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(4);
        }
        super.chooseElement(project, element, classReference, allCandidates);
        if (IntentionPreviewUtils.isPreviewElement((PsiElement)classReference)) {
            return;
        }
        PhpImportClassUsagesCollector.IMPORT_CLASS_POPUP_CLOSED.log((Object)allCandidates.size(), (Object)PhpImportClassUsagesCollector.getPlace(classReference));
    }

    @Override
    protected void applyFixFromPopup(@NotNull Project project, PhpReference classReference, @NotNull PhpNamedElement element, List<PhpNamedElement> allCandidates) {
        if (project == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(6);
        }
        super.applyFixFromPopup(project, classReference, element, allCandidates);
        PhpImportClassUsagesCollector.IMPORT_CLASS_INVOKED_FROM_POPUP.log((Object)allCandidates.size(), (Object)PhpImportClassUsagesCollector.getPlace(classReference), (Object)allCandidates.indexOf(element));
    }

    @Override
    @NlsContexts.Command
    @NotNull
    protected String getCommandName() {
        String string = PhpImportClassQuickFix.getNameText();
        if (string == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getImportPopupTitle() {
        String string = PhpBundle.message("quickfix.import.class.popup.title", new Object[0]);
        if (string == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getImportKeyword() {
        return null;
    }

    @Override
    protected void replaceReference(@NotNull Project project, @NotNull PhpReference reference, @NotNull String fqn) {
        if (project == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(9);
        }
        if (reference == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(10);
        }
        if (fqn == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(11);
        }
        ClassReference qualifiedClassReference = PhpPsiElementFactory.createClassReference(project, PhpLangUtil.toPresentableFQN(fqn));
        reference.replace((PsiElement)qualifiedClassReference);
    }

    @Override
    @NotNull
    public Collection<PhpClass> getCandidates(@NotNull Project project, @NotNull PhpReference reference) {
        if (project == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(12);
        }
        if (reference == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(13);
        }
        String name = PhpType.isPluralType((String)reference.getText()) ? StringUtil.trimEnd((String)reference.getText(), (String)"[]") : reference.getText();
        LinkedHashMap<String, PhpClass> candidates = new LinkedHashMap<String, PhpClass>();
        PhpImportClassQuickFix.addFilteredClasses(candidates, PhpImportClassQuickFix.getImportOptions(reference).getClasses(project, name));
        Collection<PhpClass> collection = candidates.values();
        if (collection == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(14);
        }
        return collection;
    }

    private static void addFilteredClasses(@NotNull Map<String, PhpClass> targetList, @NotNull Collection<PhpClass> sourceClasses) {
        if (targetList == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(15);
        }
        if (sourceClasses == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(16);
        }
        for (PhpClass phpClass : sourceClasses) {
            String namespace = phpClass.getNamespaceName();
            boolean ignore = false;
            for (String ignorableNamepsace : IGNORABLE_NAMESPACES) {
                if (!ignorableNamepsace.equals(namespace)) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            targetList.put(phpClass.getFQN(), phpClass);
        }
    }

    @NotNull
    public static Options getImportOptions(@NotNull PhpReference classReference) {
        PsiElement target;
        IElementType targetType;
        if (classReference == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(17);
        }
        if ((targetType = PsiUtilCore.getElementType((PsiElement)(target = classReference.getParent()))) == PhpStubElementTypes.ATTRIBUTE) {
            Options options = Options.IMPORT_ATTRIBUTES;
            if (options == null) {
                PhpImportClassQuickFix.$$$reportNull$$$0(18);
            }
            return options;
        }
        if (targetType == PhpStubElementTypes.USE && PhpPsiUtil.getParentOfClass(target, PhpClass.class) != null) {
            Options options = Options.IMPORT_TRAITS;
            if (options == null) {
                PhpImportClassQuickFix.$$$reportNull$$$0(19);
            }
            return options;
        }
        if (targetType == PhpElementTypes.IMPLEMENTS_LIST) {
            Options options = Options.IMPORT_INTERFACES;
            if (options == null) {
                PhpImportClassQuickFix.$$$reportNull$$$0(20);
            }
            return options;
        }
        if (targetType == PhpElementTypes.EXTENDS_LIST || targetType == PhpElementTypes.NEW_EXPRESSION) {
            Options options = Options.IMPORT_CLASSES;
            if (options == null) {
                PhpImportClassQuickFix.$$$reportNull$$$0(21);
            }
            return options;
        }
        Options options = Options.IMPORT_ALL;
        if (options == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(22);
        }
        return options;
    }

    @IntentionFamilyName
    public static String getNameText() {
        return PhpBundle.message("quickfix.import.class.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpImportClassQuickFix";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetList";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClasses";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpImportClassQuickFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPopupTitle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyDirectly";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "chooseElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFixFromPopup";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceReference";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCandidates";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addFilteredClasses";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getImportOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Options {
        IMPORT_INTERFACES{

            @Override
            public Collection<PhpClass> getClasses(Project project, String name) {
                return PhpIndex.getInstance((Project)project).getInterfacesByName(name);
            }
        }
        ,
        IMPORT_CLASSES{

            @Override
            public Collection<PhpClass> getClasses(Project project, String name) {
                return PhpIndex.getInstance((Project)project).getClassesByName(name);
            }
        }
        ,
        IMPORT_TRAITS{

            @Override
            public Collection<PhpClass> getClasses(Project project, String name) {
                return PhpIndex.getInstance((Project)project).getTraitsByName(name);
            }
        }
        ,
        IMPORT_ALL{

            @Override
            public Collection<PhpClass> getClasses(Project project, String name) {
                ArrayList<PhpClass> res = new ArrayList<PhpClass>();
                res.addAll(IMPORT_CLASSES.getClasses(project, name));
                res.addAll(IMPORT_INTERFACES.getClasses(project, name));
                res.addAll(IMPORT_TRAITS.getClasses(project, name));
                return res;
            }
        }
        ,
        IMPORT_ATTRIBUTES{

            @Override
            public @Unmodifiable Collection<PhpClass> getClasses(Project project, String name) {
                return ContainerUtil.filter(IMPORT_ALL.getClasses(project, name), PhpAttributesFQNsIndex::hasRootAttribute);
            }
        };


        public abstract @Unmodifiable Collection<PhpClass> getClasses(Project var1, String var2);
    }
}

