/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.codeInsight.navigation.TargetPresentationProvider;
import com.intellij.codeInsight.navigation.impl.PsiTargetPresentationRenderer;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpStormAttributesDeclarationFilter;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.intentions.PhpReplaceWithAliasIntention;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpBaseImportQuickFix<E extends PhpNamedElement>
extends PhpQuickFixBase {
    private static final Comparator<PhpNamedElement> VENDOR_COMPARATOR = Comparator.comparingInt(c -> PhpStormAttributesDeclarationFilter.isInsideVendorDir(c) ? 1 : -1);
    private static final Comparator<PhpNamedElement> GLOBAL_STUB_ELEMENTS_COMPARATOR = Comparator.comparingInt(c -> {
        VirtualFile file = c.getContainingFile().getVirtualFile();
        if (!PhpRuntimeLibraryRootsProvider.isInStubRoots(c.getProject(), file)) {
            return 0;
        }
        return PhpLangUtil.isGlobalNamespaceName(PhpLangUtil.getParentQualifiedName(c.getFQN())) ? -1 : 1;
    });

    public boolean isApplicable(PsiElement element) {
        PhpReference classReference = PhpBaseImportQuickFix.getReference(element);
        if (classReference == null) {
            return false;
        }
        return !this.getAllCandidates(element.getProject(), classReference).isEmpty();
    }

    public boolean isAutomaticallyApplicable(PsiElement element) {
        PhpReference classReference = PhpBaseImportQuickFix.getReference(element);
        if (classReference == null) {
            return false;
        }
        return this.getAllCandidates(element.getProject(), classReference).size() == 1;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        PhpReference classReference;
        if (project == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(1);
        }
        if ((classReference = PhpBaseImportQuickFix.getReference(element = descriptor.getPsiElement())) == null) {
            return;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            this.showIsInDumpModeMessage(project, element);
            return;
        }
        List<PhpNamedElement> allCandidates = this.getAllCandidates(project, classReference);
        if (allCandidates.isEmpty()) {
            return;
        }
        if (IntentionPreviewUtils.isPreviewElement((PsiElement)element)) {
            allCandidates = Collections.singletonList((PhpNamedElement)ContainerUtil.getFirstItem(allCandidates));
        }
        if (allCandidates.size() > 1) {
            Editor editor = PsiEditorUtil.findEditor((PsiElement)classReference);
            if (editor == null) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.applyDirectly(project, classReference, allCandidates.iterator().next());
                return;
            }
            this.showPopup(project, classReference, allCandidates, editor);
        } else {
            this.applyDirectly(project, classReference, allCandidates.iterator().next());
        }
    }

    protected void applyDirectly(@NotNull Project project, PhpReference classReference, PhpNamedElement candidate) {
        if (project == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(2);
        }
        WriteAction.run(() -> this.applyFix(project, classReference, candidate));
    }

    protected void showPopup(@NotNull Project project, PhpReference classReference, List<PhpNamedElement> allCandidates, Editor editor) {
        if (project == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(3);
        }
        PsiTargetPresentationRenderer<PhpNamedElement> renderer = new PsiTargetPresentationRenderer<PhpNamedElement>(){

            @Nls
            @NotNull
            public String getElementText(@NotNull PhpNamedElement e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String presentableFQN = PhpLangUtil.toPresentableFQN(e.getFQN());
                Object object = e instanceof PhpUse ? presentableFQN + " (" + e.getName() + ")" : presentableFQN;
                if (object == null) {
                    1.$$$reportNull$$$0(1);
                }
                return object;
            }

            @Nls
            @Nullable
            public String getContainerText(@NotNull PhpNamedElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpBaseImportQuickFix$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpBaseImportQuickFix$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElementText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getElementText";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getContainerText";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        PsiTargetNavigator navigator = new PsiTargetNavigator(allCandidates).presentationProvider((TargetPresentationProvider)renderer).builderConsumer(builder2 -> {
            builder2.setFont(EditorUtil.getEditorFont()).withHintUpdateSupply();
            builder2.setItemChosenCallback(element -> {
                PhpNamedElement psi = (PhpNamedElement)ObjectUtils.tryCast((Object)element.dereference(), PhpNamedElement.class);
                if (psi == null) {
                    return;
                }
                this.chooseElement(project, psi, classReference, allCandidates);
            });
            JScrollPane pane = ((PopupChooserBuilder)builder2).getScrollPane();
            if (pane == null) {
                return;
            }
            pane.setBorder(null);
            pane.setViewportBorder(null);
        });
        JBPopup popup = navigator.createPopup(project, this.getImportPopupTitle());
        NavigationUtil.hidePopupIfDumbModeStarts((JBPopup)popup, (Project)project);
        popup.showInBestPositionFor(editor);
    }

    protected void chooseElement(@NotNull Project project, @NotNull PhpNamedElement element, PhpReference classReference, List<PhpNamedElement> allCandidates) {
        if (project == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(5);
        }
        this.applyFixFromPopup(project, classReference, element, allCandidates);
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected void applyFixFromPopup(@NotNull Project project, PhpReference classReference, @NotNull PhpNamedElement element, List<PhpNamedElement> allCandidates) {
        if (project == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(6);
        }
        if (element == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(7);
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> this.applyFix(project, classReference, element)), this.getCommandName(), (Object)this);
    }

    @NotNull
    private List<PhpNamedElement> getAllCandidates(@NotNull Project project, PhpReference classReference) {
        PhpPsiElement scopeForUseOperator;
        if (project == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(8);
        }
        if ((scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)classReference)) == null) {
            List<PhpNamedElement> list = Collections.emptyList();
            if (list == null) {
                PhpBaseImportQuickFix.$$$reportNull$$$0(9);
            }
            return list;
        }
        ArrayList<E> candidates = new ArrayList<E>(this.getCandidates(project, classReference));
        if (candidates.size() > 1) {
            ContainerUtil.sort(candidates, PhpBaseImportQuickFix.getCandidatesComparator(scopeForUseOperator));
        }
        Collection<PhpUse> aliasesCandidates = this.getImportedAliasesCandidates(PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)classReference), candidates);
        SmartList allCandidates = new SmartList();
        allCandidates.addAll(aliasesCandidates);
        allCandidates.addAll(candidates);
        SmartList smartList = allCandidates;
        if (smartList == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    private static Comparator<PhpNamedElement> getCandidatesComparator(PhpPsiElement scopeForUseOperator) {
        return VENDOR_COMPARATOR.thenComparing(PhpBaseImportQuickFix.getCommonNamespaceComparator(scopeForUseOperator)).thenComparing(GLOBAL_STUB_ELEMENTS_COMPARATOR);
    }

    private static Comparator<PhpNamedElement> getCommonNamespaceComparator(PhpPsiElement scopeForUseOperator) {
        return Comparator.comparingInt(c -> PhpBaseImportQuickFix.countCommonNamespaceParts(c, scopeForUseOperator)).reversed();
    }

    private static <E extends PhpNamedElement> int countCommonNamespaceParts(E element, PhpPsiElement scope) {
        int i;
        List<String> currentNamespaceParts = PhpBaseImportQuickFix.getNamespaceParts(scope);
        List<String> elementNamespaceParts = PhpBaseImportQuickFix.getNamespaceParts(element);
        for (i = 0; i < Math.min(currentNamespaceParts.size(), elementNamespaceParts.size()) && currentNamespaceParts.get(i).equals(elementNamespaceParts.get(i)); ++i) {
        }
        return i;
    }

    @NotNull
    private static List<String> getNamespaceParts(PhpPsiElement scope) {
        List list = StringUtil.split((String)PhpLangUtil.toPresentableFQN(PhpNamedElementImpl.getNamespace((PsiElement)scope)), (String)"\\");
        if (list == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NlsContexts.Command
    @NotNull
    protected abstract String getCommandName();

    @Nullable
    public static PhpReference getReference(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(12);
        }
        if (!((parent = element.getParent()) instanceof PhpReference)) {
            return null;
        }
        return (PhpReference)parent;
    }

    @NlsContexts.PopupTitle
    @NotNull
    protected abstract String getImportPopupTitle();

    public void applyFix(@NotNull Project project, @NotNull PhpReference referenceToImport, @NotNull PhpNamedElement definition) {
        if (project == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(13);
        }
        if (referenceToImport == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(14);
        }
        if (definition == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(15);
        }
        if (!IntentionPreviewUtils.isPreviewElement((PsiElement)referenceToImport) && !CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)referenceToImport)) {
            return;
        }
        if (definition instanceof PhpUse) {
            PhpReplaceWithAliasIntention.replaceReference(project, (PsiReference)referenceToImport, definition.getName());
            return;
        }
        String fqn = definition.getFQN();
        if (!PhpLangUtil.isFqn(fqn)) {
            return;
        }
        PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)referenceToImport);
        if (scopeForUseOperator == null) {
            return;
        }
        PhpGroupUseElement.PhpUseKeyword useKeyword = PhpBaseImportQuickFix.getKeyword(referenceToImport);
        PhpUseList useList = PhpUseImpl.getUseList((PsiElement)referenceToImport);
        if (useList != null && !useList.isTraitImport()) {
            PhpNamespaceReference namespaceReference = useList.getNamespaceReference();
            if (namespaceReference == null) {
                this.replaceReference(project, referenceToImport, fqn);
            } else {
                String globalName = PhpLangUtil.toFQN(namespaceReference.getFullName());
                if (fqn.startsWith(globalName)) {
                    this.replaceReference(project, referenceToImport, fqn.substring(globalName.length()));
                } else {
                    this.importIfNeeded(scopeForUseOperator, fqn, useKeyword);
                    PhpUse use = (PhpUse)PhpPsiUtil.getParentByCondition((PsiElement)referenceToImport, (Condition<? super PsiElement>)PhpUse.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                    PhpCodeEditUtil.deleteUseOrUseList(use, useList);
                }
            }
        } else {
            this.importIfNeeded(scopeForUseOperator, fqn, useKeyword);
        }
    }

    private void importIfNeeded(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn, PhpGroupUseElement.PhpUseKeyword keyword) {
        if (scopeForUseOperator == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(16);
        }
        if (fqn == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(17);
        }
        String alias = PhpCodeInsightUtil.findImportedName(scopeForUseOperator, fqn, keyword);
        if (!PhpCodeInsightUtil.isSameNamespace(scopeForUseOperator, fqn) && !PhpLangUtil.equalsClassNames(alias, PhpLangUtil.toShortName(fqn))) {
            PhpAliasImporter.insertUseStatementWithKeyword(this.getImportKeyword(), fqn, null, scopeForUseOperator);
        }
    }

    @Nullable
    protected abstract String getImportKeyword();

    protected abstract void replaceReference(@NotNull Project var1, @NotNull PhpReference var2, @NotNull String var3);

    @NotNull
    public abstract Collection<E> getCandidates(@NotNull Project var1, @NotNull PhpReference var2);

    @NotNull
    private Collection<PhpUse> getImportedAliasesCandidates(@Nullable PhpPsiElement scope, @NotNull Collection<E> candidates) {
        if (candidates == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            List<PhpUse> list = Collections.emptyList();
            if (list == null) {
                PhpBaseImportQuickFix.$$$reportNull$$$0(19);
            }
            return list;
        }
        Set candidatesFqns = CollectionFactory.createCaseInsensitiveStringSet((Collection)ContainerUtil.map(candidates, PhpNamedElement::getFQN));
        SmartList result = new SmartList();
        for (PhpUseList anImport : PhpCodeInsightUtil.collectImports(scope)) {
            for (PhpUse declaration : anImport.getDeclarations()) {
                String importKeyword = StringUtil.nullize((String)PhpGroupUseElement.getKeyword(declaration, anImport));
                if (declaration.getAliasName() == null || !candidatesFqns.contains(declaration.getFQN()) || !StringUtil.equalsIgnoreCase((CharSequence)importKeyword, (CharSequence)this.getImportKeyword())) continue;
                result.add(declaration);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(20);
        }
        return smartList;
    }

    public static PhpGroupUseElement.PhpUseKeyword getKeyword(PhpReference element) {
        if (element instanceof FunctionReference) {
            return PhpGroupUseElement.PhpUseKeyword.FUNCTION;
        }
        if (element instanceof ConstantReference) {
            return PhpGroupUseElement.PhpUseKeyword.CONSTANT;
        }
        return PhpGroupUseElement.PhpUseKeyword.CLASS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpBaseImportQuickFix";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceToImport";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForUseOperator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpBaseImportQuickFix";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCandidates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceParts";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedAliasesCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyDirectly";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "chooseElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFixFromPopup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllCandidates";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "importIfNeeded";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getImportedAliasesCandidates";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 19, 20 -> new IllegalStateException(string);
        };
    }
}

