/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.psr12;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.intentions.groupUse.PhpSplitSelectedGroupUseStatementIntention;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpCompoundNamespaceDepthInspection
extends PhpInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpCompoundNamespaceDepthInspection.$$$reportNull$$$0(0);
        }
        final ExtractUseQuickFix QUICK_FIX = ExtractUseQuickFix.createInstance();
        return new PhpElementVisitor(){

            public void visitPhpUse(PhpUse expression) {
                PhpReference reference;
                PsiElement parent = expression.getParent().getParent();
                if (parent instanceof PhpUseList && (reference = expression.getTargetReference()) != null && StringUtil.countChars((CharSequence)reference.getImmediateNamespaceName(), (char)'\\') > 1) {
                    holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.message.psr.compound.namespace.with.depth.more.than.two.levels", new Object[0]), new LocalQuickFix[]{QUICK_FIX});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/psr12/PhpCompoundNamespaceDepthInspection", "buildVisitor"));
    }

    private static final class ExtractUseQuickFix
    extends PsiUpdateModCommandQuickFix {
        private ExtractUseQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("psr.12.extract.namespace", new Object[0]);
            if (string == null) {
                ExtractUseQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpUseList useList;
            if (project == null) {
                ExtractUseQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ExtractUseQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ExtractUseQuickFix.$$$reportNull$$$0(3);
            }
            if ((useList = PhpPsiUtil.getParentOfClass(element, PhpUseList.class)) != null) {
                if (useList.getDeclarations().length > 1) {
                    PhpUse use = PhpPsiUtil.getParentOfClass(element, PhpUse.class);
                    PhpNamespaceReference namespaceReference = useList.getNamespaceReference();
                    if (namespaceReference != null && use != null) {
                        PhpUseList newUseList = PhpPsiElementFactory.createUseStatementWithKeyword(project, PhpGroupUseElement.getKeyword(use, useList), PhpLangUtil.concat(PhpLangUtil.toFQN(namespaceReference.getFullName()), PhpUseImpl.getReferenceText(use)), use.getAliasName());
                        useList.getParent().addBefore((PsiElement)newUseList, (PsiElement)useList);
                        PhpCodeEditUtil.deleteUseOrUseList(use, useList);
                    }
                } else {
                    PhpSplitSelectedGroupUseStatementIntention.splitUseList(project, useList);
                }
            }
        }

        private static ExtractUseQuickFix createInstance() {
            return new ExtractUseQuickFix();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/psr12/PhpCompoundNamespaceDepthInspection$ExtractUseQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/psr12/PhpCompoundNamespaceDepthInspection$ExtractUseQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

