/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.psr0;

import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileModCommand;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.psr0.FixPackagePathFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpMoveClassToCorrespondingDirectoryQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.roots.PhpNamespaceByPsrProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIllegalPsrClassPathInspection
extends PhpInspection {
    public static final String SUPPORT = "_support";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpIllegalPsrClassPathInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFile(PhpFile file) {
                PsiElement identifier;
                PhpClass clazz = 1.findMainClass(FileUtilRt.getNameWithoutExtension((String)file.getName()), (PsiElement)file);
                if (clazz != null && (identifier = clazz.getNameIdentifier()) != null) {
                    this.processClass(clazz, clazz.getContainingFile(), "", identifier);
                }
            }

            public void visitPhpNamespace(PhpNamespace namespace) {
                PsiFile file = namespace.getContainingFile();
                PhpClass clazz = 1.findMainClass(FileUtilRt.getNameWithoutExtension((String)file.getName()), (PsiElement)namespace);
                if (clazz == null) {
                    return;
                }
                PsiElement identifier = namespace.getNameIdentifier();
                if (identifier == null) {
                    identifier = PhpPsiUtil.getChildOfType((PsiElement)namespace, PhpTokenTypes.kwNAMESPACE);
                }
                if (identifier != null) {
                    this.processClass(clazz, file, StringUtil.notNullize((String)namespace.getFQN()), identifier);
                }
            }

            @Nullable
            private static PhpClass findMainClass(@Nullable String fileName, @Nullable PsiElement root) {
                Object group = PhpPsiUtil.getChildByCondition(root, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
                List<PhpClass> classes = PhpPsiUtil.getChildren((PsiElement)(group == null ? root : group), (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                if (classes.isEmpty()) {
                    return null;
                }
                for (PhpClass clazz : classes) {
                    if (!PhpLangUtil.equalsIgnoreCase(clazz.getNameCS(), fileName)) continue;
                    return clazz;
                }
                return classes.iterator().next();
            }

            private void processClass(@NotNull PhpClass clazz, @NotNull PsiFile file, @NotNull String namespace, @Nullable PsiElement namespaceIdentifier) {
                ProjectFileIndex fileIndex;
                if (clazz == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (namespace == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!(fileIndex = ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex()).isInSourceContent(file.getVirtualFile())) {
                    return;
                }
                PsiDirectory directory = file.getContainingDirectory();
                if (directory == null) {
                    return;
                }
                List namespaces = PhpNamespaceByPsrProvider.INSTANCE.suggestNamespaces(directory);
                if (fileIndex.isInTestSourceContent(file.getVirtualFile()) && ContainerUtil.exists(namespaces, i -> i.contains(PhpIllegalPsrClassPathInspection.SUPPORT))) {
                    namespaces = ContainerUtil.map(namespaces, i -> StringUtil.join((Collection)ContainerUtil.filter((Collection)StringUtil.split((String)i, (String)"\\"), j -> !PhpIllegalPsrClassPathInspection.SUPPORT.equals(j)), (String)"\\"));
                }
                if (namespaces.isEmpty()) {
                    return;
                }
                String presentableFqn = PhpLangUtil.toPresentableFQN(namespace);
                if (namespaces.contains(presentableFqn)) {
                    PsiElement element;
                    String fileName = FileUtilRt.getNameWithoutExtension((String)file.getName());
                    if (!PhpLangUtil.equals(fileName, clazz.getNameCS()) && (element = clazz.getNameIdentifier()) != null) {
                        LocalQuickFix[] localQuickFixArray;
                        String newFileName = clazz.getName() + "." + String.valueOf(FileUtilRt.getExtension((CharSequence)file.getName(), (String)""));
                        String string = PhpBundle.message("inspection.illegal.psr.class.path.class.is.not.matched.to.psr0", StringUtil.capitalize((String)PhpIllegalPsrClassPathInspection.getClassKeyword(clazz)));
                        if (isOnTheFly) {
                            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
                            localQuickFixArray2[0] = new MyRenameElementFix(clazz, fileName);
                            localQuickFixArray = localQuickFixArray2;
                            localQuickFixArray2[1] = LocalQuickFix.from((ModCommandAction)new RenameFileModCommand(newFileName).withPresentation(pres -> Presentation.of((String)PhpBundle.message("rename.filename.quick.fix", fileName, newFileName))));
                        } else {
                            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                        }
                        holder.registerProblem(element, string, localQuickFixArray);
                    }
                } else if (namespaceIdentifier != null) {
                    ArrayList<Object> fixes = new ArrayList<Object>();
                    if (isOnTheFly) {
                        fixes.add(new FixPackagePathFix((String)namespaces.get(0), presentableFqn));
                        if (PhpMoveClassToCorrespondingDirectoryQuickFix.isAvailable(file, presentableFqn)) {
                            fixes.add(new PhpMoveClassToCorrespondingDirectoryQuickFix(file, presentableFqn));
                        }
                    }
                    holder.registerProblem(namespaceIdentifier, PhpBundle.message("inspection.illegal.psr.class.path.namespace.name.is.not.matched.to.psr0", new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "clazz";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "namespace";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/psr0/PhpIllegalPsrClassPathInspection$1";
                objectArray[2] = "processClass";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static String getClassKeyword(PhpClass clazz) {
        return clazz.isTrait() ? "trait" : (clazz.isInterface() ? "interface" : "class");
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.settingLink((String)PhpBundle.message("directories", new Object[0]), (String)"web-ide.project.structure")});
        if (optPane == null) {
            PhpIllegalPsrClassPathInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/psr0/PhpIllegalPsrClassPathInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/psr0/PhpIllegalPsrClassPathInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class MyRenameElementFix
    extends RenameElementFix {
        private final String myFileName;

        private MyRenameElementFix(@NotNull PhpClass clazz, String fileName) {
            if (clazz == null) {
                MyRenameElementFix.$$$reportNull$$$0(0);
            }
            super((PsiNamedElement)clazz);
            this.myFileName = fileName;
        }

        @NotNull
        public String getText() {
            String string = PhpBundle.message("rename.psi.element.quick.fix", PhpIllegalPsrClassPathInspection.getClassKeyword((PhpClass)this.getStartElement()), ((PhpClass)this.getStartElement()).getName(), this.myFileName);
            if (string == null) {
                MyRenameElementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/psr0/PhpIllegalPsrClassPathInspection$MyRenameElementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/psr0/PhpIllegalPsrClassPathInspection$MyRenameElementFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

