/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpDuplicateSwitchCaseBodyInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpUnusedMatchConditionInspection;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnusedSwitchBranchInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedSwitchBranchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                PhpExpression argument = (PhpExpression)ObjectUtils.tryCast((Object)switchStatement.getArgument(), PhpExpression.class);
                if (argument == null) {
                    return;
                }
                PsiElement defaultCondition = (PsiElement)ObjectUtils.doIfNotNull((Object)switchStatement.getDefaultCase(), phpCase -> phpCase.getFirstChild());
                List conditions = ContainerUtil.mapNotNull((Object[])switchStatement.getCases(), ControlStatement::getCondition);
                for (PsiElement condition : PhpUnusedMatchConditionInspection.getUnusedConditionsByEnum(argument, conditions, defaultCondition)) {
                    holder.registerProblem(condition, PhpBundle.message("inspection.message.branch.is.unused", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{PhpDuplicateSwitchCaseBodyInspection.PhpDeleteRedundantSwitchCaseQuickFix.INSTANCE});
                }
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP810;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpUnusedSwitchBranchInspection", "buildVisitor"));
    }
}

