/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpDuplicateMatchConditionInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpUncoveredEnumCasesInspection;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.PhpMatchExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnusedMatchConditionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedMatchConditionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
                PhpExpression argument = matchExpression.getArgument();
                if (argument == null) {
                    return;
                }
                for (PsiElement condition : PhpUnusedMatchConditionInspection.getUnusedConditions(matchExpression, argument)) {
                    holder.problem(condition, PhpBundle.message("inspection.message.condition.is.never.matched", new Object[0])).highlight(ProblemHighlightType.LIKE_UNUSED_SYMBOL).fix(PhpDuplicateMatchConditionInspection.getDeleteElementFix(condition, PhpBundle.message("quickfix.remove.unused.condition", new Object[0]))).register();
                }
            }
        };
    }

    private static Collection<PsiElement> getUnusedConditions(@NotNull PhpMatchExpression matchExpression, @NotNull PhpExpression argument) {
        if (matchExpression == null) {
            PhpUnusedMatchConditionInspection.$$$reportNull$$$0(1);
        }
        if (argument == null) {
            PhpUnusedMatchConditionInspection.$$$reportNull$$$0(2);
        }
        PhpType argumentType = argument.getGlobalType();
        HashSet<PsiElement> unusedConditions = new HashSet<PsiElement>();
        if (argumentType.isAmbiguous()) {
            return Collections.emptyList();
        }
        Collection<PhpExpression> conditions = PhpMatchExpressionImpl.getAllConditions(matchExpression);
        for (PhpExpression condition : conditions) {
            if (PhpStrictTypeCheckingInspection.isTypeCompatible(argumentType, condition.getGlobalType())) continue;
            unusedConditions.add((PsiElement)condition);
        }
        if (PhpLanguageFeature.ENUM_CLASSES.isSupported(argument.getProject())) {
            PsiElement defaultCondition = (PsiElement)ObjectUtils.doIfNotNull((Object)matchExpression.getDefaultMatchArm(), arm -> arm.getFirstChild());
            unusedConditions.addAll(PhpUnusedMatchConditionInspection.getUnusedConditionsByEnum(argument, conditions, defaultCondition));
        }
        return unusedConditions;
    }

    @NotNull
    static Collection<PsiElement> getUnusedConditionsByEnum(@NotNull PhpExpression argument, @NotNull Collection<? extends PsiElement> conditions, @Nullable PsiElement defaultCondition) {
        PhpType argumentType;
        if (argument == null) {
            PhpUnusedMatchConditionInspection.$$$reportNull$$$0(3);
        }
        if (conditions == null) {
            PhpUnusedMatchConditionInspection.$$$reportNull$$$0(4);
        }
        if ((argumentType = argument.getGlobalType()).filterNull().size() != 1) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PhpUnusedMatchConditionInspection.$$$reportNull$$$0(5);
            }
            return list;
        }
        Collection<PhpClass> enums = PhpUncoveredEnumCasesInspection.multiResolveEnum(argument.getProject(), argument);
        if (enums.isEmpty()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PhpUnusedMatchConditionInspection.$$$reportNull$$$0(6);
            }
            return list;
        }
        Set enumCasesUnion = enums.stream().flatMap(enumClass -> enumClass.getEnumCases().stream()).collect(Collectors.toSet());
        HashSet coveredCases = new HashSet();
        HashSet<PsiElement> unusedCandidates = new HashSet<PsiElement>();
        boolean nullCovered = !argumentType.isNullable();
        for (PsiElement psiElement : conditions) {
            Collection cases;
            if (PhpLangUtil.isNull(psiElement) && !nullCovered) {
                nullCovered = true;
                continue;
            }
            if (psiElement instanceof ClassConstantReference && enumCasesUnion.containsAll(cases = ((PhpReference)psiElement).multiResolveStrict(PhpEnumCase.class))) {
                coveredCases.addAll(cases);
                continue;
            }
            unusedCandidates.add(psiElement);
        }
        if (coveredCases.equals(enumCasesUnion) && nullCovered) {
            ContainerUtil.addIfNotNull(unusedCandidates, (Object)defaultCondition);
            HashSet<PsiElement> hashSet = unusedCandidates;
            if (hashSet == null) {
                PhpUnusedMatchConditionInspection.$$$reportNull$$$0(7);
            }
            return hashSet;
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            PhpUnusedMatchConditionInspection.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpUnusedMatchConditionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpUnusedMatchConditionInspection";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedConditionsByEnum";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedConditions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedConditionsByEnum";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

