/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.completion.PhpObjectShapeCompletionProvider;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpShapeEntriesIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PhpFieldReferenceDoesNotMatchObjectShapeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpFieldReferenceDoesNotMatchObjectShapeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFieldReference(FieldReference fieldReference) {
                String name = fieldReference.getName();
                if (name == null) {
                    return;
                }
                ArrayDeque<PhpExpectedFunctionArgument> parentAccesses = new ArrayDeque<PhpExpectedFunctionArgument>();
                PhpPsiElement parent = PhpObjectShapeCompletionProvider.findParent(fieldReference, parentAccesses);
                if (parent == null || parent == fieldReference) {
                    return;
                }
                Collection<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes = PhpObjectShapeCompletionProvider.getObjectShapes((PsiElement)parent, parentAccesses);
                if (objectShapes.isEmpty()) {
                    return;
                }
                List allowedNames = ((StreamEx)((StreamEx)StreamEx.of(objectShapes).filter(e -> !e.isUnsealedShape())).map(s -> StringUtil.unquoteString((String)s.getKey().getValue())).distinct()).toList();
                if (allowedNames.isEmpty() || allowedNames.contains(name)) {
                    return;
                }
                holder.registerProblem((PsiElement)fieldReference, PhpBundle.message("inspection.message.should.be.one", StringUtil.join((Collection)allowedNames, (String)", ")), new LocalQuickFix[0]);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpFieldReferenceDoesNotMatchObjectShapeInspection", "buildVisitor"));
    }
}

