/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDivisionByZeroInspection
extends PhpInspection {
    @NotNull
    private static final TokenSet PLUS_MINUS_TOKEN = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS, PhpTokenTypes.opMINUS});

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDivisionByZeroInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                PsiElement rightOperand;
                IElementType operationType = expression.getOperationType();
                if ((PhpTokenTypes.opDIV.equals(operationType) || PhpTokenTypes.opREM.equals(operationType)) && (rightOperand = expression.getRightOperand()) != null && PhpDivisionByZeroInspection.isZero(rightOperand)) {
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.division.by.zero", new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
    }

    public static boolean isZero(@Nullable PsiElement element) {
        String content;
        if (PhpLangUtil.isFalse(element)) {
            return true;
        }
        if (element instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)element).getOperation(), PLUS_MINUS_TOKEN)) {
            return PhpDivisionByZeroInspection.isZero((PsiElement)((UnaryExpression)element).getValue());
        }
        if (element instanceof StringLiteralExpression) {
            content = StringUtil.trimStart((String)StringUtil.trimStart((String)((StringLiteralExpression)element).getContents(), (String)"+"), (String)"-");
        } else if (PhpPsiUtil.isOfType(element, PhpElementTypes.NUMBER)) {
            content = PhpPsiUtil.getLiteralText(element);
        } else {
            return false;
        }
        String withoutTrailingZeros = StringUtil.trimTrailing((String)content, (char)'0');
        return !content.isEmpty() && withoutTrailingZeros.isEmpty() || StreamEx.of((Object[])new String[]{".", "b", "x"}).anyMatch(delimiter -> withoutTrailingZeros.equals("0" + delimiter));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpDivisionByZeroInspection", "buildVisitor"));
    }
}

