/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpPassByRefInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpVariableIsUsedOnlyInClosureInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class PhpArrayModificationWillNotHaveEffectInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayModificationWillNotHaveEffectInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                if (!expression.isWriteAccess()) {
                    return;
                }
                AssignmentExpression assignmentExpression = PhpPsiUtil.getParentOfClass((PsiElement)expression, AssignmentExpression.class);
                if (assignmentExpression == null) {
                    return;
                }
                FunctionReference functionReference = (FunctionReference)ObjectUtils.tryCast((Object)expression.getValue(), FunctionReference.class);
                if (functionReference == null) {
                    return;
                }
                Function function = (Function)ContainerUtil.getOnlyItem((Collection)functionReference.multiResolveStrict(Function.class));
                if (function == null || function.isReturningByReference() || !PhpType.hasArray((PhpType)function.getGlobalType())) {
                    return;
                }
                if (PhpArrayModificationWillNotHaveEffectInspection.canReturnByReference(function)) {
                    holder.problem((PsiElement)assignmentExpression, PhpBundle.message("inspection.array.modification.will.not.have.any.effect", new Object[0])).fix((ModCommandAction)new PhpHierarchyChecksInspection.PhpAddReturnByReferenceQuickFix(function)).register();
                } else {
                    holder.registerProblem((PsiElement)assignmentExpression, PhpBundle.message("inspection.array.modification.will.not.have.any.effect", new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
    }

    private static boolean canReturnByReference(@NotNull Function function) {
        PhpReturn phpReturn;
        if (function == null) {
            PhpArrayModificationWillNotHaveEffectInspection.$$$reportNull$$$0(1);
        }
        return (phpReturn = (PhpReturn)PsiTreeUtil.findChildOfType((PsiElement)function, PhpReturn.class)) != null && ContainerUtil.all((Object[])function.getParameters(), Parameter::isPassByRef) && !PhpVariableIsUsedOnlyInClosureInspection.functionContainsMultipleStatements(function) && PhpPassByRefInspection.canBePassByReference(phpReturn.getArgument());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpArrayModificationWillNotHaveEffectInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canReturnByReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

