/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.phpunit.AssertType;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertInspectionBase;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.AssertParameter;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitDeprecatedCallsIn10VersionInspection
extends PhpUnitAssertInspectionBase {
    private static final Map<String, String> DEPRECATED_CALLS = Map.of("assertNotIsReadable", "assertIsNotReadable", "assertNotIsWritable", "assertIsNotWritable", "assertDirectoryNotExists", "assertDirectoryDoesNotExist", "assertDirectoryNotIsReadable", "assertDirectoryIsNotReadable", "assertDirectoryNotIsWritable", "assertDirectoryIsNotWritable", "assertFileNotExists", "assertFileDoesNotExist", "assertFileNotIsReadable", "assertFileIsNotReadable", "assertRegExp", "assertMatchesRegularExpression", "assertNotRegExp", "assertDoesNotMatchRegularExpression");

    @Override
    protected boolean isSupportedAssertType(@NotNull AssertType assertType) {
        if (assertType == null) {
            PhpUnitDeprecatedCallsIn10VersionInspection.$$$reportNull$$$0(0);
        }
        return DEPRECATED_CALLS.containsKey(assertType.getValue());
    }

    @Override
    protected Collection<String> getSpecializedAssertMethodNames() {
        return DEPRECATED_CALLS.values();
    }

    @Override
    @NotNull
    protected String getMessage(PsiElement[] parameters, String descriptionParameters) {
        String string = PhpBundle.message("inspection.message.function.deprecated.will.be.removed.in.phpunit", new Object[0]);
        if (string == null) {
            PhpUnitDeprecatedCallsIn10VersionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean suitableNumberOfParameters(PsiElement[] parameters) {
        return true;
    }

    @Override
    @Nullable
    protected LocalQuickFix getAssertEqualsQuickFix(@NotNull Set<AssertParameter> nonDefaultParametersSet, @NotNull AssertType assertType) {
        if (nonDefaultParametersSet == null) {
            PhpUnitDeprecatedCallsIn10VersionInspection.$$$reportNull$$$0(2);
        }
        if (assertType == null) {
            PhpUnitDeprecatedCallsIn10VersionInspection.$$$reportNull$$$0(3);
        }
        return new PhpUnitReplaceWithExistingMethodQuickFix(Objects.requireNonNull(PhpUnitDeprecatedCallsIn10VersionInspection.getNewMethodName(assertType)));
    }

    @Nullable
    public static String getNewMethodName(@Nullable AssertType assertType) {
        return assertType != null ? DEPRECATED_CALLS.get(assertType.getValue()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDeprecatedCallsIn10VersionInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonDefaultParametersSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDeprecatedCallsIn10VersionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedAssertType";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAssertEqualsQuickFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class PhpUnitReplaceWithExistingMethodQuickFix
    extends PsiUpdateModCommandQuickFix
    implements HighPriorityAction {
        private final String myNewMethodName;

        public PhpUnitReplaceWithExistingMethodQuickFix(@NotNull String newMethodName) {
            if (newMethodName == null) {
                PhpUnitReplaceWithExistingMethodQuickFix.$$$reportNull$$$0(0);
            }
            this.myNewMethodName = newMethodName;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.suggested.call.in.phpunit", new Object[0]);
            if (string == null) {
                PhpUnitReplaceWithExistingMethodQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpUnitReplaceWithExistingMethodQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpUnitReplaceWithExistingMethodQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpUnitReplaceWithExistingMethodQuickFix.$$$reportNull$$$0(4);
            }
            element.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.IDENTIFIER, this.myNewMethodName));
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("quickfix.phpunit.replace.current.method.with.alternative", this.myNewMethodName);
            if (string == null) {
                PhpUnitReplaceWithExistingMethodQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newMethodName";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDeprecatedCallsIn10VersionInspection$PhpUnitReplaceWithExistingMethodQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDeprecatedCallsIn10VersionInspection$PhpUnitReplaceWithExistingMethodQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 5: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 5 -> new IllegalStateException(string);
            };
        }
    }
}

