/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.inspections.phpunit.AssertType;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertInspectionBase;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class PhpUnitAssertTrueWithIncompatibleTypeArgumentInspection
extends PhpUnitAssertInspectionBase {
    @Override
    protected boolean isSupportedAssertType(@NotNull AssertType assertType) {
        if (assertType == null) {
            PhpUnitAssertTrueWithIncompatibleTypeArgumentInspection.$$$reportNull$$$0(0);
        }
        return assertType == AssertType.ASSERT_TRUE;
    }

    @Override
    protected Collection<String> getSpecializedAssertMethodNames() {
        return Collections.emptyList();
    }

    @Override
    protected void declareProblemType(@NotNull MethodReference methodReference, @NotNull ProblemsHolder holder, @NotNull AssertType assertType) {
        PsiElement firstArgument;
        if (methodReference == null) {
            PhpUnitAssertTrueWithIncompatibleTypeArgumentInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpUnitAssertTrueWithIncompatibleTypeArgumentInspection.$$$reportNull$$$0(2);
        }
        if (assertType == null) {
            PhpUnitAssertTrueWithIncompatibleTypeArgumentInspection.$$$reportNull$$$0(3);
        }
        if ((firstArgument = methodReference.getParameter(0)) == null) {
            return;
        }
        PhpType type = new PhpType().add(firstArgument).global(holder.getProject());
        if (!type.isAmbiguous() && !PhpType.intersects((PhpType)PhpType.BOOLEAN, (PhpType)type) && PhpUnitAssertTrueWithIncompatibleTypeArgumentInspection.isCompatibleByParamType(methodReference, type)) {
            PhpParamsInspection.PhpReplaceArgumentWithCastQuickFix fix = new PhpParamsInspection.PhpReplaceArgumentWithCastQuickFix(firstArgument, PhpType.BOOLEAN);
            holder.problem(firstArgument, PhpBundle.message("inspection.message.assert.always.will.be.false", new Object[0])).fix((ModCommandAction)fix).register();
        }
    }

    private static boolean isCompatibleByParamType(@NotNull MethodReference methodReference, PhpType type) {
        Set<Object> declaredTypes;
        if (methodReference == null) {
            PhpUnitAssertTrueWithIncompatibleTypeArgumentInspection.$$$reportNull$$$0(4);
        }
        if ((declaredTypes = methodReference.multiResolveStrict(Function.class).stream().map(f -> f.getParameter(0)).filter(Objects::nonNull).map(Parameter::getDeclaredType).collect(Collectors.toSet())).isEmpty()) {
            declaredTypes = Collections.singleton(PhpType.BOOLEAN);
        }
        return ContainerUtil.all(declaredTypes, declaredType -> declaredType.isConvertibleFrom(type, PhpIndex.getInstance((Project)methodReference.getProject())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertType";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertTrueWithIncompatibleTypeArgumentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedAssertType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "declareProblemType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompatibleByParamType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

