/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.phpunit.AssertType;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertArrayHasKeyInspection;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertInspectionBase;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitReplaceAssertMethodReferenceQuickFix;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitAssertEqualsCanBeReplacedWithAssertTrueOrFalseInspection
extends PhpUnitAssertInspectionBase {
    private static final String ASSERT_TRUE_METHOD_NAME = "assertTrue";
    private static final String ASSERT_FALSE_METHOD_NAME = "assertFalse";

    @Override
    protected boolean isSupportedAssertType(@NotNull AssertType assertType) {
        if (assertType == null) {
            PhpUnitAssertEqualsCanBeReplacedWithAssertTrueOrFalseInspection.$$$reportNull$$$0(0);
        }
        return assertType == AssertType.ASSERT_EQUALS;
    }

    @Override
    protected Collection<String> getSpecializedAssertMethodNames() {
        return List.of(ASSERT_TRUE_METHOD_NAME, ASSERT_FALSE_METHOD_NAME);
    }

    @Override
    protected void declareProblemType(@NotNull MethodReference methodReference, @NotNull ProblemsHolder holder, @NotNull AssertType assertType) {
        PsiElement parameter;
        if (methodReference == null) {
            PhpUnitAssertEqualsCanBeReplacedWithAssertTrueOrFalseInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpUnitAssertEqualsCanBeReplacedWithAssertTrueOrFalseInspection.$$$reportNull$$$0(2);
        }
        if (assertType == null) {
            PhpUnitAssertEqualsCanBeReplacedWithAssertTrueOrFalseInspection.$$$reportNull$$$0(3);
        }
        if (PhpLangUtil.isTrue(parameter = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex((FunctionReference)methodReference, 0))) {
            this.registerProblem(holder, methodReference, PhpBundle.message("inspection.message.can.be.replaced.with.assert.true", new Object[0]), new LocalQuickFix[]{PhpUnitReplaceWithAssertQuickFix.ASSERT_TRUE_INSTANCE});
        } else if (PhpLangUtil.isFalse(parameter)) {
            this.registerProblem(holder, methodReference, PhpBundle.message("inspection.message.can.be.replaced.with.assert.false", new Object[0]), new LocalQuickFix[]{PhpUnitReplaceWithAssertQuickFix.ASSERT_FALSE_INSTANCE});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertEqualsCanBeReplacedWithAssertTrueOrFalseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedAssertType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "declareProblemType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpUnitReplaceWithAssertQuickFix
    extends PhpUnitReplaceAssertMethodReferenceQuickFix {
        private static final PhpUnitReplaceWithAssertQuickFix ASSERT_TRUE_INSTANCE = new PhpUnitReplaceWithAssertQuickFix("assertTrue");
        private static final PhpUnitReplaceWithAssertQuickFix ASSERT_FALSE_INSTANCE = new PhpUnitReplaceWithAssertQuickFix("assertFalse");

        private PhpUnitReplaceWithAssertQuickFix(@NotNull String name) {
            if (name == null) {
                PhpUnitReplaceWithAssertQuickFix.$$$reportNull$$$0(0);
            }
            super(name, 0);
        }

        @Override
        protected PsiElement @Nullable [] createNewParameters(PsiElement @NotNull [] parameters) {
            if (parameters == null) {
                PhpUnitReplaceWithAssertQuickFix.$$$reportNull$$$0(1);
            }
            return parameters.length > 1 ? Arrays.copyOfRange(parameters, 1, parameters.length) : PsiElement.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertEqualsCanBeReplacedWithAssertTrueOrFalseInspection$PhpUnitReplaceWithAssertQuickFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createNewParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

