/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdatePhpDocTypeQuickFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final PhpType myNewType;
    @NotNull
    private final String myNewTypePresentation;

    public UpdatePhpDocTypeQuickFix(@NotNull PhpType newType, @NotNull Project project, @Nullable PhpPsiElement scope) {
        if (newType == null) {
            UpdatePhpDocTypeQuickFix.$$$reportNull$$$0(0);
        }
        if (project == null) {
            UpdatePhpDocTypeQuickFix.$$$reportNull$$$0(1);
        }
        this.myNewType = newType;
        this.myNewTypePresentation = PhpDocUtil.getTypePresentation(project, newType, scope);
    }

    @IntentionName
    @NotNull
    public String getName() {
        return UpdatePhpDocTypeQuickFix.getName(this.myNewTypePresentation);
    }

    @NotNull
    @Nls
    public static String getName(@NotNull String myNewTypePresentation) {
        if (myNewTypePresentation == null) {
            UpdatePhpDocTypeQuickFix.$$$reportNull$$$0(2);
        }
        String string = PhpBundle.message("update.php.doc.type.comment", myNewTypePresentation);
        if (string == null) {
            UpdatePhpDocTypeQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("update.php.doc.type.family.name", new Object[0]);
        if (string == null) {
            UpdatePhpDocTypeQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (project == null) {
            UpdatePhpDocTypeQuickFix.$$$reportNull$$$0(5);
        }
        if (element == null) {
            UpdatePhpDocTypeQuickFix.$$$reportNull$$$0(6);
        }
        if (updater == null) {
            UpdatePhpDocTypeQuickFix.$$$reportNull$$$0(7);
        }
        PhpDocType docType = (PhpDocType)ObjectUtils.tryCast((Object)element, PhpDocType.class);
        assert (docType != null);
        PhpDocTag docTag = PhpPsiUtil.getParentOfClass((PsiElement)docType, PhpDocTag.class);
        assert (docTag != null);
        PhpTypeDeclarationImpl.update(docTag, this.myNewType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myNewTypePresentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/UpdatePhpDocTypeQuickFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/UpdatePhpDocTypeQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

