/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.inspections.phpdoc.PhpMissingDocCommentBaseInspection;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.NotNull;

public final class PhpMissingDocCommentInspection
extends PhpMissingDocCommentBaseInspection {
    @Override
    protected boolean isDocCommentNeededFor(@NotNull PhpNamedElement element) {
        if (element == null) {
            PhpMissingDocCommentInspection.$$$reportNull$$$0(0);
        }
        if (element instanceof Function) {
            return !PhpMissingDocCommentInspection.isFullyTypedFunction((Function)element);
        }
        if (element instanceof Field) {
            return PhpMissingDocCommentInspection.isDocCommentNeedFor((Field)element);
        }
        return true;
    }

    private static boolean isDocCommentNeedFor(@NotNull Field field) {
        if (field == null) {
            PhpMissingDocCommentInspection.$$$reportNull$$$0(1);
        }
        if (field.isConstant()) {
            return true;
        }
        return !PhpLanguageFeature.TYPED_PROPERTIES.isSupported(field.getProject()) || field.getTypeDeclaration() == null;
    }

    private static boolean isFullyTypedFunction(@NotNull Function function) {
        if (function == null) {
            PhpMissingDocCommentInspection.$$$reportNull$$$0(2);
        }
        if (PhpMissingDocCommentInspection.isReturnTagNeeded(function)) {
            return false;
        }
        for (Parameter parameter : function.getParameters()) {
            if (!parameter.getDeclaredType().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean isReturnTagNeeded(@NotNull Function function) {
        if (function == null) {
            PhpMissingDocCommentInspection.$$$reportNull$$$0(3);
        }
        if (PhpMissingDocCommentInspection.isConstructor(function)) {
            return false;
        }
        if (function.getType().isEmpty() || PhpType.VOID.equals((Object)function.getGlobalType())) {
            return false;
        }
        if (!PhpLanguageFeature.RETURN_TYPES.isSupported(function.getProject())) {
            return true;
        }
        return function.getTypeDeclaration() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpMissingDocCommentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDocCommentNeededFor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDocCommentNeedFor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFullyTypedFunction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isReturnTagNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

