/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpRemoveDocTagQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInappropriateInheritDocUsageInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInappropriateInheritDocUsageInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpDocTag(PhpDocTag tag) {
                if (StringUtil.equalsIgnoreCase((CharSequence)"@inheritDoc", (CharSequence)tag.getName())) {
                    PhpDocComment comment = PhpPsiUtil.getParentOfClass((PsiElement)tag, PhpDocComment.class);
                    if (comment == null) {
                        return;
                    }
                    PsiElement owner = comment.getOwner();
                    if (owner == null) {
                        return;
                    }
                    LocalQuickFix fix = LocalQuickFix.from((ModCommandAction)new PhpRemoveDocTagQuickFix(tag, PhpBundle.message("php.remove.doc.tag.quick.fix.family.name", tag.getName())));
                    if (owner instanceof PhpClass) {
                        if (!PhpInappropriateInheritDocUsageInspection.unresolvedSuperClassExist((PhpClass)owner) && !PhpInappropriateInheritDocUsageInspection.hasSuperClassWithDocComment((PhpClass)owner)) {
                            holder.registerProblem((PsiElement)tag, PhpBundle.message("inspection.php.inappropriate.inherit.doc.usage.class.description", new Object[0]), new LocalQuickFix[]{fix});
                        }
                        return;
                    }
                    if (!(owner instanceof PhpClassMember)) {
                        holder.registerProblem((PsiElement)tag, PhpBundle.message("inspection.php.inappropriate.inherit.doc.usage.description2", new Object[0]), new LocalQuickFix[]{fix});
                        return;
                    }
                    PhpClass containingClass = ((PhpClassMember)owner).getContainingClass();
                    if (containingClass == null) {
                        return;
                    }
                    Boolean hasSuperMemberWithDocComment = PhpInappropriateInheritDocUsageInspection.hasSuperMemberWithDocComment((PhpClassMember)owner);
                    if (hasSuperMemberWithDocComment == null && PhpInappropriateInheritDocUsageInspection.unresolvedSuperClassExist(containingClass)) {
                        return;
                    }
                    if (hasSuperMemberWithDocComment != Boolean.TRUE) {
                        holder.registerProblem((PsiElement)tag, PhpBundle.message("inspection.php.inappropriate.inherit.doc.usage.description", new Object[0]), new LocalQuickFix[]{fix});
                    }
                }
            }
        };
    }

    private static boolean hasSuperClassWithDocComment(@NotNull PhpClass owner) {
        if (owner == null) {
            PhpInappropriateInheritDocUsageInspection.$$$reportNull$$$0(1);
        }
        Ref hasSuperClassWithDocComment = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperWithoutMixins((PhpClass)owner, (boolean)false, (boolean)true, aClass -> {
            if (aClass.getDocComment() != null) {
                hasSuperClassWithDocComment.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)hasSuperClassWithDocComment.get();
    }

    private static boolean unresolvedSuperClassExist(PhpClass containingClass) {
        return containingClass.getSuperName() != null && containingClass.getSuperClass() == null || containingClass.getInterfaceNames().length > 0 && containingClass.getImplementedInterfaces().length == 0 || containingClass.getTraitNames().length > 0 && containingClass.getTraits().length == 0;
    }

    @Nullable
    private static Boolean hasSuperMemberWithDocComment(PhpClassMember memberOwner) {
        Ref hasSuperDocComment = new Ref();
        Ref hasSuperMethod = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)memberOwner, (superMember, subClass, baseClass) -> {
            hasSuperMethod.set((Object)true);
            if (superMember.getDocComment() != null) {
                hasSuperDocComment.set((Object)Boolean.TRUE);
            }
            return hasSuperDocComment.get() != Boolean.TRUE;
        });
        return hasSuperDocComment.isNull() && (Boolean)hasSuperMethod.get() != false ? Boolean.FALSE : (Boolean)hasSuperDocComment.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpInappropriateInheritDocUsageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSuperClassWithDocComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

