/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.constantCondition.constant;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessConstantInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpRangeCheckDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.constant.PhpDfaBasedConstantAnalyzerProcessor;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPreviousConstantDfaAnalyzerProcessor
extends PhpPreviousDfaAnalyzerProcessor {
    private PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> myConstantPredefinedState;
    private static final Map<String, Integer> MIN_CONSTANTS_VALUES = Map.of("\\PHP_VERSION_ID", 40000, "\\PHP_MAJOR_VERSION", 0, "\\PHP_MINOR_VERSION", 0, "\\PHP_RELEASE_VERSION", 0);

    public PhpPreviousConstantDfaAnalyzerProcessor(Project project, @Nullable String argumentName, @NotNull ConstantReference reference, boolean stopOnNegations, TextRange outerTextRange, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState, boolean global) {
        if (reference == null) {
            PhpPreviousConstantDfaAnalyzerProcessor.$$$reportNull$$$0(0);
        }
        super(project, reference.getName(), argumentName, stopOnNegations, outerTextRange, (PsiElement)reference, currentState, global);
        this.myConstantPredefinedState = null;
        Integer minValue = MIN_CONSTANTS_VALUES.get(reference.getFQN());
        if (minValue != null) {
            PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState state = new PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState(PhpRangeCheckDfaBasedTypeState.Operand.GREATER_EQ, minValue);
            PhpAccessConstantInstruction instruction = PhpControlFlowUtil.getInstruction((PsiElement)reference, PhpAccessConstantInstruction.class);
            if (instruction != null) {
                this.myConstantPredefinedState = new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState>(this.computeVariableName((PsiElement)reference), state, (PhpInstruction)instruction);
            }
        }
    }

    @Override
    protected boolean sameVariableName(CharSequence name) {
        return this.myAnchor == null || name != null && name.equals(PhpDfaBasedConstantAnalyzerProcessor.computeConstantName((ConstantReference)this.myAnchor));
    }

    @Override
    @NotNull
    protected PhpPreviousDfaBaseStateConditionDFAnalyzer createAnalyzer(boolean stopOnNegations) {
        return new PhpDfaBasedConstantAnalyzerProcessor.PhpConstantDfaBaseStateConditionDFAnalyzer((ConstantReference)this.myAnchor, this.myGlobal, stopOnNegations, false);
    }

    @Override
    public boolean sameElement(@Nullable PsiElement element) {
        return element instanceof ConstantReference && (this.myAnchor == null || PhpPsiUtil.areElementsEquivalent(element, this.myAnchor));
    }

    @Override
    protected PhpPreviousDfaAnalyzerProcessor createProcessor(TextRange outerRange) {
        return new PhpPreviousConstantDfaAnalyzerProcessor(this.myProject, this.myArgumentName, (ConstantReference)this.myAnchor, this.myStopOnNegations, outerRange, this.myCurrentState, this.myGlobal);
    }

    @Override
    protected CharSequence computeVariableName(PsiElement variable) {
        return PhpDfaBasedConstantAnalyzerProcessor.computeConstantName((ConstantReference)variable);
    }

    @Override
    @Nullable
    public PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> getState() {
        return this.composeStates(this.myConstantPredefinedState, super.getState(), "combined with constant predefined state");
    }

    public static boolean applicable(String name) {
        return PhpTypeSignatureKey.CONSTANT.isSigned(name);
    }

    public static PhpPreviousDfaAnalyzerProcessor createFromVariableName(Project project, String name, PsiElement condition, boolean stopOnNegations, TextRange outerTextRange, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState, boolean global) {
        String fqn = name.substring(2);
        ConstantReference fieldReference = (ConstantReference)ContainerUtil.find(PhpPsiUtil.findChildrenNonStrict(condition, ConstantReference.class), c -> fqn.equals(c.getFQN()));
        return fieldReference != null ? new PhpPreviousConstantDfaAnalyzerProcessor(project, fqn, fieldReference, stopOnNegations, outerTextRange, currentState, global) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/constant/PhpPreviousConstantDfaAnalyzerProcessor", "<init>"));
    }
}

