/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.constantCondition;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpRangeCheckDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStrictVariableCheckDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpVariableBasedTypeState;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpVariableCheckDfaBasedTypeState
extends PhpDfaBasedTypeState
implements PhpVariableBasedTypeState {
    @NotNull
    public final PhpStateArgumentInfo myArgumentInfo;
    public final boolean myNegatedCheck;
    public final String myVariableName;

    @Override
    public int getCustomHashCode() {
        return Objects.hash(this.myArgumentInfo, this.myNegatedCheck, this.myVariableName);
    }

    public PhpVariableCheckDfaBasedTypeState(@NotNull PhpStateArgumentInfo argumentInfo, boolean negatedCheck) {
        if (argumentInfo == null) {
            PhpVariableCheckDfaBasedTypeState.$$$reportNull$$$0(0);
        }
        super("COMPARISON WITH $" + argumentInfo.getArgumentName());
        this.myNegatedCheck = negatedCheck;
        this.myVariableName = argumentInfo.getArgumentName();
        this.myArgumentInfo = argumentInfo;
    }

    @Override
    public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
        if (state == null) {
            PhpVariableCheckDfaBasedTypeState.$$$reportNull$$$0(1);
        }
        if (PhpStrictVariableCheckDfaBasedTypeState.isCoveredByRangeCheck(this, state)) {
            return true;
        }
        if (this.myNegatedCheck && state instanceof PhpStrictVariableCheckDfaBasedTypeState) {
            PhpStrictVariableCheckDfaBasedTypeState strictState = (PhpStrictVariableCheckDfaBasedTypeState)state;
            return this.coveredBy(project, new PhpVariableCheckDfaBasedTypeState(strictState.myArgumentInfo, strictState.myNegatedCheck), global);
        }
        return super.coveredBy(project, state, global, skippedStates);
    }

    @Override
    public boolean is(PhpDfaBasedTypeState state) {
        return super.is(state) || state instanceof PhpVariableCheckDfaBasedTypeState && PhpLangUtil.equalsVariableNames(this.myVariableName, ((PhpVariableCheckDfaBasedTypeState)state).myVariableName) && ((PhpVariableCheckDfaBasedTypeState)state).myNegatedCheck == this.myNegatedCheck;
    }

    @Override
    public boolean excludedBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
        PhpVariableCheckDfaBasedTypeState delegate;
        if (state == null) {
            PhpVariableCheckDfaBasedTypeState.$$$reportNull$$$0(2);
        }
        if (PhpStrictVariableCheckDfaBasedTypeState.isExcludedByRangeCheck(this, state)) {
            return true;
        }
        if (state instanceof PhpVariableCheckDfaBasedTypeState && this.myNegatedCheck != ((PhpVariableCheckDfaBasedTypeState)state).myNegatedCheck && this.coveredBy(project, delegate = new PhpVariableCheckDfaBasedTypeState(((PhpVariableCheckDfaBasedTypeState)state).myArgumentInfo, !((PhpVariableCheckDfaBasedTypeState)state).myNegatedCheck), global)) {
            return true;
        }
        if (this.myNegatedCheck && state instanceof PhpStrictVariableCheckDfaBasedTypeState) {
            PhpStrictVariableCheckDfaBasedTypeState typeState = (PhpStrictVariableCheckDfaBasedTypeState)state;
            if (!typeState.myNegatedCheck) {
                PhpVariableCheckDfaBasedTypeState delegate2 = new PhpVariableCheckDfaBasedTypeState(typeState.myArgumentInfo, true);
                return this.coveredBy(project, delegate2, global);
            }
        }
        return super.excludedBy(project, state, global, skippedStates);
    }

    @Override
    @NotNull
    public String getVariableName() {
        String string = this.myVariableName;
        if (string == null) {
            PhpVariableCheckDfaBasedTypeState.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isNegated() {
        return this.myNegatedCheck;
    }

    @Override
    public Collection<PhpStateArgumentInfo> getInfo(boolean global) {
        return ContainerUtil.createMaybeSingletonList((Object)this.myArgumentInfo);
    }

    @Nullable
    public static PhpDfaBasedTypeState tryToCreateState(PsiElement argument, boolean negatedCheck, boolean strict, boolean global) {
        if (argument instanceof BinaryExpression) {
            return PhpVariableCheckDfaBasedTypeState.createFromArithmeticOperands((BinaryExpression)argument, negatedCheck, global);
        }
        PhpStateArgumentInfo argumentInfo = PhpStateArgumentInfo.tryCreateInfo(argument, global);
        if (argumentInfo != null) {
            return strict ? new PhpStrictVariableCheckDfaBasedTypeState(argumentInfo, negatedCheck) : new PhpVariableCheckDfaBasedTypeState(argumentInfo, negatedCheck);
        }
        return null;
    }

    @Nullable
    private static PhpDfaBasedTypeState createFromArithmeticOperands(BinaryExpression argument, boolean negatedCheck, boolean global) {
        PsiElement varArgument;
        PsiElement numberElement;
        PsiElement left = argument.getLeftOperand();
        PsiElement right = argument.getRightOperand();
        IElementType type = argument.getOperationType();
        if (!negatedCheck && type == PhpTokenTypes.opREM) {
            PhpStateArgumentInfo leftInfo = PhpStateArgumentInfo.tryCreateInfo(left, global);
            PhpStateArgumentInfo rightInfo = PhpStateArgumentInfo.tryCreateInfo(right, global);
            if (rightInfo != null) {
                return new PhpModuloOnVariableState(leftInfo, rightInfo);
            }
            if (PhpPsiUtil.isOfType(right, PhpElementTypes.NUMBER)) {
                try {
                    int value = Integer.parseInt(right.getText());
                    return new PhpIntModuloOnVariableState(leftInfo, value);
                }
                catch (NumberFormatException value) {
                    // empty catch block
                }
            }
        }
        Object object = PhpVariableCheckDfaBasedTypeState.isNumber(left) ? left : (numberElement = PhpVariableCheckDfaBasedTypeState.isNumber(right) ? right : null);
        if (numberElement == null) {
            return null;
        }
        PsiElement psiElement = varArgument = numberElement == left ? right : left;
        if (varArgument != left && (type == PhpTokenTypes.opMINUS || type == PhpTokenTypes.opDIV || type == PhpTokenTypes.opREM)) {
            return null;
        }
        int number = StringUtil.parseInt((String)numberElement.getText(), (int)0);
        if (number == 0) {
            return null;
        }
        PhpStateArgumentInfo info = PhpStateArgumentInfo.tryCreateInfo(varArgument, global);
        if (info == null) {
            return null;
        }
        if (type == PhpTokenTypes.opPLUS || type == PhpTokenTypes.opMINUS) {
            boolean positiveDiff = number > 0 == (type == PhpTokenTypes.opPLUS);
            PhpRangeCheckDfaBasedTypeState.Operand operand = positiveDiff ? PhpRangeCheckDfaBasedTypeState.Operand.GREATER : PhpRangeCheckDfaBasedTypeState.Operand.LOWER;
            return new PhpAdditionOnVariableState(negatedCheck ? operand.invert() : operand, info, number, negatedCheck);
        }
        return null;
    }

    private static boolean isNumber(PsiElement element) {
        return PhpPsiUtil.isOfType(element, PhpElementTypes.NUMBER) || element instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)element).getOperation(), PhpTokenTypes.opMINUS) && PhpPsiUtil.isOfType((PsiElement)((UnaryExpression)element).getValue(), PhpElementTypes.NUMBER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpVariableCheckDfaBasedTypeState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpVariableCheckDfaBasedTypeState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "coveredBy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "excludedBy";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static class PhpModuloOnVariableState
    extends PhpRangeCheckDfaBasedTypeState.PhpVariableRangeCheckDfaBasedTypeState
    implements PhpModuloState {
        private final PhpStateArgumentInfo myLeftInfo;

        public PhpModuloOnVariableState(@Nullable PhpStateArgumentInfo leftInfo, PhpStateArgumentInfo argumentInfo) {
            super(PhpRangeCheckDfaBasedTypeState.Operand.LOWER, argumentInfo);
            this.myLeftInfo = leftInfo;
        }

        @Override
        public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
            if (state == null) {
                PhpModuloOnVariableState.$$$reportNull$$$0(0);
            }
            if (state instanceof PhpModuloOnVariableState) {
                return this.isComparable((PhpRangeCheckDfaBasedTypeState)state) && this.coveredByState((PhpModuloState)((Object)state));
            }
            return super.coveredBy(project, state, global, skippedStates);
        }

        @Override
        @Nullable
        public PhpStateArgumentInfo getLeftInfo() {
            return this.myLeftInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpVariableCheckDfaBasedTypeState$PhpModuloOnVariableState", "coveredBy"));
        }
    }

    public static class PhpIntModuloOnVariableState
    extends PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState
    implements PhpModuloState {
        private final PhpStateArgumentInfo myLeftInfo;

        public PhpIntModuloOnVariableState(PhpStateArgumentInfo leftInfo, int value) {
            super(PhpRangeCheckDfaBasedTypeState.Operand.LOWER_EQ, value - 1);
            this.myLeftInfo = leftInfo;
        }

        @Override
        public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
            if (state == null) {
                PhpIntModuloOnVariableState.$$$reportNull$$$0(0);
            }
            if (state instanceof PhpIntModuloOnVariableState) {
                return this.isComparable((PhpRangeCheckDfaBasedTypeState)state) && this.coveredByState((PhpIntModuloOnVariableState)state);
            }
            return super.coveredBy(project, state, global, skippedStates);
        }

        @Override
        @Nullable
        public PhpStateArgumentInfo getLeftInfo() {
            return this.myLeftInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpVariableCheckDfaBasedTypeState$PhpIntModuloOnVariableState", "coveredBy"));
        }
    }

    public static class PhpAdditionOnVariableState
    extends PhpRangeCheckDfaBasedTypeState.PhpVariableRangeCheckDfaBasedTypeState {
        private final int myDiff;
        public final boolean myNegatedCheck;

        public PhpAdditionOnVariableState(PhpRangeCheckDfaBasedTypeState.Operand operand, PhpStateArgumentInfo argumentInfo, int diff, boolean negatedCheck) {
            super(operand, argumentInfo);
            this.myDiff = diff;
            this.myNegatedCheck = negatedCheck;
        }

        @Override
        public boolean is(PhpDfaBasedTypeState state) {
            if (state instanceof PhpAdditionOnVariableState) {
                return this.isComparable((PhpRangeCheckDfaBasedTypeState)state) && this.myOperand == ((PhpAdditionOnVariableState)state).myOperand && this.myDiff == ((PhpAdditionOnVariableState)state).myDiff;
            }
            return !this.myNegatedCheck && this.isSameRange(state);
        }

        @Override
        public boolean excludedBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
            if (state == null) {
                PhpAdditionOnVariableState.$$$reportNull$$$0(0);
            }
            if (state instanceof PhpAdditionOnVariableState) {
                if (!this.isComparable((PhpRangeCheckDfaBasedTypeState)state)) {
                    return false;
                }
                if (this.myNegatedCheck && ((PhpAdditionOnVariableState)state).myNegatedCheck) {
                    return false;
                }
                if (this.myNegatedCheck != ((PhpAdditionOnVariableState)state).myNegatedCheck) {
                    return this.myOperand.invert() == ((PhpAdditionOnVariableState)state).myOperand && this.myDiff == ((PhpAdditionOnVariableState)state).myDiff;
                }
                return this.myOperand == ((PhpAdditionOnVariableState)state).myOperand && this.myDiff != ((PhpAdditionOnVariableState)state).myDiff || this.myOperand != ((PhpAdditionOnVariableState)state).myOperand && this.myDiff == ((PhpAdditionOnVariableState)state).myDiff;
            }
            if (this.myNegatedCheck && state instanceof PhpRangeCheckDfaBasedTypeState) {
                return false;
            }
            return super.excludedBy(project, state, global, skippedStates);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpVariableCheckDfaBasedTypeState$PhpAdditionOnVariableState", "excludedBy"));
        }
    }

    private static interface PhpModuloState {
        @Nullable
        public PhpStateArgumentInfo getLeftInfo();

        default public boolean coveredByState(@NotNull PhpModuloState state) {
            if (state == null) {
                PhpModuloState.$$$reportNull$$$0(0);
            }
            return this.getLeftInfo() != null && state.getLeftInfo() != null && this.getLeftInfo().getArgumentName().equals(state.getLeftInfo().getArgumentName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpVariableCheckDfaBasedTypeState$PhpModuloState", "coveredByState"));
        }
    }
}

