/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.constantCondition;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpForeachStartHostInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.type.PhpTypeConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpAmbiguousCompositeTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpCompositeTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeStateInferredAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.PhpConditionAlreadyCheckedInspection;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateWithArgumentInfo;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStrictVariableCheckDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpVariableBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpVariableCheckDfaBasedTypeState;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpChooserFunctionsIndex;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class PhpPreviousDfaAnalyzerProcessor
extends PhpDfaBasedTypeStateInferredAnalyzerProcessor {
    private static final PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker ALWAYS_STRING = new PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker("is_string");
    private static final Collection<PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker> PRIMITIVE_TYPE_CHECKERS = List.of(ALWAYS_STRING, new PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker("is_int"), new PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker("is_float"));
    public static final int DEPTH_LIMIT = 250;
    protected final String myArgumentName;
    protected final TextRange myOuterTextRange;
    protected final PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> myCurrentState;
    private final MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> mySkippedStates = MultiMap.createSet();
    protected @Unmodifiable @NotNull Collection<Function<PhpInstruction, Boolean>> myStateDependenciesCheckers;
    private final Collection<TextRange> myAlreadyCheckedRanges = new HashSet<TextRange>();
    private final MultiMap<PhpInstruction, PhpPreviousDfaAnalyzerProcessor> myPreviousStatesProcessors = MultiMap.create();
    private final Collection<PhpInstruction> myEffectiveWriteInstruction = new HashSet<PhpInstruction>();
    @Nullable
    private PhpInstruction myRecurrentlyProcessedInstruction = null;
    private boolean myRestartable = true;
    protected final Project myProject;
    private Predicate<? super PhpInstruction> myConditionToStop = null;
    private int myDepth = 1;

    public PhpPreviousDfaAnalyzerProcessor(Project project, CharSequence variableName, @Nullable String argumentName, boolean stopOnNegations, TextRange outerTextRange, @Nullable PsiElement variable, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState, boolean global) {
        super(variableName, variable, global, stopOnNegations, Collections.emptySet());
        this.myProject = project;
        this.myArgumentName = argumentName;
        this.myOuterTextRange = outerTextRange;
        this.myStateDependenciesCheckers = this.getStateDependenciesCheckers((PhpDfaBasedTypeState)currentState.getState());
        this.myCurrentState = currentState;
    }

    public void setNonGlobal() {
        this.myGlobal = false;
    }

    @NotNull
    protected @Unmodifiable Collection<Function<PhpInstruction, Boolean>> getStateDependenciesCheckers(PhpDfaBasedTypeState currentState) {
        Collection<PhpStateArgumentInfo> infos;
        if (currentState instanceof PhpStateWithArgumentInfo && !(infos = ((PhpStateWithArgumentInfo)((Object)currentState)).getInfo(this.myGlobal)).isEmpty()) {
            Collection collection = infos.stream().flatMap(info -> info.getStateDependenciesCheckers(this.myGlobal).stream()).collect(Collectors.toList());
            if (collection == null) {
                PhpPreviousDfaAnalyzerProcessor.$$$reportNull$$$0(0);
            }
            return collection;
        }
        if (currentState instanceof PhpDfaDelegateBasedTypeState) {
            Collection collection = ((PhpDfaDelegateBasedTypeState)currentState).delegates().flatMap(s -> this.getStateDependenciesCheckers((PhpDfaBasedTypeState)s).stream()).collect(Collectors.toList());
            if (collection == null) {
                PhpPreviousDfaAnalyzerProcessor.$$$reportNull$$$0(1);
            }
            return collection;
        }
        List<Function<PhpInstruction, Boolean>> list = Collections.emptyList();
        if (list == null) {
            PhpPreviousDfaAnalyzerProcessor.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void setNonRestartable() {
        this.myRestartable = false;
    }

    public void setConditionToStop(Predicate<? super PhpInstruction> condition) {
        this.myConditionToStop = condition;
    }

    @Nullable
    protected PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> composeStates(@Nullable PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> f, @Nullable PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> s, String name) {
        if (s == null) {
            return f;
        }
        if (f != null) {
            PhpDfaDelegateBasedTypeState combinedState = new PhpDfaDelegateBasedTypeState(name, (PhpDfaBasedTypeState)s.getState(), (PhpDfaBasedTypeState)f.getState());
            PhpInstruction instruction = (PhpInstruction)ObjectUtils.chooseNotNull((Object)s.getInstruction(), (Object)f.getInstruction());
            return new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(s.getVariableName(), combinedState, instruction, s.getInfo());
        }
        return s;
    }

    public static Function<PhpInstruction, Boolean> createVariableNameDependency(String variableName) {
        return i -> {
            if (i instanceof PhpAccessVariableInstruction) {
                return PhpLangUtil.equalsVariableNames(((PhpAccessVariableInstruction)i).getVariableName(), variableName);
            }
            if (i instanceof PhpCallInstruction) {
                return PhpPreviousDfaAnalyzerProcessor.isUnresolvedFunctionWithVariableParameter(variableName, (PhpCallInstruction)i);
            }
            return false;
        };
    }

    public static boolean isUnresolvedFunctionWithVariableParameter(CharSequence variableName, PhpCallInstruction i) {
        return PhpPreviousDfaAnalyzerProcessor.isParameterWithNameExists(variableName, i) && i.getFunctionReference().multiResolve(false).length == 0;
    }

    private static boolean isParameterWithNameExists(CharSequence variableName, PhpCallInstruction i) {
        return ContainerUtil.exists((Object[])i.getFunctionReference().getParameters(), p -> p instanceof Variable && PhpLangUtil.equalsParameterNames(((Variable)p).getName(), variableName));
    }

    @Override
    @NotNull
    public PhpPreviousDfaBaseStateConditionDFAnalyzer createAnalyzer() {
        PhpPreviousDfaBaseStateConditionDFAnalyzer analyzer = this.createAnalyzer(this.myStopOnNegations);
        analyzer.addDependencyCheckers(this.myStateDependenciesCheckers);
        PhpPreviousDfaBaseStateConditionDFAnalyzer phpPreviousDfaBaseStateConditionDFAnalyzer = analyzer;
        if (phpPreviousDfaBaseStateConditionDFAnalyzer == null) {
            PhpPreviousDfaAnalyzerProcessor.$$$reportNull$$$0(3);
        }
        return phpPreviousDfaBaseStateConditionDFAnalyzer;
    }

    @Override
    @NotNull
    protected abstract PhpPreviousDfaBaseStateConditionDFAnalyzer createAnalyzer(boolean var1);

    @Override
    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
        if (this.isInnerRangeToSkip((PhpInstruction)instruction)) {
            return true;
        }
        return super.processConditionInstruction(instruction);
    }

    protected boolean isInnerRangeToSkip(PhpInstruction instruction) {
        PsiElement prevCond = instruction.getAnchor();
        return prevCond != null && this.myOuterTextRange.contains(prevCond.getTextRange());
    }

    @Override
    public boolean processCondition(PhpInstruction instruction, @Nullable PsiElement condition, boolean result) {
        if (condition == null) {
            return true;
        }
        TextRange range = condition.getTextRange();
        if (ContainerUtil.exists(this.myAlreadyCheckedRanges, arg_0 -> ((TextRange)range).intersects(arg_0))) {
            this.myAmbiguous = true;
            this.haltTraversal();
            return false;
        }
        return super.processCondition(instruction, condition, result);
    }

    public boolean processHostInstruction(PhpHostInstruction instruction) {
        if (instruction instanceof PhpForeachStartHostInstructionImpl) {
            PsiElement array = ((PhpForeachStartHostInstructionImpl)instruction).getArray();
            ForeachStatement foreach = PhpPsiUtil.getParentOfClass(array, ForeachStatement.class);
            if (this.sameElement(array) && foreach != null && !this.sameElement((PsiElement)foreach.getKey()) && !this.sameElement((PsiElement)foreach.getValue())) {
                return this.registerState((PhpInstruction)instruction, array.getTextRange(), this.createAnalyzer().createState(array, PhpCompositeTypeState.NOT_EMPTY_CHECK));
            }
        }
        return super.processHostInstruction(instruction);
    }

    public boolean registerStateFromAssignedValue(PhpAccessInstruction instruction) {
        AssignmentExpression assignment;
        PhpAccessInstruction.Access access = instruction.getAccess();
        if (PhpConditionAlreadyCheckedInspection.isModifyingAccess(access, this.myGlobal) && (assignment = PhpPsiUtil.getParentOfClass((PsiElement)instruction.getAnchor(), AssignmentExpression.class)) != null && assignment.getVariable() == instruction.getAnchor()) {
            PhpPsiElement value = assignment.getValue();
            return this.registerStateFromWrappedAssignedValue((PhpInstruction)instruction, (PsiElement)value, (PsiElement)instruction.getAnchor());
        }
        return false;
    }

    public static boolean processWrappedValues(PsiElement value, Processor<? super PsiElement> processor2, boolean global) {
        IntSet indices;
        Collection<PsiElement> chosenArguments;
        if (value instanceof TernaryExpression) {
            return PhpPreviousDfaAnalyzerProcessor.processWrappedValues((PsiElement)((TernaryExpression)value).getTrueVariant(), processor2, global) && PhpPreviousDfaAnalyzerProcessor.processWrappedValues((PsiElement)((TernaryExpression)value).getFalseVariant(), processor2, global);
        }
        if (value instanceof BinaryExpression && ((BinaryExpression)value).getOperationType() == PhpTokenTypes.opCOALESCE) {
            return PhpPreviousDfaAnalyzerProcessor.processWrappedValues(((BinaryExpression)value).getLeftOperand(), processor2, global) && PhpPreviousDfaAnalyzerProcessor.processWrappedValues(((BinaryExpression)value).getRightOperand(), processor2, global);
        }
        if (value instanceof ParenthesizedExpression) {
            return PhpPreviousDfaAnalyzerProcessor.processWrappedValues((PsiElement)((ParenthesizedExpression)value).getArgument(), processor2, global);
        }
        if (value instanceof FunctionReference && global && !(chosenArguments = PhpPreviousDfaAnalyzerProcessor.createChooseArgumentState((FunctionReference)value, indices = PhpChooserFunctionsIndex.getReturnedIndices((FunctionReference)value))).isEmpty()) {
            return ContainerUtil.all(chosenArguments, argument -> PhpPreviousDfaAnalyzerProcessor.processWrappedValues(argument, processor2, true));
        }
        return processor2.process((Object)value);
    }

    protected boolean registerStateFromWrappedAssignedValue(PhpInstruction instruction, @Nullable PsiElement value, @Nullable PsiElement variable) {
        return PhpPreviousDfaAnalyzerProcessor.processWrappedValues(value, (Processor<? super PsiElement>)((Processor)v -> {
            if (this.registerStateFromAssignedValue(instruction, (PsiElement)v, variable)) {
                if (v != value) {
                    this.mergeWithOuterValueState(value, (PsiElement)v);
                }
                return true;
            }
            return false;
        }), this.myGlobal);
    }

    private void mergeWithOuterValueState(@Nullable PsiElement value, PsiElement v) {
        PhpDfaBasedTypeState originalValueState = this.createAnalyzer(true).getPrimitiveTypeCheckState(value, false, true);
        if (originalValueState != null) {
            TextRange range = v.getTextRange();
            List amendedStates = ContainerUtil.map((Collection)this.myProcessedRanges.get((Object)range), s -> s.copy(new PhpDfaDelegateBasedTypeState("", (PhpDfaBasedTypeState)s.getState(), originalValueState)));
            this.put(range, amendedStates);
        }
    }

    private static Collection<PsiElement> createChooseArgumentState(FunctionReference functionCall, IntSet indices) {
        ArrayList<PsiElement> chosenArguments = new ArrayList<PsiElement>();
        indices.forEach(i -> chosenArguments.add(functionCall.getParameter(i)));
        return !chosenArguments.contains(null) && !chosenArguments.isEmpty() ? chosenArguments : Collections.emptyList();
    }

    public boolean registerStateFromAssignedValue(PhpInstruction instruction, @Nullable PsiElement value, @Nullable PsiElement variable) {
        if (value == null) {
            return false;
        }
        CharSequence variableName = variable != null ? this.computeVariableName(variable) : null;
        AssignmentExpression assignment = PhpPsiUtil.getParentOfClass(value, AssignmentExpression.class);
        if (assignment != null && assignment.getParent() instanceof PhpStaticStatement) {
            return false;
        }
        if (assignment instanceof SelfAssignmentExpression) {
            if (((SelfAssignmentExpression)assignment).getOperationType() == PhpTokenTypes.opCONCAT_ASGN) {
                this.registerState(instruction, value.getTextRange(), (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>)new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(variableName, ALWAYS_STRING, instruction));
                return true;
            }
            return false;
        }
        this.myEffectiveWriteInstruction.add(instruction);
        if (value instanceof NewExpression) {
            ClassReference reference = ((NewExpression)value).getClassReference();
            String fqn = this.getFQN(reference);
            if (StringUtil.isNotEmpty((String)fqn)) {
                PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> state = new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(variableName, PhpDfaBaseStateConditionDFAnalyzer.PhpClassEqualToState.createClassEqualInstance(reference.getProject(), fqn, this.myGlobal), instruction);
                this.registerState(instruction, TextRange.EMPTY_RANGE, (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>)state);
                return true;
            }
        } else if (this.doRegisterStateFromAssignedValue(instruction, value, variableName)) {
            return true;
        }
        return this.myRestartable && this.registerStateFromPreviousAssignedValue(instruction, value, value.getTextRange());
    }

    private String getFQN(ClassReference reference) {
        Set fqns;
        if (reference != null && this.myGlobal && (fqns = reference.multiResolveStrict(Method.class).stream().map(PhpClassMember::getContainingClass).filter(Objects::nonNull).map(PhpNamedElement::getFQN).collect(Collectors.toSet())).size() == 1) {
            return (String)ContainerUtil.getOnlyItem(fqns);
        }
        return reference != null ? reference.getFQN() : null;
    }

    protected boolean doRegisterStateFromAssignedValue(PhpInstruction instruction, @Nullable PsiElement value, CharSequence variableName) {
        if (value == null) {
            return false;
        }
        PhpDfaBasedTypeState primitiveTypeCheckState = this.createAnalyzer(true).getPrimitiveTypeCheckState(value, false, true);
        if (primitiveTypeCheckState != null) {
            PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> state = new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(variableName, primitiveTypeCheckState, instruction);
            this.registerState(instruction, value.getTextRange(), (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>)state);
            if (this.myRestartable) {
                this.registerStateFromPreviousAssignedValue(instruction, value, value.getTextRange());
            }
            return true;
        }
        return false;
    }

    protected CharSequence computeVariableName(PsiElement variable) {
        return this.myVariableName;
    }

    private boolean registerStateFromPreviousAssignedValue(PhpInstruction instruction, PsiElement value, TextRange range) {
        PhpPreviousDfaAnalyzerProcessor analyzer;
        PhpStateArgumentInfo info = PhpStateArgumentInfo.tryCreateInfo(value, this.myGlobal);
        if (info != null && (analyzer = PhpConditionAlreadyCheckedInspection.createAnalyzer(this.myProject, info.getArgumentName(), this.myStopOnNegations, value.getTextRange(), value, this.createStateWithInstruction(instruction), info instanceof PhpStateArgumentInfo.PhpFunctionStateArgumentInfo ? info : null, this.myGlobal)) != null && instruction.num() < this.myCurrentState.getInstruction().num()) {
            PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> instruction1 = this.getStateFromPreviousInstruction(instruction, analyzer);
            return this.registerStateFromPreviousInstruction(instruction, range, this.updateWithCurrentVariableName(instruction1));
        }
        return false;
    }

    @NotNull
    private PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> createStateWithInstruction(PhpInstruction instruction) {
        return new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(this.myCurrentState.getVariableName(), (PhpDfaBasedTypeState)this.myCurrentState.getState(), instruction, this.myCurrentState.getInfo());
    }

    @Nullable
    private PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> updateWithCurrentVariableName(PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> stateFromPreviousInstruction) {
        if (stateFromPreviousInstruction == null || this.myArgumentName == null) {
            return null;
        }
        return new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(this.myArgumentName, (PhpDfaBasedTypeState)stateFromPreviousInstruction.getState(), stateFromPreviousInstruction.getInstruction(), stateFromPreviousInstruction.getInfo());
    }

    @Override
    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
        if (!this.processInstruction((PhpInstruction)instruction)) {
            return false;
        }
        ArrayAccessExpression anchor = (ArrayAccessExpression)instruction.getAnchor();
        if (this.sameElement((PsiElement)anchor.getValue()) && PhpConditionAlreadyCheckedInspection.isModifyingAccess(instruction.getAccess(), this.myGlobal)) {
            this.setUnknownState((PhpInstruction)instruction, this.computeVariableName(instruction, (PsiElement)anchor.getValue()));
            return false;
        }
        return super.processArrayAccessInstruction(instruction);
    }

    @Nullable
    protected CharSequence computeVariableName(PhpArrayAccessInstruction instruction, PsiElement anchor) {
        return this.computeVariableName(anchor);
    }

    @Override
    @Nullable
    public PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> getState() {
        PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> state;
        PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> rangeVariableState;
        PhpDfaBasedTypeState rangesState = this.myAnchor instanceof FieldReference || this.myAnchor instanceof FunctionReference ? PhpDfaBaseStateConditionDFAnalyzer.getIntBoundRangesState(this.myAnchor, this.myGlobal) : null;
        PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> phpVariableDfaStateWithInstruction = rangeVariableState = rangesState != null ? new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(this.computeVariableName(this.myAnchor), rangesState, this.myCurrentState.getInstruction()) : null;
        if (this.myAmbiguous || this.myRecurrentlyProcessedInstruction != null && ContainerUtil.exists(this.myEffectiveWriteInstruction, i -> i.num() > this.myRecurrentlyProcessedInstruction.num())) {
            return rangeVariableState;
        }
        if (this.myRestartable) {
            for (Map.Entry entry : this.myPreviousStatesProcessors.entrySet()) {
                for (PhpPreviousDfaAnalyzerProcessor processor2 : (Collection)entry.getValue()) {
                    PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> state2 = this.getStateFromPreviousInstruction((PhpInstruction)entry.getKey(), processor2);
                    this.registerStateFromPreviousInstruction((PhpInstruction)entry.getKey(), processor2.myOuterTextRange, this.updateWithCurrentVariableName(state2));
                }
            }
        }
        if ((state = super.getState()) == null) {
            return rangeVariableState;
        }
        if (rangeVariableState != null) {
            return this.composeStates(rangeVariableState, state, "COMBINED WITH DECLARED RANGE");
        }
        return state;
    }

    @Override
    protected PhpDfaBasedTypeState composeStrictState(PhpDfaBasedTypeState state) {
        if (state instanceof PhpDfaDelegateBasedTypeState && state.coveredBy(this.myProject, PhpDfaBaseStateConditionDFAnalyzer.ALWAYS_BOOL, this.myGlobal)) {
            boolean trueCompatible = state.coveredBy(this.myProject, PhpDfaBasedTypeState.NOT_FALSE, this.myGlobal);
            boolean falseCompatible = state.coveredBy(this.myProject, PhpDfaBaseStateConditionDFAnalyzer.PROBABLY_FALSE, this.myGlobal);
            if (trueCompatible && !falseCompatible) {
                state = new PhpCompositeTypeState(state, PhpDfaBaseStateConditionDFAnalyzer.STRICT_ALWAYS_TRUE);
            } else if (!trueCompatible && falseCompatible) {
                state = new PhpCompositeTypeState(state, PhpDfaBasedTypeState.ALWAYS_FALSE);
            }
        }
        for (PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker checker : PRIMITIVE_TYPE_CHECKERS) {
            PhpCompositeTypeState strictComparison = this.composeStrictStateFromPrimitiveCheckers(state, checker);
            if (strictComparison == null) continue;
            state = strictComparison;
        }
        if (state instanceof PhpDfaDelegateBasedTypeState && !(state instanceof PhpAmbiguousCompositeTypeState)) {
            List<PhpDfaBasedTypeState> delegates = ((PhpDfaDelegateBasedTypeState)state).delegates().toList();
            for (PhpDfaBasedTypeState delegate : delegates) {
                for (PhpDfaBasedTypeState secondDelegate : delegates) {
                    if (delegate == secondDelegate) continue;
                    HashSet<PhpDfaBasedTypeState> visited = new HashSet<PhpDfaBasedTypeState>();
                    PhpPreviousDfaAnalyzerProcessor.processAmbiguousDelegatesRecursively(delegate, visited, (parent, child) -> {
                        if (secondDelegate != child && secondDelegate.excludedBy(this.myProject, (PhpDfaBasedTypeState)child, false)) {
                            this.mySkippedStates.putValue(parent, child);
                            visited.add((PhpDfaBasedTypeState)child);
                        }
                    });
                }
            }
        }
        return state;
    }

    private static void processAmbiguousDelegatesRecursively(PhpDfaBasedTypeState delegate, Collection<PhpDfaBasedTypeState> visited, BiConsumer<PhpDfaBasedTypeState, PhpDfaBasedTypeState> consumer) {
        if (!visited.add(delegate)) {
            return;
        }
        if (delegate instanceof PhpAmbiguousCompositeTypeState) {
            ((PhpAmbiguousCompositeTypeState)delegate).delegates().filter(e -> !(e instanceof PhpAmbiguousCompositeTypeState)).forEach(d -> consumer.accept(delegate, (PhpDfaBasedTypeState)d));
        }
        if (delegate instanceof PhpDfaDelegateBasedTypeState) {
            ((PhpDfaDelegateBasedTypeState)delegate).delegates().forEach(d -> PhpPreviousDfaAnalyzerProcessor.processAmbiguousDelegatesRecursively(d, visited, consumer));
        }
    }

    @Nullable
    private PhpCompositeTypeState composeStrictStateFromPrimitiveCheckers(PhpDfaBasedTypeState state, PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker checker) {
        PhpDfaBasedTypeState[] strictComparisons;
        if (state instanceof PhpDfaDelegateBasedTypeState && state.coveredBy(this.myProject, checker, this.myGlobal) && (strictComparisons = (PhpDfaBasedTypeState[])((StreamEx)((StreamEx)StreamEx.of(((PhpDfaDelegateBasedTypeState)state).delegates()).select(PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByComparison.class).filter(c -> !c.isNegated())).filter(c -> this.isProducingSameTypeContract(checker, (PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByComparison)c))).map(PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByComparison::createStrict).append((Object)state).toArray((Object[])PhpDfaBasedTypeState.EMPTY_ARRAY)).length > 1) {
            return new PhpCompositeTypeState(strictComparisons);
        }
        return null;
    }

    private boolean isProducingSameTypeContract(PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker checker, PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByComparison c) {
        PhpType comparisonType = c.getComparisonOperand().getTypeFromIdentityCheckOnScalar(this.myGlobal);
        return PhpTypeConditionDFAnalyzer.getPrimitiveTypeCheckerTypeFromName(comparisonType).contains(checker.getPrimitiveTypeCheckerName());
    }

    @Override
    public boolean processInstruction(PhpInstruction instruction) {
        if (this.myConditionToStop != null && this.myConditionToStop.test((PhpInstruction)instruction)) {
            if (this.myInjectedState != null && instruction.getAnchor() != null) {
                this.registerState(instruction, instruction.getAnchor().getTextRange(), this.myInjectedState);
            }
            return false;
        }
        if (this.isInnerRangeToSkip(instruction)) {
            return true;
        }
        if (PhpPreviousDfaAnalyzerProcessor.dependenciesMayBeInvalidated(instruction, this.myStateDependenciesCheckers, this.myGlobal)) {
            this.myAmbiguous = true;
            this.haltTraversal();
            return false;
        }
        return super.processInstruction(instruction);
    }

    public static boolean dependenciesMayBeInvalidated(PhpInstruction instruction, Collection<Function<PhpInstruction, Boolean>> checkers, boolean global) {
        if (instruction instanceof PhpCallInstruction) {
            return ContainerUtil.exists(checkers, d -> (Boolean)d.apply(instruction));
        }
        if (instruction instanceof PhpAccessInstruction && !PhpPreviousDfaAnalyzerProcessor.isLocalRead(((PhpAccessInstruction)instruction).getAccess()) && ContainerUtil.exists(checkers, d -> (Boolean)d.apply(instruction))) {
            return PhpConditionAlreadyCheckedInspection.isModifyingAccess(((PhpAccessInstruction)instruction).getAccess(), global);
        }
        return false;
    }

    private static boolean isLocalRead(PhpAccessInstruction.Access access) {
        return !(access instanceof PhpAccessInstruction.ReadOrReadRefAccess) && access.isRead();
    }

    protected void registerUnsetOrUnknownState(PhpAccessInstruction instruction, CharSequence variableName) {
        if (instruction.getAccess().isUnset()) {
            PhpPsiElement anchor = instruction.getAnchor();
            this.registerState((PhpInstruction)instruction, anchor.getTextRange(), (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>)new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(variableName, PhpDfaBaseStateConditionDFAnalyzer.NOT_ISSET, (PhpInstruction)instruction));
        } else {
            this.setUnknownState((PhpInstruction)instruction, variableName);
        }
    }

    protected void setUnknownState(PhpInstruction instruction, CharSequence variableName) {
        this.setState(new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(variableName, PhpDfaBasedTypeState.UNKNOWN, instruction));
    }

    public abstract boolean sameElement(@Nullable PsiElement var1);

    @Override
    protected boolean registerState(PhpInstruction instruction, TextRange outerRange, @NotNull PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState> state) {
        boolean result;
        if (state == null) {
            PhpPreviousDfaAnalyzerProcessor.$$$reportNull$$$0(4);
        }
        if (!(result = super.registerState(instruction, outerRange, state))) {
            if (instruction instanceof PhpConditionInstruction) {
                PhpPreviousDfaAnalyzerProcessor processor2 = this.createProcessor(outerRange);
                if (this.myConditionToStop != null) {
                    processor2.myConditionToStop = this.myConditionToStop;
                }
                if (this.myInjectedState != null) {
                    processor2.myInjectedState = this.myInjectedState;
                }
                this.registerProcessorToRestartPassForPreviousStates(instruction, processor2);
            }
            this.registerStateFromVariableComparisons(instruction, outerRange, state.getState());
        }
        return result;
    }

    private void registerStateFromVariableComparisons(PhpInstruction instruction, TextRange outerRange, PhpDfaBasedTypeState dfaState) {
        if (!this.myRestartable) {
            return;
        }
        PhpStateArgumentInfo info = PhpPreviousDfaAnalyzerProcessor.getInfoFromVariableComparisons(dfaState);
        if (info == null) {
            return;
        }
        PsiElement variable = (PsiElement)ContainerUtil.find((Iterable)PsiTreeUtil.findChildrenOfType((PsiElement)this.myLastDfaInstruction.getAnchor(), PhpPsiElement.class), v -> this.sameInfo(info, (PsiElement)v));
        if (variable == null) {
            return;
        }
        PhpPreviousDfaAnalyzerProcessor analyzer = PhpConditionAlreadyCheckedInspection.createAnalyzer(this.myProject, info.getArgumentName(), this.myStopOnNegations, outerRange, variable, this.myCurrentState, info instanceof PhpStateArgumentInfo.PhpFunctionStateArgumentInfo ? info : null, this.myGlobal);
        if (analyzer != null) {
            this.registerProcessorToRestartPassForPreviousStates(instruction, analyzer);
        }
    }

    private void registerProcessorToRestartPassForPreviousStates(PhpInstruction instruction, PhpPreviousDfaAnalyzerProcessor processor2) {
        if (!this.myRestartable) {
            return;
        }
        if (instruction.num() <= this.myCurrentState.getInstruction().num()) {
            this.myPreviousStatesProcessors.putValue((Object)instruction, (Object)processor2);
        }
    }

    @Nullable
    private static PhpStateArgumentInfo getInfoFromVariableComparisons(PhpDfaBasedTypeState dfaState) {
        if (dfaState instanceof PhpVariableBasedTypeState && !((PhpVariableBasedTypeState)((Object)dfaState)).isNegated()) {
            if (dfaState instanceof PhpStrictVariableCheckDfaBasedTypeState) {
                return ((PhpStrictVariableCheckDfaBasedTypeState)dfaState).myArgumentInfo;
            }
            if (dfaState instanceof PhpVariableCheckDfaBasedTypeState) {
                return ((PhpVariableCheckDfaBasedTypeState)dfaState).myArgumentInfo;
            }
        }
        return null;
    }

    private boolean sameInfo(PhpStateArgumentInfo info, PsiElement v) {
        PhpStateArgumentInfo curInfo = PhpStateArgumentInfo.tryCreateInfo(v, this.myGlobal);
        return curInfo != null && curInfo.getArgumentName().equals(info.getArgumentName());
    }

    protected boolean registerStateFromPreviousInstruction(PhpInstruction instruction, TextRange outerRange, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> s) {
        PhpInstruction prevInstruction;
        if (s != null && !this.isUnknown((PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>)s) && this.sameVariableName(s.getVariableName()) && (prevInstruction = s.getInstruction()) != null && prevInstruction.num() < instruction.num()) {
            this.put(outerRange, this.composeStates(outerRange, s));
            return true;
        }
        return false;
    }

    @NotNull
    protected List<PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>> composeStates(TextRange outerRange, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> s) {
        ArrayList<PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState> composed = new ArrayList<PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState>();
        for (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState dfaState : new ArrayList(this.myProcessedRanges.get((Object)outerRange))) {
            if (this.sameVariableName(dfaState.getVariableName())) {
                composed.add(new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpCompositeTypeState>(dfaState.getVariableName(), new PhpCompositeTypeState((PhpDfaBasedTypeState)dfaState.getState(), (PhpDfaBasedTypeState)s.getState())));
                continue;
            }
            composed.add(dfaState);
        }
        List<PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<Object>> list = composed.isEmpty() ? Collections.singletonList(s) : composed;
        if (list == null) {
            PhpPreviousDfaAnalyzerProcessor.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    protected PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> getStateFromPreviousInstruction(PhpInstruction instruction, PhpPreviousDfaAnalyzerProcessor processor2) {
        if (this.myDepth > 250) {
            return null;
        }
        processor2.myProcessedRangesMinStartOffset = this.myProcessedRangesMinStartOffset;
        processor2.myAlreadyCheckedRanges.addAll(this.myProcessedRanges.keySet());
        processor2.myProcessedRangesMinStartOffset = Math.min(processor2.myProcessedRangesMinStartOffset, PhpPreviousDfaAnalyzerProcessor.findMinStartOffset(this.myProcessedRanges.keySet()));
        processor2.myAlreadyCheckedRanges.addAll(this.myAlreadyCheckedRanges);
        processor2.myProcessedRangesMinStartOffset = Math.min(processor2.myProcessedRangesMinStartOffset, PhpPreviousDfaAnalyzerProcessor.findMinStartOffset(this.myAlreadyCheckedRanges));
        if (this.myConditionToStop != null) {
            processor2.setConditionToStop(this.myConditionToStop);
        }
        processor2.myDepth = this.myDepth + 1;
        PhpControlFlowUtil.processPredecessors(instruction, false, processor2);
        return processor2.getState();
    }

    private static int findMinStartOffset(@NotNull Collection<TextRange> ranges) {
        if (ranges == null) {
            PhpPreviousDfaAnalyzerProcessor.$$$reportNull$$$0(6);
        }
        return ranges.stream().mapToInt(TextRange::getStartOffset).min().orElse(Integer.MAX_VALUE);
    }

    protected abstract PhpPreviousDfaAnalyzerProcessor createProcessor(TextRange var1);

    public void handleSelfInstructionRecurringProcess(@NotNull PhpInstruction originalInstruction, @NotNull PhpInstruction recurrentlyProcessedInstruction) {
        if (originalInstruction == null) {
            PhpPreviousDfaAnalyzerProcessor.$$$reportNull$$$0(7);
        }
        if (recurrentlyProcessedInstruction == null) {
            PhpPreviousDfaAnalyzerProcessor.$$$reportNull$$$0(8);
        }
        this.myRecurrentlyProcessedInstruction = originalInstruction;
    }

    public MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> getSkippedStates() {
        return this.mySkippedStates;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpPreviousDfaAnalyzerProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalInstruction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recurrentlyProcessedInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateDependenciesCheckers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnalyzer";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpPreviousDfaAnalyzerProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "composeStates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findMinStartOffset";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleSelfInstructionRecurringProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

