/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpCustomExitPointRegistry;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInterruptScriptInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpYieldInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpReturnInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpThrowInterruptionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpYieldInstructionImpl;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInconsistentReturnPointsInspection;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNeverTypedFunctionReturnViolationInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpNeverTypedFunctionReturnViolationInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                if (function.getDeclaredType().equals((Object)PhpType.NEVER)) {
                    for (PsiElement element : PhpNeverTypedFunctionReturnViolationInspection.collectReturnElementsToHighlight(function)) {
                        holder.registerProblem(element, PhpBundle.message("inspection.message.never.returning.function.must.not.return", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }

            public void visitPhpMethod(Method method) {
                if (method instanceof PhpDocMethod) {
                    return;
                }
                this.visitPhpFunction((Function)method);
            }
        };
    }

    @NotNull
    private static Collection<PsiElement> collectReturnElementsToHighlight(final Function function) {
        final HashSet<@NotNull PsiElement> returnElementsToHighlight = new HashSet<PsiElement>();
        PhpControlFlowUtil.processSuccessors((PhpInstruction)PhpCustomExitPointRegistry.getControlFlow((PhpScopeHolder)function).getEntryPoint(), false, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction instruction) {
                PsiElement anchor = instruction.getAnchor();
                if (anchor != null && anchor.getParent() instanceof PhpReturn) {
                    returnElementsToHighlight.add(anchor.getParent());
                    return false;
                }
                if (instruction instanceof PhpThrowInterruptionInstruction) {
                    return false;
                }
                return super.processInstruction(instruction);
            }

            public boolean processCatchConditionInstruction(PhpCatchConditionInstruction instruction) {
                return instruction.getResult();
            }

            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                returnElementsToHighlight.add(((PhpReturnInstructionImpl)instruction).getReturnStatement());
                return false;
            }

            public boolean processYieldInstruction(PhpYieldInstruction instruction) {
                returnElementsToHighlight.add(((PhpYieldInstructionImpl)instruction).getStatement());
                return false;
            }

            public boolean processInterruptScriptInstruction(PhpInterruptScriptInstruction instruction) {
                return false;
            }

            public boolean processExitPointInstruction(PhpExitPointInstruction instruction) {
                ContainerUtil.addIfNotNull((Collection)returnElementsToHighlight, (Object)PhpInconsistentReturnPointsInspection.getClosingBrace(function));
                return false;
            }
        });
        HashSet<PsiElement> hashSet = returnElementsToHighlight;
        if (hashSet == null) {
            PhpNeverTypedFunctionReturnViolationInspection.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP810;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpNeverTypedFunctionReturnViolationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpNeverTypedFunctionReturnViolationInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReturnElementsToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

