/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpConvertLoopToArrayMapQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.AssignmentExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpLoopCanBeConvertedToArrayMapInspection
extends PhpInspection {
    public static final int MAXIMUM_RECURSION_DEPTH = 200;
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{new PhpConvertLoopToArrayMapQuickFix()};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpLoopCanBeConvertedToArrayMapInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpForeach(ForeachStatement foreach) {
                PhpPsiElement array;
                Variable key = foreach.getKey();
                if (key == null) {
                    return;
                }
                Variable value = foreach.getValue();
                if (value == null || PhpWorkaroundUtil.isReadReference((PsiElement)value)) {
                    return;
                }
                AssignmentExpression arrayDeclaration = PhpLoopCanBeConvertedToArrayMapInspection.getEmptyArrayDeclaration((Statement)PhpPsiUtil.getPrevSiblingByCondition((PsiElement)foreach, (Condition<? super PsiElement>)Statement.INSTANCEOF));
                PhpPsiElement phpPsiElement = array = arrayDeclaration != null ? arrayDeclaration.getVariable() : null;
                if (array != null && PhpLoopCanBeConvertedToArrayMapInspection.isSingleArrayPushStatement((PsiElement)foreach.getStatement(), array.getName(), key.getName())) {
                    holder.registerProblem(foreach.getFirstChild(), PhpBundle.message("inspection.loop.can.be.converted.to.arraymap", new Object[0]), FIXES);
                }
            }
        };
    }

    @Contract(value="null -> null")
    @Nullable
    public static AssignmentExpression getEmptyArrayDeclaration(@Nullable Statement statement) {
        AssignmentExpression arrayDeclaration = statement != null ? (AssignmentExpression)ObjectUtils.tryCast((Object)statement.getFirstChild(), AssignmentExpressionImpl.class) : null;
        return PhpLoopCanBeConvertedToArrayMapInspection.isEmptyArrayDeclaration(arrayDeclaration) ? arrayDeclaration : null;
    }

    @Contract(value="null -> false")
    private static boolean isEmptyArrayDeclaration(@Nullable AssignmentExpression expression) {
        Variable variable = expression != null ? (Variable)ObjectUtils.tryCast((Object)expression.getVariable(), Variable.class) : null;
        return variable != null && variable.isDeclaration() && PhpLoopCanBeConvertedToArrayMapInspection.isEmptyArrayCreation((PsiElement)expression.getValue());
    }

    public static boolean isEmptyArrayCreation(@Nullable PsiElement variable) {
        return variable instanceof ArrayCreationExpression && ((ArrayCreationExpression)variable).getFirstPsiChild() == null;
    }

    @Nullable
    public static Statement unwrapStatement(@Nullable Statement statement) {
        while (statement instanceof GroupStatement) {
            List statements = ContainerUtil.filter((Object[])((GroupStatement)statement).getStatements(), (Condition)Statement.INSTANCEOF);
            statement = statements.size() == 1 ? (Statement)ObjectUtils.tryCast(statements.get(0), Statement.class) : null;
        }
        return statement;
    }

    public static boolean isSingleArrayPushStatement(@Nullable PsiElement statement, @Nullable String arrayName, @NotNull String keyName) {
        if (keyName == null) {
            PhpLoopCanBeConvertedToArrayMapInspection.$$$reportNull$$$0(1);
        }
        if (arrayName == null) {
            return false;
        }
        return (statement = PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement((Statement)ObjectUtils.tryCast((Object)statement, Statement.class))) != null && PhpLoopCanBeConvertedToArrayMapInspection.isArrayPushByKey(((Statement)statement).getFirstPsiChild(), arrayName, keyName);
    }

    public static boolean isArrayPushByKey(@Nullable PhpPsiElement element, @NotNull String arrayName, @NotNull String keyName) {
        if (arrayName == null) {
            PhpLoopCanBeConvertedToArrayMapInspection.$$$reportNull$$$0(2);
        }
        if (keyName == null) {
            PhpLoopCanBeConvertedToArrayMapInspection.$$$reportNull$$$0(3);
        }
        if (element instanceof AssignmentExpression && !(element instanceof SelfAssignmentExpression)) {
            ArrayAccessExpression arrayAccess = (ArrayAccessExpression)ObjectUtils.tryCast((Object)((AssignmentExpression)element).getVariable(), ArrayAccessExpression.class);
            ArrayIndex accessIndex = arrayAccess != null ? arrayAccess.getIndex() : null;
            PhpPsiElement accessIndexValue = accessIndex != null ? (PhpPsiElement)ObjectUtils.tryCast((Object)accessIndex.getValue(), Variable.class) : null;
            PhpPsiElement pushValue = ((AssignmentExpression)element).getValue();
            if (accessIndexValue != null && pushValue != null && StringUtil.equals((CharSequence)accessIndexValue.getName(), (CharSequence)keyName)) {
                Variable variable = (Variable)ObjectUtils.tryCast((Object)arrayAccess.getValue(), Variable.class);
                return variable != null && StringUtil.equals((CharSequence)variable.getName(), (CharSequence)arrayName) && !PhpLoopCanBeConvertedToArrayMapInspection.collectUsedVariables((PsiElement)pushValue, ContainerUtil.emptyList()).contains(keyName);
            }
        }
        return false;
    }

    @NotNull
    public static Set<String> collectUsedVariables(@Nullable PsiElement element, @NotNull Collection<String> ignoredNames) {
        if (ignoredNames == null) {
            PhpLoopCanBeConvertedToArrayMapInspection.$$$reportNull$$$0(4);
        }
        HashSet<String> result = new HashSet<String>();
        for (Variable variable : new ArrayList(PsiTreeUtil.findChildrenOfAnyType((PsiElement)element, (boolean)false, (Class[])new Class[]{Variable.class}))) {
            String name;
            if (!variable.canReadName()) {
                variable = (Variable)PsiTreeUtil.findChildOfType((PsiElement)variable, Variable.class);
            }
            if ((name = variable != null ? variable.getName() : "").isEmpty() || StringUtil.equals((CharSequence)"this", (CharSequence)name) || ignoredNames.contains(name)) continue;
            result.add(name);
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            PhpLoopCanBeConvertedToArrayMapInspection.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayMapInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayMapInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUsedVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSingleArrayPushStatement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isArrayPushByKey";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectUsedVariables";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

