/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpCombineMultipleIssetCallsIntoOneInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.patterns.PhpPatterns;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIssetCanCheckNestedAccessDirectlyInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIssetCanCheckNestedAccessDirectlyInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                if (expression.getOperationType() != PhpTokenTypes.opAND || !PhpCombineMultipleIssetCallsIntoOneInspection.isTopmostLogicalAndExpression(expression)) {
                    return;
                }
                PhpMultipleIssetCallsDescriptor descriptor = PhpIssetCanCheckNestedAccessDirectlyInspection.getMultipleIssetCallsDescriptor(expression);
                if (descriptor == null) {
                    return;
                }
                List<PhpPsiElement> smallerDimensionIssetArguments = descriptor.mySmallerDimensionIssetArguments;
                if (smallerDimensionIssetArguments.isEmpty() || PhpSideEffectDetector.canContainSideEffect((PsiElement)expression)) {
                    return;
                }
                LocalQuickFix fix = LocalQuickFix.from((ModCommandAction)new PhpDeleteRedundantIssetCallsQuickFix(expression, descriptor));
                smallerDimensionIssetArguments.forEach(element -> holder.registerProblem((PsiElement)element, PhpBundle.message("inspection.php.isset.can.check.nested.access.directly", new Object[0]), new LocalQuickFix[]{fix}));
            }
        };
    }

    @Nullable
    public static PhpPsiElement getValue(@NotNull PhpPsiElement nestedElementAccess) {
        if (nestedElementAccess == null) {
            PhpIssetCanCheckNestedAccessDirectlyInspection.$$$reportNull$$$0(1);
        }
        if (nestedElementAccess instanceof ArrayAccessExpression) {
            return ((ArrayAccessExpression)nestedElementAccess).getValue();
        }
        if (nestedElementAccess instanceof FieldReference) {
            return ((FieldReference)nestedElementAccess).getClassReference();
        }
        return null;
    }

    private static boolean isSubArgument(PhpPsiElement argument, PhpPsiElement subArgument) {
        while (argument != null) {
            if (PhpPsiUtil.areElementsEquivalent((PsiElement)argument, (PsiElement)subArgument)) {
                return true;
            }
            argument = PhpIssetCanCheckNestedAccessDirectlyInspection.getValue(argument);
        }
        return false;
    }

    private static boolean issetIsDirectExpressionOperand(PsiElement element) {
        PsiElement psiElement = element.getParent();
        if (!(psiElement instanceof PhpIsset)) {
            return false;
        }
        PhpIsset isset = (PhpIsset)psiElement;
        PsiElement psiElement2 = isset.getParent();
        if (!(psiElement2 instanceof BinaryExpression)) {
            return false;
        }
        BinaryExpression expression = (BinaryExpression)psiElement2;
        return expression.getOperationType() == PhpTokenTypes.opAND;
    }

    @Nullable
    private static PhpMultipleIssetCallsDescriptor getMultipleIssetCallsDescriptor(BinaryExpression expression) {
        List allIssetArguments = PsiTreeUtil.findChildrenOfAnyType((PsiElement)expression, (Class[])new Class[]{ArrayAccessExpression.class, FieldReference.class, Variable.class}).stream().filter(x$0 -> PhpIssetCanCheckNestedAccessDirectlyInspection.issetIsDirectExpressionOperand((PsiElement)x$0)).sorted((a, b) -> b.getText().length() - a.getText().length()).collect(Collectors.toList());
        ArrayList<PhpPsiElement> smallerDimensionIssetArguments = new ArrayList<PhpPsiElement>();
        ArrayList<PhpPsiElement> largestDimensionIssetArguments = new ArrayList<PhpPsiElement>();
        for (int i = 0; i < allIssetArguments.size(); ++i) {
            PhpPsiElement argument = (PhpPsiElement)allIssetArguments.get(i);
            if (smallerDimensionIssetArguments.contains(argument)) continue;
            for (int j = i + 1; j < allIssetArguments.size(); ++j) {
                PhpPsiElement smallerDimensionArgument = (PhpPsiElement)allIssetArguments.get(j);
                if (!PhpIssetCanCheckNestedAccessDirectlyInspection.isSubArgument(argument, smallerDimensionArgument)) continue;
                smallerDimensionIssetArguments.add(smallerDimensionArgument);
            }
            largestDimensionIssetArguments.add(argument);
        }
        if (largestDimensionIssetArguments.isEmpty() || smallerDimensionIssetArguments.isEmpty()) {
            return null;
        }
        return new PhpMultipleIssetCallsDescriptor(largestDimensionIssetArguments, smallerDimensionIssetArguments);
    }

    @Nullable
    private static PhpExpression construct(Project project, Collection<PhpPsiElement> issetArguments, Collection<PsiElement> otherOperands) {
        String operandsString = (String)((StreamEx)StreamEx.of(issetArguments).map(o -> String.format("isset(%s)", o.getText())).append((Stream)StreamEx.of(otherOperands).map(PsiElement::getText))).collect(Collectors.joining(" && "));
        return PhpPsiElementFactory.createFirstFromText(project, PhpExpression.class, operandsString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedElementAccess";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpIssetCanCheckNestedAccessDirectlyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpMultipleIssetCallsDescriptor {
        private final List<PhpPsiElement> myLargestDimensionIssetArguments;
        private final List<PhpPsiElement> mySmallerDimensionIssetArguments;

        private PhpMultipleIssetCallsDescriptor(List<PhpPsiElement> largestDimensionIssetArguments, List<PhpPsiElement> smallerDimensionIssetArguments) {
            this.myLargestDimensionIssetArguments = largestDimensionIssetArguments;
            this.mySmallerDimensionIssetArguments = smallerDimensionIssetArguments;
        }
    }

    private static class PhpDeleteRedundantIssetCallsQuickFix
    extends PsiUpdateModCommandAction<BinaryExpression> {
        private final List<SmartPsiElementPointer<PhpPsiElement>> myLargestDimensionIssetArguments;

        protected PhpDeleteRedundantIssetCallsQuickFix(@NotNull BinaryExpression element, PhpMultipleIssetCallsDescriptor descriptor) {
            if (element == null) {
                PhpDeleteRedundantIssetCallsQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
            this.myLargestDimensionIssetArguments = ContainerUtil.map(descriptor.myLargestDimensionIssetArguments, SmartPointerManager::createPointer);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.php.delete.redundant.isset.calls", new Object[0]);
            if (string == null) {
                PhpDeleteRedundantIssetCallsQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull BinaryExpression expression, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpDeleteRedundantIssetCallsQuickFix.$$$reportNull$$$0(2);
            }
            if (expression == null) {
                PhpDeleteRedundantIssetCallsQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpDeleteRedundantIssetCallsQuickFix.$$$reportNull$$$0(4);
            }
            List otherOperands = ContainerUtil.filter(PhpPatterns.unwrapOperation((PsiElement)expression, PhpTokenTypes.opAND), e -> !(e instanceof PhpIsset));
            List dimensions = StreamEx.of(this.myLargestDimensionIssetArguments).nonNull().map(SmartPsiElementPointer::getElement).toList();
            PhpExpression newExpression = PhpIssetCanCheckNestedAccessDirectlyInspection.construct(context.project(), dimensions, otherOperands);
            if (newExpression == null) {
                return;
            }
            expression.replace((PsiElement)newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpIssetCanCheckNestedAccessDirectlyInspection$PhpDeleteRedundantIssetCallsQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpIssetCanCheckNestedAccessDirectlyInspection$PhpDeleteRedundantIssetCallsQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

