/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCatchWithInstanceOfCanBeReplacedWithSpecificCatchesInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpCatchWithInstanceOfCanBeReplacedWithSpecificCatchesInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpCatch(Catch phpCatch) {
                if (phpCatch.getException() == null) {
                    return;
                }
                GroupStatement groupStatement = (GroupStatement)PsiTreeUtil.findChildOfType((PsiElement)phpCatch, GroupStatement.class);
                if (groupStatement == null || groupStatement.getChildren().length != 1) {
                    return;
                }
                if (PsiTreeUtil.getChildOfType((PsiElement)groupStatement, PsiComment.class) != null) {
                    return;
                }
                If ifStatement = (If)ObjectUtils.tryCast((Object)groupStatement.getChildren()[0], If.class);
                if (ifStatement == null) {
                    return;
                }
                if (!PhpCatchWithInstanceOfCanBeReplacedWithSpecificCatchesInspection.canBeConvertedToSpecificCatches(ifStatement, phpCatch.getException())) {
                    return;
                }
                holder.registerProblem(phpCatch.getFirstChild(), PhpBundle.message("inspection.message.instanceof.checks.in.catch.can.be.replaced.with.specific.catches", new Object[0]), new LocalQuickFix[]{PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.INSTANCE});
            }
        };
    }

    private static boolean canBeConvertedToSpecificCatches(If ifStatement, Variable exceptionVariable) {
        if (ifStatement.getElseBranch() == null) {
            return false;
        }
        if (!PhpCatchWithInstanceOfCanBeReplacedWithSpecificCatchesInspection.isInstanceOfExceptionCheck(exceptionVariable, (PsiElement)ifStatement.getCondition())) {
            return false;
        }
        if (!PhpCatchWithInstanceOfCanBeReplacedWithSpecificCatchesInspection.allAreInstanceOfExceptionChecks(exceptionVariable, ifStatement.getElseIfBranches())) {
            return false;
        }
        If embeddedIf = (If)ObjectUtils.tryCast((Object)ifStatement.getElseBranch().getStatement(), If.class);
        if (embeddedIf != null) {
            return PhpCatchWithInstanceOfCanBeReplacedWithSpecificCatchesInspection.canBeConvertedToSpecificCatches(embeddedIf, exceptionVariable);
        }
        return true;
    }

    private static boolean allAreInstanceOfExceptionChecks(Variable exceptionVariable, ElseIf[] elseIfBranches) {
        return ContainerUtil.all(Arrays.asList(elseIfBranches), elseIfBranch -> PhpCatchWithInstanceOfCanBeReplacedWithSpecificCatchesInspection.isInstanceOfExceptionCheck(exceptionVariable, (PsiElement)elseIfBranch.getCondition()));
    }

    private static boolean isInstanceOfExceptionCheck(Variable exceptionVariable, PsiElement condition) {
        BinaryExpression binaryExpression = (BinaryExpression)ObjectUtils.tryCast((Object)condition, BinaryExpression.class);
        if (binaryExpression == null) {
            return false;
        }
        if (binaryExpression.getOperationType() == PhpTokenTypes.opOR) {
            if (!PhpLanguageFeature.CATCH_MULTIPLE.isSupported(condition.getProject())) {
                return false;
            }
            return PhpCatchWithInstanceOfCanBeReplacedWithSpecificCatchesInspection.isInstanceOfExceptionCheck(exceptionVariable, binaryExpression.getLeftOperand()) && PhpCatchWithInstanceOfCanBeReplacedWithSpecificCatchesInspection.isInstanceOfExceptionCheck(exceptionVariable, binaryExpression.getRightOperand());
        }
        if (binaryExpression.getOperationType() != PhpTokenTypes.kwINSTANCEOF) {
            return false;
        }
        ClassReference classReference = (ClassReference)ObjectUtils.tryCast((Object)binaryExpression.getRightOperand(), ClassReference.class);
        if (classReference == null) {
            return false;
        }
        Variable checkedVariable = (Variable)ObjectUtils.tryCast((Object)binaryExpression.getLeftOperand(), Variable.class);
        if (checkedVariable == null || !PhpLangUtil.equalsVariableNames(checkedVariable.getName(), exceptionVariable.getName())) {
            return false;
        }
        return PhpAnnotatorVisitor.isCouldBeDerivedFromException(classReference.getProject(), (PhpTypedElement)classReference);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpCatchWithInstanceOfCanBeReplacedWithSpecificCatchesInspection", "buildVisitor"));
    }

    private static class PhpReplaceInstanceOfInCatchWithSpecificCatchesFix
    extends PsiUpdateModCommandQuickFix {
        private static final PhpReplaceInstanceOfInCatchWithSpecificCatchesFix INSTANCE = new PhpReplaceInstanceOfInCatchWithSpecificCatchesFix();

        private PhpReplaceInstanceOfInCatchWithSpecificCatchesFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.instanceof.checks.in.catch.with.specific.catches", new Object[0]);
            if (string == null) {
                PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Catch phpCatch;
            if (project == null) {
                PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.$$$reportNull$$$0(3);
            }
            if ((phpCatch = (Catch)ObjectUtils.tryCast((Object)element.getParent(), Catch.class)) == null) {
                return;
            }
            If ifStatement = (If)PsiTreeUtil.findChildOfType((PsiElement)phpCatch, If.class);
            if (ifStatement == null) {
                return;
            }
            List<Catch> catches = PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.createCatchesToReplace(phpCatch, ifStatement);
            if (catches.isEmpty()) {
                return;
            }
            PsiElement insertedCatch = phpCatch.replace((PsiElement)catches.get(0));
            for (int i = 1; i < catches.size(); ++i) {
                insertedCatch = insertedCatch.add((PsiElement)catches.get(i));
            }
        }

        @NotNull
        private static List<Catch> createCatchesToReplace(Catch phpCatch, If ifStatement) {
            Catch catchStatementFromIfCondition = PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.createCatchFrom(phpCatch, ifStatement);
            if (catchStatementFromIfCondition == null) {
                List<Catch> list = Collections.emptyList();
                if (list == null) {
                    PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.$$$reportNull$$$0(4);
                }
                return list;
            }
            Else elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                List<Catch> list = Collections.emptyList();
                if (list == null) {
                    PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.$$$reportNull$$$0(5);
                }
                return list;
            }
            List<Catch> defaultCatchFromElseBranch = PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.createCatchFrom(phpCatch, elseBranch);
            if (defaultCatchFromElseBranch.isEmpty()) {
                List<Catch> list = Collections.emptyList();
                if (list == null) {
                    PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.$$$reportNull$$$0(6);
                }
                return list;
            }
            List catchesFromElseIfBranches = ContainerUtil.map((Object[])ifStatement.getElseIfBranches(), elseIfBranch -> PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.getCatchFrom(phpCatch, elseIfBranch));
            if (catchesFromElseIfBranches.contains(null)) {
                List<Catch> list = Collections.emptyList();
                if (list == null) {
                    PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.$$$reportNull$$$0(7);
                }
                return list;
            }
            ArrayList<Catch> catches = new ArrayList<Catch>();
            catches.add(catchStatementFromIfCondition);
            catches.addAll(catchesFromElseIfBranches);
            catches.addAll(defaultCatchFromElseBranch);
            ArrayList<Catch> arrayList = catches;
            if (arrayList == null) {
                PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        @Nullable
        private static Catch getCatchFrom(Catch phpCatch, ElseIf elseIfBranch) {
            return PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.createCatchStatementFrom(phpCatch.getException(), PsiTreeUtil.findChildrenOfType((PsiElement)elseIfBranch.getCondition(), ClassReference.class), (PhpPsiElement)elseIfBranch.getStatement());
        }

        @NotNull
        private static List<Catch> createCatchFrom(Catch phpCatch, Else elseBranch) {
            If ifStatement = (If)ObjectUtils.tryCast((Object)elseBranch.getStatement(), If.class);
            if (ifStatement != null) {
                return PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.createCatchesToReplace(phpCatch, ifStatement);
            }
            List<Catch> list = Collections.singletonList(PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.createCatchStatementFrom(phpCatch.getException(), phpCatch.getExceptionTypes(), elseBranch.getStatement()));
            if (list == null) {
                PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.$$$reportNull$$$0(9);
            }
            return list;
        }

        @Nullable
        private static Catch createCatchFrom(Catch phpCatch, If ifStatement) {
            return PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.createCatchStatementFrom(phpCatch.getException(), PsiTreeUtil.findChildrenOfType((PsiElement)ifStatement.getCondition(), ClassReference.class), (PhpPsiElement)ifStatement.getStatement());
        }

        @Nullable
        private static Catch createCatchStatementFrom(@Nullable Variable exceptionVariable, Collection<ClassReference> exceptionClasses, @Nullable PhpPsiElement statement) {
            if (exceptionVariable == null || statement == null || exceptionClasses.isEmpty()) {
                return null;
            }
            return PhpPsiElementFactory.createFromText(exceptionVariable.getProject(), Catch.class, PhpReplaceInstanceOfInCatchWithSpecificCatchesFix.createSpecificCatchFrom(exceptionClasses, exceptionVariable.getText(), statement));
        }

        private static String createSpecificCatchFrom(Collection<ClassReference> exceptionClasses, String exceptionVariableName, PhpPsiElement statement) {
            return "try{}catch(" + exceptionClasses.stream().map(PsiElement::getText).collect(Collectors.joining("|")) + " " + exceptionVariableName + ")" + statement.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpCatchWithInstanceOfCanBeReplacedWithSpecificCatchesInspection$PhpReplaceInstanceOfInCatchWithSpecificCatchesFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpCatchWithInstanceOfCanBeReplacedWithSpecificCatchesInspection$PhpReplaceInstanceOfInCatchWithSpecificCatchesFix";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCatchesToReplace";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCatchFrom";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

