/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.google.common.primitives.Ints;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFuncGetArgParameterIndicesUsageIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpParametersDefaultValueMatchersIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PhpRedundantOptionalArgumentInspection
extends PhpInspection {
    private static final IntSet EMPTY = new IntOpenHashSet();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantOptionalArgumentInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethodReference(MethodReference reference) {
                this.visitPhpFunctionCall((FunctionReference)reference);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                super.visitPhpFunctionCall(reference);
                PsiElement[] arguments = reference.getParameters();
                if (arguments.length == 0) {
                    return;
                }
                List functions = StreamEx.of((Object[])reference.multiResolve(false)).map(ResolveResult::getElement).select(Function.class).toList();
                if (functions.isEmpty() || !PhpRedundantOptionalArgumentInspection.allFunctionsHaveSameOptionalSignatures(functions, Arrays.asList(arguments)) || !PhpRedundantOptionalArgumentInspection.allFunctionsHaveMatchingSignatureToArgumentList(functions, arguments)) {
                    return;
                }
                Collection<Integer> indexes = PhpRedundantOptionalArgumentInspection.getRedundantIndexes(Arrays.asList(arguments), functions);
                if (indexes.isEmpty()) {
                    return;
                }
                Collection implicitlyUsedParameterIndices = functions.stream().flatMap(PhpFuncGetArgParameterIndicesUsageIndex::implicitlyUsedParameterIndices).collect(Collectors.toSet());
                if (implicitlyUsedParameterIndices.contains(-1)) {
                    return;
                }
                PhpRedundantOptionalArgumentInspection.registerProblemsOnMonotonicIndexesRanges(arguments, Ints.toArray((Collection)ContainerUtil.subtract(indexes, (Collection)implicitlyUsedParameterIndices)), holder);
            }
        };
    }

    private static void registerProblemsOnMonotonicIndexesRanges(PsiElement[] arguments, int[] indexes, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            PhpRedundantOptionalArgumentInspection.$$$reportNull$$$0(1);
        }
        int l = 0;
        while (l < indexes.length) {
            int r;
            for (r = l; r < indexes.length - 1 && indexes[r + 1] == indexes[r] + 1; ++r) {
            }
            TextRange range = TextRange.create((int)PhpRedundantOptionalArgumentInspection.getFirstAnchorToDelete(arguments[indexes[l]]).getTextRangeInParent().getStartOffset(), (int)arguments[indexes[r]].getTextRangeInParent().getEndOffset());
            int singleArgumentMessageChoice = l == r ? 0 : 1;
            holder.registerProblem(arguments[l].getParent(), PhpBundle.message("inspection.message.redundant.argument", singleArgumentMessageChoice), ProblemHighlightType.LIKE_UNUSED_SYMBOL, range, new LocalQuickFix[]{new PhpDeleteRedundantArguments(indexes[l], indexes[r], singleArgumentMessageChoice)});
            l = r + 1;
        }
    }

    public static Collection<Integer> getRedundantIndexes(List<? extends PsiElement> arguments, List<? extends Function> functions) {
        List allPossibleRedundantIndexes = ContainerUtil.map(functions, f -> PhpRedundantOptionalArgumentInspection.getRedundantArgumentIndexes(arguments, f, List.of(f.getParameters())));
        return IntStream.range(0, arguments.size()).filter(i -> ContainerUtil.all((Collection)allPossibleRedundantIndexes, t -> t.contains(i))).boxed().collect(Collectors.toList());
    }

    private static boolean allFunctionsHaveMatchingSignatureToArgumentList(List<? extends Function> functions, PsiElement[] arguments) {
        return ContainerUtil.all(functions, f -> f.getParameters().length >= arguments.length && ContainerUtil.find((Object[])f.getParameters(), Parameter::isVariadic) == null);
    }

    private static boolean allFunctionsHaveSameOptionalSignatures(List<? extends Function> functions, List<? extends PsiElement> arguments) {
        if (functions.isEmpty()) {
            return false;
        }
        Parameter[] parameters = functions.get(0).getParameters();
        return IntStream.range(1, functions.size()).allMatch(i -> PhpRedundantOptionalArgumentInspection.haveSameOptionalSignatures(((Function)functions.get(i)).getParameters(), parameters, arguments));
    }

    private static boolean haveSameOptionalSignatures(Parameter[] f, Parameter[] s, List<? extends PsiElement> arguments) {
        return f.length == s.length && IntStream.range(0, f.length).noneMatch(i -> f[i].isOptional(arguments) != s[i].isOptional(arguments));
    }

    private static IntSet getRedundantArgumentIndexes(List<? extends PsiElement> arguments, Function function, List<? extends Parameter> parameters) {
        int firstOptional = ContainerUtil.indexOf(parameters, parameter -> parameter.isOptional(arguments));
        if (firstOptional < 0 || firstOptional >= arguments.size()) {
            return EMPTY;
        }
        return PhpParametersDefaultValueMatchersIndex.getParameterDefaultValuesMatchers(function).stream().map(p -> PhpRedundantOptionalArgumentInspection.getRedundantArgumentIndexes(arguments, parameters, p)).reduce(PhpRedundantOptionalArgumentInspection::intersection).orElseGet(IntOpenHashSet::new);
    }

    @NotNull
    private static IntSet intersection(IntSet a1, IntSet a2) {
        IntOpenHashSet res = new IntOpenHashSet();
        if (a1.isEmpty() || a2.isEmpty()) {
            IntOpenHashSet intOpenHashSet = res;
            if (intOpenHashSet == null) {
                PhpRedundantOptionalArgumentInspection.$$$reportNull$$$0(2);
            }
            return intOpenHashSet;
        }
        a1.forEach(arg_0 -> PhpRedundantOptionalArgumentInspection.lambda$intersection$8(a2, (IntSet)res, arg_0));
        IntOpenHashSet intOpenHashSet = res;
        if (intOpenHashSet == null) {
            PhpRedundantOptionalArgumentInspection.$$$reportNull$$$0(3);
        }
        return intOpenHashSet;
    }

    @NotNull
    private static IntSet getRedundantArgumentIndexes(List<? extends PsiElement> arguments, List<? extends Parameter> parameters, Map<String, PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher> parameterDefaultValuesMatchers) {
        IntOpenHashSet res = new IntOpenHashSet();
        for (int i = 0; i < arguments.size(); ++i) {
            PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher matcher;
            Parameter param = PhpParamsInspection.getMappedParam(arguments, parameters, i);
            PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher phpParameterDefaultValueMatcher = matcher = param != null && param.isOptional(arguments) ? parameterDefaultValuesMatchers.get(param.getName()) : null;
            if (matcher == null || !matcher.matches(arguments.get(i))) {
                if (ParameterListImpl.getNameIdentifier(arguments.get(i)) != null) continue;
                res.clear();
                continue;
            }
            res.add(i);
        }
        IntOpenHashSet intOpenHashSet = res;
        if (intOpenHashSet == null) {
            PhpRedundantOptionalArgumentInspection.$$$reportNull$$$0(4);
        }
        return intOpenHashSet;
    }

    @NotNull
    private static PsiElement getFirstAnchorToDelete(@NotNull PsiElement parameter) {
        PsiElement nameIdentifier;
        if (parameter == null) {
            PhpRedundantOptionalArgumentInspection.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = (nameIdentifier = ParameterListImpl.getNameIdentifier(parameter)) != null ? nameIdentifier : parameter;
        if (psiElement == null) {
            PhpRedundantOptionalArgumentInspection.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    private static /* synthetic */ void lambda$intersection$8(IntSet a2, IntSet res, int i) {
        if (a2.contains(i)) {
            res.add(i);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpRedundantOptionalArgumentInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpRedundantOptionalArgumentInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedundantArgumentIndexes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstAnchorToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerProblemsOnMonotonicIndexesRanges";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFirstAnchorToDelete";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }

    private static class PhpDeleteRedundantArguments
    extends PsiUpdateModCommandQuickFix {
        private final int myFirstRedundantIndex;
        private final int myLastRedundantIndex;
        @NotNull
        @IntentionFamilyName
        private final String myMessage;

        private PhpDeleteRedundantArguments(int firstRedundantIndex, int lastRedundantIndex, int singleArgumentMessageChoice) {
            this.myFirstRedundantIndex = firstRedundantIndex;
            this.myLastRedundantIndex = lastRedundantIndex;
            this.myMessage = PhpBundle.message("intention.family.name.remove.redundant.arguments", singleArgumentMessageChoice);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.myMessage;
            if (string == null) {
                PhpDeleteRedundantArguments.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpDeleteRedundantArguments.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpDeleteRedundantArguments.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpDeleteRedundantArguments.$$$reportNull$$$0(3);
            }
            ParameterList list = (ParameterList)element;
            PsiElement[] parameters = list.getParameters();
            PsiElement firstAnchorToDelete = PhpRedundantOptionalArgumentInspection.getFirstAnchorToDelete(parameters[this.myFirstRedundantIndex]);
            PsiElement lastAnchorToDelete = parameters[this.myLastRedundantIndex];
            PsiElement prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(firstAnchorToDelete, true);
            PsiElement next = PhpPsiUtil.getNextSiblingIgnoreWhitespace(lastAnchorToDelete, true);
            if (PhpPsiUtil.isOfType(prev, PhpTokenTypes.opCOMMA)) {
                firstAnchorToDelete = prev;
            } else if (PhpPsiUtil.isOfType(next, PhpTokenTypes.opCOMMA)) {
                lastAnchorToDelete = next;
            }
            list.deleteChildRange(firstAnchorToDelete, lastAnchorToDelete);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpRedundantOptionalArgumentInspection$PhpDeleteRedundantArguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpRedundantOptionalArgumentInspection$PhpDeleteRedundantArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

