/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpInArrayCanBeReplacedWithComparisonInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpPregMatchWithoutEffectiveRegexpInspection;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.List;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPregMatchReplaceWithComparisonInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPregMatchReplaceWithComparisonInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                if (!PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "preg_match")) {
                    return;
                }
                PsiElement[] parameters = reference.getParameters();
                ParameterList parameterList = reference.getParameterList();
                if (parameterList == null || parameters.length != 2) {
                    return;
                }
                StringLiteralExpression pattern = (StringLiteralExpression)ObjectUtils.tryCast((Object)parameterList.getParameter("pattern", 0), StringLiteralExpression.class);
                if (pattern == null || PsiTreeUtil.findChildOfType((PsiElement)pattern, Variable.class) != null) {
                    return;
                }
                PhpTypedElement subject = (PhpTypedElement)ObjectUtils.tryCast((Object)parameterList.getParameter("subject", 1), PhpTypedElement.class);
                if (subject == null) {
                    return;
                }
                RegExpBranch branch = PhpPregMatchWithoutEffectiveRegexpInspection.getBranch(pattern);
                if (branch == null || !PhpPregMatchWithoutEffectiveRegexpInspection.resultIsUsedAsBoolean(reference)) {
                    return;
                }
                List<RegExpAtom> atoms = Arrays.asList(branch.getAtoms());
                String patternWithOutStartAndEndBoundaries = 1.getPatternWithOutStartAndEndBoundaries(atoms, pattern);
                PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)subject.getContainingFile(), PhpFile.class);
                if (file != null && patternWithOutStartAndEndBoundaries != null) {
                    holder.problem((PsiElement)reference, PhpBundle.message("inspection.php.preg.match.can.be.replaced.with.comparison", new Object[0])).fix((ModCommandAction)new PhpInArrayCanBeReplacedWithComparisonInspection.PhpReplaceWithComparison((PsiElement)reference, String.format("%s %s %s", subject.getText(), PhpCodeInsightUtil.isStrictTypes(file) ? "===" : "==", patternWithOutStartAndEndBoundaries))).register();
                }
            }

            @Nullable
            private static String getPatternWithOutStartAndEndBoundaries(List<RegExpAtom> atoms, StringLiteralExpression parameter) {
                if (atoms.size() > 2 && PhpPregMatchWithoutEffectiveRegexpInspection.isLineStart(atoms.get(0)) && PhpPregMatchWithoutEffectiveRegexpInspection.isLineEnd(atoms.get(atoms.size() - 1)) && atoms.stream().limit(atoms.size() - 1).skip(1L).allMatch(PhpPregMatchWithoutEffectiveRegexpInspection::isSimpleCharacter)) {
                    String quote = parameter.isSingleQuote() ? "'" : "\"";
                    return quote + parameter.getContents().substring(2, parameter.getContents().length() - 2) + quote;
                }
                return null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpPregMatchReplaceWithComparisonInspection", "buildVisitor"));
    }
}

