/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpPregMatchWithoutEffectiveRegexpInspection;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.List;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPregMatchRedundantClosureInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPregMatchRedundantClosureInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                StringLiteralExpression pattern = PhpPregMatchWithoutEffectiveRegexpInspection.getPregMatchPatternWithoutMatches(reference);
                if (pattern == null) {
                    return;
                }
                RegExpBranch branch = PhpPregMatchWithoutEffectiveRegexpInspection.getBranch(pattern);
                if (branch == null) {
                    return;
                }
                List<RegExpAtom> atoms = Arrays.asList(branch.getAtoms());
                if (atoms.isEmpty() || ContainerUtil.exists(atoms, atom -> PhpPregMatchWithoutEffectiveRegexpInspection.isLineStart(atom) || PhpPregMatchWithoutEffectiveRegexpInspection.isLineEnd(atom))) {
                    return;
                }
                Pair<PsiElement, TextRange> leadingClosure = PhpPregMatchRedundantClosureInspection.getClosureWithTextRange(atoms.get(0));
                Pair<PsiElement, TextRange> trailingClosure = atoms.size() > 1 ? PhpPregMatchRedundantClosureInspection.getClosureWithTextRange(atoms.get(atoms.size() - 1)) : null;
                String message = PhpBundle.message("inspection.php.preg.match.redundant.closure", new Object[0]);
                if (leadingClosure != null) {
                    holder.problem((PsiElement)pattern, message).range((TextRange)leadingClosure.second).fix((ModCommandAction)new PhpDeleteElementQuickFix((PsiElement)leadingClosure.first)).register();
                }
                if (trailingClosure != null) {
                    holder.problem((PsiElement)pattern, message).range((TextRange)trailingClosure.second).fix((ModCommandAction)new PhpDeleteElementQuickFix((PsiElement)trailingClosure.first)).register();
                }
            }
        };
    }

    @Nullable
    private static Pair<PsiElement, TextRange> getClosureWithTextRange(RegExpAtom atom) {
        RegExpClosure closure = (RegExpClosure)ObjectUtils.tryCast((Object)atom, RegExpClosure.class);
        if (closure == null || !closure.getText().equals(".*")) {
            return null;
        }
        return Pair.create((Object)atom, (Object)new TextRange(atom.getTextRange().getStartOffset() + 2, atom.getTextRange().getEndOffset() + 2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpPregMatchRedundantClosureInspection", "buildVisitor"));
    }
}

